<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }

$api_key = '306426e96ccc208c97ff49dc51d85558';
$base_url = 'http://localhost/boxenstop';

$tests = [
    // GET endpoints (public oder mit API-Key)
    ['method' => 'GET', 'endpoint' => '/api/get_available_slots.php?event_id=21&date=2025-10-31', 'expect' => 200],
    ['method' => 'GET', 'endpoint' => '/api/settings.php', 'expect' => 200],
    
    // POST endpoints die Scope benötigen
    ['method' => 'POST', 'endpoint' => '/api/appointments.php', 'body' => json_encode(['event_id' => 21, 'slot_time' => '09:30:00', 'slot_date' => '2025-10-31', 'customer_name' => 'Test', 'license_plate' => 'TEST', 'phone' => '+49 123', 'email' => 'test@test.de', 'source' => 'website']), 'expect' => [401, 403]],
    
    // Profile endpoints
    ['method' => 'GET', 'endpoint' => '/api/get_user_profile.php', 'expect' => [401, 403]],
    ['method' => 'POST', 'endpoint' => '/api/update_profile.php', 'body' => json_encode(['first_name' => 'Test']), 'expect' => [401, 403]],
    
    // Vehicle endpoints
    ['method' => 'GET', 'endpoint' => '/api/get_vehicle.php?id=1', 'expect' => [401, 403]],
    ['method' => 'POST', 'endpoint' => '/api/add_vehicle.php', 'body' => json_encode(['license_plate' => 'TEST', 'brand' => 'Test']), 'expect' => [401, 403]],
    
    // Notifications
    ['method' => 'GET', 'endpoint' => '/api/get_user_notifications.php', 'expect' => [401, 403]],
    ['method' => 'POST', 'endpoint' => '/api/mark_notification_read.php', 'body' => json_encode(['notification_id' => 1]), 'expect' => [401, 403]],
    
    // Activity
    ['method' => 'GET', 'endpoint' => '/api/get_activity_log.php', 'expect' => [401, 403]],
];

echo "API-Key Test – Alle Endpunkte\n";
echo "API Key: {$api_key}\n";
echo "====================================\n\n";

foreach ($tests as $test) {
    $url = $base_url . $test['endpoint'];
    $method = $test['method'];
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json',
            "X-Api-Key: {$api_key}"
        ],
        CURLOPT_CUSTOMREQUEST => $method,
    ]);
    
    if ($method === 'POST' && isset($test['body'])) {
        curl_setopt($ch, CURLOPT_POSTFIELDS, $test['body']);
    }
    
    $response = curl_exec($ch);
    $status = curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
    curl_close($ch);
    
    $expected = is_array($test['expect']) ? $test['expect'] : [$test['expect']];
    $passed = in_array($status, $expected, true);
    $icon = $passed ? '✅' : '❌';
    
    echo "{$icon} {$method} {$test['endpoint']}\n";
    echo "   Status: {$status} (erwartet: " . implode(' oder ', $expected) . ")\n";
    
    if (!$passed) {
        $json = json_decode($response, true);
        if ($json && isset($json['message'])) {
            echo "   Message: " . $json['message'] . "\n";
        }
    }
    
    echo "\n";
}

echo "====================================\n";
echo "✅ Test abgeschlossen\n";
?>

