<?php
// CLI only
if (php_sapi_name() !== 'cli') { echo "CLI only\n"; exit(1); }
require_once __DIR__ . '/../config/database.php';

$name = $argv[1] ?? null;
$scopesArg = $argv[2] ?? '[]';
$rate = isset($argv[3]) ? (int)$argv[3] : 60;
if (!$name) {
  echo "Usage: php tools/generate_api_key.php <name> [scopes_json] [rate_limit_per_min]\n";
  echo "Example: php tools/generate_api_key.php mobile '[\"slots:read\",\"appointments:write\"]' 120\n";
  exit(1);
}

$apiKey = bin2hex(random_bytes(16));
$apiSecret = bin2hex(random_bytes(32));
$keyHash = hash('sha256', $apiKey);
$secretHash = hash('sha256', $apiSecret);

$scopes = json_decode($scopesArg, true);
if (!is_array($scopes)) {
  echo "Invalid scopes JSON\n";
  exit(1);
}

try {
  $db = new Database();
  $conn = $db->getConnection();
  $stmt = $conn->prepare("INSERT INTO api_keys (name, key_hash, secret_hash, scopes, rate_limit_per_min, is_active) VALUES (?, ?, ?, ?, ?, 1)");
  $stmt->execute([$name, $keyHash, $secretHash, json_encode($scopes, JSON_UNESCAPED_UNICODE), $rate]);
  echo "API_KEY=" . $apiKey . "\n";
  echo "API_SECRET=" . $apiSecret . "\n";
  echo "NOTE: Store these secrets securely.\n";
} catch (Throwable $e) {
  echo "ERROR: " . $e->getMessage() . "\n";
  exit(1);
}
