<?php
/**
 * Test: Prüft ob Satznummer 103520 in der RESY API existiert
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/resy_rest_api_complete.php';

$autohausId = 1;
$wheelsetNumber = 103520;

echo "Prüfe Satznummer: {$wheelsetNumber}\n\n";

try {
    $api = new ResyRestAPIComplete($autohausId);
    
    // Versuche Details zu laden
    echo "Versuche Wheelset-Details zu laden...\n";
    $details = $api->getWheelsetDetails($wheelsetNumber);
    
    if ($details && !empty($details)) {
        echo "✓ Satznummer {$wheelsetNumber} existiert!\n\n";
        echo "Details:\n";
        echo "Satznummer: " . ($details['wheelSetNumber'] ?? 'unbekannt') . "\n";
        echo "Kennzeichen: " . ($details['licenseNo'] ?? '-') . "\n";
        echo "VIN: " . ($details['VIN'] ?? '-') . "\n";
        echo "Customer No: " . ($details['customerNo'] ?? '-') . "\n";
        echo "Anzahl Räder: " . (isset($details['wheels']) ? count($details['wheels']) : 0) . "\n";
    } else {
        echo "✗ Satznummer {$wheelsetNumber} existiert nicht oder ist leer\n";
    }
    
} catch (Exception $e) {
    echo "✗ Fehler: " . $e->getMessage() . "\n";
    echo "Die Satznummer {$wheelsetNumber} existiert wahrscheinlich nicht in der RESY API.\n";
}
?>



