// Test: Hole RESY-Page-Struktur
const { chromium } = require('playwright');

async function test() {
    const browser = await chromium.launch({ 
        headless: false,
        channel: 'chrome' // Nutze installiertes Chrome
    });
    const page = await browser.newPage();
    
    await page.goto('https://resy.dtm-reifen.de/index.php?m=login&a=login');
    await page.fill('#InputUser', 'D.ULUDAG');
    await page.fill('#InputPass', 'Ikizler123!');
    await page.click('button[type="submit"]');
    await page.waitForTimeout(5000);
    
    await page.goto('https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=453&STATUS_ID=20');
    await page.waitForTimeout(10000);
    
    // Hole alle Text-Inhalte
    const content = await page.evaluate(() => {
        return document.body.innerText;
    });
    
    // Speichere
    const fs = require('fs');
    fs.writeFileSync('temp/resy_page_content.txt', content);
    
    console.log('✅ Page-Content gespeichert in temp/resy_page_content.txt');
    console.log('\nErste 1000 Zeichen:');
    console.log(content.substring(0, 1000));
    
    await browser.close();
}

test();

