<?php
/**
 * Test: Prüft was die API tatsächlich zurückgibt
 */

require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/get_resy_wheelsets.php';

header('Content-Type: application/json');

$autohausId = $_GET['autohaus_id'] ?? 1;

try {
    $api = new ResyRestAPI($autohausId);
    $result = $api->getAllWheelsets();
    
    // Zusätzliche Debug-Info
    $result['debug'] = [
        'autohaus_id' => $autohausId,
        'timestamp' => date('Y-m-d H:i:s'),
        'wheelsets_count' => count($result['wheelsets'] ?? []),
        'wheelset_numbers' => array_map(function($ws) {
            return $ws['satznummer'] ?? $ws['wheelSetNumber'] ?? 'unbekannt';
        }, $result['wheelsets'] ?? [])
    ];
    
    echo json_encode($result, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'debug' => [
            'autohaus_id' => $autohausId,
            'timestamp' => date('Y-m-d H:i:s')
        ]
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
?>



