"""
Direkter Test der P2 API für Kennzeichen und Namen
Testet die genannten Kennzeichen und Namen
"""

import requests
import json
from urllib.parse import quote

# API-Konfiguration
API_BASE_URL = "http://100.82.207.72:5001/api"
API_KEY = "bungert-p2-api-key-2024-default"

def test_license_plate(license_plate):
    """Testet Kennzeichen-Suche"""
    print(f"\n{'='*80}")
    print(f"🔍 Teste Kennzeichen: {license_plate}")
    print(f"{'='*80}")
    
    encoded = quote(license_plate)
    url = f"{API_BASE_URL}/auftraege/by-license/{encoded}"
    params = {'days': 2000, 'limit': 200}
    headers = {'X-API-Key': API_KEY}
    
    try:
        response = requests.get(url, params=params, headers=headers, timeout=30)
        print(f"Status Code: {response.status_code}")
        print(f"URL: {url}")
        
        if response.status_code == 200:
            data = response.json()
            print(f"✅ Success: {data.get('success')}")
            print(f"📊 Count: {data.get('count', 0)}")
            
            if data.get('count', 0) > 0:
                print(f"\n📋 Erste Ergebnisse:")
                for i, auftrag in enumerate(data.get('data', [])[:3], 1):
                    print(f"  {i}. AuftragNr: {auftrag.get('AuftragNr')}, "
                          f"Kunde: {auftrag.get('KundenName1')} {auftrag.get('KundenVorname')}, "
                          f"Kennzeichen: {auftrag.get('ZulassungsKz')}, "
                          f"Datum: {auftrag.get('DatumAuftrag')}")
            else:
                print("❌ Keine Ergebnisse gefunden!")
                if 'debug' in data:
                    print(f"🔧 Debug Info: {json.dumps(data['debug'], indent=2)}")
        else:
            print(f"❌ Fehler: {response.status_code}")
            print(f"Response: {response.text[:500]}")
            
    except Exception as e:
        print(f"❌ Exception: {e}")

def test_customer_name(name):
    """Testet Kunden-Namen-Suche"""
    print(f"\n{'='*80}")
    print(f"🔍 Teste Kundenname: {name}")
    print(f"{'='*80}")
    
    url = f"{API_BASE_URL}/kunden"
    params = {'search': name, 'limit': 50}
    headers = {'X-API-Key': API_KEY}
    
    try:
        response = requests.get(url, params=params, headers=headers, timeout=30)
        print(f"Status Code: {response.status_code}")
        print(f"URL: {url}?search={quote(name)}")
        
        if response.status_code == 200:
            data = response.json()
            print(f"✅ Success: {data.get('success')}")
            print(f"📊 Count: {data.get('count', 0)}")
            
            if data.get('count', 0) > 0:
                print(f"\n📋 Gefundene Kunden:")
                for i, kunde in enumerate(data.get('data', [])[:5], 1):
                    print(f"  {i}. ID: {kunde.get('KundenAdrID')}, "
                          f"Name: {kunde.get('KundenName1')} {kunde.get('KundenVorname')}, "
                          f"Aufträge: {kunde.get('AnzahlAuftraege')}, "
                          f"Umsatz: {kunde.get('GesamtUmsatz')}")
            else:
                print("❌ Keine Ergebnisse gefunden!")
        else:
            print(f"❌ Fehler: {response.status_code}")
            print(f"Response: {response.text[:500]}")
            
    except Exception as e:
        print(f"❌ Exception: {e}")

if __name__ == "__main__":
    print("🚀 Starte API-Tests...")
    print(f"API Base URL: {API_BASE_URL}")
    
    # Teste Kennzeichen
    license_plates = [
        "OH-KP 1886",
        "MS-AV 261",
        "KI-GB 69",
        "KI-FS 221",
        "ECK-FB 26E"
    ]
    
    for plate in license_plates:
        test_license_plate(plate)
    
    # Teste Namen
    names = [
        "Hanna Richter",
        "Frank Bertram",
        "Freytag",
        "Paratus"
    ]
    
    for name in names:
        test_customer_name(name)
    
    print(f"\n{'='*80}")
    print("✅ Alle Tests abgeschlossen!")
    print(f"{'='*80}")

