<?php
/**
 * Direkter Test der P2 API für Kennzeichen und Namen
 * Testet die genannten Kennzeichen und Namen
 */

// API-Konfiguration
$API_BASE_URL = "http://100.82.207.72:5001/api";
$API_KEY = "bungert-p2-api-key-2024-default";

function testLicensePlate($licensePlate, $apiBaseUrl, $apiKey) {
    echo "\n" . str_repeat("=", 80) . "\n";
    echo "🔍 Teste Kennzeichen: $licensePlate\n";
    echo str_repeat("=", 80) . "\n";
    
    $encoded = rawurlencode($licensePlate);
    $url = "$apiBaseUrl/auftraege/by-license/$encoded";
    $params = http_build_query(['days' => 2000, 'limit' => 200]);
    $fullUrl = "$url?$params";
    
    $ch = curl_init($fullUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "X-API-Key: $apiKey",
        "Content-Type: application/json"
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    echo "Status Code: $httpCode\n";
    echo "URL: $fullUrl\n";
    
    if ($error) {
        echo "❌ cURL Error: $error\n";
        return;
    }
    
    if ($httpCode == 200) {
        $data = json_decode($response, true);
        if ($data) {
            echo "✅ Success: " . ($data['success'] ? 'true' : 'false') . "\n";
            echo "📊 Count: " . ($data['count'] ?? 0) . "\n";
            
            if (($data['count'] ?? 0) > 0) {
                echo "\n📋 Erste Ergebnisse:\n";
                $results = array_slice($data['data'] ?? [], 0, 3);
                foreach ($results as $i => $auftrag) {
                    $i++;
                    echo "  $i. AuftragNr: " . ($auftrag['AuftragNr'] ?? 'N/A') . ", ";
                    echo "Kunde: " . ($auftrag['KundenName1'] ?? '') . " " . ($auftrag['KundenVorname'] ?? '') . ", ";
                    echo "Kennzeichen: " . ($auftrag['ZulassungsKz'] ?? 'N/A') . ", ";
                    echo "Datum: " . ($auftrag['DatumAuftrag'] ?? 'N/A') . "\n";
                }
            } else {
                echo "❌ Keine Ergebnisse gefunden!\n";
                if (isset($data['debug'])) {
                    echo "🔧 Debug Info:\n";
                    echo json_encode($data['debug'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
                }
            }
        } else {
            echo "❌ JSON Parse Error\n";
            echo "Response: " . substr($response, 0, 500) . "\n";
        }
    } else {
        echo "❌ Fehler: $httpCode\n";
        echo "Response: " . substr($response, 0, 500) . "\n";
    }
}

function testCustomerName($name, $apiBaseUrl, $apiKey) {
    echo "\n" . str_repeat("=", 80) . "\n";
    echo "🔍 Teste Kundenname: $name\n";
    echo str_repeat("=", 80) . "\n";
    
    $url = "$apiBaseUrl/kunden";
    $params = http_build_query(['search' => $name, 'limit' => 50]);
    $fullUrl = "$url?$params";
    
    $ch = curl_init($fullUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "X-API-Key: $apiKey",
        "Content-Type: application/json"
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);
    
    echo "Status Code: $httpCode\n";
    echo "URL: $fullUrl\n";
    
    if ($error) {
        echo "❌ cURL Error: $error\n";
        return;
    }
    
    if ($httpCode == 200) {
        $data = json_decode($response, true);
        if ($data) {
            echo "✅ Success: " . ($data['success'] ? 'true' : 'false') . "\n";
            echo "📊 Count: " . ($data['count'] ?? 0) . "\n";
            
            if (($data['count'] ?? 0) > 0) {
                echo "\n📋 Gefundene Kunden:\n";
                $results = array_slice($data['data'] ?? [], 0, 5);
                foreach ($results as $i => $kunde) {
                    $i++;
                    echo "  $i. ID: " . ($kunde['KundenAdrID'] ?? 'N/A') . ", ";
                    echo "Name: " . ($kunde['KundenName1'] ?? '') . " " . ($kunde['KundenVorname'] ?? '') . ", ";
                    echo "Aufträge: " . ($kunde['AnzahlAuftraege'] ?? 0) . ", ";
                    echo "Umsatz: " . ($kunde['GesamtUmsatz'] ?? 0) . "\n";
                }
            } else {
                echo "❌ Keine Ergebnisse gefunden!\n";
            }
        } else {
            echo "❌ JSON Parse Error\n";
            echo "Response: " . substr($response, 0, 500) . "\n";
        }
    } else {
        echo "❌ Fehler: $httpCode\n";
        echo "Response: " . substr($response, 0, 500) . "\n";
    }
}

echo "🚀 Starte API-Tests...\n";
echo "API Base URL: $API_BASE_URL\n";

// Teste Kennzeichen
$licensePlates = [
    "OH-KP 1886",
    "MS-AV 261",
    "KI-GB 69",
    "KI-FS 221",
    "ECK-FB 26E"
];

foreach ($licensePlates as $plate) {
    testLicensePlate($plate, $API_BASE_URL, $API_KEY);
}

// Teste Namen
$names = [
    "Hanna Richter",
    "Frank Bertram",
    "Freytag",
    "Paratus"
];

foreach ($names as $name) {
    testCustomerName($name, $API_BASE_URL, $API_KEY);
}

echo "\n" . str_repeat("=", 80) . "\n";
echo "✅ Alle Tests abgeschlossen!\n";
echo str_repeat("=", 80) . "\n";

