<?php
/**
 * Migration: Füge Spalten für Bewertungsanfrage hinzu
 * 
 * Fügt die Spalten whatsapp_review_request_sent und whatsapp_review_request_sent_at
 * zur appointments Tabelle hinzu, um zu tracken, ob die Bewertungsanfrage gesendet wurde.
 */

require_once __DIR__ . '/../config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Prüfe ob Spalte bereits existiert
    $stmt = $conn->query("SHOW COLUMNS FROM appointments LIKE 'whatsapp_review_request_sent'");
    if ($stmt->rowCount() == 0) {
        // Füge Spalte hinzu
        $conn->exec("
            ALTER TABLE appointments 
            ADD COLUMN whatsapp_review_request_sent TINYINT(1) DEFAULT 0 
            AFTER whatsapp_confirmation_sent_at
        ");
        echo "✓ Spalte 'whatsapp_review_request_sent' hinzugefügt\n";
    } else {
        echo "ℹ Spalte 'whatsapp_review_request_sent' existiert bereits\n";
    }
    
    // Prüfe ob Spalte für Zeitstempel existiert
    $stmt = $conn->query("SHOW COLUMNS FROM appointments LIKE 'whatsapp_review_request_sent_at'");
    if ($stmt->rowCount() == 0) {
        // Füge Spalte hinzu
        $conn->exec("
            ALTER TABLE appointments 
            ADD COLUMN whatsapp_review_request_sent_at DATETIME NULL 
            AFTER whatsapp_review_request_sent
        ");
        echo "✓ Spalte 'whatsapp_review_request_sent_at' hinzugefügt\n";
    } else {
        echo "ℹ Spalte 'whatsapp_review_request_sent_at' existiert bereits\n";
    }
    
    echo "\n✅ Migration erfolgreich abgeschlossen!\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}
?>




