<?php
/**
 * Migration: Füge is_enabled Flag zu whatsapp_template_configs hinzu
 * is_active = Template existiert und ist zugewiesen
 * is_enabled = Nachricht wird gesendet (An/Aus-Schalter)
 */

require_once __DIR__ . '/../config/database.php';

$db = new Database();
$conn = $db->getConnection();

try {
    // Prüfe ob Spalte bereits existiert
    $stmt = $conn->query("SHOW COLUMNS FROM whatsapp_template_configs LIKE 'is_enabled'");
    if ($stmt->rowCount() > 0) {
        echo "ℹ️ Spalte 'is_enabled' existiert bereits.\n";
    } else {
        // Füge Spalte hinzu
        $conn->exec("ALTER TABLE whatsapp_template_configs ADD COLUMN is_enabled TINYINT(1) DEFAULT 1 COMMENT 'Nachricht wird gesendet (An/Aus-Schalter)' AFTER is_active");
        echo "✅ Spalte 'is_enabled' erfolgreich hinzugefügt!\n";
        
        // Setze alle bestehenden Einträge auf enabled (Standard)
        $conn->exec("UPDATE whatsapp_template_configs SET is_enabled = 1 WHERE is_enabled IS NULL");
        echo "✅ Bestehende Einträge auf 'enabled' gesetzt.\n";
    }
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
}




