// PhantomJS RESY Crawler
var page = require('webpage').create();
var system = require('system');

page.settings.userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36';

// Http Server
var server = require('webserver').create();
var service = server.listen(8910, function(request, response) {
    try {
        var url = require('querystring').parse(request.url.substring(1));
        
        if (url.action === 'get_wheelsets') {
            // Navigate to RESY and get wheelsets
            page.open('https://resy.dtm-reifen.de/index.php?m=login&a=login', function(status) {
                if (status === 'success') {
                    // Fill login
                    page.evaluate(function(username, password) {
                        document.getElementById('InputUser').value = username;
                        document.getElementById('InputPass').value = password;
                        document.querySelector('button[type="submit"]').click();
                    }, 'D.ULUDAG', 'Ikizler123!');
                    
                    setTimeout(function() {
                        // Navigate to wheelsets
                        page.open('https://resy.dtm-reifen.de/index.php?m=wheelset&a=search&FN=WheelsetSearch&KD_ID=453&STATUS_ID=20', function(status) {
                            setTimeout(function() {
                                var html = page.content;
                                
                                response.statusCode = 200;
                                response.setHeader('Content-Type', 'application/json');
                                response.write(JSON.stringify({
                                    success: true,
                                    html: html,
                                    length: html.length
                                }));
                                response.close();
                            }, 5000);
                        });
                    }, 3000);
                }
            });
        } else {
            response.statusCode = 404;
            response.write('Not Found');
            response.close();
        }
    } catch (e) {
        response.statusCode = 500;
        response.write(JSON.stringify({ error: e.message }));
        response.close();
    }
});

console.log('✅ PhantomJS RESY Crawler läuft auf Port 8910');

