import { EventDispatcher, GraphEdgeEvent, GraphEvent, GraphNodeEvent } from './event-dispatcher.js';
import { GraphEdge } from './graph-edge.js';
import { GraphNode } from './graph-node.js';
/**
 * A graph manages a network of {@link GraphNode} nodes, connected
 * by {@link @Link} edges.
 */
export declare class Graph<T extends GraphNode> extends EventDispatcher<GraphEvent | GraphNodeEvent | GraphEdgeEvent> {
    private _emptySet;
    private _edges;
    private _parentEdges;
    private _childEdges;
    /** Returns a list of all parent->child edges on this graph. */
    listEdges(): GraphEdge<T, T>[];
    /** Returns a list of all edges on the graph having the given node as their child. */
    listParentEdges(node: T): GraphEdge<T, T>[];
    /** Returns a list of parent nodes for the given child node. */
    listParents(node: T): T[];
    /** Returns a list of all edges on the graph having the given node as their parent. */
    listChildEdges(node: T): GraphEdge<T, T>[];
    /** Returns a list of child nodes for the given parent node. */
    listChildren(node: T): T[];
    disconnectParents(node: T, filter?: (n: T) => boolean): this;
    /**********************************************************************************************
     * Internal.
     */
    /**
     * Creates a {@link GraphEdge} connecting two {@link GraphNode} instances. Edge is returned
     * for the caller to store.
     * @param a Owner
     * @param b Resource
     * @hidden
     * @internal
     */
    _createEdge<A extends T, B extends T>(name: string, a: A, b: B, attributes?: Record<string, unknown>): GraphEdge<A, B>;
    /**
     * Detaches a {@link GraphEdge} from the {@link Graph}. Before calling this
     * method, ensure that the GraphEdge has first been detached from any
     * associated {@link GraphNode} attributes.
     * @hidden
     * @internal
     */
    _destroyEdge(edge: GraphEdge<T, T>): this;
}
