import { GraphNode } from './graph-node.js';
/**
 * Represents a connection between two {@link GraphNode} resources in a {@link Graph}.
 *
 * The left node is considered the owner, and the right node the resource. The
 * owner is responsible for being able find and remove a reference to a resource, given
 * that link. The resource does not hold a reference to the link or to the owner,
 * although that reverse lookup can be done on the graph.
 */
export declare class GraphEdge<Parent extends GraphNode, Child extends GraphNode> {
    private readonly _name;
    private readonly _parent;
    private _child;
    private _attributes;
    private _disposed;
    constructor(_name: string, _parent: Parent, _child: Child, _attributes?: Record<string, unknown>);
    /** Name (attribute name from parent {@link GraphNode}). */
    getName(): string;
    /** Owner node. */
    getParent(): Parent;
    /** Resource node. */
    getChild(): Child;
    /**
     * Sets the child node.
     *
     * @internal Only {@link Graph} implementations may safely call this method directly. Use
     * 	{@link Property.swap} or {@link Graph.swapChild} instead.
     */
    setChild(child: Child): this;
    /** Attributes of the graph node relationship. */
    getAttributes(): Record<string, unknown>;
    /** Destroys a (currently intact) edge, updating both the graph and the owner. */
    dispose(): void;
    /** Whether this link has been destroyed. */
    isDisposed(): boolean;
}
