import { type Transform } from '@gltf-transform/core';
export interface PruneOptions {
    /** List of {@link PropertyType} identifiers to be de-duplicated.*/
    propertyTypes?: string[];
    /** Whether to keep empty leaf nodes. */
    keepLeaves?: boolean;
    /** Whether to keep unused vertex attributes, such as UVs without an assigned texture. */
    keepAttributes?: boolean;
    /**
     * Whether to keep redundant mesh indices, where vertex count equals index count.
     * @deprecated Disabled. To remove indices, use {@link unweld} or other APIs.
     * @privateRemarks TODO(v5): Remove this option.
     */
    keepIndices?: boolean;
    /** Whether to keep single-color textures that can be converted to material factors. */
    keepSolidTextures?: boolean;
    /** Whether custom extras should prevent pruning a property. */
    keepExtras?: boolean;
}
export declare const PRUNE_DEFAULTS: Required<PruneOptions>;
/**
 * Removes properties from the file if they are not referenced by a {@link Scene}. Commonly helpful
 * for cleaning up after other operations, e.g. allowing a node to be detached and any unused
 * meshes, materials, or other resources to be removed automatically.
 *
 * Example:
 *
 * ```javascript
 * import { PropertyType } from '@gltf-transform/core';
 * import { prune } from '@gltf-transform/functions';
 *
 * document.getRoot().listMaterials(); // → [Material, Material]
 *
 * await document.transform(
 * 	prune({
 * 		propertyTypes: [PropertyType.MATERIAL],
 * 		keepExtras: true
 * 	})
 * );
 *
 * document.getRoot().listMaterials(); // → [Material]
 * ```
 *
 * By default, pruning will aggressively remove most unused resources. Use
 * {@link PruneOptions} to limit what is considered for pruning.
 *
 * @category Transforms
 */
export declare function prune(_options?: PruneOptions): Transform;
