import type { Transform } from '@gltf-transform/core';
import { type QuantizeOptions } from './quantize.js';
export interface MeshoptOptions extends Omit<QuantizeOptions, 'pattern' | 'patternTargets'> {
    encoder: unknown;
    level?: 'medium' | 'high';
}
export declare const MESHOPT_DEFAULTS: Required<Omit<MeshoptOptions, 'encoder'>>;
/**
 * Applies Meshopt compression using {@link EXTMeshoptCompression EXT_meshopt_compression}.
 * This type of compression can reduce the size of point, line, and triangle geometry,
 * morph targets, and animation data.
 *
 * This function is a thin wrapper around {@link reorder}, {@link quantize}, and
 * {@link EXTMeshoptCompression}, and exposes relatively few configuration options.
 * To access more options (like quantization bits) direct use of the underlying
 * functions is recommended.
 *
 * Example:
 *
 * ```javascript
 * import { MeshoptEncoder } from 'meshoptimizer';
 * import { meshopt } from '@gltf-transform/functions';
 *
 * await MeshoptEncoder.ready;
 *
 * await document.transform(
 *   meshopt({encoder: MeshoptEncoder, level: 'medium'})
 * );
 * ```
 *
 * Compression is deferred until generating output with an I/O class.
 *
 * @category Transforms
 */
export declare function meshopt(_options: MeshoptOptions): Transform;
