import { type Transform } from '@gltf-transform/core';
/** Options for the {@link flatten} function. */
export interface FlattenOptions {
    /**
     * Whether to perform cleanup steps after completing the operation. Recommended, and enabled by
     * default. Cleanup removes temporary resources created during the operation, but may also remove
     * pre-existing unused or duplicate resources in the {@link Document}. Applications that require
     * keeping these resources may need to disable cleanup, instead calling {@link dedup} and
     * {@link prune} manually (with customized options) later in the processing pipeline.
     * @experimental
     */
    cleanup?: boolean;
}
export declare const FLATTEN_DEFAULTS: Required<FlattenOptions>;
/**
 * Flattens the scene graph, leaving {@link Node Nodes} with
 * {@link Mesh Meshes}, {@link Camera Cameras}, and other attachments
 * as direct children of the {@link Scene}. Skeletons and their
 * descendants are left in their original Node structure.
 *
 * {@link Animation} targeting a Node or its parents will
 * prevent that Node from being moved.
 *
 * Example:
 *
 * ```ts
 * import { flatten } from '@gltf-transform/functions';
 *
 * await document.transform(flatten());
 * ```
 *
 * @category Transforms
 */
export declare function flatten(_options?: FlattenOptions): Transform;
