import type { Transform } from '@gltf-transform/core';
export interface DracoOptions {
    method?: 'edgebreaker' | 'sequential';
    encodeSpeed?: number;
    decodeSpeed?: number;
    quantizePosition?: number;
    quantizeNormal?: number;
    quantizeColor?: number;
    quantizeTexcoord?: number;
    quantizeGeneric?: number;
    quantizationVolume?: 'mesh' | 'scene';
}
export declare const DRACO_DEFAULTS: Required<DracoOptions>;
/**
 * Applies Draco compression using {@link KHRDracoMeshCompression KHR_draco_mesh_compression}.
 * Draco compression can reduce the size of triangle geometry.
 *
 * This function is a thin wrapper around the {@link KHRDracoMeshCompression} extension.
 *
 * ### Example
 *
 * ```typescript
 * import { NodeIO } from '@gltf-transform/core';
 * import { KHRDracoMeshCompression } from '@gltf-transform/extensions';
 * import { draco } from '@gltf-transform/functions';
 * import draco3d from 'draco3dgltf';
 *
 * const io = new NodeIO()
 * 	.registerExtensions([KHRDracoMeshCompression])
 * 	.registerDependencies({
 * 		'draco3d.encoder': await draco3d.createEncoderModule()
 * 	});
 *
 * await document.transform(
 *   draco({method: 'edgebreaker'})
 * );
 *
 * await io.write('compressed.glb', document);
 * ```
 *
 * Compression is deferred until generating output with an I/O class.
 *
 * @category Transforms
 */
export declare function draco(_options?: DracoOptions): Transform;
