import { ExtensionProperty, type IProperty, type Material, type Nullable, RefSet } from '@gltf-transform/core';
import { KHR_MATERIALS_VARIANTS } from '../constants.js';
import type { Variant } from './variant.js';
interface IMapping extends IProperty {
    material: Material;
    variants: RefSet<Variant>;
}
/**
 * Maps {@link Variant}s to {@link Material}s. See {@link KHRMaterialsVariants}.
 */
export declare class Mapping extends ExtensionProperty<IMapping> {
    static EXTENSION_NAME: typeof KHR_MATERIALS_VARIANTS;
    extensionName: typeof KHR_MATERIALS_VARIANTS;
    propertyType: 'Mapping';
    parentTypes: ['MappingList'];
    protected init(): void;
    protected getDefaults(): Nullable<IMapping>;
    /** The {@link Material} designated for this {@link Primitive}, under the given variants. */
    getMaterial(): Material | null;
    /** The {@link Material} designated for this {@link Primitive}, under the given variants. */
    setMaterial(material: Material | null): this;
    /** Adds a {@link Variant} to this mapping. */
    addVariant(variant: Variant): this;
    /** Removes a {@link Variant} from this mapping. */
    removeVariant(variant: Variant): this;
    /** Lists {@link Variant}s in this mapping. */
    listVariants(): Variant[];
}
export {};
