import { ExtensionProperty, type IProperty, type Nullable, PropertyType } from '@gltf-transform/core';
import { KHR_MATERIALS_DISPERSION } from '../constants.js';
interface IDispersion extends IProperty {
    dispersion: number;
}
/**
 * Defines dispersion for a PBR {@link Material}. See {@link KHRMaterialsDispersion}.
 */
export declare class Dispersion extends ExtensionProperty<IDispersion> {
    static EXTENSION_NAME: typeof KHR_MATERIALS_DISPERSION;
    extensionName: typeof KHR_MATERIALS_DISPERSION;
    propertyType: 'Dispersion';
    parentTypes: [PropertyType.MATERIAL];
    protected init(): void;
    protected getDefaults(): Nullable<IDispersion>;
    /**********************************************************************************************
     * Dispersion.
     */
    /** Dispersion. */
    getDispersion(): number;
    /** Dispersion. */
    setDispersion(dispersion: number): this;
}
export {};
