import { ExtensionProperty, type IProperty, type Nullable, PropertyType, type Texture, TextureInfo, type vec3 } from '@gltf-transform/core';
import { KHR_MATERIALS_DIFFUSE_TRANSMISSION } from '../constants.js';
interface IDiffuseTransmission extends IProperty {
    diffuseTransmissionFactor: number;
    diffuseTransmissionTexture: Texture;
    diffuseTransmissionTextureInfo: TextureInfo;
    diffuseTransmissionColorFactor: vec3;
    diffuseTransmissionColorTexture: Texture;
    diffuseTransmissionColorTextureInfo: TextureInfo;
}
/**
 * Defines diffuse transmission on a PBR {@link Material}. See {@link KHRMaterialsDiffuseTransmission}.
 *
 * @experimental KHR_materials_diffuse_transmission is not yet ratified by the Khronos Group.
 */
export declare class DiffuseTransmission extends ExtensionProperty<IDiffuseTransmission> {
    static EXTENSION_NAME: typeof KHR_MATERIALS_DIFFUSE_TRANSMISSION;
    extensionName: typeof KHR_MATERIALS_DIFFUSE_TRANSMISSION;
    propertyType: 'DiffuseTransmission';
    parentTypes: [PropertyType.MATERIAL];
    protected init(): void;
    protected getDefaults(): Nullable<IDiffuseTransmission>;
    /**********************************************************************************************
     * Diffuse transmission.
     */
    /**
     * Percentage of reflected, non-specularly reflected light that is transmitted through the
     * surface via the Lambertian diffuse transmission, i.e., the strength of the diffuse
     * transmission effect.
     */
    getDiffuseTransmissionFactor(): number;
    /**
     * Percentage of reflected, non-specularly reflected light that is transmitted through the
     * surface via the Lambertian diffuse transmission, i.e., the strength of the diffuse
     * transmission effect.
     */
    setDiffuseTransmissionFactor(factor: number): this;
    /**
     * Texture that defines the strength of the diffuse transmission effect, stored in the alpha (A)
     * channel. Will be multiplied by the diffuseTransmissionFactor.
     */
    getDiffuseTransmissionTexture(): Texture | null;
    /**
     * Settings affecting the material's use of its diffuse transmission texture. If no texture is attached,
     * {@link TextureInfo} is `null`.
     */
    getDiffuseTransmissionTextureInfo(): TextureInfo | null;
    /**
     * Texture that defines the strength of the diffuse transmission effect, stored in the alpha (A)
     * channel. Will be multiplied by the diffuseTransmissionFactor.
     */
    setDiffuseTransmissionTexture(texture: Texture | null): this;
    /**********************************************************************************************
     * Diffuse transmission color.
     */
    /** Color of the transmitted light; Linear-sRGB components. */
    getDiffuseTransmissionColorFactor(): vec3;
    /** Color of the transmitted light; Linear-sRGB components. */
    setDiffuseTransmissionColorFactor(factor: vec3): this;
    /**
     * Texture that defines the color of the transmitted light, stored in the RGB channels and
     * encoded in sRGB. This texture will be multiplied by diffuseTransmissionColorFactor.
     */
    getDiffuseTransmissionColorTexture(): Texture | null;
    /**
     * Settings affecting the material's use of its diffuse transmission color texture. If no
     * texture is attached, {@link TextureInfo} is `null`.
     */
    getDiffuseTransmissionColorTextureInfo(): TextureInfo | null;
    /**
     * Texture that defines the color of the transmitted light, stored in the RGB channels and
     * encoded in sRGB. This texture will be multiplied by diffuseTransmissionColorFactor.
     */
    setDiffuseTransmissionColorTexture(texture: Texture | null): this;
}
export {};
