import type { Ref, RefList, RefMap, RefSet } from 'property-graph';
import type { BufferViewUsage } from '../constants.js';
import type { Property } from '../properties/index.js';
export type UnknownRef = Ref<Property> | RefList<Property> | RefSet<Property> | RefMap<Property>;
export declare function equalsRef(refA: Ref<Property>, refB: Ref<Property>): boolean;
export declare function equalsRefSet<A extends RefList<Property> | RefSet<Property>, B extends RefList<Property> | RefSet<Property>>(refSetA: A, refSetB: B): boolean;
export declare function equalsRefMap(refMapA: RefMap<Property>, refMapB: RefMap<Property>): boolean;
export declare function equalsArray(a: ArrayLike<unknown> | null, b: ArrayLike<unknown> | null): boolean;
export declare function equalsObject(_a: unknown, _b: unknown): boolean;
export type RefAttributes = Record<string, unknown>;
export interface AccessorRefAttributes extends RefAttributes {
    /** Usage role of an accessor reference. */
    usage: BufferViewUsage | string;
}
export interface TextureRefAttributes extends RefAttributes {
    /** Bitmask for {@link TextureChannel TextureChannels} used by a texture reference. */
    channels: number;
    /**
     * Specifies that the texture contains color data (base color, emissive, …),
     * rather than non-color data (normal maps, metallic roughness, …). Used
     * when tuning texture compression settings.
     */
    isColor?: boolean;
}
export declare function isArray(value: unknown): boolean;
