import type { Extension, NodeIO } from '@gltf-transform/core';
import type { program } from './program.js';
import type { Session } from './session.js';
interface Config {
    extensions: (typeof Extension)[];
    dependencies: Record<string, unknown>;
    onProgramReady?: (params: {
        program: typeof program;
        io: NodeIO;
        Session: typeof Session;
    }) => Promise<void>;
}
export type CustomConfig = Partial<Config>;
export declare function defineConfig(configProvider: CustomConfig | (() => Promise<CustomConfig>)): Promise<CustomConfig>;
export declare function createDefaultConfig(): Promise<Config>;
export declare function loadConfig(path: string): void;
export declare function validateConfig(config: CustomConfig): CustomConfig;
export declare function getConfig(): Promise<Config>;
export {};
