import type { ParserOptions, ParserResult } from "../types.js";
/**
 * Parse a line
 *
 * @param line Line to be parsed
 * @param options Parser options
 * @internal
 */
export declare function parseLine(line: string, options?: Partial<ParserOptions>): ParserResult;
/**
 * Parse command line arguments
 *
 * @param options Parser options
 * @param argv command line arguments array (a.k.a. "argv")
 */
export declare function parseArgv(options?: Partial<ParserOptions>, argv?: string[]): ParserResult;
