/**
 * @packageDocumentation
 * @module caporal/help
 */
import { Command } from "../command/index.js";
import { Program } from "../program/index.js";
import { CustomizedHelpOpts, TemplateContext, Template } from "./types.js";
/**
 * Customize the help
 *
 * @param obj
 * @param text
 * @param options
 * @internal
 */
export declare function customizeHelp(obj: Command | Program, text: string, options: Partial<CustomizedHelpOpts>): void;
/**
 * Register a new help template
 *
 * @param name Template name
 * @param template Template function
 *
 */
export declare function registerTemplate(name: string, template: Template): Map<string, Template>;
/**
 * Helper to be used to call templates from within templates
 *
 * @param name Template name
 * @param ctx Execution context
 * @internal
 */
export declare function tpl(name: string, ctx: TemplateContext): Promise<string>;
/**
 * @internal
 * @param program
 * @param command
 */
export declare function getContext(program: Program, command?: Command): TemplateContext;
/**
 * Return the help text
 *
 * @param program Program instance
 * @param command Command instance, if any
 * @internal
 */
export declare function getHelp(program: Program, command?: Command): Promise<string>;
