<?php
/**
 * Implementiere eine Navigation-basierte RESY-Suchfunktion
 * Diese Funktion navigiert über die Benutzeroberfläche statt direkter URLs
 */

require_once 'api/resy_data_extraction_breakthrough.php';

echo "=== NAVIGATION-BASIERTE RESY-SUCHFUNKTION ===\n";

$testConfig = [
    'base_url' => 'https://resy.dtm-reifen.de',
    'username' => 'D.ULUDAG',
    'password' => 'Ikizler123!',
    'working_lgs_id' => '9716706'
];

try {
    $ch = curl_init();
    $cookieFile = sys_get_temp_dir() . '/resy_navigation_test.txt';
    
    // Lösche alte Cookie-Datei
    if (file_exists($cookieFile)) {
        unlink($cookieFile);
    }
    
    echo "--- Schritt 1: Login durchführen ---\n";
    $loginUrl = $testConfig['base_url'] . '/index.php?m=login&a=login';
    
    curl_setopt($ch, CURLOPT_URL, $loginUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
    curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
    
    $loginPageResponse = curl_exec($ch);
    echo "Login-Seite geladen\n";
    
    // Login-Daten senden
    $postData = [
        'FN' => 'login',
        'UserName' => $testConfig['username'],
        'Password' => $testConfig['password'],
        'button' => 'submit'
    ];
    
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
        'Referer: ' . $loginUrl
    ]);
    
    $loginResponse = curl_exec($ch);
    $loginFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    echo "Login durchgeführt: $loginFinalUrl\n";
    
    echo "\n--- Schritt 2: Navigiere zur Suchseite ---\n";
    $searchPageUrl = $testConfig['base_url'] . '/resyweb/index.php?m=wheelset&a=search';
    echo "Navigation zur Suchseite: $searchPageUrl\n";
    
    curl_setopt($ch, CURLOPT_POST, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, null);
    curl_setopt($ch, CURLOPT_URL, $searchPageUrl);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Referer: ' . $loginFinalUrl
    ]);
    
    $searchPageResponse = curl_exec($ch);
    $searchPageCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $searchPageFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
    
    echo "Suchseite Response: HTTP $searchPageCode\n";
    echo "Suchseite Final URL: $searchPageFinalUrl\n";
    echo "Content Length: " . strlen($searchPageResponse) . " Zeichen\n";
    
    // Speichere die Suchseite
    file_put_contents(sys_get_temp_dir() . "/resy_search_page.html", $searchPageResponse);
    echo "Suchseite gespeichert: " . sys_get_temp_dir() . "/resy_search_page.html\n";
    
    // Analysiere die Suchseite
    $hasLoginForm = strpos($searchPageResponse, 'Anmeldename') !== false;
    $hasSearchForm = strpos($searchPageResponse, '<form') !== false;
    $hasLgsIdField = strpos($searchPageResponse, 'LGS_ID') !== false;
    
    echo "Enthält Login-Form: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält Such-Form: " . ($hasSearchForm ? 'Ja' : 'Nein') . "\n";
    echo "Enthält LGS_ID-Feld: " . ($hasLgsIdField ? 'Ja' : 'Nein') . "\n";
    
    if ($hasLoginForm) {
        echo "❌ Session verloren - zur Login-Seite umgeleitet\n";
    } elseif ($hasSearchForm && $hasLgsIdField) {
        echo "✅ Suchformular gefunden!\n";
        
        echo "\n--- Schritt 3: Analysiere Suchformular ---\n";
        
        // Extrahiere Formular-Details
        if (preg_match('/<form[^>]*action=["\']([^"\']*)["\'][^>]*>(.*?)<\/form>/is', $searchPageResponse, $formMatch)) {
            $formAction = $formMatch[1];
            $formContent = $formMatch[2];
            
            echo "Formular Action: $formAction\n";
            
            // Extrahiere alle Input-Felder
            preg_match_all('/<input[^>]*name=["\']([^"\']*)["\'][^>]*>/i', $formContent, $inputMatches);
            echo "Input-Felder gefunden:\n";
            foreach ($inputMatches[1] as $inputName) {
                echo "  - $inputName\n";
            }
            
            echo "\n--- Schritt 4: Sende Suchformular ---\n";
            
            // Erstelle Formular-Daten
            $searchData = [
                'LGS_ID' => $testConfig['working_lgs_id'],
                'button' => 'submit',
                'FN' => 'WheelsetSearch'
            ];
            
            // Füge alle anderen versteckten Felder hinzu
            preg_match_all('/<input[^>]*type=["\']hidden["\'][^>]*name=["\']([^"\']*)["\'][^>]*value=["\']([^"\']*)["\'][^>]*>/i', $formContent, $hiddenMatches);
            for ($i = 0; $i < count($hiddenMatches[1]); $i++) {
                $hiddenName = $hiddenMatches[1][$i];
                $hiddenValue = $hiddenMatches[2][$i];
                $searchData[$hiddenName] = $hiddenValue;
                echo "Verstecktes Feld: $hiddenName = $hiddenValue\n";
            }
            
            $formUrl = $testConfig['base_url'] . '/resyweb/' . ltrim($formAction, './');
            echo "Formular-URL: $formUrl\n";
            echo "Suchparameter: " . json_encode($searchData) . "\n";
            
            curl_setopt($ch, CURLOPT_URL, $formUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($searchData));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/x-www-form-urlencoded',
                'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36',
                'Referer: ' . $searchPageFinalUrl
            ]);
            
            $searchResultResponse = curl_exec($ch);
            $searchResultCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $searchResultFinalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
            
            echo "Suchergebnis Response: HTTP $searchResultCode\n";
            echo "Suchergebnis Final URL: $searchResultFinalUrl\n";
            echo "Suchergebnis Content Length: " . strlen($searchResultResponse) . " Zeichen\n";
            
            // Speichere das Suchergebnis
            file_put_contents(sys_get_temp_dir() . "/resy_search_result.html", $searchResultResponse);
            echo "Suchergebnis gespeichert: " . sys_get_temp_dir() . "/resy_search_result.html\n";
            
            // Analysiere das Suchergebnis
            $hasWheelsetData = strpos($searchResultResponse, 'WheelHALTERNAME') !== false || 
                              strpos($searchResultResponse, 'WheelKENNZEICHEN') !== false;
            $hasTargetLgsId = strpos($searchResultResponse, $testConfig['working_lgs_id']) !== false;
            $hasLoginForm = strpos($searchResultResponse, 'Anmeldename') !== false;
            
            echo "Suchergebnis enthält Wheelset-Daten: " . ($hasWheelsetData ? 'Ja' : 'Nein') . "\n";
            echo "Suchergebnis enthält Ziel-LGS_ID: " . ($hasTargetLgsId ? 'Ja' : 'Nein') . "\n";
            echo "Suchergebnis ist Login-Seite: " . ($hasLoginForm ? 'Ja' : 'Nein') . "\n";
            
            if ($hasWheelsetData && $hasTargetLgsId) {
                echo "\n🎉 ERFOLG! Navigation-basierte Suche funktioniert!\n";
                echo "Wheelset-Daten für LGS_ID {$testConfig['working_lgs_id']} gefunden!\n";
            } elseif ($hasLoginForm) {
                echo "\n❌ Session verloren während der Suche\n";
            } else {
                echo "\n⚠️ Suchergebnis unklar - Details in HTML-Datei\n";
            }
            
        } else {
            echo "❌ Kein Formular gefunden\n";
        }
        
    } else {
        echo "❌ Keine Suchfunktion gefunden\n";
    }
    
    curl_close($ch);
    
} catch (Exception $e) {
    echo "❌ Test fehlgeschlagen: " . $e->getMessage() . "\n";
}

echo "\n=== NAVIGATION-BASIERTE SUCHFUNKTION ABGESCHLOSSEN ===\n";
?>
