<?php
/**
 * Manueller Test für RESY-Login
 * Analysiert exakt was passiert
 */

require_once 'config/database.php';

$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT id, name, resy_username, resy_password FROM autohaus WHERE id = 1");
$stmt->execute();
$autohaus = $stmt->fetch(PDO::FETCH_ASSOC);

echo "🔍 Manual RESY Debug\n";
echo "==================\n\n";
echo "Username: " . $autohaus['resy_username'] . "\n";
echo "Password: " . str_repeat('*', strlen($autohaus['resy_password'])) . "\n\n";

$cookieFile = sys_get_temp_dir() . '/resy_debug_' . time() . '.txt';

// Login-Seite laden
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://resy.dtm-reifen.de/index.php?m=login&a=login');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'User-Agent: Mozilla/5.0'
]);

$response1 = curl_exec($ch);
echo "✅ Login-Seite geladen (" . strlen($response1) . " Zeichen)\n";

// Login durchführen
$postData = http_build_query([
    'UserName' => $autohaus['resy_username'],
    'Password' => $autohaus['resy_password'],
    'button' => 'submit',
    'FN' => 'login'
]);

curl_setopt($ch, CURLOPT_URL, 'https://resy.dtm-reifen.de/index.php?m=login&a=login');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'User-Agent: Mozilla/5.0',
    'Content-Type: application/x-www-form-urlencoded',
    'Referer: https://resy.dtm-reifen.de/index.php?m=login&a=login'
]);

$response2 = curl_exec($ch);
echo "✅ Login-Request gesendet (" . strlen($response2) . " Zeichen)\n\n";

// Prüfe Login-Erfolg
echo "Prüfe Login-Response...\n";

$indicators = [
    'Sätze / Rücklieferungen bestellen' => 'ADMIN-MENU',
    'RESY Websystem' => 'SYSTEM-TITLE',
    'Lagerbestand' => 'INVENTORY',
    'Anmeldename' => 'LOGIN-FORM',
    'Kennwort' => 'PASSWORD-FIELD',
    'InputUser' => 'USER-INPUT',
    'InputPass' => 'PASS-INPUT'
];

foreach ($indicators as $indicator => $label) {
    if (strpos($response2, $indicator) !== false) {
        echo "   ✅ Gefunden: $label\n";
    }
}

echo "\n";

// Speichere Response
file_put_contents('debug_login_response.html', $response2);
echo "📄 Login-Response gespeichert in: debug_login_response.html\n";

curl_close($ch);

if (file_exists($cookieFile)) {
    echo "\n📄 Cookie-Datei:\n";
    $cookies = file($cookieFile);
    foreach ($cookies as $cookie) {
        if (strpos($cookie, '#') !== 0 && trim($cookie)) {
            echo "   $cookie\n";
        }
    }
}

echo "\n✅ Debug abgeschlossen!\n";

?>

