<?php
/**
 * Login/Registrierungsseite für Boxenstop
 */

session_start();
require_once 'config/database.php';

// Prüfe ob User bereits eingeloggt ist
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    // Redirect zu gewünschter Seite oder index.php
    $redirect = $_GET['redirect'] ?? 'index.php';
    
    // Validiere und sanitize redirect URL (nur relative Pfade erlauben)
    $redirect = filter_var($redirect, FILTER_SANITIZE_URL);
    if (!preg_match('/^[a-zA-Z0-9_\-\.\/]+\.php(\?.*)?$/', $redirect)) {
        $redirect = 'index.php';
    }
    
    if (isset($_GET['event'])) {
        // Validiere event ID (nur Zahlen erlauben)
        $event_id = filter_var($_GET['event'], FILTER_VALIDATE_INT);
        if ($event_id !== false && $event_id > 0) {
            $redirect .= '?event=' . $event_id;
        }
    }
    header('Location: ' . $redirect);
    exit;
}

// Redirect-Parameter speichern
$redirect_after_login = $_GET['redirect'] ?? 'index.php';

// Validiere und sanitize redirect URL (nur relative Pfade erlauben)
$redirect_after_login = filter_var($redirect_after_login, FILTER_SANITIZE_URL);
if (!preg_match('/^[a-zA-Z0-9_\-\.\/]+\.php(\?.*)?$/', $redirect_after_login)) {
    $redirect_after_login = 'index.php';
}

if (isset($_GET['event'])) {
    // Validiere event ID (nur Zahlen erlauben)
    $event_id = filter_var($_GET['event'], FILTER_VALIDATE_INT);
    if ($event_id !== false && $event_id > 0) {
        $redirect_after_login .= '?event=' . $event_id;
    }
}
$_SESSION['redirect_after_login'] = $redirect_after_login;

// Unternehmensdaten laden
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('company_name', 'company_logo', 'app_name')");
$stmt->execute();
$companySettings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

$companyName = $companySettings['company_name'] ?? 'B&E Gruppe';
$companyLogo = $companySettings['company_logo'] ?? 'assets/images/pwa_logo.png';
$companyLogo = ltrim($companyLogo, '/');
$appName = $companySettings['app_name'] ?? 'B&E Gruppe';

// Aktive Autohäuser laden (mit allen Daten für Cards)
$stmt = $conn->prepare("SELECT id, name, short_name, address, phone, footer_image, footer_image_alt FROM autohaus WHERE is_active = 1 ORDER BY name ASC");
$stmt->execute();
$autohauser = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Anmelden oder Registrieren - <?php echo htmlspecialchars($appName); ?></title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#0056b3">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="<?php echo htmlspecialchars($appName); ?>">
    <link rel="manifest" href="/manifest.json">
    
    <!-- Apple Touch Icons - iOS (180x180 ist Standard für moderne iOS-Geräte) -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon-precomposed" sizes="180x180" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="152x152" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="144x144" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="120x120" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="114x114" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="76x76" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="72x72" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="60x60" href="assets/images/new-pwa_icon.png">
    <link rel="apple-touch-icon" sizes="57x57" href="assets/images/new-pwa_icon.png">
    
    <!-- Favicons - Alle Browser -->
    <link rel="icon" type="image/png" sizes="512x512" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="384x384" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="192x192" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="152x152" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="144x144" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="128x128" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="96x96" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="72x72" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="48x48" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/new-pwa_icon.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/new-pwa_icon.png">
    <link rel="shortcut icon" href="assets/images/new-pwa_icon.png">
    <link rel="icon" href="assets/images/new-pwa_icon.png">
    
    <!-- Favicons -->
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/pwa_logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/pwa_logo.png">
    <link rel="shortcut icon" href="assets/images/pwa_logo.png">
    
    <link rel="stylesheet" href="assets/css/style.css">
    <link rel="stylesheet" href="assets/css/volvo-theme.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://appleid.cdn-apple.com/appleauth/static/jsapi/appleid/1/en_US/appleid.auth.js"></script>
    <script src="https://accounts.google.com/gsi/client" async defer></script>
    <style>
        body {
            position: relative;
            min-height: 100vh;
            background: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/backgroundimage2x_processed.jpg') center center / cover no-repeat;
        }
        
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: url('https://www.volvocars-haendler.de/assets/support/img/home_campaign_teaser/1369/backgroundimage2x_processed.jpg') center center / cover no-repeat;
            filter: blur(8px);
            z-index: -1;
        }
        
        body::after {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.3);
            z-index: -1;
        }
        
        /* Einfaches Tab-Interface */
        .auth-container {
            min-height: calc(100vh - 80px);
            padding: 3rem 2rem;
            margin-top: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .auth-wrapper {
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
            max-width: 850px;
            width: 100%;
            overflow: hidden;
        }
        
        .auth-tabs {
            display: flex;
            border-bottom: 2px solid #e9ecef;
        }
        
        .auth-tab {
            flex: 1;
            padding: 0.625rem 1.25rem;
            text-align: center;
            background: transparent;
            border: none;
            border-bottom: 2px solid transparent;
            font-size: 0.9rem;
            font-weight: 500;
            color: #6c757d;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 4px 4px 0 0;
        }
        
        .auth-tab.active {
            color: #0056b3;
            border-bottom-color: #0056b3;
            font-weight: 500;
        }
        
        .auth-tab:hover:not(.active) {
            color: #1a1a1a;
            background: #f8f9fa;
        }
        
        .auth-tab:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .auth-content {
            display: none;
            padding: 2.5rem;
        }
        
        .auth-content.active {
            display: block;
        }
        
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            margin-bottom: 0.5rem;
            color: #495057;
            font-weight: 600;
            font-size: 0.95rem;
        }
        
        .form-group label i {
            color: #0056b3;
            font-size: 0.9rem;
            width: 18px;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 1rem 1.25rem;
            border: 2px solid #e9ecef;
            border-radius: 12px;
            font-size: 0.95rem;
            transition: all 0.3s;
            background-color: white;
            font-family: inherit;
        }
        
        .form-group input:hover,
        .form-group select:hover {
            border-color: #dee2e6;
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #003057;
            box-shadow: 0 0 0 3px rgba(0, 48, 87, 0.1);
            transform: translateY(-1px);
        }
        
        .form-group select {
            cursor: pointer;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='16' height='16' viewBox='0 0 16 16'%3E%3Cpath fill='%23003057' d='M8 11L3 6h10z'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 1rem center;
            padding-right: 3rem;
        }
        
        /* Autohaus Cards wie in index.php */
        .autohaus-selection-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 1.5rem;
            margin-bottom: 1.5rem;
        }
        
        @media (max-width: 1200px) {
            .autohaus-selection-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }
        
        @media (max-width: 768px) {
            .autohaus-selection-grid {
                grid-template-columns: 1fr;
            }
        }
        
        .autohaus-selection-card {
            background: white;
            border-radius: 12px;
            padding: 1.5rem;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            cursor: pointer;
            transition: all 0.3s ease;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }
        
        .autohaus-selection-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.15);
            border-color: #003057;
        }
        
        .autohaus-selection-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #003057, #0056b3);
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .autohaus-selection-card:hover::before {
            transform: scaleX(1);
        }
        
        .autohaus-selection-card.selected {
            border-color: #003057;
            background: #f8f9ff;
        }
        
        .autohaus-selection-card.selected::before {
            transform: scaleX(1);
        }
        
        .autohaus-card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1rem;
        }
        
        .autohaus-card-header h3 {
            margin: 0;
            color: #003057;
            font-size: 1.1rem;
            font-weight: 700;
        }
        
        .autohaus-short {
            background: #003057;
            color: white;
            padding: 0.25rem 0.75rem;
            border-radius: 20px;
            font-size: 0.75rem;
            font-weight: 600;
        }
        
        .autohaus-card-info {
            margin-bottom: 0.5rem;
        }
        
        .autohaus-card-info .info-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 0.5rem;
            color: #6c757d;
            font-size: 0.9rem;
        }
        
        .autohaus-card-info .info-item i {
            width: 16px;
            color: #003057;
        }
        
        .autohaus-card-image {
            margin-top: 1rem;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .autohaus-card-image img {
            width: 100%;
            max-height: 150px;
            object-fit: cover;
            border-radius: 8px;
        }
        
        .autohaus-card-action {
            text-align: center;
            color: #003057;
            font-size: 1.2rem;
            opacity: 0;
            transition: opacity 0.3s ease;
            margin-top: 0.5rem;
        }
        
        .autohaus-selection-card:hover .autohaus-card-action {
            opacity: 1;
        }
        
        .autohaus-selection-card.selected .autohaus-card-action {
            opacity: 1;
            color: #28a745;
        }
        
        /* Registrierungsformular - Gruppierte Felder */
        .register-section {
            margin-bottom: 2rem;
        }
        
        .register-section-title {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-size: 1.1rem;
            font-weight: 700;
            color: #003057;
            margin-bottom: 1.25rem;
            padding-bottom: 0.75rem;
            border-bottom: 2px solid #e9ecef;
        }
        
        .register-section-title i {
            color: #0056b3;
            font-size: 1.25rem;
        }
        
        .register-fields-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.25rem;
        }
        
        .register-field-full {
            grid-column: 1 / -1;
        }
        
        /* Icons für Input-Felder */
        .input-with-icon {
            position: relative;
        }
        
        .input-with-icon i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
            pointer-events: none;
            z-index: 1;
        }
        
        .input-with-icon input {
            padding-left: 2.75rem;
        }
        
        .input-with-icon select {
            padding-left: 2.75rem;
        }
        
        .btn {
            width: 100%;
            padding: 0.625rem 1.25rem;
            border: none;
            border-radius: 4px;
            font-size: 0.9rem;
            font-weight: 500;
            cursor: pointer;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            position: relative;
            font-family: inherit;
        }
        
        .btn-primary {
            background: #0056b3;
            color: #ffffff;
            box-shadow: none;
        }
        
        .btn-primary:hover,
        .btn-primary:focus {
            background: #0066cc;
            color: #ffffff;
        }
        
        .btn-primary:active {
            background: #004c99;
            color: #ffffff;
        }
        
        .btn-primary:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .btn-primary:disabled {
            background: #cfe2ff;
            color: #adb5bd;
            cursor: not-allowed;
            opacity: 0.6;
        }
        
        .btn-apple {
            background: #1a1a1a;
            color: #ffffff;
            box-shadow: none;
        }
        
        .btn-apple:hover,
        .btn-apple:focus {
            background: #2d2d2d;
            color: #ffffff;
        }
        
        .btn-apple:active {
            background: #0d0d0d;
            color: #ffffff;
        }
        
        .btn-apple:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .btn-apple:disabled {
            background: #e9ecef;
            color: #adb5bd;
            cursor: not-allowed;
            opacity: 0.6;
        }
        
        .btn-apple i {
            font-size: 1rem;
            width: auto;
            height: auto;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .btn-google {
            background: #ffffff;
            color: #1a1a1a;
            border: 1px solid #dee2e6;
            box-shadow: none;
        }
        
        .btn-google:hover,
        .btn-google:focus {
            background: #f8f9fa;
            color: #1a1a1a;
            border-color: #adb5bd;
        }
        
        .btn-google:active {
            background: #e9ecef;
            color: #1a1a1a;
            border-color: #6c757d;
        }
        
        .btn-google:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .btn-google:disabled {
            background: #ffffff;
            color: #adb5bd;
            border-color: #e9ecef;
            cursor: not-allowed;
            opacity: 0.6;
        }
        
        .btn-google .google-logo {
            width: 1rem;
            height: 1rem;
        }
        
        .btn-google .google-logo svg {
            width: 1rem;
            height: 1rem;
        }
        
        /* Loading Animation für Buttons */
        .btn.loading {
            position: relative;
            pointer-events: none;
            opacity: 0.7;
        }
        
        .btn.loading::after {
            content: '';
            position: absolute;
            width: 16px;
            height: 16px;
            margin: auto;
            border: 2px solid transparent;
            border-top-color: currentColor;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }
        
        .btn.loading span,
        .btn.loading i {
            opacity: 0.5;
        }
        
        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }
        
        /* OAuth Modal */
        .oauth-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 10001;
            overflow-y: auto;
            padding: 1rem;
            animation: fadeIn 0.3s ease;
        }
        
        .oauth-modal.active {
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .oauth-modal-content {
            background: white;
            border-radius: 16px;
            padding: 2rem;
            max-width: 500px;
            width: 100%;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            animation: slideUp 0.3s ease;
            position: relative;
        }
        
        .oauth-modal-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1.5rem;
        }
        
        .oauth-modal-header h3 {
            margin: 0;
            color: #003057;
            font-size: 1.25rem;
            font-weight: 700;
        }
        
        .oauth-modal-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: pointer;
            color: #6c757d;
            padding: 0;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            transition: all 0.2s;
        }
        
        .oauth-modal-close:hover {
            background: #f8f9fa;
            color: #003057;
        }
        
        .oauth-modal-body {
            text-align: center;
        }
        
        .oauth-modal-spinner {
            width: 48px;
            height: 48px;
            margin: 0 auto 1.5rem;
            border: 4px solid #e9ecef;
            border-top-color: #0056b3;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }
        
        .oauth-modal-message {
            color: #495057;
            font-size: 1rem;
            margin-bottom: 1rem;
            line-height: 1.5;
        }
        
        .oauth-modal-instruction {
            color: #6c757d;
            font-size: 0.9rem;
            margin-top: 1rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 8px;
        }
        
        .oauth-modal-instruction i {
            color: #0056b3;
            margin-right: 0.5rem;
        }
        
        .btn-volvo {
            background: #0056b3;
            color: #ffffff;
            border: none;
            box-shadow: none;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }
        
        .btn-volvo:not(:disabled):hover,
        .btn-volvo:not(:disabled):focus {
            background: #0066cc;
            color: #ffffff;
        }
        
        .btn-volvo:not(:disabled):active {
            background: #004c99;
            color: #ffffff;
        }
        
        .btn-volvo:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .btn-volvo:disabled {
            background: #cfe2ff;
            color: #adb5bd;
            cursor: not-allowed;
            opacity: 0.6;
        }
        
        .btn-volvo .volvo-logo {
            width: 1rem;
            height: 1rem;
        }
        
        .volvo-logo {
            width: 28px;
            height: 28px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .volvo-logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            filter: brightness(0) invert(1);
            display: block;
        }
        
        /* Google Logo mit vier Farben */
        .google-logo {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 28px;
            height: 28px;
            margin-right: 0.5rem;
            position: relative;
            flex-shrink: 0;
        }
        
        .google-logo svg {
            width: 28px;
            height: 28px;
        }
        
        /* Google Logo - vierfarbiges "G" */
        .google-g {
            font-weight: 500;
            font-size: 18px;
            line-height: 1;
            display: inline-block;
            background: linear-gradient(135deg, #4285f4 0%, #4285f4 25%, #ea4335 25%, #ea4335 50%, #fbbc04 50%, #fbbc04 75%, #34a853 75%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            font-family: 'Product Sans', 'Roboto', 'Arial', sans-serif;
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 2rem 0;
            color: #6c757d;
        }
        
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            height: 1px;
            background: #dee2e6;
        }
        
        .social-buttons {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .social-buttons .btn {
            width: 100%;
        }
        
        .divider span {
            padding: 0 1rem;
            font-size: 0.9rem;
        }
        
        /* Notification System */
        .notification-container {
            position: fixed;
            top: 100px;
            right: 20px;
            z-index: 10000;
            display: flex;
            flex-direction: column;
            gap: 1rem;
            max-width: 400px;
            width: 100%;
            pointer-events: none;
        }
        
        .notification {
            background: white;
            border-radius: 12px;
            padding: 1rem 1.25rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.15);
            display: flex;
            align-items: flex-start;
            gap: 1rem;
            min-width: 300px;
            max-width: 100%;
            pointer-events: auto;
            animation: slideInRight 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            border-left: 4px solid;
        }
        
        .notification::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: currentColor;
            opacity: 0.3;
        }
        
        @keyframes slideInRight {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        @keyframes slideOutRight {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(100%);
                opacity: 0;
            }
        }
        
        @keyframes fadeIn {
            from {
                opacity: 0;
            }
            to {
                opacity: 1;
            }
        }
        
        @keyframes slideUp {
            from {
                transform: translateY(30px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        
        @keyframes fadeOut {
            from {
                opacity: 1;
            }
            to {
                opacity: 0;
            }
        }
        
        .notification.hiding {
            animation: slideOutRight 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .notification-icon {
            flex-shrink: 0;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
        }
        
        .notification-content {
            flex: 1;
            min-width: 0;
        }
        
        .notification-title {
            font-weight: 600;
            font-size: 0.95rem;
            margin-bottom: 0.25rem;
            line-height: 1.4;
        }
        
        .notification-message {
            font-size: 0.875rem;
            line-height: 1.5;
            opacity: 0.9;
        }
        
        .notification-close {
            flex-shrink: 0;
            background: none;
            border: none;
            color: inherit;
            cursor: pointer;
            padding: 0.25rem;
            opacity: 0.6;
            transition: opacity 0.2s;
            font-size: 1.25rem;
            line-height: 1;
            width: 24px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .notification-close:hover {
            opacity: 1;
        }
        
        /* Notification Types */
        .notification-success {
            border-left-color: #28a745;
            color: #155724;
        }
        
        .notification-success .notification-icon {
            background: #d4edda;
            color: #28a745;
        }
        
        .notification-error {
            border-left-color: #dc3545;
            color: #721c24;
        }
        
        .notification-error .notification-icon {
            background: #f8d7da;
            color: #dc3545;
        }
        
        .notification-warning {
            border-left-color: #ffc107;
            color: #856404;
        }
        
        .notification-warning .notification-icon {
            background: #fff3cd;
            color: #ffc107;
        }
        
        .notification-info {
            border-left-color: #17a2b8;
            color: #0c5460;
        }
        
        .notification-info .notification-icon {
            background: #d1ecf1;
            color: #17a2b8;
        }
        
        /* Progress Bar für Auto-Dismiss */
        .notification-progress {
            position: absolute;
            bottom: 0;
            left: 0;
            height: 3px;
            background: currentColor;
            opacity: 0.4;
            transform-origin: left;
            animation: progressShrink linear forwards;
        }
        
        @keyframes progressShrink {
            from {
                transform: scaleX(1);
            }
            to {
                transform: scaleX(0);
            }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .notification-container {
                top: 80px;
                right: 10px;
                left: 10px;
                max-width: calc(100% - 20px);
            }
            
            .notification {
                min-width: auto;
                width: 100%;
            }
        }
        
        /* Legacy Alert System (für Rückwärtskompatibilität) */
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
            display: none;
        }
        
        .alert.show {
            display: block;
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        
        .alert-info {
            background: #d1ecf1;
            color: #0c5460;
            border: 1px solid #bee5eb;
        }
        
        .password-toggle {
            position: relative;
        }
        
        .password-toggle input {
            padding-right: 3rem;
        }
        
        .password-toggle.input-with-icon input {
            padding-left: 2.75rem;
            padding-right: 3rem;
        }
        
        .password-toggle-btn {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #6c757d;
            cursor: pointer;
            padding: 0.5rem;
            z-index: 2;
            transition: color 0.3s;
        }
        
        .password-toggle-btn:hover {
            color: #0056b3;
        }
        
        .password-toggle-btn i {
            font-size: 1rem;
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .auth-container {
                padding: 1rem;
                margin-top: 80px;
            }
            
            .auth-wrapper {
                max-width: 100%;
                border-radius: 12px;
            }
            
            .auth-content {
                padding: 1.5rem;
            }
            
            .auth-tab {
                padding: 1rem 0.75rem;
                font-size: 0.9rem;
            }
            
            .register-fields-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .register-section {
                margin-bottom: 1.5rem;
            }
            
            .register-section-title {
                font-size: 1rem;
                margin-bottom: 1rem;
            }
            
            .form-group label {
                font-size: 0.9rem;
            }
            
            .input-with-icon i {
                left: 0.875rem;
                font-size: 0.9rem;
            }
            
            .input-with-icon input,
            .input-with-icon select {
                padding-left: 2.5rem;
                font-size: 0.9rem;
            }
            
            .password-toggle.input-with-icon input {
                padding-left: 2.5rem;
                padding-right: 2.75rem;
            }
            
            .autohaus-selection-grid {
                grid-template-columns: 1fr;
                gap: 1rem;
            }
            
            .autohaus-selection-card {
                padding: 1.25rem;
            }
            
            .autohaus-card-header h3 {
                font-size: 1rem;
            }
        }
        /* Navigation - Volvo Style */
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
        }
        
        .nav-brand h1 {
            font-size: 1.2rem;
            margin: 0;
        }
        
        .nav-brand .brand-subtitle {
            font-size: 0.85rem;
        }
        
        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.625rem 1.25rem;
            border-radius: 4px;
            text-decoration: none;
            font-weight: 500;
            font-size: 0.9rem;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid #dee2e6;
            background: #ffffff;
            color: #1a1a1a;
            box-shadow: none;
        }
        
        .nav-link:hover,
        .nav-link:focus {
            background: #f8f9fa;
            color: #1a1a1a;
            border-color: #adb5bd;
        }
        
        .nav-link:active {
            background: #e9ecef;
            color: #1a1a1a;
            border-color: #6c757d;
        }
        
        .nav-link:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .nav-link i {
            font-size: 0.9rem;
        }
        
        /* Mobile Menu Button (Burger Menu) - Volvo Design */
        .mobile-menu-btn {
            display: none;
            background: #1a1a1a !important;
            border: 1px solid #1a1a1a !important;
            color: #ffffff !important;
            font-size: 1.25rem;
            cursor: pointer;
            padding: 0.625rem;
            border-radius: 4px;
            transition: all 0.2s cubic-bezier(0.4, 0, 0.2, 1);
            width: 44px;
            height: 44px;
            align-items: center;
            justify-content: center;
            box-shadow: none;
            flex-shrink: 0;
            margin-left: auto;
        }
        
        .mobile-menu-btn i {
            color: #ffffff !important;
        }
        
        .mobile-menu-btn:hover {
            background: #2d2d2d;
            border-color: #2d2d2d;
            color: #ffffff;
        }
        
        .mobile-menu-btn:active {
            background: #0d0d0d;
            border-color: #0d0d0d;
        }
        
        .mobile-menu-btn:focus {
            outline: 2px solid #0056b3;
            outline-offset: 2px;
        }
        
        .mobile-menu-btn.active {
            background: #0056b3;
            border-color: #0056b3;
        }
        
        .mobile-menu-btn.active:hover {
            background: #0066cc;
            border-color: #0066cc;
        }
        
        @media (max-width: 768px) {
            .nav-container {
                position: relative;
            }
            
            .mobile-menu-btn {
                display: flex !important;
                order: 2;
            }
            
            .nav-menu {
                position: absolute;
                top: 100%;
                left: 0;
                right: 0;
                background: #ffffff;
                flex-direction: column;
                padding: 1rem;
                gap: 0.5rem;
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
                border-radius: 0 0 4px 4px;
                border-top: 1px solid #e9ecef;
                transform: translateY(-100%);
                opacity: 0;
                visibility: hidden;
                transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
                z-index: 999;
                order: 3;
            }
            
            .nav-menu.mobile-open {
                transform: translateY(0);
                opacity: 1;
                visibility: visible;
            }
            
            .nav-link {
                width: 100%;
                padding: 0.75rem 1rem;
                font-size: 0.9rem;
                justify-content: flex-start;
            }
            
            .nav-link span {
                display: inline;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <div class="logo-wrapper">
                    <img src="<?php echo htmlspecialchars($companyLogo); ?>" alt="<?php echo htmlspecialchars($companyName); ?>" class="nav-logo">
                    <div class="brand-text">
                        <h1><?php echo htmlspecialchars($appName); ?></h1>
                        <span class="brand-subtitle">B&E Gruppe - Volvo Service</span>
                    </div>
                </div>
            </div>
            <div class="nav-menu">
                <a href="index.php" class="nav-link">
                    <i class="fas fa-arrow-left"></i>
                    <span>Zurück</span>
                </a>
            </div>
        </div>
    </nav>
    
    <!-- Alert Messages (Legacy) -->
    <div id="alert-message" class="alert"></div>
    
    <!-- Notification Container -->
    <div id="notification-container" class="notification-container"></div>
    
    <div class="auth-container">
        <div class="auth-wrapper">
            <!-- Tabs -->
            <div class="auth-tabs">
                <button class="auth-tab active" onclick="switchTab('login')">Anmelden</button>
                <button class="auth-tab" onclick="switchTab('register')">Registrieren</button>
            </div>
            
            <!-- Login Content -->
            <div id="login-content" class="auth-content active">
                <form id="login-form">
                    <div class="form-group">
                        <label for="login-email">
                            <i class="fas fa-envelope"></i>
                            <span>E-Mail-Adresse</span>
                        </label>
                        <div class="input-with-icon">
                            <i class="fas fa-at"></i>
                            <input type="email" id="login-email" name="email" required placeholder="ihr@email.de">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="login-password">
                            <i class="fas fa-lock"></i>
                            <span>Passwort</span>
                        </label>
                        <div class="password-toggle input-with-icon">
                            <i class="fas fa-key"></i>
                            <input type="password" id="login-password" name="password" required placeholder="Ihr Passwort">
                            <button type="button" class="password-toggle-btn" onclick="togglePassword('login-password')">
                                <i class="fas fa-eye"></i>
                            </button>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-sign-in-alt"></i>
                        <span>Anmelden</span>
                    </button>
                </form>
                
                <div class="divider">
                    <span>oder</span>
                </div>
                
                <div class="social-buttons">
                    <button id="apple-signin-button" class="btn btn-apple" onclick="handleAppleSignIn()">
                        <i class="fab fa-apple"></i>
                        <span id="apple-button-text">Mit Apple anmelden</span>
                    </button>
                    
                    <button id="google-signin-button" class="btn btn-google" onclick="handleGoogleSignIn()">
                        <span class="google-logo">
                            <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                                <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                                <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                                <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                            </svg>
                        </span>
                        <span id="google-button-text">Mit Google anmelden</span>
                    </button>
                    
                    <button id="volvo-signin-button" class="btn btn-volvo" onclick="handleVolvoSignIn()" disabled>
                        <div class="volvo-logo">
                            <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/2/29/Volvo-Iron-Mark-Black.svg/2048px-Volvo-Iron-Mark-Black.svg.png" alt="Volvo Logo" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline';">
                            <span style="display:none; font-size: 10px; font-weight: 700; color: white;">VOLVO</span>
                        </div>
                        <span id="volvo-button-text">Mit VOLVO-ID anmelden</span>
                    </button>
                </div>
            </div>
            
            <!-- Register Content -->
            <div id="register-content" class="auth-content">
                <form id="register-form">
                    <!-- Autohaus Auswahl -->
                    <div class="register-section">
                        <div class="register-section-title">
                            <i class="fas fa-building"></i>
                            <span>Autohaus auswählen</span>
                        </div>
                        <div class="autohaus-selection-grid">
                            <?php foreach ($autohauser as $autohaus) { ?>
                                <div class="autohaus-selection-card" data-autohaus-id="<?php echo $autohaus['id']; ?>">
                                    <div class="autohaus-card-header">
                                        <h3><?php echo htmlspecialchars($autohaus['name']); ?></h3>
                                        <?php if (!empty($autohaus['short_name'])): ?>
                                            <span class="autohaus-short"><?php echo htmlspecialchars($autohaus['short_name']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="autohaus-card-info">
                                        <?php if (!empty($autohaus['address'])): ?>
                                            <div class="info-item">
                                                <i class="fas fa-map-marker-alt"></i>
                                                <span><?php echo htmlspecialchars($autohaus['address']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <?php if (!empty($autohaus['phone'])): ?>
                                            <div class="info-item">
                                                <i class="fas fa-phone"></i>
                                                <span><?php echo htmlspecialchars($autohaus['phone']); ?></span>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if (!empty($autohaus['footer_image'])): ?>
                                        <div class="autohaus-card-image">
                                            <?php 
                                            // Extrahiere Dateinamen aus dem Pfad
                                            $footer_filename = basename($autohaus['footer_image']); 
                                            ?>
                                            <img src="api/view_footer_image.php?file=<?php echo urlencode($footer_filename); ?>" 
                                                 alt="<?php echo htmlspecialchars($autohaus['footer_image_alt'] ?? $autohaus['name']); ?>" 
                                                 style="width: 100%; max-height: 150px; object-fit: cover; border-radius: 8px; margin-top: 1rem;">
                                        </div>
                                    <?php endif; ?>
                                    <div class="autohaus-card-action">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <input type="hidden" id="autohaus-auswahl" name="autohaus_id" required>
                    </div>
                        
                        <!-- Persönliche Daten -->
                        <div class="register-section">
                            <div class="register-section-title">
                                <i class="fas fa-user"></i>
                                <span>Persönliche Daten</span>
                            </div>
                            <div class="register-fields-grid">
                                <div class="form-group">
                                    <label for="register-firstname">
                                        <i class="fas fa-user-circle"></i>
                                        <span>Vorname</span>
                                    </label>
                                    <div class="input-with-icon">
                                        <i class="fas fa-user"></i>
                                        <input type="text" id="register-firstname" name="first_name" required placeholder="Max">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="register-lastname">
                                        <i class="fas fa-user-circle"></i>
                                        <span>Nachname</span>
                                    </label>
                                    <div class="input-with-icon">
                                        <i class="fas fa-user"></i>
                                        <input type="text" id="register-lastname" name="last_name" required placeholder="Mustermann">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Kontaktdaten -->
                        <div class="register-section">
                            <div class="register-section-title">
                                <i class="fas fa-address-card"></i>
                                <span>Kontaktdaten</span>
                            </div>
                            <div class="register-fields-grid">
                                <div class="form-group">
                                    <label for="register-email">
                                        <i class="fas fa-envelope"></i>
                                        <span>E-Mail-Adresse</span>
                                    </label>
                                    <div class="input-with-icon">
                                        <i class="fas fa-at"></i>
                                        <input type="email" id="register-email" name="email" required placeholder="ihr@email.de">
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <label for="register-phone">
                                        <i class="fas fa-phone"></i>
                                        <span>Telefonnummer</span>
                                    </label>
                                    <div class="input-with-icon">
                                        <i class="fas fa-phone-alt"></i>
                                        <input type="tel" id="register-phone" name="phone_number" required placeholder="+49 123 456789">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Fahrzeugdaten -->
                        <div class="register-section">
                            <div class="register-section-title">
                                <i class="fas fa-car"></i>
                                <span>Fahrzeugdaten</span>
                            </div>
                            <div class="form-group register-field-full">
                                <label for="register-license">
                                    <i class="fas fa-id-card"></i>
                                    <span>Kennzeichen</span>
                                </label>
                                <div class="input-with-icon">
                                    <i class="fas fa-car-side"></i>
                                    <input type="text" id="register-license" name="license_plate" required placeholder="M-AB 123">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Sicherheit -->
                        <div class="register-section">
                            <div class="register-section-title">
                                <i class="fas fa-lock"></i>
                                <span>Sicherheit</span>
                            </div>
                            <div class="register-fields-grid">
                                <div class="form-group">
                                    <label for="register-password">
                                        <i class="fas fa-key"></i>
                                        <span>Passwort</span>
                                    </label>
                                    <div class="password-toggle input-with-icon">
                                        <i class="fas fa-lock"></i>
                                        <input type="password" id="register-password" name="password" required placeholder="Mindestens 8 Zeichen" minlength="8" oninput="validatePassword()">
                                        <button type="button" class="password-toggle-btn" onclick="togglePassword('register-password')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <div id="password-strength" style="margin-top: 0.5rem; font-size: 0.85rem;"></div>
                                    <small style="display: block; margin-top: 0.5rem; color: #6c757d; font-size: 0.85rem;">
                                        <i class="fas fa-info-circle"></i> Mindestens 8 Zeichen, 1 Großbuchstabe, 1 Zahl
                                    </small>
                                </div>
                                
                                <div class="form-group">
                                    <label for="register-password-confirm">
                                        <i class="fas fa-key"></i>
                                        <span>Passwort bestätigen</span>
                                    </label>
                                    <div class="password-toggle input-with-icon">
                                        <i class="fas fa-lock"></i>
                                        <input type="password" id="register-password-confirm" name="password_confirm" required placeholder="Passwort wiederholen" oninput="validatePasswordMatch()">
                                        <button type="button" class="password-toggle-btn" onclick="togglePassword('register-password-confirm')">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                    <div id="password-match" style="margin-top: 0.5rem; font-size: 0.85rem;"></div>
                                </div>
                            </div>
                        </div>
                        
                    <!-- Einheitliche Datenschutz-Checkbox für alle Register-Methoden -->
                    <div id="global-datenschutz" style="display: block; margin: 1.5rem 0; padding: 1.25rem; background: #f8f9fa; border-radius: 12px; border: 2px solid #e9ecef; transition: all 0.3s ease;" class="datenschutz-container">
                    <label style="display: flex; align-items: flex-start; gap: 0.75rem; font-size: 0.95rem; margin: 0;">
                        <input type="checkbox" id="global-datenschutz-agreement" disabled style="width: auto; margin-top: 0.25rem; flex-shrink: 0; cursor: not-allowed;" onchange="toggleAllRegisterButtons()">
                        <span style="line-height: 1.6;">
                            <a href="#" onclick="openDatenschutzModal(); return false;" style="color: #0056b3; text-decoration: underline; font-weight: 600;">Datenschutzerklärung lesen und akzeptieren</a> ist erforderlich. *
                        </span>
                    </label>
                    <p style="margin-top: 0.75rem; color: #6c757d; font-size: 0.85rem; text-align: center;">
                        <i class="fas fa-lock"></i> Öffnen Sie die Datenschutzerklärung und bestätigen Sie diese im Modal.
                    </p>
                </div>
                    
                        <button type="submit" id="register-submit" class="btn btn-primary" style="margin-top: 1rem;">
                            <i class="fas fa-user-plus"></i>
                            <span>Jetzt registrieren</span>
                        </button>
                    </form>
                    
                    <div class="divider" style="margin-top: 2rem;">
                        <span>oder</span>
                    </div>
                    
                    <div class="social-buttons">
                        <button id="apple-signin-button-register" class="btn btn-apple" onclick="handleAppleSignIn()">
                            <i class="fab fa-apple"></i>
                            <span id="apple-button-text-register">Mit Apple registrieren</span>
                        </button>
                        
                        <button id="google-signin-button-register" class="btn btn-google" onclick="handleGoogleSignIn()">
                            <span class="google-logo">
                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                                    <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                                    <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                                    <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
                                </svg>
                            </span>
                            <span id="google-button-text-register">Mit Google registrieren</span>
                        </button>
                        
                        <button id="volvo-signin-button-register" class="btn btn-volvo" onclick="handleVolvoSignIn()" disabled>
                            <div class="volvo-logo">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/2/29/Volvo-Iron-Mark-Black.svg/2048px-Volvo-Iron-Mark-Black.svg.png" alt="Volvo Logo" onerror="this.style.display='none'; this.nextElementSibling.style.display='inline';">
                                <span style="display:none; font-size: 10px; font-weight: 700; color: white;">VOLVO</span>
                            </div>
                            <span id="volvo-button-text-register">Mit VOLVO-ID registrieren</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Datenschutz Modal -->
    <div id="datenschutz-modal" class="modal" style="display: none; position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(0,0,0,0.7); z-index: 9999; overflow-y: auto; padding: 1rem;">
        <div class="modal-content" style="background: white; max-width: 800px; margin: 1rem auto; border-radius: 16px; padding: 1.5rem; box-shadow: 0 8px 32px rgba(0,0,0,0.3); max-height: 95vh; display: flex; flex-direction: column;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 2rem;">
                <h2 style="margin: 0; color: #003057;">Datenschutzerklärung</h2>
                <button onclick="closeDatenschutzModal()" style="background: none; border: none; font-size: 2rem; cursor: pointer; color: #6c757d;">&times;</button>
            </div>
            
            <div style="flex: 1; overflow-y: auto; line-height: 1.8; margin-bottom: 1.5rem;">
                <h3 style="color: #003057; margin-top: 0;">1. Verantwortlicher</h3>
                <p>
                    B&E Vertriebsgesellschaft mbH<br>
                    B&E Gruppe
                </p>
                
                <h3 style="color: #003057;">2. Erhebung und Verarbeitung personenbezogener Daten</h3>
                <p>
                    Wir erheben und verarbeiten folgende personenbezogene Daten:
                </p>
                <ul>
                    <li><strong>Anmeldedaten:</strong> Vorname, Nachname, E-Mail-Adresse, Passwort (verschlüsselt)</li>
                    <li><strong>Kontaktdaten:</strong> Telefonnummer, Adresse, Postleitzahl, Stadt</li>
                    <li><strong>Fahrzeugdaten:</strong> Kennzeichen, Marke, Modell, Baujahr</li>
                    <li><strong>Buchungsdaten:</strong> Termine, Autohaus, bevorzugtes Datum</li>
                    <li><strong>Technische Daten:</strong> IP-Adresse, Gerätetyp, Browser-Version</li>
                    <li><strong>Registrierungsquelle:</strong> Web, iOS App, Android App, Apple Sign-In, Google Sign-In</li>
                </ul>
                
                <h3 style="color: #003057;">3. Zweck der Datenverarbeitung</h3>
                <p>
                    Ihre Daten werden für folgende Zwecke verwendet:
                </p>
                <ul>
                    <li>Erstellung und Verwaltung Ihres Benutzerkontos</li>
                    <li>Terminbuchungen und -verwaltung bei unseren Partner-Autohäusern</li>
                    <li>Kommunikation bezüglich Ihrer Termine</li>
                    <li>Verifikation Ihrer Identität zum Schutz vor Missbrauch</li>
                    <li>Erfüllung gesetzlicher Anforderungen</li>
                    <li>Verbesserung unserer Dienstleistungen</li>
                </ul>
                
                <h3 style="color: #003057;">4. Speicherdauer</h3>
                <p>
                    Ihre Daten werden so lange gespeichert, wie es für die genannten Zwecke erforderlich ist oder gesetzlich vorgeschrieben ist. Nach Beendigung der Geschäftsbeziehung werden die Daten gelöscht, sofern keine gesetzlichen Aufbewahrungspflichten bestehen.
                </p>
                
                <h3 style="color: #003057;">5. Ihre Rechte</h3>
                <p>
                    Sie haben folgende Rechte bezüglich Ihrer Daten:
                </p>
                <ul>
                    <li><strong>Auskunft:</strong> Sie können jederzeit Auskunft über Ihre gespeicherten Daten verlangen</li>
                    <li><strong>Berichtigung:</strong> Sie können falsche Daten korrigieren lassen</li>
                    <li><strong>Löschung:</strong> Sie können die Löschung Ihrer Daten verlangen (außer bei gesetzlichen Aufbewahrungspflichten)</li>
                    <li><strong>Einschränkung:</strong> Sie können die Verarbeitung Ihrer Daten einschränken lassen</li>
                    <li><strong>Widerspruch:</strong> Sie können der Verarbeitung Ihrer Daten widersprechen</li>
                    <li><strong>Datenübertragbarkeit:</strong> Sie können Ihre Daten in einem strukturierten, gängigen Format erhalten</li>
                </ul>
                
                <h3 style="color: #003057;">6. Datensicherheit</h3>
                <p>
                    Wir setzen technische und organisatorische Maßnahmen ein, um Ihre Daten vor unberechtigtem Zugriff, Verlust oder Zerstörung zu schützen. Alle Übertragungen erfolgen verschlüsselt (HTTPS/SSL).
                </p>
                
                <h3 style="color: #003057;">7. Weitergabe von Daten</h3>
                <p>
                    Ihre Daten werden nur an unsere Partner-Autohäuser weitergegeben, soweit dies für die Terminbuchung erforderlich ist. Eine Weitergabe an Dritte erfolgt nicht ohne Ihre ausdrückliche Einwilligung, es sei denn, gesetzliche Bestimmungen verlangen dies.
                </p>
                
                <h3 style="color: #003057;">8. Einwilligung</h3>
                <p>
                    Durch die Registrierung erklären Sie sich mit der Erhebung, Verarbeitung und Nutzung Ihrer Daten gemäß dieser Datenschutzerklärung einverstanden. Diese Einwilligung kann jederzeit widerrufen werden.
                </p>
                
                <h3 style="color: #003057;">9. Änderungen der Datenschutzerklärung</h3>
                <p>
                    Wir behalten uns vor, diese Datenschutzerklärung anzupassen. Aktuelle Version: Oktober 2025.
                </p>
                
                <p style="margin-top: 2rem; font-weight: 600; color: #003057;">
                    Bei Fragen zum Datenschutz kontaktieren Sie uns bitte unter:<br>
                    E-Mail: info@be-automobile.de
                </p>
            </div>
            
            <div style="text-align: center; padding-top: 1rem; border-top: 2px solid #e9ecef; flex-shrink: 0;">
                <button onclick="acceptDatenschutzAndClose()" class="btn btn-primary" style="padding: 1rem 3rem; font-size: 1.1rem; width: 100%; max-width: 400px;">
                    <i class="fas fa-check-circle"></i>
                    Verstanden und Akzeptieren
                </button>
            </div>
        </div>
    </div>
    
    <!-- OAuth Login Modal -->
    <div id="oauth-modal" class="oauth-modal">
        <div class="oauth-modal-content">
            <div class="oauth-modal-header">
                <h3 id="oauth-modal-title">Anmeldung läuft...</h3>
                <button class="oauth-modal-close" onclick="closeOAuthModal()" id="oauth-modal-close" style="display: none;">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="oauth-modal-body">
                <div class="oauth-modal-spinner" id="oauth-modal-spinner"></div>
                <p class="oauth-modal-message" id="oauth-modal-message">
                    Bitte warten Sie, während wir Sie anmelden...
                </p>
                <div class="oauth-modal-instruction" id="oauth-modal-instruction" style="display: none;">
                    <i class="fas fa-info-circle"></i>
                    <span id="oauth-modal-instruction-text"></span>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .modal {
            animation: fadeIn 0.3s;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        
        /* Mobile Optimierung */
        @media (max-width: 768px) {
            #datenschutz-modal .modal-content {
                margin: 0.5rem !important;
                padding: 1rem !important;
                max-height: 98vh !important;
            }
            
            #datenschutz-modal h2 {
                font-size: 1.3rem !important;
            }
            
            #datenschutz-modal h3 {
                font-size: 1rem !important;
            }
            
            #datenschutz-modal p, #datenschutz-modal li {
                font-size: 0.9rem !important;
                line-height: 1.5 !important;
            }
            
            #datenschutz-modal button[onclick="acceptDatenschutzAndClose()"] {
                padding: 0.875rem 1.5rem !important;
                font-size: 1rem !important;
            }
            
            .close-modal {
                font-size: 1.5rem !important;
            }
        }
    </style>
    
        <script>
        // Redirect nach Login speichern
        const urlParams = new URLSearchParams(window.location.search);
        const redirect = urlParams.get('redirect');
        const event = urlParams.get('event');
        if (redirect) {
            let redirectUrl = redirect;
            if (event) {
                redirectUrl += '?event=' + event;
            }
            localStorage.setItem('redirect_after_login', redirectUrl);
        }
        
        // Tab Navigation
        async function switchTab(tab) {
            // Tabs
            const tabs = document.querySelectorAll('.auth-tab');
            tabs.forEach(t => {
                t.classList.remove('active');
                if ((tab === 'login' && t.textContent.trim() === 'Anmelden') || 
                    (tab === 'register' && t.textContent.trim() === 'Registrieren')) {
                    t.classList.add('active');
                }
            });
            
            // Content
            const loginContent = document.getElementById('login-content');
            const registerContent = document.getElementById('register-content');
            
            if (tab === 'login') {
                loginContent.classList.add('active');
                registerContent.classList.remove('active');
                const datenschutz = document.getElementById('global-datenschutz');
                if (datenschutz) datenschutz.style.display = 'none';
                // Button Texte für Login
                const appleText = document.getElementById('apple-button-text');
                const googleText = document.getElementById('google-button-text');
                if (appleText) appleText.textContent = 'Mit Apple anmelden';
                if (googleText) googleText.textContent = 'Mit Google anmelden';
            } else {
                loginContent.classList.remove('active');
                registerContent.classList.add('active');
                const datenschutz = document.getElementById('global-datenschutz');
                if (datenschutz) datenschutz.style.display = 'block';
                // Button Texte für Register
                const appleTextReg = document.getElementById('apple-button-text-register');
                const googleTextReg = document.getElementById('google-button-text-register');
                if (appleTextReg) appleTextReg.textContent = 'Mit Apple registrieren';
                if (googleTextReg) googleTextReg.textContent = 'Mit Google registrieren';
                
                // Prüfe ob bereits ein Autohaus ausgewählt ist
                const autohausSelected = document.getElementById('autohaus-auswahl')?.value;
                if (!autohausSelected || autohausSelected === '') {
                    // Kein Autohaus ausgewählt - versuche automatisch zu finden
                    // Warte kurz, damit das Modal vollständig geladen ist
                    setTimeout(async () => {
                        await getBrowserLocation();
                    }, 500);
                }
            }
        }
        
        // Autohaus Card Auswahl
        function selectAutohausCard(autohausId, event) {
            // Event-Objekt bekommen falls nicht übergeben
            if (!event) {
                event = window.event;
            }
            
            // Alle Cards deselektieren
            document.querySelectorAll('.autohaus-selection-card').forEach(card => {
                card.classList.remove('selected');
            });
            
            // Gewählte Card selektieren
            const selectedCard = event.currentTarget || event.target.closest('.autohaus-selection-card');
            if (selectedCard) {
                selectedCard.classList.add('selected');
            }
            
            // Hidden input setzen
            const input = document.getElementById('autohaus-auswahl');
            if (input) {
                input.value = autohausId;
                // Validierung auslösen
                input.setAttribute('data-selected', 'true');
            }
        }
        
        // Event Listener für Autohaus Cards (für bessere Desktop-Unterstützung)
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.autohaus-selection-card');
            cards.forEach(card => {
                // Entferne onclick-Attribut und verwende nur Event Listener
                const autohausId = card.getAttribute('data-autohaus-id') || 
                                   (card.getAttribute('onclick') ? 
                                    card.getAttribute('onclick').match(/selectAutohausCard\((\d+)\)/)?.[1] : null);
                
                if (autohausId) {
                    card.setAttribute('data-autohaus-id', autohausId);
                    card.removeAttribute('onclick');
                    
                    card.addEventListener('click', function(e) {
                        selectAutohausCard(parseInt(autohausId), e);
                    });
                }
            });
        });
        
        
        // Password Toggle
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const icon = input.nextElementSibling.querySelector('i');
            if (input.type === 'password') {
                input.type = 'text';
                icon.classList.remove('fa-eye');
                icon.classList.add('fa-eye-slash');
            } else {
                input.type = 'password';
                icon.classList.remove('fa-eye-slash');
                icon.classList.add('fa-eye');
            }
        }
        
        // Passwort-Validierung
        function validatePassword() {
            const password = document.getElementById('register-password').value;
            const strengthDiv = document.getElementById('password-strength');
            
            if (!password) {
                strengthDiv.innerHTML = '';
                return false;
            }
            
            let errors = [];
            let strength = 0;
            
            // Mindestlänge
            if (password.length >= 8) {
                strength++;
            } else {
                errors.push('Mindestens 8 Zeichen');
            }
            
            // Großbuchstabe
            if (/[A-Z]/.test(password)) {
                strength++;
            } else {
                errors.push('Mindestens 1 Großbuchstabe');
            }
            
            // Zahl
            if (/[0-9]/.test(password)) {
                strength++;
            } else {
                errors.push('Mindestens 1 Zahl');
            }
            
            // Sonderzeichen (optional, aber stärkt das Passwort)
            if (/[!@#$%^&*(),.?":{}|<>]/.test(password)) {
                strength++;
            }
            
            // Feedback anzeigen
            if (errors.length > 0) {
                strengthDiv.innerHTML = '<span style="color: #dc3545;"><i class="fas fa-times-circle"></i> ' + errors.join(', ') + '</span>';
                strengthDiv.parentElement.querySelector('input').setCustomValidity(errors.join(', '));
                return false;
            } else {
                let strengthText = '';
                let strengthColor = '';
                if (strength <= 2) {
                    strengthText = 'Schwach';
                    strengthColor = '#dc3545';
                } else if (strength === 3) {
                    strengthText = 'Mittel';
                    strengthColor = '#ffc107';
                } else {
                    strengthText = 'Stark';
                    strengthColor = '#28a745';
                }
                strengthDiv.innerHTML = '<span style="color: ' + strengthColor + ';"><i class="fas fa-check-circle"></i> ' + strengthText + '</span>';
                strengthDiv.parentElement.querySelector('input').setCustomValidity('');
                return true;
            }
        }
        
        // Passwort-Bestätigung validieren
        function validatePasswordMatch() {
            const password = document.getElementById('register-password').value;
            const passwordConfirm = document.getElementById('register-password-confirm').value;
            const matchDiv = document.getElementById('password-match');
            
            if (!passwordConfirm) {
                matchDiv.innerHTML = '';
                return false;
            }
            
            if (password === passwordConfirm) {
                matchDiv.innerHTML = '<span style="color: #28a745;"><i class="fas fa-check-circle"></i> Passwörter stimmen überein</span>';
                document.getElementById('register-password-confirm').setCustomValidity('');
                return true;
            } else {
                matchDiv.innerHTML = '<span style="color: #dc3545;"><i class="fas fa-times-circle"></i> Passwörter stimmen nicht überein</span>';
                document.getElementById('register-password-confirm').setCustomValidity('Passwörter stimmen nicht überein');
                return false;
            }
        }
        
        // Formular-Validierung wird im Register Form Handler durchgeführt
        
        // Datenschutz Modal
        function openDatenschutzModal() {
            document.getElementById('datenschutz-modal').style.display = 'block';
        }
        
        function closeDatenschutzModal() {
            document.getElementById('datenschutz-modal').style.display = 'none';
        }
        
        // OAuth Modal Funktionen
        let oauthModalOpen = false;
        let oauthPopupWindow = null;
        let oauthCheckInterval = null;
        
        function openOAuthModal(provider) {
            oauthModalOpen = true;
            const modal = document.getElementById('oauth-modal');
            const title = document.getElementById('oauth-modal-title');
            const message = document.getElementById('oauth-modal-message');
            const instruction = document.getElementById('oauth-modal-instruction');
            const instructionText = document.getElementById('oauth-modal-instruction-text');
            const closeBtn = document.getElementById('oauth-modal-close');
            
            modal.classList.add('active');
            
            if (provider === 'google') {
                title.textContent = 'Google Anmeldung';
                message.textContent = 'Ein Popup-Fenster wird geöffnet. Bitte melden Sie sich dort an.';
                instructionText.textContent = 'Falls kein Popup erscheint, erlauben Sie Popups für diese Website in Ihren Browser-Einstellungen.';
                instruction.style.display = 'block';
            } else if (provider === 'apple') {
                title.textContent = 'Apple Anmeldung';
                message.textContent = 'Ein Popup-Fenster wird geöffnet. Bitte melden Sie sich dort an.';
                instructionText.textContent = 'Falls kein Popup erscheint, erlauben Sie Popups für diese Website in Ihren Browser-Einstellungen.';
                instruction.style.display = 'block';
            }
            
            closeBtn.style.display = 'none';
        }
        
        function closeOAuthModal() {
            oauthModalOpen = false;
            const modal = document.getElementById('oauth-modal');
            modal.classList.remove('active');
            
            if (oauthCheckInterval) {
                clearInterval(oauthCheckInterval);
                oauthCheckInterval = null;
            }
            
            if (oauthPopupWindow && !oauthPopupWindow.closed) {
                oauthPopupWindow.close();
                oauthPopupWindow = null;
            }
        }
        
        function updateOAuthModal(message, showClose = false) {
            const messageEl = document.getElementById('oauth-modal-message');
            const closeBtn = document.getElementById('oauth-modal-close');
            const spinner = document.getElementById('oauth-modal-spinner');
            
            if (messageEl) {
                messageEl.textContent = message;
            }
            
            if (showClose && closeBtn) {
                closeBtn.style.display = 'flex';
            }
            
            if (spinner && showClose) {
                spinner.style.display = 'none';
            }
        }
        
        function setButtonLoading(buttonId, isLoading) {
            const buttons = document.querySelectorAll(`#${buttonId}, #${buttonId}-register`);
            buttons.forEach(button => {
                if (isLoading) {
                    button.classList.add('loading');
                    button.disabled = true;
                } else {
                    button.classList.remove('loading');
                    button.disabled = false;
                }
            });
        }
        
        function checkOAuthPopupClosed() {
            if (oauthPopupWindow && oauthPopupWindow.closed) {
                if (oauthCheckInterval) {
                    clearInterval(oauthCheckInterval);
                    oauthCheckInterval = null;
                }
                // Popup wurde geschlossen, Modal schließen
                setTimeout(() => {
                    closeOAuthModal();
                    setButtonLoading('google-signin-button', false);
                    setButtonLoading('apple-signin-button', false);
                }, 1000);
            }
        }
        
        function acceptDatenschutzAndClose() {
            // Setze die Checkbox automatisch und aktiviere sie
            const checkbox = document.getElementById('global-datenschutz-agreement');
            const container = document.getElementById('global-datenschutz');
            
            if (checkbox && container) {
                checkbox.checked = true;
                checkbox.disabled = false;
                
                // Dezentes visuelles Feedback
                container.style.borderColor = '#28a745';
                container.style.background = '#f8fff9';
                
                // Ändere Text nach Akzeptieren
                const label = container.querySelector('label');
                if (label) {
                    label.querySelector('span').innerHTML = 'Ich stimme der <a href="#" onclick="openDatenschutzModal(); return false;" style="color: #0056b3; text-decoration: underline; font-weight: 600;">Datenschutzerklärung</a> zu und bin mit der Verarbeitung meiner Daten einverstanden. *';
                    label.style.cursor = 'pointer';
                }
                
                const hint = container.querySelector('p');
                if (hint) {
                    hint.innerHTML = '<i class="fas fa-check-circle" style="color: #28a745;"></i> Datenschutz akzeptiert';
                }
                
                toggleAllRegisterButtons();
            }
            closeDatenschutzModal();
        }
        
        function toggleAllRegisterButtons() {
            const checkbox = document.getElementById('global-datenschutz-agreement');
            const container = document.getElementById('global-datenschutz');
            const registerBtn = document.getElementById('register-submit');
            const appleBtn = document.getElementById('apple-signin-button');
            const googleBtn = document.getElementById('google-signin-button');
            const volvoBtn = document.getElementById('volvo-signin-button');
            
            if (!checkbox) return;
            
            const enable = checkbox.checked;
            
            // Visuelles Feedback für Container
            if (container) {
                if (enable) {
                    container.style.borderColor = '#28a745';
                    container.style.background = '#f0fff4';
                } else {
                    container.style.borderColor = '#e9ecef';
                    container.style.background = '#fff';
                }
            }
            
            // Register Button
            if (registerBtn) {
                registerBtn.disabled = !enable;
                registerBtn.style.opacity = enable ? '1' : '0.5';
                registerBtn.style.cursor = enable ? 'pointer' : 'not-allowed';
            }
            
            // Apple Button
            if (appleBtn) {
                appleBtn.disabled = !enable;
                appleBtn.style.opacity = enable ? '1' : '0.5';
                appleBtn.style.cursor = enable ? 'pointer' : 'not-allowed';
            }
            
            // Google Button
            if (googleBtn) {
                googleBtn.disabled = !enable;
                googleBtn.style.opacity = enable ? '1' : '0.5';
                googleBtn.style.cursor = enable ? 'pointer' : 'not-allowed';
            }
            
            // Volvo Button - immer disabled (in Entwicklung)
            if (volvoBtn) {
                volvoBtn.disabled = true;
                volvoBtn.style.opacity = '0.6';
                volvoBtn.style.cursor = 'not-allowed';
            }
        }
        
        // Warnung zeigen wenn versucht wird ohne Checkbox zu registrieren
        function warnDatenschutzNotAccepted() {
            const container = document.getElementById('global-datenschutz');
            if (container) {
                container.style.borderColor = '#dc3545';
                container.style.background = '#fff5f5';
                container.style.boxShadow = '0 0 0 4px rgba(220, 53, 69, 0.2)';
                
                setTimeout(() => {
                    container.style.boxShadow = '';
                }, 2000);
            }
        }
        
        // Close modal on outside click
        window.onclick = function(event) {
            const modal = document.getElementById('datenschutz-modal');
            if (event.target === modal) {
                closeDatenschutzModal();
            }
            
            // OAuth Modal schließen bei Klick außerhalb (nur wenn kein aktiver Login-Prozess)
            const oauthModal = document.getElementById('oauth-modal');
            if (event.target === oauthModal && oauthModalOpen) {
                // Modal kann nur geschlossen werden, wenn der Close-Button sichtbar ist
                const closeBtn = document.getElementById('oauth-modal-close');
                if (closeBtn && closeBtn.style.display !== 'none') {
                    closeOAuthModal();
                }
            }
        }
        
        // Modern Notification System
        let notificationIdCounter = 0;
        const notificationDefaults = {
            duration: 5000,
            showClose: true,
            position: 'top-right'
        };
        
        /**
         * Zeigt eine Notification an
         * @param {string} message - Die Nachricht
         * @param {string} type - Der Typ: 'success', 'error', 'warning', 'info'
         * @param {object} options - Optionale Einstellungen
         * @param {number} options.duration - Anzeigedauer in ms (0 = kein Auto-Dismiss)
         * @param {string} options.title - Optionaler Titel
         * @param {boolean} options.showClose - Schließen-Button anzeigen
         * @param {boolean} options.allowHtml - HTML in der Nachricht erlauben (Standard: false)
         */
        function showNotification(message, type = 'info', options = {}) {
            const config = { ...notificationDefaults, ...options };
            const container = document.getElementById('notification-container');
            if (!container) return;
            
            notificationIdCounter++;
            const notificationId = `notification-${notificationIdCounter}`;
            
            // Icons für verschiedene Typen
            const icons = {
                success: 'fa-check-circle',
                error: 'fa-exclamation-circle',
                warning: 'fa-exclamation-triangle',
                info: 'fa-info-circle'
            };
            
            const icon = icons[type] || icons.info;
            
            // Erstelle Notification Element
            const notification = document.createElement('div');
            notification.id = notificationId;
            notification.className = `notification notification-${type}`;
            
            // Progress Bar (wenn Auto-Dismiss aktiviert)
            let progressBar = '';
            if (config.duration > 0) {
                progressBar = `<div class="notification-progress" style="animation-duration: ${config.duration}ms;"></div>`;
            }
            
            // HTML-Escape nur wenn nicht erlaubt
            const messageHtml = config.allowHtml ? message : escapeHtml(message);
            const titleHtml = config.title ? (config.allowHtml ? config.title : escapeHtml(config.title)) : '';
            
            notification.innerHTML = `
                <div class="notification-icon">
                    <i class="fas ${icon}"></i>
                </div>
                <div class="notification-content">
                    ${titleHtml ? `<div class="notification-title">${titleHtml}</div>` : ''}
                    <div class="notification-message">${messageHtml}</div>
                </div>
                ${config.showClose ? `
                    <button class="notification-close" onclick="closeNotification('${notificationId}')" aria-label="Schließen">
                        <i class="fas fa-times"></i>
                    </button>
                ` : ''}
                ${progressBar}
            `;
            
            // Füge Notification hinzu
            container.appendChild(notification);
            
            // Auto-Dismiss nach duration
            if (config.duration > 0) {
                setTimeout(() => {
                    closeNotification(notificationId);
                }, config.duration);
            }
            
            // Entferne Notification nach Animation
            notification.addEventListener('animationend', function(e) {
                if (notification.classList.contains('hiding')) {
                    notification.remove();
                }
            });
            
            return notificationId;
        }
        
        /**
         * Schließt eine Notification
         */
        function closeNotification(notificationId) {
            const notification = document.getElementById(notificationId);
            if (notification) {
                notification.classList.add('hiding');
            }
        }
        
        /**
         * Schließt alle Notifications
         */
        function closeAllNotifications() {
            const container = document.getElementById('notification-container');
            if (!container) return;
            
            const notifications = container.querySelectorAll('.notification:not(.hiding)');
            notifications.forEach(notification => {
                notification.classList.add('hiding');
            });
        }
        
        /**
         * HTML-Escape für Sicherheit
         */
        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
        
        // Convenience-Funktionen für verschiedene Typen
        function showSuccess(message, title = '', options = {}) {
            return showNotification(message, 'success', { title, ...options });
        }
        
        function showError(message, title = '', options = {}) {
            return showNotification(message, 'error', { title, ...options, duration: 6000 }); // Fehler länger anzeigen
        }
        
        function showWarning(message, title = '', options = {}) {
            return showNotification(message, 'warning', { title, ...options, duration: 5500 });
        }
        
        function showInfo(message, title = '', options = {}) {
            return showNotification(message, 'info', { title, ...options, duration: 5000 });
        }
        
        // Legacy Alert System (für Rückwärtskompatibilität)
        function showAlert(message, type = 'error') {
            // Verwende neues Notification System
            const notificationTypes = {
                'error': 'error',
                'success': 'success',
                'warning': 'warning',
                'info': 'info'
            };
            
            const notificationType = notificationTypes[type] || 'info';
            
            // Bestimme Titel basierend auf Typ
            const titles = {
                'error': 'Fehler',
                'success': 'Erfolg',
                'warning': 'Warnung',
                'info': 'Information'
            };
            
            showNotification(message, notificationType, {
                title: titles[notificationType],
                duration: type === 'info' ? 7000 : (type === 'error' ? 6000 : 5000)
            });
            
            // Legacy Alert auch noch anzeigen (für fallback)
            const alert = document.getElementById('alert-message');
            if (alert) {
                alert.textContent = message;
                alert.className = `alert alert-${type} show`;
                const timeout = type === 'info' ? 7000 : 5000;
                setTimeout(() => {
                    hideAlert();
                }, timeout);
            }
        }
        
        function hideAlert() {
            const alert = document.getElementById('alert-message');
            if (alert) {
                alert.className = 'alert';
            }
        }
        
        // Login Form Handler
        document.getElementById('login-form').addEventListener('submit', async function(e) {
            e.preventDefault();
            hideAlert();
            
            // Versuche Browser Geolocation zu erfassen (für genauere Standortbestimmung)
            const browserLocation = await getBrowserLocation();
            
            const formData = {
                email: document.getElementById('login-email').value,
                password: document.getElementById('login-password').value,
                browser_location: browserLocation // Füge Browser-Geolocation hinzu, falls verfügbar
            };
            
            try {
                const response = await fetch('api/login_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                });
                
                const data = await response.json();
                
                if (data.success) {
                    // Save to session via PHP
                    await saveSession(data.user, data.token);
                    
                    // Prüfe Verifizierungsstatus
                    const verificationStatus = data.user?.verification_status || 'pending';
                    
                    if (verificationStatus === 'pending' || verificationStatus === 'rejected') {
                        // User mit pending/rejected Status zur Verifizierungsseite weiterleiten
                        showInfo('Bitte vervollständigen Sie Ihre Verifizierung.', 'Verifizierung erforderlich', { duration: 2000 });
                        setTimeout(() => {
                            window.location.href = 'verification_pending.php';
                        }, 1500);
                    } else {
                        // Verifizierte User normal weiterleiten
                        showSuccess('Erfolgreich angemeldet!', 'Login erfolgreich', { duration: 2000 });
                        setTimeout(() => {
                            const redirect = localStorage.getItem('redirect_after_login') || 'index.php';
                            localStorage.removeItem('redirect_after_login');
                            window.location.href = redirect;
                        }, 1500);
                    }
                } else {
                    showError(data.message || 'Anmeldung fehlgeschlagen', 'Login fehlgeschlagen');
                }
            } catch (error) {
                showError('Verbindungsfehler. Bitte überprüfen Sie Ihre Internetverbindung und versuchen Sie es erneut.', 'Verbindungsfehler');
                console.error(error);
            }
        });
        
        // Register Form Handler
        document.getElementById('register-form').addEventListener('submit', async function(e) {
            e.preventDefault();
            hideAlert();
            
            // Versuche Browser Geolocation zu erfassen (für automatische Autohaus-Auswahl)
            const browserLocation = await getBrowserLocation();
            
            // Validierungen durchführen
            const passwordValid = validatePassword();
            const passwordMatch = validatePasswordMatch();
            const autohausSelected = document.getElementById('autohaus-auswahl').value;
            
            if (!passwordValid) {
                showError('Bitte korrigieren Sie das Passwort. Mindestens 8 Zeichen, 1 Großbuchstabe und 1 Zahl erforderlich.', 'Passwort ungültig');
                return;
            }
            
            if (!passwordMatch) {
                showError('Die Passwörter stimmen nicht überein.', 'Passwort-Bestätigung');
                return;
            }
            
            if (!autohausSelected) {
                showWarning('Bitte wählen Sie ein Autohaus aus.', 'Autohaus auswählen');
                return;
            }
            
            // Prüfe Datenschutz-Checkbox
            const checkbox = document.getElementById('global-datenschutz-agreement');
            if (!checkbox || !checkbox.checked) {
                showError('Bitte stimmen Sie der Datenschutzerklärung zu.', 'Datenschutz erforderlich');
                warnDatenschutzNotAccepted();
                return;
            }
            
            const formData = {
                first_name: document.getElementById('register-firstname').value,
                last_name: document.getElementById('register-lastname').value,
                email: document.getElementById('register-email').value,
                phone_number: document.getElementById('register-phone').value,
                license_plate: document.getElementById('register-license').value,
                password: document.getElementById('register-password').value,
                password_confirm: document.getElementById('register-password-confirm').value,
                autohaus_id: document.getElementById('autohaus-auswahl').value,
                datenschutz_accepted: true // Wurde client-seitig geprüft
            };
            
            try {
                const response = await fetch('api/register_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(formData)
                });
                
                const data = await response.json();
                
                if (data.success) {
                    // Save to session via PHP
                    await saveSession(data.user, data.token);
                    
                    // Prüfe Verifizierungsstatus
                    const verificationStatus = data.user?.verification_status || 'pending';
                    
                    if (verificationStatus === 'pending' || verificationStatus === 'rejected') {
                        // Neue User mit pending Status zur Verifizierungsseite weiterleiten
                        showInfo('Bitte vervollständigen Sie Ihre Verifizierung.', 'Verifizierung erforderlich', { duration: 3000 });
                        setTimeout(() => {
                            window.location.href = 'verification_pending.php';
                        }, 2000);
                    } else {
                        // Verifizierte User normal weiterleiten
                        showSuccess('Willkommen! Ihre Registrierung war erfolgreich.', 'Registrierung erfolgreich', { duration: 3000 });
                        setTimeout(() => {
                            const redirect = localStorage.getItem('redirect_after_login') || 'index.php';
                            localStorage.removeItem('redirect_after_login');
                            window.location.href = redirect;
                        }, 2000);
                    }
                } else {
                    showError(data.message || 'Registrierung fehlgeschlagen. Bitte überprüfen Sie Ihre Eingaben.', 'Registrierung fehlgeschlagen');
                }
            } catch (error) {
                showError('Verbindungsfehler. Bitte überprüfen Sie Ihre Internetverbindung und versuchen Sie es erneut.', 'Verbindungsfehler');
                console.error(error);
            }
        });
        
        // Save Session
        async function saveSession(user, token) {
            const response = await fetch('api/save_user_session.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    user: user,
                    token: token
                })
            });
            return await response.json();
        }
        
        // Apple Sign In Handler
        function handleAppleSignIn() {
            // Prüfe ob Datenschutz akzeptiert wurde
            const checkbox = document.getElementById('global-datenschutz-agreement');
            const tab = document.querySelector('.auth-tab.active')?.textContent;
            
            // Nur bei Registrierung (Register-Tab aktiv) prüfen
            if (tab && tab.includes('Registrieren')) {
                if (!checkbox || !checkbox.checked) {
                    showError('Bitte stimmen Sie der Datenschutzerklärung zu.', 'Datenschutz erforderlich');
                    warnDatenschutzNotAccepted();
                    return;
                }
            }
            
            // Button deaktivieren und Loading-Animation anzeigen
            setButtonLoading('apple-signin-button', true);
            
            // Modal öffnen
            openOAuthModal('apple');
            
            if (typeof AppleID !== 'undefined') {
                AppleID.auth.init({
                    clientId: 'be.automobileapps.boxenstop',
                    scope: 'name email',
                    redirectURI: 'https://be-automobileapps.de/api/apple_callback.php',
                    usePopup: true
                });
                
                updateOAuthModal('Öffne Apple Anmeldung...', false);
                
                // WICHTIG: requeste AUF JEDEN FALL 'name' UND 'email' um die Namen zu bekommen
                AppleID.auth.signIn({
                    requestedScopes: ['name', 'email']
                }).then(function(response) {
                console.log('=== APPLE SIGN IN RESPONSE ===');
                console.log('Full Response:', JSON.stringify(response, null, 2));
                console.log('Response Type:', typeof response);
                console.log('Response Keys:', Object.keys(response));
                console.log('=======================');
                
                // Modal schließen und Button wieder aktivieren
                setButtonLoading('apple-signin-button', false);
                updateOAuthModal('Anmeldung erfolgreich! Verarbeite Daten...', false);
                
                // Handle response
                handleAppleCallback(response);
                }).catch(function(error) {
                    console.error('Apple Sign In Error:', error);
                    console.error('Error Details:', JSON.stringify(error, null, 2));
                    
                    // Modal schließen und Button wieder aktivieren
                    setButtonLoading('apple-signin-button', false);
                    closeOAuthModal();
                    
                    showError('Apple Anmeldung fehlgeschlagen. Bitte versuchen Sie es erneut.', 'Apple Sign-In Fehler');
                });
            } else {
                setButtonLoading('apple-signin-button', false);
                closeOAuthModal();
                showWarning('Apple Sign In ist derzeit nicht verfügbar. Bitte verwenden Sie eine alternative Anmeldemethode.', 'Apple Sign-In');
            }
        }
        
        async function handleAppleCallback(response) {
            try {
                console.log('=== APPLE CALLBACK - FULL RESPONSE ===');
                console.log('Response:', JSON.stringify(response, null, 2));
                console.log('Response Keys:', Object.keys(response));
                console.log('Has response.user?', !!response.user);
                console.log('response.user:', response.user);
                console.log('response.authorization:', response.authorization);
                console.log('========================================');
                
                // Extrahiere User-Informationen aus dem Apple Response
                const appleUserId = response.user || response.authorization?.id_token || 'apple_user_' + Date.now();
                const appleIdentityToken = response.authorization?.id_token;
                
                // Email kann im JWT Token sein (im Backend dekodiert)
                let email = null;
                if (response.user && response.user.email) {
                    email = response.user.email;
                    console.log('Email from response.user:', email);
                } else if (response.email) {
                    email = response.email;
                    console.log('Email from response.email:', email);
                }
                // Falls nicht vorhanden, wird im Backend aus Token extrahiert
                
                // Name-Daten werden nur beim ersten Login geliefert (response.user.name)
                let firstName = null;
                let lastName = null;
                
                // PRIORITÄT 1: response.user.name (nur beim ersten Login)
                if (response.user && response.user.name) {
                    console.log('✅ Found response.user.name:', response.user.name);
                    firstName = response.user.name.givenName || response.user.name.firstName;
                    lastName = response.user.name.familyName || response.user.name.lastName;
                }
                
                // PRIORITÄT 2: Alternative Strukturen
                else if (response.user) {
                    console.log('Checking alternative user structures');
                    firstName = response.user.firstName || response.user.givenName;
                    lastName = response.user.lastName || response.user.familyName;
                }
                
                // PRIORITÄT 3: Direkt im Response
                else if (response.fullName) {
                    console.log('Found fullName directly in response');
                    firstName = response.fullName.givenName || response.fullName.firstName;
                    lastName = response.fullName.familyName || response.fullName.lastName;
                }
                
                console.log('Final extracted names - first:', firstName, 'last:', lastName);
                
                // WICHTIG: Apple liefert user.name NUR beim ersten Login
                // Bei nachfolgenden Logins ist response.user = undefined
                // Fallback: Wenn keine Namen vorhanden, verwende 'Unknown' damit der User weiß dass er editieren muss
                if (!firstName && !lastName) {
                    console.warn('⚠️ No name data from Apple - user needs to edit profile');
                }
                
                console.log('=== EXTRACTED DATA ===');
                console.log('Apple User ID:', appleUserId);
                console.log('Email:', email);
                console.log('First Name:', firstName, firstName ? '(from Apple)' : '(MUST EDIT)');
                console.log('Last Name:', lastName, lastName ? '(from Apple)' : '(MUST EDIT)');
                console.log('=========================');
                
                
                const apiResponse = await fetch('api/login_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        apple_user_id: appleUserId,
                        apple_identity_token: appleIdentityToken,
                        email: email,
                        first_name: firstName,
                        last_name: lastName,
                        phone_number: '', // Apple liefert keine Telefonnummer
                        registration_device: navigator.userAgent,
                        registration_ip: await getClientIP(),
                        datenschutz_accepted: true // Wurde client-seitig geprüft
                    })
                });
                
                const data = await apiResponse.json();
                console.log('API Response:', data);
                
                // Modal schließen
                closeOAuthModal();
                
                if (data.success) {
                    await saveSession(data.user, data.token);
                    console.log('✅ Login successful - User:', data.user);
                    
                    // Prüfe Verifizierungsstatus
                    const verificationStatus = data.user?.verification_status || 'pending';
                    
                    if (verificationStatus === 'pending' || verificationStatus === 'rejected') {
                        // User mit pending/rejected Status zur Verifizierungsseite weiterleiten
                        showInfo('Bitte vervollständigen Sie Ihre Verifizierung.', 'Verifizierung erforderlich', { duration: 2000 });
                        setTimeout(() => {
                            window.location.href = 'verification_pending.php';
                        }, 1500);
                    } else {
                        // Verifizierte User normal weiterleiten
                        showSuccess('Erfolgreich mit Apple angemeldet!', 'Apple Login erfolgreich', { duration: 2000 });
                        setTimeout(() => {
                            const redirect = localStorage.getItem('redirect_after_login') || 'profile.php';
                            localStorage.removeItem('redirect_after_login');
                            console.log('🔄 Redirecting to:', redirect);
                            window.location.href = redirect;
                        }, 1500);
                    }
                } else {
                    showError(data.message || 'Apple Anmeldung fehlgeschlagen. Bitte versuchen Sie es erneut.', 'Apple Login fehlgeschlagen');
                }
            } catch (error) {
                closeOAuthModal();
                showError('Verbindungsfehler. Bitte überprüfen Sie Ihre Internetverbindung und versuchen Sie es erneut.', 'Verbindungsfehler');
                console.error(error);
            }
        }
        
        // Google Sign In Handler
        async function handleGoogleSignIn() {
            // Prüfe ob Datenschutz akzeptiert wurde
            const checkbox = document.getElementById('global-datenschutz-agreement');
            const tab = document.querySelector('.auth-tab.active')?.textContent;
            
            // Nur bei Registrierung (Register-Tab aktiv) prüfen
            if (tab && tab.includes('Registrieren')) {
                if (!checkbox || !checkbox.checked) {
                    showError('Bitte stimmen Sie der Datenschutzerklärung zu.', 'Datenschutz erforderlich');
                    warnDatenschutzNotAccepted();
                    return;
                }
            }
            
            // Button deaktivieren und Loading-Animation anzeigen
            setButtonLoading('google-signin-button', true);
            
            // Modal öffnen
            openOAuthModal('google');
            
            try {
                // Warte bis Google SDK geladen ist
                if (typeof google === 'undefined' || !google.accounts) {
                    updateOAuthModal('Google Sign-In wird geladen... Bitte warten Sie einen Moment.', false);
                    // Warte kurz und versuche es erneut
                    setTimeout(() => {
                        if (typeof google !== 'undefined' && google.accounts) {
                            handleGoogleSignIn();
                        } else {
                            setButtonLoading('google-signin-button', false);
                            closeOAuthModal();
                            showError('Google Sign-In konnte nicht geladen werden. Bitte versuchen Sie es erneut.', 'Google Sign-In Fehler');
                        }
                    }, 1000);
                    return;
                }
                
                updateOAuthModal('Öffne Google Anmeldung...', false);
                
                // Google Client ID - TODO: Ersetzen Sie dies mit Ihrer Google Client ID
                const GOOGLE_CLIENT_ID = '104117899033-jobelrs9lg173bvr3amka2ffql5qicvh.apps.googleusercontent.com';
                
                // Google OAuth mit Popup
                const client = google.accounts.oauth2.initTokenClient({
                    client_id: GOOGLE_CLIENT_ID,
                    scope: 'openid email profile',
                    callback: async (response) => {
                        // Modal schließen und Button wieder aktivieren
                        setButtonLoading('google-signin-button', false);
                        closeOAuthModal();
                        
                        if (response.error) {
                            console.error('Google OAuth Error:', response);
                            showError('Google Anmeldung fehlgeschlagen: ' + (response.error_description || response.error), 'Google Sign-In Fehler');
                            return;
                        }
                        
                        updateOAuthModal('Anmeldung erfolgreich! Verarbeite Daten...', false);
                        
                        // Token verwenden um User-Info zu bekommen
                        await fetchGoogleUserInfo(response.access_token);
                    }
                });
                
                // Fordere Access Token an (öffnet Popup)
                client.requestAccessToken();
                
                // Überwache Popup-Fenster (falls verfügbar)
                // Google SDK öffnet das Popup intern, daher können wir es nicht direkt überwachen
                // Aber wir können das Modal schließen, wenn der Callback aufgerufen wird
                
            } catch (error) {
                setButtonLoading('google-signin-button', false);
                closeOAuthModal();
                showError('Google Sign-In Fehler. Bitte versuchen Sie es erneut.', 'Google Sign-In');
                console.error('Google Sign-In Error:', error);
            }
        }
        
        // Google User Info mit Access Token abrufen
        async function fetchGoogleUserInfo(accessToken) {
            try {
                const response = await fetch('https://www.googleapis.com/oauth2/v2/userinfo', {
                    headers: {
                        'Authorization': `Bearer ${accessToken}`
                    }
                });
                
                if (!response.ok) {
                    throw new Error('Failed to fetch user info');
                }
                
                const userInfo = await response.json();
                console.log('=== GOOGLE USER INFO ===');
                console.log('Full User Info:', JSON.stringify(userInfo, null, 2));
                console.log('========================');
                
                const googleUserId = userInfo.id;
                const email = userInfo.email;
                const firstName = userInfo.given_name || null;
                const lastName = userInfo.family_name || null;
                const fullName = userInfo.name || null;
                
                // Falls Vorname/Nachname nicht direkt vorhanden, aus fullName extrahieren
                let extractedFirstName = firstName;
                let extractedLastName = lastName;
                
                if (!extractedFirstName && fullName) {
                    const nameParts = fullName.split(' ');
                    extractedFirstName = nameParts[0] || null;
                    extractedLastName = nameParts.slice(1).join(' ') || null;
                }
                
                console.log('=== EXTRACTED DATA ===');
                console.log('Google User ID:', googleUserId);
                console.log('Email:', email);
                console.log('First Name:', extractedFirstName, extractedFirstName ? '(from Google)' : '(MUST EDIT)');
                console.log('Last Name:', extractedLastName, extractedLastName ? '(from Google)' : '(MUST EDIT)');
                console.log('=======================');
                
                const apiResponse = await fetch('api/login_user.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        google_user_id: googleUserId,
                        email: email,
                        first_name: extractedFirstName,
                        last_name: extractedLastName,
                        phone_number: '', // Google liefert keine Telefonnummer
                        registration_device: navigator.userAgent,
                        registration_ip: await getClientIP(),
                        datenschutz_accepted: true // Wurde client-seitig geprüft
                    })
                });
                
                const data = await apiResponse.json();
                console.log('API Response:', data);
                
                // Modal schließen
                closeOAuthModal();
                
                if (data.success) {
                    await saveSession(data.user, data.token);
                    console.log('✅ Login successful - User:', data.user);
                    
                    // Prüfe Verifizierungsstatus
                    const verificationStatus = data.user?.verification_status || 'pending';
                    
                    if (verificationStatus === 'pending' || verificationStatus === 'rejected') {
                        // User mit pending/rejected Status zur Verifizierungsseite weiterleiten
                        showInfo('Bitte vervollständigen Sie Ihre Verifizierung.', 'Verifizierung erforderlich', { duration: 2000 });
                        setTimeout(() => {
                            window.location.href = 'verification_pending.php';
                        }, 1500);
                    } else {
                        // Verifizierte User normal weiterleiten
                        showSuccess('Erfolgreich mit Google angemeldet!', 'Google Login erfolgreich', { duration: 2000 });
                        setTimeout(() => {
                            const redirect = localStorage.getItem('redirect_after_login') || 'profile.php';
                            localStorage.removeItem('redirect_after_login');
                            console.log('🔄 Redirecting to:', redirect);
                            window.location.href = redirect;
                        }, 1500);
                    }
                } else {
                    showError(data.message || 'Google Anmeldung fehlgeschlagen. Bitte versuchen Sie es erneut.', 'Google Login fehlgeschlagen');
                }
            } catch (error) {
                closeOAuthModal();
                console.error('Error fetching Google user info:', error);
                showError('Fehler beim Abrufen der Google-Daten. Bitte versuchen Sie es erneut.', 'Google Daten Fehler');
            }
        }
        
        
        // Zeige Modal für Standortberechtigung
        function showLocationPermissionModal() {
            return new Promise((resolve) => {
                // Prüfe ob bereits eine Entscheidung getroffen wurde (nur einmal pro Session fragen)
                const locationPermissionAsked = sessionStorage.getItem('location_permission_asked');
                if (locationPermissionAsked === 'denied' || locationPermissionAsked === 'granted') {
                    resolve(locationPermissionAsked === 'granted');
                    return;
                }
                
                // Erstelle Modal
                const modal = document.createElement('div');
                modal.id = 'location-permission-modal';
                modal.style.cssText = `
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0, 0, 0, 0.5);
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    z-index: 10000;
                    animation: fadeIn 0.3s ease;
                `;
                
                modal.innerHTML = `
                    <div style="
                        background: white;
                        border-radius: 16px;
                        padding: 2rem;
                        max-width: 500px;
                        width: 90%;
                        box-shadow: 0 10px 40px rgba(0,0,0,0.2);
                        animation: slideUp 0.3s ease;
                    ">
                        <div style="text-align: center; margin-bottom: 1.5rem;">
                            <div style="
                                width: 64px;
                                height: 64px;
                                background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                                border-radius: 50%;
                                display: flex;
                                align-items: center;
                                justify-content: center;
                                margin: 0 auto 1rem;
                                box-shadow: 0 4px 12px rgba(0,123,255,0.3);
                            ">
                                <i class="fas fa-map-marker-alt" style="font-size: 2rem; color: white;"></i>
                            </div>
                            <h3 style="margin: 0 0 0.5rem 0; color: #212529; font-size: 1.5rem; font-weight: 600;">
                                Standortbestimmung
                            </h3>
                            <p style="margin: 0; color: #6c757d; font-size: 0.95rem;">
                                Für eine bessere Service-Erfahrung
                            </p>
                        </div>
                        
                        <div style="background: #f8f9fa; padding: 1.25rem; border-radius: 12px; margin-bottom: 1.5rem; border-left: 4px solid #007bff;">
                            <p style="margin: 0 0 0.75rem 0; color: #495057; line-height: 1.6; font-size: 0.95rem;">
                                <strong>Warum benötigen wir Ihren Standort?</strong>
                            </p>
                            <p style="margin: 0; color: #6c757d; line-height: 1.6; font-size: 0.9rem;">
                                Wir verwenden Ihren Standort, um Ihnen automatisch das richtige Autohaus in Ihrer Nähe zuzuordnen und Ihnen relevante Angebote zu zeigen. Dies hilft uns, Ihnen den bestmöglichen Service zu bieten.
                            </p>
                        </div>
                        
                        <div style="background: #e7f3ff; padding: 1rem; border-radius: 8px; margin-bottom: 1.5rem; border: 1px solid #b3d9ff;">
                            <div style="display: flex; align-items: start; gap: 0.75rem;">
                                <i class="fas fa-shield-alt" style="color: #007bff; font-size: 1.2rem; margin-top: 0.2rem;"></i>
                                <div>
                                    <p style="margin: 0 0 0.5rem 0; color: #004085; font-weight: 600; font-size: 0.9rem;">
                                        Datenschutz
                                    </p>
                                    <p style="margin: 0; color: #004085; font-size: 0.85rem; line-height: 1.5;">
                                        Ihr Standort wird nur lokal auf Ihrem Gerät ermittelt und zur automatischen Zuordnung verwendet. Wir speichern keine präzisen Koordinaten ohne Ihre Zustimmung.
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div style="display: flex; gap: 0.75rem;">
                            <button id="location-deny-btn" style="
                                flex: 1;
                                padding: 0.875rem 1.5rem;
                                background: white;
                                border: 2px solid #dee2e6;
                                border-radius: 8px;
                                color: #6c757d;
                                font-weight: 600;
                                font-size: 0.95rem;
                                cursor: pointer;
                                transition: all 0.2s ease;
                            " onmouseover="this.style.background='#f8f9fa'; this.style.borderColor='#adb5bd';" 
                               onmouseout="this.style.background='white'; this.style.borderColor='#dee2e6';">
                                Später
                            </button>
                            <button id="location-allow-btn" style="
                                flex: 1;
                                padding: 0.875rem 1.5rem;
                                background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                                border: none;
                                border-radius: 8px;
                                color: white;
                                font-weight: 600;
                                font-size: 0.95rem;
                                cursor: pointer;
                                transition: all 0.2s ease;
                                box-shadow: 0 4px 12px rgba(0,123,255,0.3);
                            " onmouseover="this.style.transform='translateY(-2px)'; this.style.boxShadow='0 6px 16px rgba(0,123,255,0.4)';" 
                               onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 12px rgba(0,123,255,0.3)';">
                                <i class="fas fa-check"></i> Erlauben
                            </button>
                        </div>
                    </div>
                `;
                
                document.body.appendChild(modal);
                
                // Event Handler
                document.getElementById('location-allow-btn').addEventListener('click', () => {
                    sessionStorage.setItem('location_permission_asked', 'granted');
                    modal.remove();
                    resolve(true);
                });
                
                document.getElementById('location-deny-btn').addEventListener('click', () => {
                    sessionStorage.setItem('location_permission_asked', 'denied');
                    modal.remove();
                    resolve(false);
                });
                
                // Klick außerhalb des Modals schließt es
                modal.addEventListener('click', (e) => {
                    if (e.target === modal) {
                        sessionStorage.setItem('location_permission_asked', 'denied');
                        modal.remove();
                        resolve(false);
                    }
                });
            });
        }
        
        // Finde nächstes Autohaus basierend auf Koordinaten
        async function findNearestAutohaus(latitude, longitude) {
            try {
                const response = await fetch('api/find_nearest_autohaus.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        latitude: latitude,
                        longitude: longitude
                    })
                });
                
                const data = await response.json();
                if (data.success && data.nearest_autohaus) {
                    return data.nearest_autohaus;
                }
                return null;
            } catch (error) {
                console.warn('Fehler beim Finden des nächsten Autohauses:', error);
                return null;
            }
        }
        
        // Zeige Lade-Indikator für Autohaus-Auswahl
        function showAutohausLoadingState(isLoading) {
            const cards = document.querySelectorAll('.autohaus-selection-card');
            
            if (isLoading) {
                // Deaktiviere alle Cards
                cards.forEach(card => {
                    card.style.pointerEvents = 'none';
                    card.style.opacity = '0.5';
                    card.style.cursor = 'not-allowed';
                });
                
                // Erstelle oder aktualisiere Lade-Indikator
                let loadingIndicator = document.getElementById('autohaus-loading-indicator');
                if (!loadingIndicator) {
                    loadingIndicator = document.createElement('div');
                    loadingIndicator.id = 'autohaus-loading-indicator';
                    loadingIndicator.style.cssText = `
                        background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
                        color: white;
                        padding: 1rem 1.5rem;
                        border-radius: 12px;
                        margin-bottom: 1.5rem;
                        display: flex;
                        align-items: center;
                        gap: 1rem;
                        box-shadow: 0 4px 12px rgba(0,123,255,0.3);
                        animation: slideUp 0.3s ease;
                    `;
                    loadingIndicator.innerHTML = `
                        <div style="width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                            <i class="fas fa-spinner fa-spin" style="font-size: 1.5rem;"></i>
                        </div>
                        <div style="flex: 1;">
                            <div style="font-weight: 600; margin-bottom: 0.25rem; font-size: 0.95rem;">Standort wird ermittelt...</div>
                            <div style="font-size: 0.85rem; opacity: 0.9;">Sind Sie Kunde dort oder haben Sie Ihre Räder dort eingelagert? Wir finden automatisch das passende Autohaus für Sie.</div>
                        </div>
                    `;
                    
                    // Füge vor den Cards ein
                    const grid = document.querySelector('.autohaus-selection-grid');
                    if (grid && grid.parentElement) {
                        grid.parentElement.insertBefore(loadingIndicator, grid);
                    }
                }
            } else {
                // Aktiviere alle Cards wieder
                cards.forEach(card => {
                    card.style.pointerEvents = '';
                    card.style.opacity = '';
                    card.style.cursor = '';
                });
                
                // Entferne Lade-Indikator
                const loadingIndicator = document.getElementById('autohaus-loading-indicator');
                if (loadingIndicator) {
                    loadingIndicator.style.animation = 'fadeOut 0.3s ease';
                    setTimeout(() => {
                        loadingIndicator.remove();
                    }, 300);
                }
            }
        }
        
        // Automatische Autohaus-Auswahl basierend auf Standort
        async function autoSelectAutohaus(latitude, longitude) {
            // Zeige Lade-Indikator
            showAutohausLoadingState(true);
            
            try {
                const nearestAutohaus = await findNearestAutohaus(latitude, longitude);
                
                if (nearestAutohaus) {
                    const autohausId = nearestAutohaus.id;
                    const autohausName = nearestAutohaus.name;
                    const distance = nearestAutohaus.distance_km;
                    
                    // Wähle Autohaus automatisch aus
                    const input = document.getElementById('autohaus-auswahl');
                    if (input) {
                        input.value = autohausId;
                        input.setAttribute('data-selected', 'true');
                    }
                    
                    // Visuell auswählen
                    const cards = document.querySelectorAll('.autohaus-selection-card');
                    cards.forEach(card => {
                        card.classList.remove('selected');
                        if (parseInt(card.getAttribute('data-autohaus-id')) === autohausId) {
                            card.classList.add('selected');
                            // Smooth scroll zu ausgewähltem Autohaus
                            setTimeout(() => {
                                card.scrollIntoView({ behavior: 'smooth', block: 'center' });
                            }, 300);
                        }
                    });
                    
                    // Professionelle Notification anzeigen (ohne HTML-Tags für bessere Lesbarkeit)
                    showInfo(
                        `Sind Sie Kunde bei "${autohausName}" oder haben Sie Ihre Räder dort eingelagert? Anhand Ihres Standorts haben wir dieses Autohaus (${distance} km entfernt) automatisch für Sie ausgewählt.`,
                        'Autohaus automatisch zugeordnet',
                        { duration: 8000 }
                    );
                    
                    return true;
                }
            } finally {
                // Entferne Lade-Indikator
                showAutohausLoadingState(false);
            }
            return false;
        }
        
        // Browser Geolocation Helper (für genaue Standortbestimmung)
        async function getBrowserLocation() {
            return new Promise(async (resolve) => {
                if (!navigator.geolocation) {
                    resolve(null);
                    return;
                }
                
                // Zeige erst Modal für Erklärung
                const userAllowed = await showLocationPermissionModal();
                if (!userAllowed) {
                    resolve(null);
                    return;
                }
                
                // Timeout nach 5 Sekunden (mehr Zeit für genauere Position)
                const timeout = setTimeout(() => {
                    resolve(null);
                }, 5000);
                
                navigator.geolocation.getCurrentPosition(
                    async (position) => {
                        clearTimeout(timeout);
                        const lat = position.coords.latitude;
                        const lng = position.coords.longitude;
                        const accuracy = position.coords.accuracy;
                        
                        // Reverse Geocoding: Hole Stadt/Region aus Koordinaten
                        let cityInfo = null;
                        try {
                            const reverseGeoUrl = `https://nominatim.openstreetmap.org/reverse?format=json&lat=${lat}&lon=${lng}&zoom=10&addressdetails=1`;
                            const geoResponse = await fetch(reverseGeoUrl, {
                                headers: {
                                    'User-Agent': 'Boxenstop-App/1.0'
                                }
                            });
                            if (geoResponse.ok) {
                                const geoData = await geoResponse.json();
                                if (geoData.address) {
                                    cityInfo = {
                                        city: geoData.address.city || geoData.address.town || geoData.address.village || geoData.address.municipality || null,
                                        region: geoData.address.state || geoData.address.region || null,
                                        country: geoData.address.country || null,
                                        postcode: geoData.address.postcode || null
                                    };
                                }
                            }
                        } catch (error) {
                            console.warn('Reverse Geocoding Fehler:', error);
                        }
                        
                        // Automatische Autohaus-Auswahl beim Registrieren
                        const isRegisterTab = document.querySelector('.auth-tab.active')?.textContent?.includes('Registrieren');
                        if (isRegisterTab) {
                            await autoSelectAutohaus(lat, lng);
                        }
                        
                        resolve({
                            latitude: lat,
                            longitude: lng,
                            accuracy: accuracy,
                            source: 'browser_geolocation',
                            city_info: cityInfo
                        });
                    },
                    (error) => {
                        clearTimeout(timeout);
                        // Benutzer hat Berechtigung verweigert oder Fehler aufgetreten
                        resolve(null);
                    },
                    {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0 // Keine Cache, immer aktuelle Position
                    }
                );
            });
        }
        
        // Client IP Helper
        async function getClientIP() {
            try {
                const response = await fetch('https://api.ipify.org?format=json');
                const data = await response.json();
                return data.ip || 'Unknown';
            } catch (error) {
                return 'Unknown';
            }
        }
        
        // Volvo Sign In Handler
        function handleVolvoSignIn() {
            const volvoButton = document.getElementById('volvo-signin-button');
            
            // Prüfe ob Button deaktiviert ist
            if (volvoButton && volvoButton.disabled) {
                showInfo('🚧 Volvo ID Login ist derzeit in Entwicklung und wird bald verfügbar sein. Wir arbeiten daran, Ihnen die beste Erfahrung zu bieten!', 'Volvo ID in Entwicklung');
                return;
            }
            
            // Prüfe ob Datenschutz akzeptiert wurde (nur bei Registrierung)
            const checkbox = document.getElementById('global-datenschutz-agreement');
            const tab = document.querySelector('.auth-tab.active')?.textContent;
            
            // Nur bei Registrierung (Register-Tab aktiv) prüfen
            if (tab && tab.includes('Registrieren')) {
                if (!checkbox || !checkbox.checked) {
                    showError('Bitte stimmen Sie der Datenschutzerklärung zu.', 'Datenschutz erforderlich');
                    warnDatenschutzNotAccepted();
                    return;
                }
            }
            
            // Weiterleitung zu Volvo OAuth
            const demo = urlParams.get('demo');
            if (demo === '1') {
                window.location.href = '/auth/volvo/login.php?demo=1';
            } else {
                window.location.href = '/auth/volvo/login.php';
            }
        }
        
        // Prüfe ob Volvo-Fehler in URL ist
        const volvoError = urlParams.get('volvo_error');
        if (volvoError) {
            showError(decodeURIComponent(volvoError), 'Volvo Login Fehler');
            // Entferne Fehler aus URL
            window.history.replaceState({}, document.title, window.location.pathname);
        }
    </script>
</body>
</html>

