<?php
/**
 * Listet alle verfügbaren Drucker auf (Windows)
 * 
 * Dieses Skript hilft Ihnen, den exakten Namen Ihres Druckers zu finden,
 * der für die Druckersteuerung benötigt wird.
 */

echo "=== Verfügbare Drucker ===\n\n";

// Methode 1: WMI (Windows Management Instrumentation)
echo "Methode 1: WMI (Windows Management Instrumentation)\n";
echo str_repeat("-", 50) . "\n";

$printers = [];
exec('wmic printer get name,driverName,portName /format:list', $output);

$current_printer = [];
foreach ($output as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current_printer)) {
            $printers[] = $current_printer;
            $current_printer = [];
        }
        continue;
    }
    
    if (strpos($line, 'Name=') === 0) {
        $current_printer['name'] = substr($line, 5);
    } elseif (strpos($line, 'driverName=') === 0) {
        $current_printer['driver'] = substr($line, 11);
    } elseif (strpos($line, 'portName=') === 0) {
        $current_printer['port'] = substr($line, 9);
    }
}

if (!empty($current_printer)) {
    $printers[] = $current_printer;
}

if (empty($printers)) {
    echo "❌ Keine Drucker gefunden (oder WMI nicht verfügbar)\n\n";
} else {
    foreach ($printers as $idx => $printer) {
        echo "Drucker " . ($idx + 1) . ":\n";
        echo "  Name: " . ($printer['name'] ?? 'N/A') . "\n";
        echo "  Treiber: " . ($printer['driver'] ?? 'N/A') . "\n";
        echo "  Port: " . ($printer['port'] ?? 'N/A') . "\n";
        echo "\n";
    }
}

// Methode 2: PowerShell
echo "\n" . str_repeat("=", 50) . "\n";
echo "Methode 2: PowerShell\n";
echo str_repeat("-", 50) . "\n";

exec('powershell -Command "Get-Printer | Select-Object Name, DriverName, PortName | Format-List"', $ps_output);

if (!empty($ps_output)) {
    foreach ($ps_output as $line) {
        echo $line . "\n";
    }
} else {
    echo "❌ PowerShell-Befehl fehlgeschlagen\n";
}

// Methode 3: Registry (Windows)
echo "\n" . str_repeat("=", 50) . "\n";
echo "Methode 3: Registry\n";
echo str_repeat("-", 50) . "\n";

exec('reg query "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\Print\Printers" /s /v Name', $reg_output);

$found_printers = [];
foreach ($reg_output as $line) {
    if (strpos($line, 'Name') !== false && strpos($line, 'REG_SZ') !== false) {
        $parts = explode('REG_SZ', $line);
        if (count($parts) > 1) {
            $printer_name = trim($parts[1]);
            if (!empty($printer_name) && !in_array($printer_name, $found_printers)) {
                $found_printers[] = $printer_name;
            }
        }
    }
}

if (!empty($found_printers)) {
    echo "Gefundene Drucker:\n";
    foreach ($found_printers as $idx => $name) {
        echo "  " . ($idx + 1) . ". $name\n";
    }
} else {
    echo "❌ Keine Drucker in Registry gefunden\n";
}

// Zusammenfassung
echo "\n" . str_repeat("=", 50) . "\n";
echo "📌 HINWEISE:\n";
echo str_repeat("-", 50) . "\n";
echo "1. Verwenden Sie den EXAKTEN Namen des Druckers (inkl. Leerzeichen)\n";
echo "2. Der Name muss in Anführungszeichen gesetzt werden, wenn er Leerzeichen enthält\n";
echo "3. Beispiel: 'Brother QL-700' oder 'HP LaserJet Pro'\n";
echo "4. Sie können den Namen auch in der Systemsteuerung finden:\n";
echo "   Systemsteuerung > Geräte und Drucker > Rechtsklick > Druckereigenschaften\n";
echo "\n";

// Beispiel-Konfiguration
if (!empty($printers) && isset($printers[0]['name'])) {
    $first_printer = $printers[0]['name'];
    echo "💡 Beispiel-Konfiguration für print_etikett_example.php:\n";
    echo str_repeat("-", 50) . "\n";
    echo "define('PRINTER_NAME', '$first_printer');\n";
    echo "\n";
}

?>

