<?php
/**
 * Helper-Funktion für Push-Benachrichtigungen
 * Wird aufgerufen wenn eine neue Benachrichtigung erstellt wird
 */

require_once __DIR__ . '/../api/send_push_notification.php';

/**
 * Erstellt eine Benachrichtigung und sendet Push-Benachrichtigungen an alle Geräte
 * 
 * @param PDO $conn Datenbankverbindung
 * @param int $user_id Benutzer-ID
 * @param string $title Titel der Benachrichtigung
 * @param string $message Nachricht
 * @param string $type Typ (info, success, warning, error)
 * @param string $url URL zum Öffnen (optional)
 * @return array Ergebnis
 */
function createNotificationWithPush($conn, $user_id, $title, $message, $type = 'info', $url = '/profile.php') {
    try {
        // Erstelle Benachrichtigung in der Datenbank
        $stmt = $conn->prepare("
            INSERT INTO user_notifications (user_id, type, title, message, is_read, created_at)
            VALUES (?, ?, ?, ?, 0, NOW())
        ");
        $stmt->execute([$user_id, $type, $title, $message]);
        
        $notificationId = $conn->lastInsertId();
        
        // Sende Push-Benachrichtigung an alle Geräte des Users
        $pushResult = sendPushNotificationToUser(
            $user_id,
            $title,
            $message,
            $url,
            $notificationId,
            $type
        );
        
        return [
            'success' => true,
            'notification_id' => $notificationId,
            'push_sent' => $pushResult['success'] ?? false,
            'push_result' => $pushResult
        ];
        
    } catch (Exception $e) {
        error_log('Error creating notification with push: ' . $e->getMessage());
        return [
            'success' => false,
            'message' => $e->getMessage()
        ];
    }
}
?>

