<?php
/**
 * Generiert VAPID Keys für Push-Benachrichtigungen
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'vendor/autoload.php';

use Minishlink\WebPush\VAPID;
use Jose\Component\KeyManagement\JWKFactory;

// Prüfe Extensions
echo "=== PRÜFE VORAUSSETZUNGEN ===\n";
echo "OpenSSL: " . (extension_loaded('openssl') ? 'OK' : 'FEHLT') . "\n";
echo "JSON: " . (extension_loaded('json') ? 'OK' : 'FEHLT') . "\n";
echo "MBString: " . (extension_loaded('mbstring') ? 'OK' : 'FEHLT') . "\n\n";

try {
    echo "=== GENERIERE VAPID KEYS ===\n";
    $keys = VAPID::createVapidKeys();
    
    echo "✅ Keys erfolgreich generiert!\n\n";
    echo "=== VAPID KEYS ===\n\n";
    echo "Public Key:\n";
    echo $keys['publicKey'] . "\n\n";
    echo "Private Key:\n";
    echo $keys['privateKey'] . "\n\n";
    echo "=== SQL BEFEHL ZUM SPEICHERN ===\n\n";
    echo "Führe diesen SQL-Befehl in deiner Datenbank aus:\n\n";
    echo "INSERT INTO settings (setting_key, setting_value) VALUES\n";
    echo "('vapid_public_key', '" . $keys['publicKey'] . "'),\n";
    echo "('vapid_private_key', '" . $keys['privateKey'] . "')\n";
    echo "ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value);\n\n";
    
    // Speichere auch in Datei (optional)
    file_put_contents('vapid_keys.txt', 
        "Public Key: " . $keys['publicKey'] . "\n" .
        "Private Key: " . $keys['privateKey'] . "\n"
    );
    echo "✅ Keys auch in 'vapid_keys.txt' gespeichert\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    echo "Stack Trace:\n" . $e->getTraceAsString() . "\n";
    exit(1);
} catch (Error $e) {
    echo "❌ Fataler Fehler: " . $e->getMessage() . "\n";
    echo "Stack Trace:\n" . $e->getTraceAsString() . "\n";
    exit(1);
}
?>

