<?php
/**
 * Sucht nach dem Benutzer Deniz Uludag/Uludag
 * Findet Drucker, Netzwerkressourcen und Konfigurationen dieses Benutzers
 */

echo "=== SUCHE NACH BENUTZER: DENIZ ULUDAG / ULUDAG ===\n\n";

$found = [];

// 1. Lokale Benutzer
echo "1. LOKALE BENUTZER:\n";
echo str_repeat("-", 50) . "\n";

exec('net user', $users);
foreach ($users as $line) {
    if (stripos($line, 'uludag') !== false || stripos($line, 'deniz') !== false) {
        echo "✅ GEFUNDEN: $line\n";
        $found[] = ['type' => 'Lokaler Benutzer', 'name' => trim($line)];
    }
}

// 2. Windows-Benutzer (WMI)
echo "\n2. WINDOWS-BENUTZER (WMI):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic useraccount get name,fullname,sid /format:list', $wmi_users);
$current = [];
foreach ($wmi_users as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $fullname = $current['fullname'] ?? '';
            if (stripos($name, 'uludag') !== false || 
                stripos($name, 'deniz') !== false ||
                stripos($fullname, 'uludag') !== false || 
                stripos($fullname, 'deniz') !== false) {
                echo "✅ GEFUNDEN:\n";
                echo "   Name: $name\n";
                echo "   Vollständiger Name: $fullname\n";
                echo "   SID: " . ($current['sid'] ?? 'N/A') . "\n";
                $found[] = ['type' => 'WMI-Benutzer', 'name' => $name, 'fullname' => $fullname];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'FullName=') === 0) $current['fullname'] = substr($line, 9);
    if (strpos($line, 'SID=') === 0) $current['sid'] = substr($line, 4);
}

// 3. Benutzer-Profile
echo "\n3. BENUTZER-PROFILE:\n";
echo str_repeat("-", 50) . "\n";

$users_dir = 'C:\\Users';
if (is_dir($users_dir)) {
    $user_folders = scandir($users_dir);
    foreach ($user_folders as $user_folder) {
        if ($user_folder === '.' || $user_folder === '..') continue;
        
        if (stripos($user_folder, 'uludag') !== false || 
            stripos($user_folder, 'deniz') !== false) {
            $user_path = "$users_dir\\$user_folder";
            echo "✅ GEFUNDEN - Benutzer-Ordner: $user_path\n";
            $found[] = ['type' => 'Benutzer-Ordner', 'path' => $user_path];
            
            // Suche nach Drucker-Konfigurationen in diesem Profil
            $printer_configs = [
                "$user_path\\AppData\\Roaming\\Microsoft\\Windows\\Printer Shortcuts",
                "$user_path\\AppData\\Roaming\\Microsoft\\Windows\\Recent",
            ];
            
            foreach ($printer_configs as $config_path) {
                if (is_dir($config_path)) {
                    echo "   📁 Drucker-Konfiguration gefunden: $config_path\n";
                }
            }
        }
    }
}

// 4. Registry - Benutzer-spezifische Einträge
echo "\n4. REGISTRY - BENUTZER-EINTRÄGE:\n";
echo str_repeat("-", 50) . "\n";

// Suche in HKEY_CURRENT_USER (aktueller Benutzer)
exec('reg query "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows NT\\CurrentVersion\\Devices" /s 2>nul', $user_devices);
foreach ($user_devices as $line) {
    if (stripos($line, 'uludag') !== false || 
        stripos($line, 'deniz') !== false ||
        stripos($line, 'PRT17') !== false ||
        (stripos($line, 'PRT') !== false && stripos($line, '17') !== false)) {
        echo "✅ GEFUNDEN - Registry: $line\n";
        $found[] = ['type' => 'Registry', 'path' => $line];
    }
}

// 5. Drucker des aktuellen Benutzers
echo "\n5. DRUCKER DES AKTUELLEN BENUTZERS:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,portname,sharename,attributes /format:list', $user_printers);
$current = [];
foreach ($user_printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $port = $current['port'] ?? '';
            $share = $current['share'] ?? '';
            
            // Zeige alle Drucker (könnten von Uludag installiert sein)
            if (stripos($name, 'PRT') !== false || 
                stripos($port, 'PRT') !== false || 
                stripos($share, 'PRT') !== false) {
                echo "📄 Drucker: $name\n";
                if (!empty($port)) echo "   Port: $port\n";
                if (!empty($share)) echo "   Freigabe: $share\n";
                if (stripos($name, '17') !== false || stripos($port, '17') !== false) {
                    echo "   ⭐ Enthält '17' - könnte PRT17 sein!\n";
                    $found[] = ['type' => 'Drucker', 'name' => $name, 'port' => $port, 'share' => $share];
                }
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
    if (strpos($line, 'Attributes=') === 0) $current['attributes'] = substr($line, 12);
}

// 6. Netzwerkverbindungen (mapped drives, etc.)
echo "\n6. NETZWERKVERBINDUNGEN:\n";
echo str_repeat("-", 50) . "\n";

exec('net use', $net_use);
foreach ($net_use as $line) {
    if (stripos($line, 'uludag') !== false || 
        stripos($line, 'deniz') !== false ||
        stripos($line, 'PRT') !== false ||
        stripos($line, 'buek') !== false) {
        echo "✅ GEFUNDEN - Netzwerkverbindung: $line\n";
        $found[] = ['type' => 'Netzwerkverbindung', 'info' => $line];
    }
}

// 7. Event Log - Benutzer-Aktivitäten
echo "\n7. EVENT LOG (Benutzer-Aktivitäten):\n";
echo str_repeat("-", 50) . "\n";

exec('wevtutil qe Security /c:20 /f:text /q:"*[EventData[Data[@Name=\'SubjectUserName\'] and (Data=\'uludag\' or Data=\'deniz\')]]" 2>nul', $events);
foreach ($events as $line) {
    if (stripos($line, 'PRT') !== false || stripos($line, 'Drucker') !== false) {
        echo "✅ GEFUNDEN - Event: " . substr($line, 0, 100) . "...\n";
    }
}

// 8. Aktueller Benutzer
echo "\n8. AKTUELLER BENUTZER:\n";
echo str_repeat("-", 50) . "\n";

$current_user = getenv('USERNAME');
$user_domain = getenv('USERDOMAIN');
echo "Aktueller Benutzer: $current_user\n";
echo "Domain: $user_domain\n";

if (stripos($current_user, 'uludag') !== false || stripos($current_user, 'deniz') !== false) {
    echo "✅ Sie sind als Uludag/Deniz angemeldet!\n";
    $found[] = ['type' => 'Aktueller Benutzer', 'name' => $current_user];
}

// 9. Alle Drucker (vollständig) - könnte von Uludag installiert sein
echo "\n9. ALLE DRUCKER (VOLLSTÄNDIG):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer list full /format:list', $all_printers_full);
$current = [];
foreach ($all_printers_full as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $all_text = implode(' ', $current);
            if (stripos($all_text, 'PRT17') !== false || 
                (stripos($all_text, 'PRT') !== false && stripos($all_text, '17') !== false)) {
                echo "✅ DRUCKER MIT PRT17 GEFUNDEN:\n";
                foreach ($current as $key => $value) {
                    if (stripos($key, 'name') !== false || 
                        stripos($key, 'port') !== false || 
                        stripos($key, 'share') !== false) {
                        echo "   $key: $value\n";
                    }
                }
                $found[] = ['type' => 'Drucker (voll)', 'data' => $current];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, '=') !== false) {
        list($key, $value) = explode('=', $line, 2);
        $current[$key] = $value;
    }
}

// 10. Suche nach Dateien/Ordnern mit Uludag im Namen
echo "\n10. DATEIEN/ORDNER MIT 'ULUDAG':\n";
echo str_repeat("-", 50) . "\n";

$search_paths = [
    'C:\\Users',
    'C:\\Windows\\System32\\spool',
];

foreach ($search_paths as $path) {
    if (is_dir($path)) {
        exec("dir /s /b \"$path\" 2>nul | findstr /i \"uludag\"", $files);
        foreach ($files as $file) {
            echo "✅ GEFUNDEN: $file\n";
            $found[] = ['type' => 'Datei/Ordner', 'path' => $file];
        }
    }
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found)) {
    echo "✅ ES WURDEN " . count($found) . " EINTRÄGE GEFUNDEN!\n\n";
    
    $printers_found = [];
    foreach ($found as $item) {
        if ($item['type'] === 'Drucker' || $item['type'] === 'Drucker (voll)') {
            if (isset($item['name'])) {
                $printers_found[] = $item['name'];
            } elseif (isset($item['share'])) {
                $printers_found[] = $item['share'];
            } elseif (isset($item['data']['Name'])) {
                $printers_found[] = $item['data']['Name'];
            }
        }
    }
    
    if (!empty($printers_found)) {
        echo "💡 GEFUNDENE DRUCKER:\n";
        echo str_repeat("-", 50) . "\n";
        $unique_printers = array_unique($printers_found);
        foreach ($unique_printers as $printer) {
            echo "   - $printer\n";
        }
        
        echo "\n💡 VERWENDUNG IN PHP:\n";
        echo str_repeat("-", 50) . "\n";
        foreach ($unique_printers as $printer) {
            if (stripos($printer, 'PRT17') !== false || 
                (stripos($printer, 'PRT') !== false && stripos($printer, '17') !== false)) {
                // Prüfe ob es ein UNC-Pfad ist
                if (strpos($printer, '\\') === 0) {
                    echo "   define('PRINTER_NAME', '" . str_replace('\\', '\\\\', $printer) . "');\n";
                } else {
                    echo "   define('PRINTER_NAME', '$printer');\n";
                }
            }
        }
    }
    
    echo "\n📋 ALLE GEFUNDENEN EINTRÄGE:\n";
    echo str_repeat("-", 50) . "\n";
    foreach ($found as $idx => $item) {
        echo ($idx + 1) . ". " . $item['type'] . "\n";
        if (isset($item['name'])) echo "   Name: " . $item['name'] . "\n";
        if (isset($item['path'])) echo "   Pfad: " . $item['path'] . "\n";
        if (isset($item['info'])) echo "   Info: " . substr($item['info'], 0, 80) . "...\n";
        echo "\n";
    }
} else {
    echo "❌ KEINE EINTRÄGE MIT 'ULUDAG' ODER 'DENIZ' GEFUNDEN\n\n";
    echo "Mögliche Erklärungen:\n";
    echo "1. Der Benutzer ist nicht auf diesem Computer\n";
    echo "2. Der Benutzer hat einen anderen Namen\n";
    echo "3. Die Drucker sind auf einem anderen Computer/Server\n\n";
    
    echo "💡 LÖSUNG: Versuchen Sie:\n";
    echo "1. Fragen Sie Deniz Uludag nach:\n";
    echo "   - Dem exakten Druckernamen\n";
    echo "   - Dem Server-Namen (z.B. buek-s01)\n";
    echo "   - Dem UNC-Pfad (z.B. \\\\SERVER\\PRT17)\n";
    echo "\n";
    echo "2. Öffnen Sie Explorer und geben Sie ein:\n";
    echo "   \\\\buek-s01\n";
    echo "   Oder andere Server-Namen\n";
}

?>

