<?php
/**
 * ULTIMATIVE SUCHE nach PRT17
 * Sucht nach allem was damit zu tun haben könnte
 */

echo "=== ULTIMATIVE SUCHE NACH 'PRT17' ===\n\n";

$found = [];

// 1. Alle installierten Geräte
echo "1. INSTALLIERTE GERÄTE:\n";
echo str_repeat("-", 50) . "\n";
exec('wmic path win32_pnpentity get name,deviceid /format:list', $devices);
$current = [];
foreach ($devices as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $id = $current['id'] ?? '';
            if (stripos($name, 'PRT17') !== false || stripos($id, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Gerät: $name\n";
                $found[] = ['type' => 'Gerät', 'name' => $name, 'id' => $id];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'DeviceID=') === 0) $current['id'] = substr($line, 9);
}

// 2. Alle installierten Treiber
echo "\n2. INSTALLIERTE TREIBER:\n";
echo str_repeat("-", 50) . "\n";
exec('driverquery /v', $drivers);
foreach ($drivers as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Treiber: $line\n";
        $found[] = ['type' => 'Treiber', 'info' => $line];
    }
}

// 3. Drucker (alle Methoden)
echo "\n3. DRUCKER (alle Methoden):\n";
echo str_repeat("-", 50) . "\n";

// Methode A: WMI
exec('wmic printer get name,portname,drivername /format:list', $wmi_printers);
$current = [];
foreach ($wmi_printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $port = $current['port'] ?? '';
            $driver = $current['driver'] ?? '';
            if (stripos($name, 'PRT17') !== false || 
                stripos($port, 'PRT17') !== false || 
                stripos($driver, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Drucker: $name\n";
                echo "   Port: $port\n";
                echo "   Treiber: $driver\n";
                $found[] = ['type' => 'Drucker', 'name' => $name, 'port' => $port, 'driver' => $driver];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'DriverName=') === 0) $current['driver'] = substr($line, 11);
}

// Methode B: Registry - Alle Drucker
echo "\n4. REGISTRY - ALLE DRUCKER:\n";
echo str_repeat("-", 50) . "\n";
exec('reg query "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Printers" /s', $reg_all);
foreach ($reg_all as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Registry: $line\n";
        $found[] = ['type' => 'Registry', 'path' => $line];
    }
}

// 5. Spool-Verzeichnis
echo "\n5. SPOOL-VERZEICHNIS:\n";
echo str_repeat("-", 50) . "\n";
$spool_dirs = [
    'C:\\Windows\\System32\\spool\\PRINTERS',
    'C:\\Windows\\System32\\spool\\drivers',
    'C:\\Windows\\System32\\spool\\drivers\\x64',
    'C:\\Windows\\System32\\spool\\drivers\\w32x86',
];

foreach ($spool_dirs as $dir) {
    if (is_dir($dir)) {
        exec("dir /b \"$dir\" 2>nul | findstr /i \"PRT17\"", $spool_files);
        foreach ($spool_files as $file) {
            echo "✅ GEFUNDEN - Spool: $dir\\$file\n";
            $found[] = ['type' => 'Spool', 'path' => "$dir\\$file"];
        }
    }
}

// 6. Netzwerkdrucker testen (verschiedene Varianten)
echo "\n6. NETZWERKDRUCKER-TEST:\n";
echo str_repeat("-", 50) . "\n";

// Teste verschiedene UNC-Pfade
$test_paths = [
    '\\\\localhost\\PRT17',
    '\\\\127.0.0.1\\PRT17',
    '\\\\' . gethostname() . '\\PRT17',
];

foreach ($test_paths as $path) {
    if (@file_exists($path) || @is_dir($path)) {
        echo "✅ GEFUNDEN - Netzwerkpfad erreichbar: $path\n";
        $found[] = ['type' => 'Netzwerkpfad', 'path' => $path];
    }
}

// 7. Druckerports (alle)
echo "\n7. DRUCKERPORTS:\n";
echo str_repeat("-", 50) . "\n";
exec('wmic path Win32_TCPIPPrinterPort get name /format:list', $tcp_ports);
exec('wmic path Win32_LocalPrintingConfiguration get name /format:list', $local_ports);
$all_ports = array_merge($tcp_ports, $local_ports);
foreach ($all_ports as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Port: $line\n";
        $found[] = ['type' => 'Port', 'info' => $line];
    }
}

// 8. Druckerfreigaben (net view)
echo "\n8. NETZWERK-FREIGABEN:\n";
echo str_repeat("-", 50) . "\n";
exec('net view 2>nul', $net_view);
exec('net share 2>nul', $net_share);
$all_net = array_merge($net_view, $net_share);
foreach ($all_net as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Netzwerk: $line\n";
        $found[] = ['type' => 'Netzwerk', 'info' => $line];
    }
}

// 9. Alle Drucker (auch versteckte/fehlerhafte)
echo "\n9. ALLE DRUCKER (inkl. versteckte):\n";
echo str_repeat("-", 50) . "\n";
exec('wmic printer list full /format:list', $all_printers_full);
$current = [];
foreach ($all_printers_full as $line) {
    $line = trim($line);
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN: $line\n";
        $found[] = ['type' => 'Drucker (voll)', 'info' => $line];
    }
}

// 10. Drucker-Infrastruktur
echo "\n10. DRUCKER-INFRASTRUKTUR:\n";
echo str_repeat("-", 50) . "\n";

// Print Spooler Service
exec('sc query spooler', $spooler);
foreach ($spooler as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Spooler: $line\n";
        $found[] = ['type' => 'Spooler', 'info' => $line];
    }
}

// 11. Event Log (Drucker-Ereignisse)
echo "\n11. EVENT LOG (letzte Drucker-Ereignisse):\n";
echo str_repeat("-", 50) . "\n";
exec('wevtutil qe System /c:10 /f:text /q:"*[System[Provider[@Name=\'Microsoft-Windows-PrintService\']]]" 2>nul', $events);
foreach ($events as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Event: $line\n";
        $found[] = ['type' => 'Event', 'info' => $line];
    }
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found)) {
    echo "✅ ES WURDEN " . count($found) . " EINTRÄGE MIT 'PRT17' GEFUNDEN!\n\n";
    foreach ($found as $idx => $item) {
        echo ($idx + 1) . ". " . $item['type'] . "\n";
        if (isset($item['name'])) echo "   Name: " . $item['name'] . "\n";
        if (isset($item['path'])) echo "   Pfad: " . $item['path'] . "\n";
        if (isset($item['info'])) echo "   Info: " . $item['info'] . "\n";
        echo "\n";
    }
    
    // Verwendungsvorschlag
    if (isset($found[0]['name'])) {
        $printer_name = $found[0]['name'];
        echo "💡 VERWENDUNG:\n";
        echo "   define('PRINTER_NAME', '$printer_name');\n";
    } elseif (isset($found[0]['path'])) {
        $printer_path = $found[0]['path'];
        echo "💡 VERWENDUNG (Netzwerkpfad):\n";
        echo "   define('PRINTER_NAME', '$printer_path');\n";
    }
} else {
    echo "❌ KEINE EINTRÄGE MIT 'PRT17' GEFUNDEN\n\n";
    echo "Mögliche Erklärungen:\n";
    echo "1. PRT17 ist ein Netzwerkdrucker auf einem anderen Computer\n";
    echo "2. PRT17 muss erst als Netzwerkdrucker hinzugefügt werden\n";
    echo "3. PRT17 ist ein UNC-Pfad wie: \\\\SERVER\\PRT17\n";
    echo "4. PRT17 ist ein Treiber-Name, der installiert werden muss\n\n";
    
    echo "💡 LÖSUNG: Versuchen Sie PRT17 als Netzwerkdrucker zu verwenden:\n";
    echo "   - Als Druckername: 'PRT17' (wenn lokal installiert)\n";
    echo "   - Als UNC-Pfad: '\\\\SERVERNAME\\PRT17'\n";
    echo "   - Als IP: '\\\\192.168.1.100\\PRT17'\n";
    echo "\n";
    echo "   In PHP können Sie auch direkt den UNC-Pfad verwenden:\n";
    echo "   printToPrinter(\$pdf_path, '\\\\SERVER\\PRT17', \$copies);\n";
}

?>

