<?php
/**
 * Sucht nach PRT17-Geräten, die von Deniz Uludag/Uludag installiert wurden
 */

echo "=== SUCHE NACH PRT17-GERÄTEN VON DENIZ ULUDAG ===\n\n";

$found = [];

// 1. Alle Drucker mit Benutzer-Informationen
echo "1. DRUCKER MIT BENUTZER-INFO:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,driverName,portName,attributes,status /format:list', $printers);
$current = [];
foreach ($printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $driver = $current['driver'] ?? '';
            $port = $current['port'] ?? '';
            
            // Suche nach PRT17
            if (stripos($name, 'PRT17') !== false || 
                stripos($driver, 'PRT17') !== false || 
                stripos($port, 'PRT17') !== false) {
                echo "✅ GEFUNDEN - Drucker: $name\n";
                echo "   Treiber: $driver\n";
                echo "   Port: $port\n";
                $found[] = ['type' => 'Drucker', 'name' => $name, 'driver' => $driver, 'port' => $port];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'DriverName=') === 0) $current['driver'] = substr($line, 11);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'Attributes=') === 0) $current['attributes'] = substr($line, 11);
    if (strpos($line, 'Status=') === 0) $current['status'] = substr($line, 7);
}

// 2. Registry - Benutzer-spezifische Drucker
echo "\n2. BENUTZER-SPEZIFISCHE DRUCKER (Registry):\n";
echo str_repeat("-", 50) . "\n";

// Suche in allen Benutzerprofilen
$users_dir = 'C:\\Users';
if (is_dir($users_dir)) {
    $users = scandir($users_dir);
    foreach ($users as $user) {
        if ($user === '.' || $user === '..') continue;
        
        // Prüfe ob es Uludag oder ähnlich ist
        if (stripos($user, 'uludag') !== false || stripos($user, 'deniz') !== false) {
            echo "Benutzer gefunden: $user\n";
            
            $user_reg_path = "HKEY_USERS\\S-1-5-21-*\\Printers";
            // Suche in Registry nach diesem Benutzer
            exec("reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows NT\\CurrentVersion\\Devices\" /s 2>nul", $user_devices);
            foreach ($user_devices as $line) {
                if (stripos($line, 'PRT17') !== false || stripos($line, 'uludag') !== false) {
                    echo "✅ GEFUNDEN - Benutzer-Registry: $line\n";
                    $found[] = ['type' => 'Benutzer-Registry', 'info' => $line, 'user' => $user];
                }
            }
        }
    }
}

// 3. Registry - Geräte-Einträge mit PRT17
echo "\n3. REGISTRY - GERÄTE-EINTRÄGE:\n";
echo str_repeat("-", 50) . "\n";

$registry_paths = [
    'HKEY_CURRENT_USER\\Software\\Microsoft\\Windows NT\\CurrentVersion\\Devices',
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Printers',
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Enum',
    'HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Print\\Printers',
];

foreach ($registry_paths as $path) {
    exec("reg query \"$path\" /s 2>nul", $reg_output);
    foreach ($reg_output as $line) {
        if (stripos($line, 'PRT17') !== false) {
            echo "✅ GEFUNDEN - Registry: $line\n";
            $found[] = ['type' => 'Registry', 'path' => $line];
        }
        // Auch nach Uludag suchen
        if (stripos($line, 'uludag') !== false || stripos($line, 'deniz') !== false) {
            if (stripos($line, 'PRT') !== false || stripos($line, '17') !== false) {
                echo "✅ MÖGLICH - Benutzer + Drucker: $line\n";
                $found[] = ['type' => 'Möglicher Eintrag', 'path' => $line];
            }
        }
    }
}

// 4. Installierte Geräte (PnP)
echo "\n4. INSTALLIERTE GERÄTE (PnP):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic path win32_pnpentity get name,deviceid,status /format:list', $devices);
$current = [];
foreach ($devices as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $id = $current['id'] ?? '';
            if (stripos($name, 'PRT17') !== false || 
                stripos($id, 'PRT17') !== false ||
                (stripos($name, 'PRT') !== false && stripos($name, '17') !== false)) {
                echo "✅ GEFUNDEN - Gerät: $name\n";
                echo "   DeviceID: $id\n";
                $found[] = ['type' => 'PnP-Gerät', 'name' => $name, 'id' => $id];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'DeviceID=') === 0) $current['id'] = substr($line, 9);
    if (strpos($line, 'Status=') === 0) $current['status'] = substr($line, 7);
}

// 5. Druckertreiber (alle)
echo "\n5. DRUCKERTREIBER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printerdriver get name,driverpath,version /format:list', $drivers);
$current = [];
foreach ($drivers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $path = $current['path'] ?? '';
            if (stripos($name, 'PRT17') !== false || 
                stripos($path, 'PRT17') !== false ||
                (stripos($name, 'PRT') !== false && stripos($name, '17') !== false)) {
                echo "✅ GEFUNDEN - Treiber: $name\n";
                echo "   Pfad: $path\n";
                $found[] = ['type' => 'Treiber', 'name' => $name, 'path' => $path];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'DriverPath=') === 0) $current['path'] = substr($line, 12);
    if (strpos($line, 'Version=') === 0) $current['version'] = substr($line, 9);
}

// 6. Druckerports
echo "\n6. DRUCKERPORTS:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic path Win32_TCPIPPrinterPort get name /format:list', $tcp_ports);
exec('wmic path Win32_LocalPrintingConfiguration get name /format:list', $local_ports);
$all_ports = array_merge($tcp_ports, $local_ports);
foreach ($all_ports as $line) {
    if (stripos($line, 'PRT17') !== false) {
        echo "✅ GEFUNDEN - Port: $line\n";
        $found[] = ['type' => 'Port', 'info' => $line];
    }
}

// 7. Event Log - Installationen
echo "\n7. EVENT LOG (Installationen):\n";
echo str_repeat("-", 50) . "\n";

// Suche nach Installationen von Uludag
exec('wevtutil qe System /c:50 /f:text /q:"*[System[Provider[@Name=\'Microsoft-Windows-User-Device-Registration\'] or Provider[@Name=\'Microsoft-Windows-PrintService\']]]" 2>nul', $events);
foreach ($events as $line) {
    if ((stripos($line, 'uludag') !== false || stripos($line, 'deniz') !== false) && 
        (stripos($line, 'PRT17') !== false || (stripos($line, 'PRT') !== false && stripos($line, '17') !== false))) {
        echo "✅ GEFUNDEN - Event: $line\n";
        $found[] = ['type' => 'Event', 'info' => $line];
    }
}

// 8. Alle Drucker (vollständige Liste)
echo "\n8. ALLE DRUCKER (vollständig):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer list full /format:list', $all_printers);
$current = [];
foreach ($all_printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            // Prüfe alle Felder
            $all_text = implode(' ', $current);
            if (stripos($all_text, 'PRT17') !== false || 
                (stripos($all_text, 'PRT') !== false && stripos($all_text, '17') !== false)) {
                echo "✅ GEFUNDEN - Drucker-Details:\n";
                foreach ($current as $key => $value) {
                    if (stripos($value, 'PRT17') !== false || 
                        (stripos($key, 'PRT') !== false && stripos($value, '17') !== false)) {
                        echo "   $key: $value\n";
                    }
                }
                $found[] = ['type' => 'Drucker (voll)', 'data' => $current];
            }
            $current = [];
        }
        continue;
    }
    if (strpos($line, '=') !== false) {
        list($key, $value) = explode('=', $line, 2);
        $current[$key] = $value;
    }
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found)) {
    echo "✅ ES WURDEN " . count($found) . " EINTRÄGE GEFUNDEN!\n\n";
    
    $printer_names = [];
    foreach ($found as $idx => $item) {
        echo ($idx + 1) . ". " . $item['type'] . "\n";
        if (isset($item['name'])) {
            echo "   Name: " . $item['name'] . "\n";
            if (stripos($item['name'], 'PRT17') !== false) {
                $printer_names[] = $item['name'];
            }
        }
        if (isset($item['port']) && stripos($item['port'], 'PRT17') !== false) {
            echo "   Port: " . $item['port'] . "\n";
            $printer_names[] = $item['port'];
        }
        if (isset($item['driver']) && stripos($item['driver'], 'PRT17') !== false) {
            echo "   Treiber: " . $item['driver'] . "\n";
        }
        if (isset($item['path'])) {
            echo "   Pfad: " . $item['path'] . "\n";
        }
        if (isset($item['info'])) {
            echo "   Info: " . substr($item['info'], 0, 100) . "...\n";
        }
        echo "\n";
    }
    
    // Eindeutige Druckernamen
    $unique_names = array_unique($printer_names);
    if (!empty($unique_names)) {
        echo "💡 VERWENDUNGSVORSCHLÄGE:\n";
        echo str_repeat("-", 50) . "\n";
        foreach ($unique_names as $name) {
            echo "   define('PRINTER_NAME', '$name');\n";
        }
    }
} else {
    echo "❌ KEINE EINTRÄGE MIT 'PRT17' GEFUNDEN\n\n";
    echo "Mögliche Erklärungen:\n";
    echo "1. PRT17 ist ein Netzwerkdrucker (UNC-Pfad)\n";
    echo "2. PRT17 ist ein virtueller Drucker/Treiber\n";
    echo "3. PRT17 wurde unter einem anderen Namen installiert\n";
    echo "4. PRT17 ist auf einem anderen Computer/Server\n\n";
    
    echo "💡 LÖSUNG: Versuchen Sie PRT17 direkt zu verwenden:\n";
    echo "   - Als Druckername: 'PRT17'\n";
    echo "   - Als UNC-Pfad: '\\\\SERVER\\PRT17'\n";
    echo "   - Als IP: '\\\\192.168.1.100\\PRT17'\n";
    echo "\n";
    echo "   In print_etikett_example.php:\n";
    echo "   define('PRINTER_NAME', 'PRT17');\n";
    echo "   ODER\n";
    echo "   define('PRINTER_NAME', '\\\\SERVER\\PRT17');\n";
}

?>

