<?php
/**
 * Sucht nach Domain-Benutzern (Deniz Uludag) und Domain-Druckern
 * Für Active Directory / Domain-Umgebung
 */

echo "=== SUCHE NACH DOMAIN-BENUTZER UND DOMAIN-DRUCKERN ===\n\n";

$found = [];

// 1. Domain-Informationen
echo "1. DOMAIN-INFORMATIONEN:\n";
echo str_repeat("-", 50) . "\n";

$domain = getenv('USERDOMAIN');
$domain_controller = getenv('LOGONSERVER');
$computer_name = getenv('COMPUTERNAME');

echo "Domain: $domain\n";
echo "Domain Controller: $domain_controller\n";
echo "Computer Name: $computer_name\n";

if (!empty($domain_controller)) {
    echo "✅ Domain-Umgebung erkannt!\n";
}

// 2. Domain-Benutzer suchen
echo "\n2. DOMAIN-BENUTZER:\n";
echo str_repeat("-", 50) . "\n";

// Versuche verschiedene Methoden
$domain_queries = [
    "dsquery user -name *uludag* 2>nul",
    "dsquery user -name *deniz* 2>nul",
    "net user /domain 2>nul",
    "wmic useraccount where \"domain='$domain'\" get name,fullname /format:list 2>nul",
];

foreach ($domain_queries as $query) {
    exec($query, $output, $return_code);
    if ($return_code === 0 && !empty($output)) {
        foreach ($output as $line) {
            if (stripos($line, 'uludag') !== false || stripos($line, 'deniz') !== false) {
                echo "✅ GEFUNDEN: $line\n";
                $found[] = ['type' => 'Domain-Benutzer', 'info' => $line];
            }
        }
    }
}

// 3. Domain-Drucker (über Gruppenrichtlinien)
echo "\n3. DOMAIN-DRUCKER (GRUPPENRICHTLINIEN):\n";
echo str_repeat("-", 50) . "\n";

// Suche nach Gruppenrichtlinien-Druckern
$gpo_paths = [
    'C:\\Windows\\System32\\GroupPolicy\\Machine\\Preferences\\Printers',
    'C:\\Windows\\System32\\GroupPolicy\\User\\Preferences\\Printers',
];

foreach ($gpo_paths as $gpo_path) {
    if (is_dir($gpo_path)) {
        echo "✅ Gruppenrichtlinien-Pfad gefunden: $gpo_path\n";
        exec("dir /s /b \"$gpo_path\" 2>nul | findstr /i \"PRT17\"", $gpo_files);
        foreach ($gpo_files as $file) {
            echo "  📄 GEFUNDEN: $file\n";
            $found[] = ['type' => 'GPO-Drucker', 'path' => $file];
        }
    }
}

// 4. Netzwerkdrucker (Domain-weit)
echo "\n4. NETZWERKDRUCKER (DOMAIN):\n";
echo str_repeat("-", 50) . "\n";

// Suche nach Domain-Druckerservern
$possible_servers = [
    $domain_controller,
    'buek-s01',
    'buek-s02',
    'buek-server',
    'print-server',
    'printer-server',
    'print.' . $domain,
    'printer.' . $domain,
];

foreach ($possible_servers as $server) {
    if (empty($server)) continue;
    
    echo "Prüfe Server: $server\n";
    
    // Teste ob Server erreichbar ist
    $ping_cmd = sprintf('ping -n 1 -w 1000 %s 2>nul', escapeshellarg($server));
    exec($ping_cmd, $ping_output, $ping_return);
    
    if ($ping_return === 0) {
        echo "  ✅ Server erreichbar\n";
        
        // Versuche Drucker zu finden
        $net_cmd = sprintf('net view \\\\%s 2>&1', escapeshellarg($server));
        exec($net_cmd, $net_output, $net_return);
        
        if ($net_return === 0) {
            echo "  ✅ Freigaben gefunden:\n";
            foreach ($net_output as $line) {
                if (stripos($line, 'PRT') !== false || 
                    stripos($line, 'Drucker') !== false || 
                    stripos($line, 'Printer') !== false) {
                    echo "    📄 $line\n";
                    if (stripos($line, 'PRT17') !== false) {
                        $found[] = ['type' => 'Domain-Drucker', 'server' => $server, 'info' => $line];
                    }
                }
            }
        }
    }
}

// 5. Registry - Domain-Drucker
echo "\n5. REGISTRY - DOMAIN-DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

$registry_paths = [
    'HKEY_LOCAL_MACHINE\\SOFTWARE\\Policies\\Microsoft\\Windows NT\\Printers',
    'HKEY_CURRENT_USER\\SOFTWARE\\Policies\\Microsoft\\Windows NT\\Printers',
    'HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Printers',
];

foreach ($registry_paths as $path) {
    exec("reg query \"$path\" /s 2>nul", $reg_output);
    foreach ($reg_output as $line) {
        if (stripos($line, 'PRT17') !== false ||
            (stripos($line, 'PRT') !== false && stripos($line, '17') !== false)) {
            echo "✅ GEFUNDEN - Registry: $line\n";
            $found[] = ['type' => 'Registry', 'path' => $line];
        }
    }
}

// 6. Alle installierten Drucker (könnten Domain-Drucker sein)
echo "\n6. ALLE INSTALLIERTEN DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,portname,sharename,drivername /format:list', $printers);
$current = [];
foreach ($printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $name = $current['name'] ?? '';
            $port = $current['port'] ?? '';
            $share = $current['share'] ?? '';
            
            // Zeige alle Drucker
            echo "Drucker: $name\n";
            if (!empty($port)) echo "  Port: $port\n";
            if (!empty($share)) echo "  Freigabe: $share\n";
            
            // Prüfe ob es ein Domain-Drucker ist (UNC-Pfad im Port)
            if (strpos($port, '\\\\') === 0) {
                echo "  🌐 DOMAIN-DRUCKER (UNC-Pfad)\n";
                if (stripos($port, 'PRT17') !== false || 
                    stripos($share, 'PRT17') !== false) {
                    echo "    ⭐⭐⭐ PRT17 GEFUNDEN! ⭐⭐⭐\n";
                    $found[] = ['type' => 'Domain-Drucker', 'name' => $name, 'port' => $port, 'share' => $share];
                }
            }
            
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
    if (strpos($line, 'DriverName=') === 0) $current['driver'] = substr($line, 11);
}

// 7. Suche nach Druckern mit Domain-Servern im Port
echo "\n7. DRUCKER MIT DOMAIN-SERVERN:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get portname /format:list', $ports);
foreach ($ports as $line) {
    $line = trim($line);
    if (strpos($line, 'PortName=') === 0) {
        $port = substr($line, 9);
        if (strpos($port, '\\\\') === 0) {
            echo "✅ Domain-Drucker gefunden: $port\n";
            if (stripos($port, 'PRT17') !== false) {
                echo "  ⭐⭐⭐ PRT17 GEFUNDEN! ⭐⭐⭐\n";
                $found[] = ['type' => 'Domain-Drucker-Port', 'port' => $port];
            }
        }
    }
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

if (!empty($found)) {
    echo "✅ ES WURDEN " . count($found) . " EINTRÄGE GEFUNDEN!\n\n";
    
    $prt17_found = [];
    foreach ($found as $item) {
        if ($item['type'] === 'Domain-Drucker' || $item['type'] === 'Domain-Drucker-Port') {
            if (isset($item['port']) && stripos($item['port'], 'PRT17') !== false) {
                $prt17_found[] = $item['port'];
            } elseif (isset($item['share']) && stripos($item['share'], 'PRT17') !== false) {
                $prt17_found[] = $item['share'];
            } elseif (isset($item['name']) && stripos($item['name'], 'PRT17') !== false) {
                $prt17_found[] = $item['name'];
            }
        }
    }
    
    if (!empty($prt17_found)) {
        echo "💡 PRT17 GEFUNDEN:\n";
        echo str_repeat("-", 50) . "\n";
        $unique = array_unique($prt17_found);
        foreach ($unique as $printer) {
            echo "   $printer\n";
            echo "   💡 Verwendung: define('PRINTER_NAME', '" . str_replace('\\', '\\\\', $printer) . "');\n";
        }
    } else {
        echo "📋 ALLE GEFUNDENEN EINTRÄGE:\n";
        foreach ($found as $idx => $item) {
            echo ($idx + 1) . ". " . $item['type'] . "\n";
            if (isset($item['port'])) echo "   Port: " . $item['port'] . "\n";
            if (isset($item['share'])) echo "   Freigabe: " . $item['share'] . "\n";
            if (isset($item['name'])) echo "   Name: " . $item['name'] . "\n";
            echo "\n";
        }
    }
} else {
    echo "❌ KEINE DOMAIN-DRUCKER MIT PRT17 GEFUNDEN\n\n";
    echo "💡 LÖSUNG FÜR DOMAIN-UMGEBUNG:\n";
    echo "1. Fragen Sie die IT nach:\n";
    echo "   - Dem Domain-Druckerserver-Namen\n";
    echo "   - Dem UNC-Pfad zu PRT17\n";
    echo "   - Ob PRT17 über Gruppenrichtlinien bereitgestellt wird\n";
    echo "\n";
    echo "2. Prüfen Sie im Explorer:\n";
    echo "   - \\\\$domain_controller (Domain Controller)\n";
    echo "   - \\\\buek-s01 (möglicher Druckerserver)\n";
    echo "   - \\\\print-server (möglicher Druckerserver)\n";
    echo "\n";
    echo "3. Verwenden Sie den UNC-Pfad direkt:\n";
    echo "   define('PRINTER_NAME', '\\\\SERVER\\PRT17');\n";
}

echo "\n";
echo "💡 HINWEIS: In Domain-Umgebungen werden Drucker oft über\n";
echo "   Gruppenrichtlinien oder Domain-Druckerserver bereitgestellt.\n";
echo "   Der exakte UNC-Pfad kann von der IT bereitgestellt werden.\n";

?>

