<?php
/**
 * Zeigt ALLE verfügbaren Drucker mit allen Details
 * Hilft dabei, PRT17 zu finden, auch wenn es anders heißt
 */

echo "=== ALLE VERFÜGBAREN DRUCKER (VOLLSTÄNDIG) ===\n\n";

// 1. Alle Drucker mit WMI
echo "1. ALLE DRUCKER (WMI):\n";
echo str_repeat("-", 50) . "\n";

exec('wmic printer get name,portname,sharename,drivername,attributes,status,default /format:list', $printers);
$current = [];
$all_printers = [];

foreach ($printers as $line) {
    $line = trim($line);
    if (empty($line)) {
        if (!empty($current)) {
            $all_printers[] = $current;
            $current = [];
        }
        continue;
    }
    if (strpos($line, 'Name=') === 0) $current['name'] = substr($line, 5);
    if (strpos($line, 'PortName=') === 0) $current['port'] = substr($line, 9);
    if (strpos($line, 'ShareName=') === 0) $current['share'] = substr($line, 10);
    if (strpos($line, 'DriverName=') === 0) $current['driver'] = substr($line, 11);
    if (strpos($line, 'Attributes=') === 0) $current['attributes'] = substr($line, 12);
    if (strpos($line, 'Status=') === 0) $current['status'] = substr($line, 7);
    if (strpos($line, 'Default=') === 0) $current['default'] = substr($line, 8);
}

if (empty($all_printers)) {
    echo "❌ Keine Drucker gefunden\n";
} else {
    foreach ($all_printers as $idx => $printer) {
        echo "Drucker " . ($idx + 1) . ":\n";
        echo "  Name: " . ($printer['name'] ?? 'N/A') . "\n";
        if (!empty($printer['port'])) echo "  Port: " . $printer['port'] . "\n";
        if (!empty($printer['share'])) echo "  Freigabe: " . $printer['share'] . "\n";
        if (!empty($printer['driver'])) echo "  Treiber: " . $printer['driver'] . "\n";
        if (!empty($printer['status'])) echo "  Status: " . $printer['status'] . "\n";
        if (!empty($printer['default']) && $printer['default'] === 'TRUE') {
            echo "  ⭐ STANDARD-DRUCKER\n";
        }
        
        // Prüfe ob es PRT17 sein könnte
        $name = strtoupper($printer['name'] ?? '');
        $port = strtoupper($printer['port'] ?? '');
        $share = strtoupper($printer['share'] ?? '');
        
        if (stripos($name, 'PRT') !== false && stripos($name, '17') !== false ||
            stripos($port, 'PRT') !== false && stripos($port, '17') !== false ||
            stripos($share, 'PRT') !== false && stripos($share, '17') !== false) {
            echo "  ⭐⭐⭐ KÖNNTE PRT17 SEIN! ⭐⭐⭐\n";
        }
        
        echo "\n";
    }
}

// 2. Druckerports
echo "\n2. DRUCKERPORTS:\n";
echo str_repeat("-", 50) . "\n";

exec('wmic path Win32_TCPIPPrinterPort get name /format:list', $tcp_ports);
exec('wmic path Win32_LocalPrintingConfiguration get name /format:list', $local_ports);
$all_ports = array_merge($tcp_ports, $local_ports);

if (empty($all_ports)) {
    echo "❌ Keine Ports gefunden\n";
} else {
    foreach ($all_ports as $line) {
        $line = trim($line);
        if (!empty($line) && $line !== 'Name') {
            echo "  Port: $line\n";
            if (stripos($line, 'PRT17') !== false) {
                echo "    ⭐⭐⭐ PRT17 GEFUNDEN! ⭐⭐⭐\n";
            }
        }
    }
}

// 3. Registry - Alle Drucker
echo "\n3. REGISTRY - ALLE DRUCKER:\n";
echo str_repeat("-", 50) . "\n";

exec('reg query "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Print\\Printers" 2>nul', $reg_printers);
foreach ($reg_printers as $line) {
    $line = trim($line);
    if (!empty($line) && stripos($line, 'HKEY') !== false) {
        $printer_name = basename($line);
        echo "  Drucker: $printer_name\n";
        if (stripos($printer_name, 'PRT17') !== false ||
            (stripos($printer_name, 'PRT') !== false && stripos($printer_name, '17') !== false)) {
            echo "    ⭐⭐⭐ PRT17 GEFUNDEN! ⭐⭐⭐\n";
        }
    }
}

// ZUSAMMENFASSUNG
echo "\n" . str_repeat("=", 50) . "\n";
echo "ZUSAMMENFASSUNG:\n";
echo str_repeat("=", 50) . "\n";

$possible_prt17 = [];
foreach ($all_printers as $printer) {
    $name = $printer['name'] ?? '';
    $port = $printer['port'] ?? '';
    $share = $printer['share'] ?? '';
    
    if (stripos($name, 'PRT') !== false && stripos($name, '17') !== false ||
        stripos($port, 'PRT') !== false && stripos($port, '17') !== false ||
        stripos($share, 'PRT') !== false && stripos($share, '17') !== false) {
        $possible_prt17[] = [
            'name' => $name,
            'port' => $port,
            'share' => $share
        ];
    }
}

if (!empty($possible_prt17)) {
    echo "✅ MÖGLICHE PRT17-DRUCKER GEFUNDEN:\n\n";
    foreach ($possible_prt17 as $idx => $printer) {
        echo ($idx + 1) . ". Name: " . $printer['name'] . "\n";
        if (!empty($printer['port'])) echo "   Port: " . $printer['port'] . "\n";
        if (!empty($printer['share'])) echo "   Freigabe: " . $printer['share'] . "\n";
        
        // Verwendungsvorschlag
        if (!empty($printer['share'])) {
            echo "   💡 Verwendung: define('PRINTER_NAME', '" . str_replace('\\', '\\\\', $printer['share']) . "');\n";
        } elseif (!empty($printer['name'])) {
            echo "   💡 Verwendung: define('PRINTER_NAME', '" . $printer['name'] . "');\n";
        }
        echo "\n";
    }
} else {
    echo "❌ KEIN DRUCKER MIT PRT17 GEFUNDEN\n\n";
    echo "💡 NÄCHSTE SCHRITTE:\n";
    echo "1. Öffnen Sie Windows Explorer\n";
    echo "2. Geben Sie ein: \\\\buek-s01 (oder anderen Server-Namen)\n";
    echo "3. Suchen Sie nach PRT17 in der Liste\n";
    echo "4. Kopieren Sie den exakten UNC-Pfad\n";
    echo "5. Verwenden Sie ihn in PHP:\n";
    echo "   define('PRINTER_NAME', '\\\\SERVER\\PRT17');\n";
}

echo "\n";
echo "📋 ALLE GEFUNDENEN DRUCKER:\n";
echo str_repeat("-", 50) . "\n";
foreach ($all_printers as $printer) {
    echo "- " . ($printer['name'] ?? 'N/A') . "\n";
}

?>

