@echo off
setlocal ENABLEDELAYEDEXPANSION

REM =========== Konfiguration / Hilfe ===========
if "%~1"=="" (
  echo Nutzung:
  echo   exshowroom_fetch.bat "https://ex-showroom.de/vs-ex90.gltf" [.^\out] [--hdr-only] [--headers "Header: Wert^|Cookie: x=y"]
  echo.
  echo Beispiele:
  echo   exshowroom_fetch.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90
  echo   exshowroom_fetch.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90 --hdr-only
  echo   exshowroom_fetch.bat "https://ex-showroom.de/vs-ex90.gltf" .\ex90 --headers "User-Agent: Mozilla/5.0^|Cookie: __Host=abc"
  exit /b 1
)

set "GLTF_URL=%~1"
set "OUT_DIR=%~2"
if "%OUT_DIR%"=="" set "OUT_DIR=.\downloaded_model"

set "HDR_ONLY=false"
set "HDR_FLAG=%~3"
set "HEADERS_FLAG=%~3"
set "HEADERS_STR=%~4"

if /I "%HDR_FLAG%"=="--hdr-only" set "HDR_ONLY=true"

if /I "%HEADERS_FLAG%"=="--headers" (
  set "HEADERS_STR=%~4"
) else (
  if /I "%~5"=="--headers" set "HEADERS_STR=%~6"
)

REM Prüfe PowerShell
where powershell >nul 2>nul
if errorlevel 1 (
  echo Fehler: PowerShell wurde nicht gefunden. Bitte sicherstellen, dass PowerShell^/Windows 10+ vorhanden ist.
  exit /b 1
)

REM Temporäre PS1-Datei anlegen
set "TMP_PS1=%TEMP%\exshowroom_fetch_%RANDOM%.ps1"
break > "%TMP_PS1%"

REM PowerShell-Script schreiben
(
  echo param(
  echo   [Parameter(Mandatory=$true)][string]$GltfUrl,
  echo   [string]$Out = ".\downloaded_model",
  echo   [bool]$HdrOnly = $false,
  echo   [string]$HeadersString = ""
  echo )
  echo
  echo function Write-Info(^$m^){ Write-Host ^$m -ForegroundColor Cyan }
  echo function Write-Ok(^$m^){ Write-Host ^$m -ForegroundColor Green }
  echo function Write-Err(^$m^){ Write-Host ^$m -ForegroundColor Red }
  echo
  echo function Join-Uri(^[string^]^$base, ^[string^]^$rel){
  echo   ^$baseUri = [System.Uri]^$base
  echo   ^$u = [System.Uri]::new(^$baseUri, ^$rel)
  echo   return ^$u.AbsoluteUri
  echo }
  echo
  echo function Is-DataUri(^[string^]^$uri){
  echo   return (^$null -ne ^$uri -and ^$uri.StartsWith(^"data:^"))
  echo }
  echo
  echo function Ensure-Dir(^[string^]^$path){
  echo   ^$dir = Split-Path -Parent ^$path
  echo   if (-not [string]::IsNullOrWhiteSpace(^$dir)) { New-Item -ItemType Directory -Force -Path ^$dir ^| Out-Null }
  echo }
  echo
  echo function Parse-Headers(^[string^]^$s){
  echo   ^$dict = @{}
  echo   if ([string]::IsNullOrWhiteSpace(^$s)) { return ^$dict }
  echo   ^$parts = ^$s -split '\^|'
  echo   foreach(^$p in ^$parts){
  echo     if ([string]::IsNullOrWhiteSpace(^$p)) { continue }
  echo     ^$kv = ^$p -split ':', 2
  echo     if (^$kv.Count -ge 2){
  echo       ^$k = (^$kv[0]).Trim()
  echo       ^$v = (^$kv[1]).Trim()
  echo       if (-not [string]::IsNullOrWhiteSpace(^$k)) { ^$dict[^$k] = ^$v }
  echo     }
  echo   }
  echo   return ^$dict
  echo }
  echo
  echo function Collect-Uris(^$gltf, ^[bool^]^$hdrOnly){
  echo   ^$list = New-Object System.Collections.Generic.List[string]
  echo   if (^$gltf.buffers){
  echo     foreach(^$b in ^$gltf.buffers){
  echo       ^$u = ^$b.uri
  echo       if (^$u -and -not (Is-DataUri ^$u)) { ^$list.Add(^$u) }
  echo     }
  echo   }
  echo   if (^$gltf.images){
  echo     foreach(^$img in ^$gltf.images){
  echo       ^$u = ^$img.uri
  echo       if (^$u -and -not (Is-DataUri ^$u)){
  echo         if (^$hdrOnly) {
  echo           if ((^$u.ToLower(^)).EndsWith(^".hdr^")) { ^$list.Add(^$u) }
  echo         } else {
  echo           ^$list.Add(^$u)
  echo         }
  echo       }
  echo     }
  echo   }
  echo   # generische Tiefensuche nach "uri"
  echo   function Scan(^$o){
  echo     if (^$null -eq ^$o) { return }
  echo     if (^$o -is [System.Collections.IDictionary]){
  echo       foreach(^$k in ^$o.Keys){
  echo         ^$v = ^$o[^$k]
  echo         if (^$k -eq ^"uri^" -and ^$v -is [string] -and -not (Is-DataUri ^$v)){
  echo           if (-not ^$hdrOnly -or (^$v.ToLower(^)).EndsWith(^".hdr^")) { ^$list.Add(^$v) }
  echo         } else { Scan ^$v }
  echo       }
  echo     } elseif (^$o -is [System.Collections.IEnumerable] -and -not (^$o -is [string])){
  echo       foreach(^$it in ^$o){ Scan ^$it }
  echo     }
  echo   }
  echo   Scan (^$gltf.PSObject.Properties ^| ForEach-Object { @{(^$_.Name) = ^$_.Value} })
  echo   return ^$list
  echo }
  echo
  echo try {
  echo   if (-not (Test-Path ^$Out)) { New-Item -ItemType Directory -Force -Path ^$Out ^| Out-Null }
  echo   ^$baseUrl = ^$GltfUrl.Substring(0, ^$GltfUrl.LastIndexOf(^"/^"))
  echo   ^$gltfName = Split-Path -Leaf ^$GltfUrl
  echo   ^$localGltfPath = Join-Path ^$Out ^$gltfName
  echo
  echo   ^$headers = Parse-Headers ^$HeadersString
  echo   Write-Info ^"Lade GLTF:`n  ^$GltfUrl^"
  echo   if (^$headers.Count -gt 0) {
  echo     Invoke-WebRequest -Uri ^$GltfUrl -OutFile ^$localGltfPath -Headers ^$headers -UseBasicParsing
  echo   } else {
  echo     Invoke-WebRequest -Uri ^$GltfUrl -OutFile ^$localGltfPath -UseBasicParsing
  echo   }
  echo   Write-Ok ^"✓ GLTF gespeichert: ^$localGltfPath^"
  echo
  echo   ^$jsonRaw = Get-Content -LiteralPath ^$localGltfPath -Raw
  echo   ^$gltf = ^$jsonRaw ^| ConvertFrom-Json
  echo
  echo   ^$uris = Collect-Uris ^$gltf ^$HdrOnly
  echo   ^$all = ^$uris ^| Sort-Object -Unique
  echo   Write-Info (^"Gefundene URIs: {0}^" -f ^$all.Count)
  echo   ^$all ^| ForEach-Object { Write-Host ^" - ^$_^" }
  echo
  echo   foreach(^$rel in ^$all){
  echo     try {
  echo       ^$fileUrl = Join-Uri ^$baseUrl ^$rel
  echo       ^$dst = Join-Path ^$Out (^$rel -replace '[\\]+','\')
  echo       Ensure-Dir ^$dst
  echo       Write-Host ^"↓ ^$fileUrl^"
  echo       if (^$headers.Count -gt 0) {
  echo         Invoke-WebRequest -Uri ^$fileUrl -OutFile ^$dst -Headers ^$headers -UseBasicParsing
  echo       } else {
  echo         Invoke-WebRequest -Uri ^$fileUrl -OutFile ^$dst -UseBasicParsing
  echo       }
  echo       Write-Ok ^"  ✓ ^$dst^"
  echo     } catch {
  echo       Write-Err (^"  ✗ Fehler bei {0} : {1}^" -f ^$rel, ^$_.Exception.Message)
  echo     }
  echo   }
  echo
  echo   Write-Ok (^"Fertig. Ordner: {0}^" -f (Resolve-Path ^$Out))
  echo   Write-Host
  echo   Write-Info ^"Optional: Zu .glb konvertieren (Node-Tool 'gltf-pipeline' erforderlich):^"
  echo   Write-Host ^"  npm install -g gltf-pipeline^"
  echo   Write-Host (^"  gltf-pipeline -i `"{0}`" -o `"{1}`"^" -f ^$localGltfPath (^$localGltfPath -replace '\.gltf$','\.glb'))
  echo
  echo } catch {
  echo   Write-Err (^"Abbruch: {0}^" -f ^$_.Exception.Message)
  echo   exit 1
  echo }
) >> "%TMP_PS1%"

REM PowerShell ausführen
powershell -NoProfile -ExecutionPolicy Bypass -File "%TMP_PS1%" -GltfUrl "%GLTF_URL%" -Out "%OUT_DIR%" -HdrOnly (%HDR_ONLY%) -HeadersString "%HEADERS_STR%"
set "ERR=%ERRORLEVEL%"

REM Aufräumen
del /q "%TMP_PS1%" >nul 2>nul

exit /b %ERR%