<?php
/**
 * Debug RESY Login
 */

$loginUrl = 'https://resy.dtm-reifen.de/index.php?m=login&a=login';
$username = 'D.ULUDAG';
$password = 'Ikizler123!';

echo "🧪 Debug RESY Login\n";
echo str_repeat("=", 60) . "\n\n";

// 1. Hole Login-Seite
echo "[1/3] Hole Login-Seite...\n";
$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_debug_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_debug_cookies.txt');

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";

// Parse Cookies
preg_match_all('/Set-Cookie: ([^=]+)=([^;]+)/', $response, $matches);
echo "Cookies empfangen: " . count($matches[0]) . "\n\n";

// 2. Submit Login
echo "[2/3] Submit Login...\n";
$postData = http_build_query([
    'InputUser' => $username,
    'InputPass' => $password,
    'button' => 'Anmelden'
]);

$ch = curl_init($loginUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_debug_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_debug_cookies.txt');
curl_setopt($ch, CURLOPT_HEADER, true);

$loginResponse = curl_exec($ch);
$finalUrl = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
curl_close($ch);

echo "Final URL nach Login: $finalUrl\n";
echo "Response-Länge: " . strlen($loginResponse) . "\n\n";

// Prüfe ob eingeloggt
if (strpos($loginResponse, 'Fehler') !== false) {
    echo "❌ FEHLER gefunden!\n";
    preg_match('/Fehler[^<]*/', $loginResponse, $error);
    if (!empty($error)) {
        echo "Fehlertext: " . $error[0] . "\n";
    }
} else {
    echo "✅ Kein Fehler-Text gefunden\n";
}

// 3. Teste Dashboard
echo "\n[3/3] Teste Dashboard-Zugriff...\n";
$dashboardUrl = 'https://resy.dtm-reifen.de/index.php';

$ch = curl_init($dashboardUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_COOKIEFILE, sys_get_temp_dir() . '/resy_debug_cookies.txt');
curl_setopt($ch, CURLOPT_COOKIEJAR, sys_get_temp_dir() . '/resy_debug_cookies.txt');

$dashboard = curl_exec($ch);
$dashboardCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "Dashboard HTTP Code: $dashboardCode\n";

if (strpos($dashboard, 'Anmeldung') !== false || strpos($dashboard, 'Login') !== false) {
    echo "❌ Nicht eingeloggt - noch auf Login-Seite\n";
} else {
    echo "✅ Erscheint eingeloggt zu sein\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "✅ Debug abgeschlossen\n";

