<?php
/**
 * Debug-Script für resy_image_proxy.php
 */

// Simuliere die Parameter
$lgfotoId = $_GET['lgfoto_id'] ?? '75767';
$appointmentId = $_GET['appointment_id'] ?? '89';

echo "<h1>Debug für resy_image_proxy.php</h1>";
echo "<p>LGFOTO_ID: $lgfotoId</p>";
echo "<p>Appointment ID: $appointmentId</p>";

// Teste die Proxy-URL
$proxyUrl = "http://100.82.207.72:8080/api/resy_image_proxy.php?lgfoto_id=$lgfotoId&appointment_id=$appointmentId";
echo "<p>Proxy URL: <a href='$proxyUrl' target='_blank'>$proxyUrl</a></p>";

// Teste mit cURL
echo "<h2>cURL Test:</h2>";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $proxyUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<p>HTTP Code: $httpCode</p>";
if ($error) {
    echo "<p>cURL Error: $error</p>";
}
echo "<p>Response Headers:</p>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

// Teste die Datenbankverbindung
echo "<h2>Datenbank Test:</h2>";
try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Teste Autohaus-Abfrage
    $stmt = $conn->prepare("
        SELECT a.resy_base_url, a.resy_username, a.resy_password 
        FROM autohaus a 
        JOIN appointments ap ON a.id = ap.autohaus_id 
        WHERE ap.id = ?
    ");
    $stmt->execute([$appointmentId]);
    $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($autohaus) {
        echo "<p>Autohaus gefunden:</p>";
        echo "<pre>" . print_r($autohaus, true) . "</pre>";
    } else {
        echo "<p>Kein Autohaus für Appointment ID $appointmentId gefunden</p>";
        
        // Teste alle Appointments
        $stmt = $conn->prepare("SELECT id, customer_name FROM appointments ORDER BY id DESC LIMIT 5");
        $stmt->execute();
        $appointments = $stmt->fetchAll(PDO::FETCH_ASSOC);
        echo "<p>Verfügbare Appointments:</p>";
        echo "<pre>" . print_r($appointments, true) . "</pre>";
    }
    
} catch (Exception $e) {
    echo "<p>Datenbankfehler: " . $e->getMessage() . "</p>";
}

// Teste die Log-Datei
echo "<h2>Log-Datei:</h2>";
$logFile = __DIR__ . '/logs/resy_image_proxy.log';
if (file_exists($logFile)) {
    $logContent = file_get_contents($logFile);
    $lines = explode("\n", $logContent);
    $recentLines = array_slice($lines, -20);
    echo "<pre>" . htmlspecialchars(implode("\n", $recentLines)) . "</pre>";
} else {
    echo "<p>Log-Datei nicht gefunden: $logFile</p>";
}

// Teste die Session
echo "<h2>Session Test:</h2>";
session_start();
echo "<pre>" . print_r($_SESSION, true) . "</pre>";

// Teste den Referer
echo "<h2>Referer Test:</h2>";
echo "<p>HTTP_REFERER: " . ($_SERVER['HTTP_REFERER'] ?? 'Nicht gesetzt') . "</p>";
?>
