@echo off
REM Windows Task Scheduler Setup für Boxenstop Admin-Benachrichtigungen
REM Dieses Script erstellt einen geplanten Task für Admin-Benachrichtigungen

echo Boxenstop Admin-Benachrichtigungen - Windows Task Scheduler Setup
echo ================================================================

REM Aktuelles Verzeichnis ermitteln
set "SCRIPT_DIR=%~dp0"
set "PROJECT_DIR=%SCRIPT_DIR%.."
set "PHP_PATH=C:\xampp\php\php.exe"
set "CRON_SCRIPT=%PROJECT_DIR%\cron\admin_notifications_cron.php"

echo.
echo Projekt-Verzeichnis: %PROJECT_DIR%
echo PHP-Pfad: %PHP_PATH%
echo Cron-Script: %CRON_SCRIPT%
echo.

REM Prüfen ob PHP existiert
if not exist "%PHP_PATH%" (
    echo FEHLER: PHP nicht gefunden unter %PHP_PATH%
    echo Bitte passen Sie den PHP_PATH in diesem Script an.
    pause
    exit /b 1
)

REM Prüfen ob Cron-Script existiert
if not exist "%CRON_SCRIPT%" (
    echo FEHLER: Cron-Script nicht gefunden unter %CRON_SCRIPT%
    pause
    exit /b 1
)

echo Erstelle Windows Task für Admin-Benachrichtigungen...
echo.

REM Task erstellen (täglich um 09:00 Uhr)
schtasks /create /tn "Boxenstop Admin Notifications" /tr "\"%PHP_PATH%\" \"%CRON_SCRIPT%\"" /sc daily /st 09:00 /f

if %errorlevel% equ 0 (
    echo.
    echo ✓ Task erfolgreich erstellt!
    echo.
    echo Der Task läuft täglich um 09:00 Uhr.
    echo.
    echo Weitere Optionen:
    echo - Task anzeigen: schtasks /query /tn "Boxenstop Admin Notifications"
    echo - Task löschen: schtasks /delete /tn "Boxenstop Admin Notifications" /f
    echo - Task sofort ausführen: schtasks /run /tn "Boxenstop Admin Notifications"
    echo.
) else (
    echo.
    echo FEHLER: Task konnte nicht erstellt werden!
    echo Möglicherweise sind Administrator-Rechte erforderlich.
    echo.
)

REM Logs-Verzeichnis erstellen
if not exist "%PROJECT_DIR%\logs" (
    mkdir "%PROJECT_DIR%\logs"
    echo ✓ Logs-Verzeichnis erstellt
)

echo.
echo Setup abgeschlossen!
echo.
pause
