<?php
/**
 * Drucker-Konfiguration für Boxenstop
 * 
 * WICHTIG: Diese Datei enthält sensible Informationen!
 * Bitte nicht in Git committen oder öffentlich zugänglich machen.
 */

// Drucker-Server-Credentials
// Diese werden verwendet, um sich mit dem Druckerserver zu verbinden
define('PRINTER_SERVER_USER', getenv('PRINTER_SERVER_USER') ?: 'VOLVOKIE\Projekt');
define('PRINTER_SERVER_PASS', getenv('PRINTER_SERVER_PASS') ?: 'start#2025');

// Drucker-Konfiguration
define('PRINTER_SERVER_TAILSCALE_IP', '100.82.207.72');
define('PRINTER_SERVER_HOSTNAME', 'buek-s01');
// WICHTIG: Auf dem Server (100.82.207.72) ist PRT17 als "BUEK-PRT17" freigegeben
// Freigabename auf dem Server: "BUEK-PRT17" (wie in Windows Explorer)
// Auf dem API-Server (nach Installation) heißt er "PRT17_BUEK-Server"
define('PRINTER_NAME_SERVER', 'BUEK-PRT17');  // Name auf Server 100.82.207.72 (Freigabename)
define('PRINTER_NAME_LOCAL', 'PRT17_BUEK-Server');  // Name nach lokaler Installation (tatsächlicher Name!)
define('PRINTER_NAME_API', 'PRT17_BUEK-Server');  // Name für API-Verwendung
define('PRINTER_NAME_WORKING', 'PRT17_BUEK-Server');  // Funktioniert nach Installation

// Fallback: labelprinter service (falls PRT17 nicht verfügbar)
define('PRINTER_NAME_FALLBACK', 'labelprinter service');  // Fallback-Drucker

// Lokale Druckernamen (werden automatisch erkannt)
// Diese Namen werden gesucht, wenn der Drucker lokal installiert ist
// WICHTIG: Die Drucker können als UNC-Pfade installiert sein (\\100.82.207.72\...)
define('PRINTER_LOCAL_NAMES', [
    'PRT17_BUEK-Server',          // Primärer Name (tatsächlicher lokaler Name!)
    'PRT17_BUEK-Server',           // Alternative Schreibweise
    'BUEK-PRT17',                  // Freigabename auf Server
    'PRT17',                       // Alternative Bezeichnung
    'PRT-17',                      // Mit Bindestrich
    'LABELPRINTER SERVICE',        // Fallback
    'LABELPRINTER-SERVICE',        // Mit Bindestrich
    'LABEL Printer TTP068-50',    // Mit Leerzeichen
    'LABEL_Printer_TTP068-50',    // Mit Unterstrichen
    'LABELPRINTER',
    'LABEL-PRINTER',
    'LABEL PRINTER',
    'TTP068'
]);

// UNC-Pfade für lokal installierte Drucker (falls als UNC installiert)
define('PRINTER_UNC_PATHS', [
    '\\\\100.82.207.72\\BUEK-PRT17',         // Primärer UNC-Pfad (Freigabename)
    '\\\\buek-s01\\BUEK-PRT17',              // Mit Hostname
    '\\\\100.82.207.72\\PRT17',              // Alternative Bezeichnung
    '\\\\buek-s01\\PRT17',                   // Mit Hostname
    '\\\\100.82.207.72\\LABELPRINTER SERVICE', // Fallback
    '\\\\100.82.207.72\\LABEL Printer TTP068-50',
    '\\\\100.82.207.72\\LABEL_Printer_TTP068-50'
]);

