<?php
/**
 * Bereinigt die push_subscriptions Tabelle
 * Entfernt doppelte Spalten (p256dh_key, auth_key) falls p256dh und auth existieren
 */

require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "=== BEREINIGUNG PUSH-SUBSCRIPTIONS TABELLE ===\n\n";
    
    // Prüfe welche Spalten existieren
    $stmt = $conn->query("DESCRIBE push_subscriptions");
    $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    $hasNewColumns = in_array('p256dh', $columns) && in_array('auth', $columns);
    $hasOldColumns = in_array('p256dh_key', $columns) && in_array('auth_key', $columns);
    
    if ($hasNewColumns && $hasOldColumns) {
        echo "⚠️  Doppelte Spalten gefunden!\n";
        echo "   - p256dh_key (alt)\n";
        echo "   - auth_key (alt)\n";
        echo "   - p256dh (neu)\n";
        echo "   - auth (neu)\n\n";
        
        echo "📋 Migriere Daten von alten zu neuen Spalten...\n";
        
        // Migriere Daten falls alte Spalten Daten haben
        $stmt = $conn->query("
            SELECT COUNT(*) as count 
            FROM push_subscriptions 
            WHERE (p256dh IS NULL OR p256dh = '') 
            AND (p256dh_key IS NOT NULL AND p256dh_key != '')
        ");
        $needsMigration = $stmt->fetch(PDO::FETCH_ASSOC)['count'] > 0;
        
        if ($needsMigration) {
            $conn->exec("
                UPDATE push_subscriptions 
                SET p256dh = p256dh_key 
                WHERE (p256dh IS NULL OR p256dh = '') 
                AND (p256dh_key IS NOT NULL AND p256dh_key != '')
            ");
            
            $conn->exec("
                UPDATE push_subscriptions 
                SET auth = auth_key 
                WHERE (auth IS NULL OR auth = '') 
                AND (auth_key IS NOT NULL AND auth_key != '')
            ");
            
            echo "   ✅ Daten migriert\n";
        } else {
            echo "   ℹ️  Keine Migration nötig\n";
        }
        
        echo "\n📋 Entferne alte Spalten...\n";
        
        try {
            $conn->exec("ALTER TABLE push_subscriptions DROP COLUMN p256dh_key");
            echo "   ✅ Spalte 'p256dh_key' entfernt\n";
        } catch (PDOException $e) {
            echo "   ⚠️  Fehler beim Entfernen von 'p256dh_key': " . $e->getMessage() . "\n";
        }
        
        try {
            $conn->exec("ALTER TABLE push_subscriptions DROP COLUMN auth_key");
            echo "   ✅ Spalte 'auth_key' entfernt\n";
        } catch (PDOException $e) {
            echo "   ⚠️  Fehler beim Entfernen von 'auth_key': " . $e->getMessage() . "\n";
        }
        
    } else if ($hasNewColumns) {
        echo "✅ Tabelle verwendet bereits neue Spaltennamen (p256dh, auth)\n";
    } else if ($hasOldColumns) {
        echo "⚠️  Tabelle verwendet noch alte Spaltennamen (p256dh_key, auth_key)\n";
        echo "   Die API unterstützt beide Varianten, aber neue Spalten werden empfohlen.\n";
    }
    
    echo "\n=== BEREINIGUNG ABGESCHLOSSEN ===\n";
    
} catch (Exception $e) {
    echo "❌ Fehler: " . $e->getMessage() . "\n";
    exit(1);
}
?>

