-- Database Backup: 2025-11-24 00:01:15
-- Backup Name: backup_2025-11-24_00-01-15


-- Table structure for `admin_actions`
DROP TABLE IF EXISTS `admin_actions`;
CREATE TABLE `admin_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `reason` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_admin_id` (`admin_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `admin_actions_ibfk_1` FOREIGN KEY (`admin_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `admin_actions_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_actions`
INSERT INTO `admin_actions` (`id`, `admin_id`, `user_id`, `action`, `reason`, `created_at`) VALUES
('2', '1', '65', 'suspend', 'sadsad', '2025-11-14 00:27:32'),
('6', '1', '65', 'suspend', 'weil ich das so will', '2025-11-14 15:39:15'),
('7', '1', '76', 'suspend', 'Das ist nur ein Test', '2025-11-16 11:01:21'),
('8', '1', '76', 'suspend', 'terst', '2025-11-16 11:06:59'),
('9', '1', '76', 'unsuspend', 'rtasdsd', '2025-11-16 11:08:19'),
('10', '1', '65', 'suspend', 'Sperrgrund: Test', '2025-11-16 11:11:45'),
('11', '1', '65', 'unsuspend', 'Entsperrgrund: asdasd', '2025-11-16 11:16:45');


-- Table structure for `admin_audit_log`
DROP TABLE IF EXISTS `admin_audit_log`;
CREATE TABLE `admin_audit_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action` varchar(50) NOT NULL,
  `table_name` varchar(50) NOT NULL,
  `record_id` int(11) DEFAULT NULL,
  `old_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`old_values`)),
  `new_values` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`new_values`)),
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `admin_audit_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Audit-Log für Admin-Benutzer-Aktivitäten';

-- Dumping data for table `admin_audit_log`

-- Table structure for `admin_notifications`
DROP TABLE IF EXISTS `admin_notifications`;
CREATE TABLE `admin_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_user_id` int(11) NOT NULL,
  `notification_type` enum('appointment_reminder_check','pending_appointments','system_alert') NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `sent_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_admin_notifications_admin` (`admin_user_id`),
  KEY `idx_admin_notifications_type` (`notification_type`),
  KEY `idx_admin_notifications_read` (`is_read`),
  KEY `idx_admin_notifications_created` (`created_at`),
  CONSTRAINT `admin_notifications_ibfk_1` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_notifications`

-- Table structure for `admin_settings`
DROP TABLE IF EXISTS `admin_settings`;
CREATE TABLE `admin_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`),
  KEY `fk_admin_settings_user_id` (`user_id`),
  CONSTRAINT `fk_admin_settings_user_id` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=378 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_settings`
INSERT INTO `admin_settings` (`id`, `user_id`, `setting_key`, `setting_value`, `created_at`, `updated_at`) VALUES
('1', '1', 'admin_name', 'Administrator', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('2', '1', 'admin_email', 'admin@boxenstop.de', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('3', '1', 'admin_phone', '01782465658', '2025-09-09 14:23:12', '2025-09-23 15:51:51'),
('4', '1', 'admin_position', 'Systemadministrator', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('5', '1', 'admin_department', 'IT', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('6', '1', 'admin_avatar', '../assets/images/avatars/admin-1758635430.png', '2025-09-09 14:23:12', '2025-09-23 15:50:30'),
('7', '1', 'admin_bio', 'Verwalte das Boxenstop-System', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('8', '1', 'admin_language', 'de', '2025-09-09 14:23:12', '2025-09-23 15:56:47'),
('9', '1', 'admin_timezone', 'Europe/Berlin', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('10', '1', 'admin_notifications', 'all', '2025-09-09 14:23:12', '2025-09-09 15:10:52'),
('11', '1', 'admin_theme', 'dark', '2025-09-09 14:23:12', '2025-09-23 16:10:38'),
('174', '1', 'sidebar_collapsed', 'false', '2025-09-21 19:46:06', '2025-09-23 11:31:50');


-- Table structure for `admin_users`
DROP TABLE IF EXISTS `admin_users`;
CREATE TABLE `admin_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `needs_dashboard_setup` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_login` timestamp NULL DEFAULT NULL,
  `email_notifications` tinyint(1) DEFAULT 1,
  `reminder_check_notifications` tinyint(1) DEFAULT 1,
  `pending_appointment_notifications` tinyint(1) DEFAULT 1,
  `role` enum('admin','manager','user') DEFAULT 'user',
  `autohaus_id` int(11) DEFAULT NULL,
  `can_switch_autohaus` tinyint(1) DEFAULT 0,
  `full_name` varchar(100) DEFAULT 'Administrator',
  `department` varchar(50) DEFAULT 'IT',
  `status` enum('active','inactive') DEFAULT 'active',
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `phone` varchar(20) DEFAULT NULL,
  `position` varchar(100) DEFAULT NULL,
  `avatar` varchar(255) DEFAULT NULL,
  `bio` text DEFAULT NULL,
  `language` varchar(10) DEFAULT 'de',
  `timezone` varchar(50) DEFAULT 'Europe/Berlin',
  `notifications` varchar(20) DEFAULT 'all',
  `theme` varchar(20) DEFAULT 'light',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `idx_admin_users_autohaus` (`autohaus_id`),
  KEY `idx_admin_users_role` (`role`),
  KEY `idx_admin_users_can_switch` (`can_switch_autohaus`),
  KEY `idx_admin_users_autohaus_id` (`autohaus_id`),
  KEY `idx_needs_dashboard_setup` (`needs_dashboard_setup`),
  CONSTRAINT `admin_users_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `admin_users`
INSERT INTO `admin_users` (`id`, `username`, `email`, `password_hash`, `is_active`, `needs_dashboard_setup`, `created_at`, `last_login`, `email_notifications`, `reminder_check_notifications`, `pending_appointment_notifications`, `role`, `autohaus_id`, `can_switch_autohaus`, `full_name`, `department`, `status`, `updated_at`, `phone`, `position`, `avatar`, `bio`, `language`, `timezone`, `notifications`, `theme`) VALUES
('1', 'admin', 'uludag@be-automobile.de', '$2y$10$IJS35gM9yXJ1uVX7jpTM0edL2esBARFkSEFClnPnfE0LtNqR1B.vq', '1', '0', '2025-09-04 08:13:05', '2025-11-23 23:13:20', '1', '1', '1', 'admin', NULL, '1', 'Deniz Uludag', 'Service', 'active', '2025-11-23 23:15:07', '01782465658', 'IT-Service', '../assets/images/avatars/admin-1763135402.png', 'Verwalte das Boxenstop-System', 'de', 'Europe/Berlin', 'all', 'light'),
('12', 'schoettle', 'schoettle@be-automobile.de', '$2y$10$vb4WPCP0jtaiMd3fHOP6LOZtQRNJub2jqtib8aHx.hZvfbwxSoQoa', '1', '0', '2025-09-25 13:03:13', '2025-09-25 14:07:53', '1', '1', '1', '', '1', '0', 'Torben Schöttle', 'Service', 'active', '2025-10-29 07:15:14', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'dark'),
('14', 'dobbratz', 'dobbratz@be-automobile.de', '$2y$10$50nODX0zSdm4L30ILtzQV.9YAiczji5sw8j7HVdJXsUb1oSjP7SCm', '1', '0', '2025-10-28 22:50:39', '2025-11-15 18:55:37', '1', '1', '1', 'admin', NULL, '1', 'Andreas Dobbreatz', 'Serviceleiter', 'active', '2025-11-15 18:55:37', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('15', 'jacholke', 'jacholke@be-automobile.de', '$2y$10$1QWHt/cscPGt86OY6tXbZesYRaoC87QTFUcYk0qOoZi/Q5i6J9v.m', '1', '0', '2025-10-29 07:12:47', '2025-11-14 17:33:27', '1', '1', '1', 'manager', '3', '0', 'Olaf Jacholke', 'Lager', 'active', '2025-11-14 17:33:27', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('16', 'vonholten', 'vonholten@be-automobile.de', '$2y$10$g3h5KedP8qrSwt24iPZ2xeCs5VAvO7d0v9QRqi7YtAeUPeeAub5nC', '1', '0', '2025-10-29 07:13:18', '2025-11-14 17:46:02', '1', '1', '1', 'manager', '1', '0', 'David von Holten', 'Lager', 'active', '2025-11-14 17:46:02', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('17', 'fischer', 'fischer@be-automobile.de', '$2y$10$WAST1BsttyxHLTlFgHMxBOwoeaC.q/9U2cZcMI2jC8Kyv.gM4khMW', '1', '0', '2025-10-29 07:13:57', '2025-11-06 11:31:42', '1', '1', '1', '', '1', '0', 'Tina Fischer', 'Service', 'active', '2025-11-06 11:31:42', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('18', 'neise', 'neise@be-automobile.de', '$2y$10$.WI3yDWDctjl18/ZVKMoc.EfCLapRtDjnvtpUcXm.ZnUod/ITR4qW', '1', '1', '2025-10-29 07:14:32', NULL, '1', '1', '1', '', '1', '0', 'Kerstin Neise', 'Service', 'active', '2025-10-29 07:14:32', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('19', 'marten', 'marten@be-automobile.de', '$2y$10$RDoUKrep.1PHB/IHksd8W.7bCOFgJHKvYX8oJv9ZQzT2nU.brk1Oe', '1', '1', '2025-10-29 07:15:03', NULL, '1', '1', '1', '', '1', '0', 'Andrea Marten', 'Service', 'active', '2025-10-29 07:15:03', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light'),
('20', 'panchuk', 'panchuk@be-automobile.de', '$2y$10$OBMRPVQmH6pDTYlb4Z2F7O0ZMjucTqQFHTds1Dw/V397sz4vqEQO.', '1', '1', '2025-10-29 07:16:07', NULL, '1', '1', '1', '', '1', '0', 'Dima Panchuk', 'Werkstatt', 'active', '2025-10-29 07:16:07', NULL, NULL, NULL, NULL, 'de', 'Europe/Berlin', 'all', 'light');


-- Table structure for `api_error_log`
DROP TABLE IF EXISTS `api_error_log`;
CREATE TABLE `api_error_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `error_type` varchar(50) NOT NULL COMMENT 'Art des Fehlers',
  `error_message` text NOT NULL COMMENT 'Fehlermeldung',
  `stack_trace` text DEFAULT NULL COMMENT 'Stack-Trace',
  `request_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Request-Daten' CHECK (json_valid(`request_data`)),
  `response_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Response-Daten' CHECK (json_valid(`response_data`)),
  `retry_count` int(11) DEFAULT 0 COMMENT 'Anzahl der Wiederholungsversuche',
  `resolved` tinyint(1) DEFAULT 0 COMMENT 'Ob der Fehler behoben wurde',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_error_autohaus` (`autohaus_id`,`created_at`),
  KEY `idx_error_type` (`error_type`,`created_at`),
  KEY `idx_error_log_autohaus_time` (`autohaus_id`,`created_at`),
  CONSTRAINT `api_error_log_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Fehler-Logs für API-Debugging und Monitoring';

-- Dumping data for table `api_error_log`

-- Table structure for `api_key_usage`
DROP TABLE IF EXISTS `api_key_usage`;
CREATE TABLE `api_key_usage` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `api_key_id` int(11) NOT NULL,
  `endpoint` varchar(255) NOT NULL,
  `http_method` varchar(10) NOT NULL,
  `status_code` int(11) NOT NULL,
  `request_ts` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip` varchar(64) DEFAULT NULL,
  `bytes_in` int(11) DEFAULT 0,
  `bytes_out` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `api_key_id` (`api_key_id`,`request_ts`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `api_key_usage`
INSERT INTO `api_key_usage` (`id`, `api_key_id`, `endpoint`, `http_method`, `status_code`, `request_ts`, `ip`, `bytes_in`, `bytes_out`) VALUES
('1', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:03:18', '::1', '0', '0'),
('2', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:03:18', '::1', '0', '1954'),
('3', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:08:59', '::1', '0', '0'),
('4', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:08:59', '::1', '0', '1954'),
('5', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:09:05', '::1', '0', '0'),
('6', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:09:05', '::1', '0', '1954'),
('7', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:10:49', '::1', '0', '0'),
('8', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:10:49', '::1', '0', '1954'),
('9', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:12:53', '::1', '0', '0'),
('10', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:12:53', '::1', '0', '1954'),
('11', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:13:39', '::1', '0', '0'),
('12', '1', '/boxenstop/api/get_available_slots.php', 'GET', '200', '2025-10-27 13:13:39', '::1', '0', '1954'),
('13', '1', '/boxenstop/api/appointments.php', 'GET', '200', '2025-10-27 13:13:39', '::1', '0', '0'),
('14', '1', '/boxenstop/api/appointments.php', 'GET', '200', '2025-10-27 13:13:39', '::1', '0', '2402'),
('15', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-29 21:50:50', '46.128.117.37', '0', '0'),
('16', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-29 21:50:50', '46.128.117.37', '0', '876'),
('17', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-30 08:25:26', '46.128.117.37', '0', '0'),
('18', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-30 08:25:26', '46.128.117.37', '0', '1954'),
('19', '2', '/api/appointments.php', 'POST', '200', '2025-10-30 08:26:05', '46.128.117.37', '262', '0'),
('20', '2', '/api/appointments.php', 'POST', '200', '2025-10-30 08:26:05', '46.128.117.37', '262', '78'),
('21', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-30 08:33:23', '46.128.117.37', '0', '0'),
('22', '2', '/api/get_available_slots.php', 'GET', '200', '2025-10-30 08:33:23', '46.128.117.37', '0', '1954'),
('23', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:36:09', '46.128.117.37', '0', '0'),
('24', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:36:09', '46.128.117.37', '0', '992'),
('25', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:41:53', '46.128.117.37', '0', '0'),
('26', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:41:53', '46.128.117.37', '0', '992'),
('27', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:42:33', '46.128.117.37', '0', '0'),
('28', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:42:33', '46.128.117.37', '0', '992'),
('29', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:49:38', '46.128.117.37', '0', '0'),
('30', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:49:38', '46.128.117.37', '0', '992'),
('31', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:58:15', '46.128.117.37', '0', '0'),
('32', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:58:15', '46.128.117.37', '0', '992'),
('33', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:58:53', '46.128.117.37', '0', '0'),
('34', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 20:58:53', '46.128.117.37', '0', '992'),
('35', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 21:13:56', '46.128.117.37', '0', '0'),
('36', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 21:13:56', '46.128.117.37', '0', '992'),
('37', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:38', '46.128.117.37', '0', '0'),
('38', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:38', '46.128.117.37', '0', '992'),
('39', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:42', '46.128.117.37', '0', '0'),
('40', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:42', '46.128.117.37', '0', '992'),
('41', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:43', '46.128.117.37', '0', '0'),
('42', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:05:43', '46.128.117.37', '0', '992'),
('43', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:06:02', '46.128.117.37', '0', '0'),
('44', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:06:02', '46.128.117.37', '0', '992'),
('45', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:06:16', '46.128.117.37', '255', '0'),
('46', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:06:16', '46.128.117.37', '255', '78'),
('47', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:30:55', '46.128.117.37', '0', '0'),
('48', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:30:55', '46.128.117.37', '0', '992'),
('49', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:31:07', '46.128.117.37', '229', '0'),
('50', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:31:07', '46.128.117.37', '229', '78'),
('51', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:31:22', '46.128.117.37', '0', '0'),
('52', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:31:22', '46.128.117.37', '0', '992'),
('53', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:44:12', '46.128.117.37', '0', '0'),
('54', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:44:12', '46.128.117.37', '0', '992'),
('55', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:52:52', '46.128.117.37', '0', '0'),
('56', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:52:52', '46.128.117.37', '0', '992'),
('57', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:52:57', '46.128.117.37', '0', '0'),
('58', '3', '/api/get_available_slots.php', 'GET', '200', '2025-10-31 22:52:57', '46.128.117.37', '0', '992'),
('59', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:53:28', '46.128.117.37', '229', '0'),
('60', '3', '/api/appointments.php', 'POST', '200', '2025-10-31 22:53:28', '46.128.117.37', '229', '78'),
('61', '3', '/api/get_available_slots.php', 'GET', '200', '2025-11-01 14:22:40', '176.4.0.70', '0', '0'),
('62', '3', '/api/get_available_slots.php', 'GET', '200', '2025-11-01 14:22:40', '176.4.0.70', '0', '992');


-- Table structure for `api_keys`
DROP TABLE IF EXISTS `api_keys`;
CREATE TABLE `api_keys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `key_hash` char(64) NOT NULL,
  `secret_hash` char(64) NOT NULL,
  `scopes` text NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `rate_limit_per_min` int(11) NOT NULL DEFAULT 60,
  `owner_type` varchar(20) DEFAULT 'admin',
  `owner_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_used_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_hash` (`key_hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `api_keys`
INSERT INTO `api_keys` (`id`, `name`, `key_hash`, `secret_hash`, `scopes`, `is_active`, `rate_limit_per_min`, `owner_type`, `owner_id`, `created_at`, `last_used_at`) VALUES
('1', 'Test', 'e92918242d0f8e201efe7ee916e46f3eb6aa12cdbcb7cb5ce46cd285a3b9ea4b', '22494dfe47c06f6ab64f5c196a1c257cca6f75e14029004cfdcf5c8f626daeb0', '[\"slots:read\",\"appointments:write\",\"profile:read\",\"profile:write\",\"vehicles:write\",\"notifications:read\",\"notifications:write\",\"activity:read\",\"documents:upload\"]', '0', '120', 'admin', NULL, '2025-10-27 12:46:55', NULL),
('3', 'B&E Gruppe v0.0.2', '977899d2b38b453678cc6cbd88f10ac8c73bbb91e730f206ad53b1a856dd96c3', '2b2632dcb0f6fcc90fc0e89694f93b7c5c1497d67cec10bee6b05bf43a1d3d93', '[\"slots:read\",\"appointments:write\",\"profile:read\",\"profile:write\",\"vehicles:read\",\"vehicles:write\",\"notifications:read\",\"notifications:write\",\"activity:read\",\"documents:upload\"]', '1', '120', 'admin', NULL, '2025-10-30 08:51:06', NULL);


-- Table structure for `api_performance_log`
DROP TABLE IF EXISTS `api_performance_log`;
CREATE TABLE `api_performance_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `load_time` decimal(5,2) NOT NULL COMMENT 'Ladezeit in Sekunden',
  `memory_usage` decimal(8,2) NOT NULL COMMENT 'Memory-Verbrauch in MB',
  `wheelsets_count` int(11) NOT NULL COMMENT 'Anzahl geladener Reifensätze',
  `pages_loaded` int(11) NOT NULL COMMENT 'Anzahl geladener Seiten',
  `strategy_used` varchar(50) NOT NULL COMMENT 'Verwendete Strategie',
  `cache_hit` tinyint(1) DEFAULT 0 COMMENT 'Ob Cache verwendet wurde',
  `error_occurred` tinyint(1) DEFAULT 0 COMMENT 'Ob ein Fehler aufgetreten ist',
  `error_message` text DEFAULT NULL COMMENT 'Fehlermeldung falls vorhanden',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_performance_autohaus` (`autohaus_id`,`created_at`),
  KEY `idx_performance_time` (`created_at`),
  KEY `idx_performance_log_autohaus_time` (`autohaus_id`,`created_at`),
  CONSTRAINT `api_performance_log_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Detaillierte Performance-Logs für API-Aufrufe';

-- Dumping data for table `api_performance_log`

-- Table structure for `api_replay_nonce`
DROP TABLE IF EXISTS `api_replay_nonce`;
CREATE TABLE `api_replay_nonce` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `api_key_id` int(11) NOT NULL,
  `nonce` varchar(64) NOT NULL,
  `ts` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_nonce` (`api_key_id`,`nonce`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `api_replay_nonce`
INSERT INTO `api_replay_nonce` (`id`, `api_key_id`, `nonce`, `ts`) VALUES
('1', '2', '04A77AC2-481F-4003-AEBA-3F3E63723132', '2025-10-30 08:26:05'),
('2', '3', '41730567-AA9D-4C9F-865C-1CF0DFDBCD70', '2025-10-31 22:06:16'),
('3', '3', '3A6AA51F-B565-443D-9F94-1A1100044A03', '2025-10-31 22:31:07'),
('4', '3', 'F5CE58DB-F0BC-4157-B006-47CE770F3480', '2025-10-31 22:53:28');


-- Table structure for `appointment_templates`
DROP TABLE IF EXISTS `appointment_templates`;
CREATE TABLE `appointment_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `template_type` varchar(50) NOT NULL DEFAULT 'tire_offer',
  `template_texts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`template_texts`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_template` (`appointment_id`,`template_type`),
  CONSTRAINT `appointment_templates_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `appointment_templates`

-- Table structure for `appointments`
DROP TABLE IF EXISTS `appointments`;
CREATE TABLE `appointments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `autohaus_id` int(11) DEFAULT NULL,
  `event_id` int(11) NOT NULL,
  `slot_time` time NOT NULL,
  `slot_date` date NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `license_plate` varchar(20) NOT NULL,
  `storage_number` varchar(50) DEFAULT NULL,
  `tire_status` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`tire_status`)),
  `tire_recommendation` varchar(255) DEFAULT NULL,
  `brings_wheels` tinyint(1) DEFAULT 1,
  `wheels_storage_action` enum('store','vehicle') DEFAULT 'store',
  `seasonal_check` enum('none','spring','winter') DEFAULT 'none',
  `phone` varchar(20) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `order_number` varchar(50) DEFAULT NULL,
  `tire_order_date` datetime DEFAULT NULL,
  `tire_order_notes` text DEFAULT NULL,
  `tire_order_priority` enum('normal','high','urgent') DEFAULT 'normal',
  `tire_order_user` varchar(100) DEFAULT NULL,
  `tire_order_status` enum('bestellt','geliefert','storniert') DEFAULT 'bestellt',
  `info_text` text DEFAULT NULL,
  `has_wheel_lock` tinyint(1) DEFAULT 0,
  `status` enum('pending','approved','rejected','rescheduled','booked','completed','cancelled') DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `wiper_blades` tinyint(1) DEFAULT 0 COMMENT 'Scheibenwischerblõtter 20% + 1L Scheibenklar',
  `admin_notes` text DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `rejection_reason` text DEFAULT NULL,
  `reschedule_reason` text DEFAULT NULL,
  `whatsapp_reminder_sent` tinyint(1) DEFAULT 0 COMMENT 'WhatsApp-Erinnerung für diesen Termin gesendet',
  `whatsapp_reminder_sent_at` timestamp NULL DEFAULT NULL COMMENT 'Zeitpunkt der gesendeten WhatsApp-Erinnerung',
  `source` enum('website','hellomateo','admin','admin_manual','admin_copy','ios_app','android_app','app','whatsapp') DEFAULT 'website',
  `notes` text DEFAULT NULL,
  `vehicle_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `reminder_sent` tinyint(1) DEFAULT 0,
  `reminder_sent_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_appointments_status` (`status`),
  KEY `idx_appointments_source` (`source`),
  KEY `idx_appointments_reminder` (`slot_date`),
  KEY `idx_appointments_email` (`email`),
  KEY `idx_appointments_approved_by` (`approved_by`),
  KEY `idx_appointments_created_at` (`created_at`),
  KEY `idx_appointments_autohaus` (`autohaus_id`),
  KEY `idx_appointments_whatsapp_reminder` (`whatsapp_reminder_sent`,`slot_date`),
  KEY `idx_appointments_autohaus_id` (`autohaus_id`),
  KEY `idx_appointments_slot_date` (`slot_date`),
  KEY `idx_appointments_autohaus_date` (`autohaus_id`,`slot_date`),
  KEY `idx_appointments_date_status` (`slot_date`,`status`),
  KEY `idx_appointments_event_id` (`event_id`),
  KEY `idx_appointments_complex` (`event_id`,`autohaus_id`,`slot_date`,`status`),
  KEY `idx_user_id_appointments` (`user_id`),
  KEY `idx_vehicle_id_appointments` (`vehicle_id`),
  CONSTRAINT `appointments_ibfk_1` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointments_ibfk_2` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_appointments_approved_by` FOREIGN KEY (`approved_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vehicle_id` FOREIGN KEY (`vehicle_id`) REFERENCES `user_vehicles` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `appointments`
INSERT INTO `appointments` (`id`, `user_id`, `autohaus_id`, `event_id`, `slot_time`, `slot_date`, `customer_name`, `license_plate`, `storage_number`, `tire_status`, `tire_recommendation`, `brings_wheels`, `wheels_storage_action`, `seasonal_check`, `phone`, `email`, `order_number`, `tire_order_date`, `tire_order_notes`, `tire_order_priority`, `tire_order_user`, `tire_order_status`, `info_text`, `has_wheel_lock`, `status`, `created_at`, `updated_at`, `wiper_blades`, `admin_notes`, `approved_by`, `approved_at`, `rejection_reason`, `reschedule_reason`, `whatsapp_reminder_sent`, `whatsapp_reminder_sent_at`, `source`, `notes`, `vehicle_id`, `is_active`, `reminder_sent`, `reminder_sent_at`) VALUES
('245', NULL, '1', '26', '08:30:00', '2026-11-07', 'Deniz Uludag', 'KI-B 1302', '9.718.476', NULL, NULL, '1', 'store', 'spring', '01782465658', 'duludag16@gmail.com', '6', NULL, NULL, 'normal', NULL, 'bestellt', 'asdasd', '1', 'booked', '2025-11-14 17:30:03', '2025-11-14 22:26:30', '1', 'asdasd', NULL, NULL, NULL, NULL, '0', NULL, '', NULL, NULL, '1', '0', NULL),
('247', NULL, '1', '26', '14:30:00', '2026-11-07', 'Torben Schöttle', 'KI-SD 244', '103391', NULL, NULL, '1', 'store', 'winter', '01782465658', 'duludag16@gmail.com', '46607', NULL, NULL, 'normal', NULL, 'bestellt', '', '1', 'booked', '2025-11-14 17:46:48', '2025-11-18 23:08:17', '1', '', '16', '2025-11-14 17:46:48', NULL, NULL, '0', NULL, 'admin_manual', NULL, NULL, '1', '0', NULL),
('249', '65', '1', '26', '09:00:00', '2026-11-07', 'Vorname Nachname', 'TES-T 10', '', NULL, NULL, '1', 'store', 'spring', '+491782465658', 'denizuludag439@gmail.com', NULL, NULL, NULL, 'normal', NULL, 'bestellt', '', '1', 'booked', '2025-11-15 12:52:49', '2025-11-23 07:37:16', '1', '', NULL, NULL, NULL, NULL, '0', NULL, 'website', NULL, '28', '1', '0', NULL);


-- Table structure for `autohaus`
DROP TABLE IF EXISTS `autohaus`;
CREATE TABLE `autohaus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `footer_image` varchar(255) DEFAULT NULL COMMENT 'Pfad zum Footer-Bild des Autohauses',
  `footer_image_alt` varchar(255) DEFAULT '' COMMENT 'Alt-Text für das Footer-Bild',
  `title_image` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `resy_username` varchar(100) NOT NULL,
  `resy_password` varchar(255) NOT NULL,
  `resy_dealer_id` varchar(100) NOT NULL,
  `resy_customer_no` varchar(50) DEFAULT NULL,
  `resy_base_url` varchar(255) DEFAULT 'https://resy.dtm-reifen.de',
  `timezone` varchar(50) DEFAULT 'Europe/Berlin',
  `working_days` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '["monday", "tuesday", "wednesday", "thursday", "friday"]' CHECK (json_valid(`working_days`)),
  `working_hours` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '{"start": "08:00", "end": "18:00"}' CHECK (json_valid(`working_hours`)),
  `profiltiefe_winter` decimal(3,1) DEFAULT 4.0,
  `profiltiefe_sommer` decimal(3,1) DEFAULT 2.0,
  `profiltiefe_ganzjahres` decimal(3,1) DEFAULT 4.0,
  `price_wheel_change` decimal(10,2) DEFAULT 0.00,
  `price_storage` decimal(10,2) DEFAULT 0.00,
  `price_spring_check` decimal(10,2) DEFAULT 0.00,
  `price_winter_check` decimal(10,2) DEFAULT 0.00,
  `last_wheelset_count` int(11) DEFAULT 0 COMMENT 'Anzahl der zuletzt geladenen Reifensätze',
  `last_load_time` datetime DEFAULT NULL COMMENT 'Zeitpunkt des letzten erfolgreichen Ladens',
  `performance_tier` enum('small','medium','large','chunked') DEFAULT 'small' COMMENT 'Performance-Tier basierend auf Autohaus-Größe',
  `avg_load_time` decimal(5,2) DEFAULT 0.00 COMMENT 'Durchschnittliche Ladezeit in Sekunden',
  `success_rate` decimal(5,2) DEFAULT 100.00 COMMENT 'Erfolgsrate der API-Aufrufe in Prozent',
  `last_error` text DEFAULT NULL COMMENT 'Letzte Fehlermeldung',
  `last_error_time` datetime DEFAULT NULL COMMENT 'Zeitpunkt des letzten Fehlers',
  `api_version` varchar(20) DEFAULT '1.0' COMMENT 'Verwendete API-Version',
  `cache_strategy` varchar(50) DEFAULT 'standard' COMMENT 'Verwendete Cache-Strategie',
  `load_strategy` varchar(50) DEFAULT 'balanced' COMMENT 'Verwendete Lade-Strategie',
  `is_optimized` tinyint(1) DEFAULT 0 COMMENT 'Ob das Autohaus optimiert wurde',
  `email_smtp_host` varchar(255) DEFAULT '',
  `email_smtp_port` int(11) DEFAULT 587,
  `email_smtp_username` varchar(255) DEFAULT '',
  `email_smtp_password` varchar(255) DEFAULT '',
  `email_smtp_encryption` varchar(10) DEFAULT 'tls',
  `email_from_name` varchar(255) DEFAULT '',
  `teams_webhook_url` varchar(500) DEFAULT '',
  `teams_channel_name` varchar(100) DEFAULT '',
  `teams_notifications_enabled` tinyint(1) DEFAULT 0,
  `teams_mention_users` text DEFAULT NULL,
  `whatsapp_notifications_enabled` tinyint(1) DEFAULT 0 COMMENT 'WhatsApp-Benachrichtigungen für dieses Autohaus aktiviert',
  `whatsapp_api_key` varchar(255) DEFAULT '' COMMENT 'HelloMateo API-Key für WhatsApp-Nachrichten',
  `whatsapp_phone_number` varchar(20) DEFAULT '' COMMENT 'WhatsApp-Geschäftsnummer für dieses Autohaus',
  `whatsapp_business_name` varchar(255) DEFAULT '' COMMENT 'Geschäftsname für WhatsApp-Nachrichten',
  `whatsapp_template_id` varchar(100) DEFAULT '' COMMENT 'HelloMateo Template-ID für strukturierte Nachrichten',
  `whatsapp_test_mode` tinyint(1) DEFAULT 1 COMMENT 'Test-Modus für WhatsApp-Nachrichten (keine echten Nachrichten)',
  `tire_offers_api_url` varchar(255) DEFAULT NULL COMMENT 'API-URL für Tire-Offers-System (z.B. http://100.82.207.72:5001/api)',
  `tire_offers_api_key` varchar(255) DEFAULT NULL COMMENT 'API-Key für Tire-Offers-System',
  `tire_offers_api_key_required` tinyint(1) DEFAULT 0 COMMENT 'API-Key erforderlich (Standard: false für Entwicklung)',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_short_name` (`short_name`),
  UNIQUE KEY `unique_resy_dealer_id` (`resy_dealer_id`),
  KEY `idx_autohaus_performance` (`performance_tier`,`last_load_time`),
  KEY `idx_autohaus_load_time` (`last_load_time`),
  KEY `idx_autohaus_whatsapp_enabled` (`whatsapp_notifications_enabled`),
  KEY `idx_autohaus_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Erweitert um Performance-Metriken für Smart API';

-- Dumping data for table `autohaus`
INSERT INTO `autohaus` (`id`, `name`, `short_name`, `address`, `phone`, `email`, `footer_image`, `footer_image_alt`, `title_image`, `is_active`, `created_at`, `updated_at`, `resy_username`, `resy_password`, `resy_dealer_id`, `resy_customer_no`, `resy_base_url`, `timezone`, `working_days`, `working_hours`, `profiltiefe_winter`, `profiltiefe_sommer`, `profiltiefe_ganzjahres`, `price_wheel_change`, `price_storage`, `price_spring_check`, `price_winter_check`, `last_wheelset_count`, `last_load_time`, `performance_tier`, `avg_load_time`, `success_rate`, `last_error`, `last_error_time`, `api_version`, `cache_strategy`, `load_strategy`, `is_optimized`, `email_smtp_host`, `email_smtp_port`, `email_smtp_username`, `email_smtp_password`, `email_smtp_encryption`, `email_from_name`, `teams_webhook_url`, `teams_channel_name`, `teams_notifications_enabled`, `teams_mention_users`, `whatsapp_notifications_enabled`, `whatsapp_api_key`, `whatsapp_phone_number`, `whatsapp_business_name`, `whatsapp_template_id`, `whatsapp_test_mode`, `tire_offers_api_url`, `tire_offers_api_key`, `tire_offers_api_key_required`) VALUES
('1', 'B & E Volvo Kiel', 'Kiel', 'Suchskrug 2, 24107 Kiel', '0431 546300', 'kiel@be-automobile.de', 'uploads/autohaus_footer/autohaus_1_1761622076.jpg', 'Footer Image Kiel', 'assets/images/autohaus/autohaus_1.svg', '1', '2025-09-10 11:22:22', '2025-11-05 10:26:08', 'BUE1', 'resytest', '201', '201', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\",\"tuesday\",\"wednesday\",\"thursday\",\"friday\"]', '{\"start\":\"08:00\",\"end\":\"18:00\"}', '4.0', '2.0', '4.0', '49.99', '89.00', '39.00', '39.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0', 'smtp-mail.outlook.com', '587', 'rentacar-kiel@be-automobile.de', 'W@050373011206af', 'tls', 'B&E Autocentrum', 'https://buekiel.webhook.office.com/webhookb2/40db877a-d64e-4e01-b622-c9cb38daa97c@5e0f5f5d-ab48-44f2-be89-3cfc8a039687/IncomingWebhook/40630e36023c405ca7e412940c3d9842/a6218f68-40f5-4976-bce2-c5841c286a8d/V2Bi16HyliqmPWISVt6_uXIPgOWnm281CVao-lxGhhRzU1', 'Reifenangebote', '1', '@David von Holten, @Olaf Jacholke', '0', '', '', 'B & E Volvo Kiel', '', '1', 'http://100.82.207.72:5001/api', 'bungert-p2-api-key-2024-default', '0'),
('2', 'B & E Volvo Norderstedt', 'Norderstedt', 'Niendorfer Str. 27, 22848 Norderstedt', '040 5236076', 'norderstedt@be-automobile.de', 'uploads/autohaus_footer/autohaus_2_1761761363.jpg', 'Norderstedt', 'assets/images/autohaus/autohaus_3.svg', '1', '2025-09-10 11:22:22', '2025-11-05 12:25:05', 'BUE1', 'resytest', '112 B & E / Norderstadt', '201', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\",\"tuesday\",\"wednesday\",\"thursday\",\"friday\"]', '{\"start\":\"07:30\",\"end\":\"18:00\"}', '4.0', '2.0', '4.0', '15.00', '25.00', '35.00', '35.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0', '', '587', '', '', 'tls', '', '', '', '0', '', '0', '', '', 'B & E Volvo Glinde', '', '1', 'http://100.82.207.72:5001/api', 'bungert-p2-api-key-2024-default', '0'),
('3', 'B & E Volvo Glinde', 'Glinde', 'Gewerbestra├ƒe 8, 21509 Glinde', '+49 40 555666', 'glinde@volvo-autohaus.de', 'uploads/autohaus_footer/autohaus_3_1761765093.jpeg', '', 'assets/images/autohaus/autohaus_3.svg', '1', '2025-09-10 11:22:22', '2025-11-05 10:39:54', 'BUE1', 'resytest', '114 B & E /Glinde', '201', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\",\"tuesday\",\"wednesday\",\"thursday\",\"friday\"]', '{\"start\":\"08:00\",\"end\":\"18:00\"}', '4.0', '2.0', '4.0', '15.00', '25.00', '35.00', '35.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0', '', '587', '', '', 'tls', '', '', '', '0', '', '0', '', '', 'B & E Volvo Glinde', '', '1', 'http://100.82.207.72:5001/boxenstop', 'bungert-p2-api-key-2024-default', '0');


-- Table structure for `autohaus_backup_before_smart_api`
DROP TABLE IF EXISTS `autohaus_backup_before_smart_api`;
CREATE TABLE `autohaus_backup_before_smart_api` (
  `id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `short_name` varchar(50) NOT NULL,
  `address` text NOT NULL,
  `phone` varchar(20) NOT NULL,
  `email` varchar(100) NOT NULL,
  `title_image` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `resy_username` varchar(100) NOT NULL,
  `resy_password` varchar(255) NOT NULL,
  `resy_dealer_id` varchar(100) NOT NULL,
  `resy_base_url` varchar(255) DEFAULT 'https://resy.dtm-reifen.de',
  `timezone` varchar(50) DEFAULT 'Europe/Berlin',
  `working_days` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '["monday", "tuesday", "wednesday", "thursday", "friday"]' CHECK (json_valid(`working_days`)),
  `working_hours` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT '{"start": "08:00", "end": "18:00"}' CHECK (json_valid(`working_hours`)),
  `price_wheel_change` decimal(10,2) DEFAULT 0.00,
  `price_storage` decimal(10,2) DEFAULT 0.00,
  `price_spring_check` decimal(10,2) DEFAULT 0.00,
  `price_winter_check` decimal(10,2) DEFAULT 0.00,
  `last_wheelset_count` int(11) DEFAULT 0 COMMENT 'Anzahl der zuletzt geladenen Reifensätze',
  `last_load_time` datetime DEFAULT NULL COMMENT 'Zeitpunkt des letzten erfolgreichen Ladens',
  `performance_tier` enum('small','medium','large','chunked') DEFAULT 'small' COMMENT 'Performance-Tier basierend auf Autohaus-Größe',
  `avg_load_time` decimal(5,2) DEFAULT 0.00 COMMENT 'Durchschnittliche Ladezeit in Sekunden',
  `success_rate` decimal(5,2) DEFAULT 100.00 COMMENT 'Erfolgsrate der API-Aufrufe in Prozent',
  `last_error` text DEFAULT NULL COMMENT 'Letzte Fehlermeldung',
  `last_error_time` datetime DEFAULT NULL COMMENT 'Zeitpunkt des letzten Fehlers',
  `api_version` varchar(20) DEFAULT '1.0' COMMENT 'Verwendete API-Version',
  `cache_strategy` varchar(50) DEFAULT 'standard' COMMENT 'Verwendete Cache-Strategie',
  `load_strategy` varchar(50) DEFAULT 'balanced' COMMENT 'Verwendete Lade-Strategie',
  `is_optimized` tinyint(1) DEFAULT 0 COMMENT 'Ob das Autohaus optimiert wurde'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `autohaus_backup_before_smart_api`
INSERT INTO `autohaus_backup_before_smart_api` (`id`, `name`, `short_name`, `address`, `phone`, `email`, `title_image`, `is_active`, `created_at`, `updated_at`, `resy_username`, `resy_password`, `resy_dealer_id`, `resy_base_url`, `timezone`, `working_days`, `working_hours`, `price_wheel_change`, `price_storage`, `price_spring_check`, `price_winter_check`, `last_wheelset_count`, `last_load_time`, `performance_tier`, `avg_load_time`, `success_rate`, `last_error`, `last_error_time`, `api_version`, `cache_strategy`, `load_strategy`, `is_optimized`) VALUES
('1', 'B & E Volvo Kiel', 'Kiel', 'Suchskrug 2, 24107 Kiel', '0431 546300', 'kiel@be-automobile.de', 'assets/images/autohaus/autohaus_1.svg', '1', '2025-09-10 11:22:22', '2025-09-10 15:01:27', 'D.ULUDAG', 'Ikizler123!', '113 B & E / Kiel', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\",\"tuesday\",\"wednesday\",\"thursday\",\"friday\"]', '{\"start\":\"08:00\",\"end\":\"18:00\"}', '49.99', '89.00', '39.00', '39.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0'),
('2', 'B & E Volvo Norderstedt', 'Norderstedt', 'Hauptstra├ƒe 15, 22846 Norderstedt', '+49 40 987654', 'norderstedt@volvo-autohaus.de', 'assets/images/autohaus/autohaus_2.svg', '1', '2025-09-10 11:22:22', '2025-09-10 15:31:46', 'D.ULUDAG', 'Ikizler123!', '112 B & E / Norderstedt', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\", \"tuesday\", \"wednesday\", \"thursday\", \"friday\"]', '{\"start\": \"08:00\", \"end\": \"18:00\"}', '15.00', '25.00', '35.00', '35.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0'),
('3', 'B & E Volvo Glinde', 'Glinde', 'Gewerbestra├ƒe 8, 21509 Glinde', '+49 40 555666', 'glinde@volvo-autohaus.de', 'assets/images/autohaus/autohaus_3.svg', '1', '2025-09-10 11:22:22', '2025-09-10 21:15:12', 'D.ULUDAG', 'Ikizler123!', '114 B & E / Glinde', 'https://resy.dtm-reifen.de', 'Europe/Berlin', '[\"monday\",\"tuesday\",\"wednesday\",\"thursday\",\"friday\"]', '{\"start\":\"08:00\",\"end\":\"18:00\"}', '15.00', '25.00', '35.00', '35.00', '0', NULL, 'small', '0.00', '100.00', NULL, NULL, '1.0', 'standard', 'balanced', '0');


-- Table structure for `autohaus_services`
DROP TABLE IF EXISTS `autohaus_services`;
CREATE TABLE `autohaus_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `service_name` varchar(255) NOT NULL,
  `service_description` text DEFAULT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `show_price` tinyint(1) DEFAULT 1,
  `is_active` tinyint(1) DEFAULT 1,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_sort_order` (`sort_order`),
  CONSTRAINT `autohaus_services_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `autohaus_services`
INSERT INTO `autohaus_services` (`id`, `autohaus_id`, `service_name`, `service_description`, `price`, `show_price`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
('44', '1', 'Achsvermessung', 'Spureinstellungen können nicht während der Event-Tage durchgeführt werden', '120.00', '1', '1', '0', '2025-11-03 13:59:57', '2025-11-03 14:19:37');


-- Table structure for `cache_statistics`
DROP TABLE IF EXISTS `cache_statistics`;
CREATE TABLE `cache_statistics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `cache_type` enum('processed','raw_html','partial') NOT NULL,
  `hit_count` int(11) DEFAULT 0 COMMENT 'Anzahl Cache-Hits',
  `miss_count` int(11) DEFAULT 0 COMMENT 'Anzahl Cache-Misses',
  `last_hit` datetime DEFAULT NULL COMMENT 'Letzter Cache-Hit',
  `last_miss` datetime DEFAULT NULL COMMENT 'Letzter Cache-Miss',
  `cache_size` int(11) DEFAULT 0 COMMENT 'Cache-Größe in Bytes',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_autohaus_cache` (`autohaus_id`,`cache_type`),
  KEY `idx_cache_autohaus` (`autohaus_id`,`cache_type`),
  KEY `idx_cache_stats_autohaus_type` (`autohaus_id`,`cache_type`),
  CONSTRAINT `cache_statistics_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Cache-Statistiken für verschiedene Cache-Typen';

-- Dumping data for table `cache_statistics`

-- Table structure for `cached_images`
DROP TABLE IF EXISTS `cached_images`;
CREATE TABLE `cached_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lgfoto_id` varchar(50) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `content_type` varchar(100) NOT NULL,
  `appointment_id` int(11) DEFAULT NULL,
  `file_size` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_lgfoto_id` (`lgfoto_id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci COMMENT='Cache für Reifenbilder aus RESY-System';

-- Dumping data for table `cached_images`
INSERT INTO `cached_images` (`id`, `lgfoto_id`, `filename`, `content_type`, `appointment_id`, `file_size`, `created_at`) VALUES
('1', '48253', 'lgfoto_48253_1758543178.png', 'image/png', '100', '348425', '2025-09-22 14:12:58'),
('2', '48255', 'lgfoto_48255_1758543178.png', 'image/png', '100', '347417', '2025-09-22 14:12:58'),
('3', '48256', 'lgfoto_48256_1758543178.png', 'image/png', '100', '104835', '2025-09-22 14:12:58'),
('4', '48258', 'lgfoto_48258_1758543178.png', 'image/png', '100', '343851', '2025-09-22 14:12:58'),
('5', '48254', 'lgfoto_48254_1758543178.png', 'image/png', '100', '106061', '2025-09-22 14:12:58'),
('6', '48259', 'lgfoto_48259_1758543179.png', 'image/png', '100', '104582', '2025-09-22 14:12:59'),
('7', '48257', 'lgfoto_48257_1758543179.png', 'image/png', '100', '369819', '2025-09-22 14:12:59'),
('8', '48261', 'lgfoto_48261_1758543179.png', 'image/png', '100', '106829', '2025-09-22 14:12:59'),
('9', '48260', 'lgfoto_48260_1758543179.png', 'image/png', '100', '368706', '2025-09-22 14:12:59'),
('10', '54500', 'lgfoto_54500_1758728334.png', 'image/png', '101', '144398', '2025-09-24 17:38:54'),
('11', '54499', 'lgfoto_54499_1758728335.png', 'image/png', '101', '394222', '2025-09-24 17:38:55'),
('12', '54502', 'lgfoto_54502_1758728335.png', 'image/png', '101', '147730', '2025-09-24 17:38:55'),
('13', '54501', 'lgfoto_54501_1758728335.png', 'image/png', '101', '391731', '2025-09-24 17:38:55'),
('14', '54504', 'lgfoto_54504_1758728335.png', 'image/png', '101', '149161', '2025-09-24 17:38:55'),
('15', '54503', 'lgfoto_54503_1758728335.png', 'image/png', '101', '397444', '2025-09-24 17:38:55'),
('16', '54506', 'lgfoto_54506_1758728335.png', 'image/png', '101', '154053', '2025-09-24 17:38:55'),
('17', '54505', 'lgfoto_54505_1758728335.png', 'image/png', '101', '392469', '2025-09-24 17:38:55'),
('18', '76924', 'lgfoto_76924_1758728405.png', 'image/png', '102', '373798', '2025-09-24 17:40:05'),
('19', '76925', 'lgfoto_76925_1758728405.png', 'image/png', '102', '140828', '2025-09-24 17:40:05'),
('20', '76923', 'lgfoto_76923_1758728405.png', 'image/png', '102', '396667', '2025-09-24 17:40:05'),
('21', '76927', 'lgfoto_76927_1758728405.png', 'image/png', '102', '134603', '2025-09-24 17:40:05'),
('22', '76926', 'lgfoto_76926_1758728405.png', 'image/png', '102', '384354', '2025-09-24 17:40:05'),
('23', '76929', 'lgfoto_76929_1758728406.png', 'image/png', '102', '153529', '2025-09-24 17:40:06'),
('24', '76928', 'lgfoto_76928_1758728406.png', 'image/png', '102', '396072', '2025-09-24 17:40:06'),
('25', '76931', 'lgfoto_76931_1758728406.png', 'image/png', '102', '151382', '2025-09-24 17:40:06'),
('26', '76930', 'lgfoto_76930_1758728406.png', 'image/png', '102', '403382', '2025-09-24 17:40:06'),
('27', '73044', 'lgfoto_73044_1758809355.png', 'image/png', '100', '166460', '2025-09-25 16:09:15'),
('28', '73043', 'lgfoto_73043_1758809356.png', 'image/png', '100', '344399', '2025-09-25 16:09:16'),
('29', '73041', 'lgfoto_73041_1758809356.png', 'image/png', '100', '351399', '2025-09-25 16:09:16'),
('30', '73042', 'lgfoto_73042_1758809356.png', 'image/png', '100', '168943', '2025-09-25 16:09:16'),
('31', '73046', 'lgfoto_73046_1758809356.png', 'image/png', '100', '166173', '2025-09-25 16:09:16'),
('32', '73045', 'lgfoto_73045_1758809357.png', 'image/png', '100', '349956', '2025-09-25 16:09:17'),
('33', '73048', 'lgfoto_73048_1758809357.png', 'image/png', '100', '163983', '2025-09-25 16:09:17'),
('34', '73047', 'lgfoto_73047_1758809357.png', 'image/png', '100', '340456', '2025-09-25 16:09:17'),
('35', '73929', 'lgfoto_73929_1758879272.png', 'image/png', '100', '133186', '2025-09-26 11:34:32'),
('36', '73930', 'lgfoto_73930_1758879272.png', 'image/png', '100', '331034', '2025-09-26 11:34:32'),
('37', '73928', 'lgfoto_73928_1758879273.png', 'image/png', '100', '349117', '2025-09-26 11:34:33'),
('38', '73932', 'lgfoto_73932_1758879273.png', 'image/png', '100', '129783', '2025-09-26 11:34:33'),
('39', '73931', 'lgfoto_73931_1758879273.png', 'image/png', '100', '414277', '2025-09-26 11:34:33'),
('40', '73936', 'lgfoto_73936_1758879274.png', 'image/png', '100', '338372', '2025-09-26 11:34:34'),
('41', '73934', 'lgfoto_73934_1758879274.png', 'image/png', '100', '411983', '2025-09-26 11:34:34'),
('42', '73937', 'lgfoto_73937_1758879274.png', 'image/png', '100', '130407', '2025-09-26 11:34:34'),
('43', '73933', 'lgfoto_73933_1758879275.png', 'image/png', '100', '336647', '2025-09-26 11:34:35'),
('44', '73935', 'lgfoto_73935_1758879276.png', 'image/png', '100', '137593', '2025-09-26 11:34:36');


-- Table structure for `customer_selections`
DROP TABLE IF EXISTS `customer_selections`;
CREATE TABLE `customer_selections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `tire_selection` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`tire_selection`)),
  `service_selection` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`service_selection`)),
  `customer_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `customer_selections`
INSERT INTO `customer_selections` (`id`, `appointment_id`, `tire_selection`, `service_selection`, `customer_notes`, `created_at`) VALUES
('1', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 22:47:04'),
('2', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 22:47:17'),
('3', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 22:56:05'),
('4', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 22:58:48'),
('5', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 23:01:32'),
('6', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 23:04:46'),
('7', '89', '[\"0\",\"new_0\"]', '[\"1\",\"2\"]', 'Test-Kundenauswahl: Ich möchte die Continental Reifen und die Achsvermessung.', '2025-09-20 23:05:42'),
('8', '92', '[\"0\",\"new_0\"]', '[\"38\"]', 'sadasd', '2025-09-20 23:05:48'),
('9', '89', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', 'test 5', '2025-09-20 23:11:30'),
('10', '89', '[\"0\",\"1\",\"2\",\"new_0\"]', '[]', 'tsad', '2025-09-20 23:31:50'),
('11', '89', '[\"0\",\"1\",\"2\",\"new_0\"]', '[]', 'tsad', '2025-09-20 23:40:39'),
('12', '89', '[\"0\",\"1\",\"2\",\"new_0\"]', '[]', 'tsad', '2025-09-20 23:41:15'),
('13', '93', '[\"0\",\"new_0\"]', '[]', 'sdfsdf ', '2025-09-20 23:43:49'),
('14', '93', '[\"0\",\"new_0\"]', '[]', 'sdfsdf ', '2025-09-20 23:49:49'),
('15', '93', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', 'sadasd', '2025-09-20 23:56:01'),
('16', '94', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', '', '2025-09-21 08:52:24'),
('17', '93', '[\"0\",\"new_0\"]', '[]', '', '2025-09-21 18:48:28'),
('18', '95', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', 'test', '2025-09-21 19:00:13'),
('19', '95', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', '', '2025-09-21 19:04:34'),
('20', '95', '[\"0\",\"new_0\"]', '[\"31\",\"38\"]', '', '2025-09-21 19:10:33'),
('21', '96', '[\"0\",\"new_0\"]', '[\"38\"]', '', '2025-09-21 19:16:25'),
('22', '96', '[\"0\",\"new_0\"]', '[\"31\"]', '', '2025-09-21 19:30:44'),
('23', '96', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', '', '2025-09-21 21:18:44'),
('24', '96', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', '', '2025-09-21 21:25:52'),
('25', '97', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', '', '2025-09-21 21:28:25'),
('26', '99', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', 'sdfsdfsdf', '2025-09-22 08:34:23'),
('27', '98', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', 'yxcyxcyxc', '2025-09-22 08:42:23'),
('28', '100', '[\"1\",\"2\",\"new_0\"]', '[\"31\"]', 'sdfsdfsdf', '2025-09-22 11:49:27'),
('29', '100', '[\"0\",\"new_0\"]', '[\"31\"]', 'sdfsdfdsf', '2025-09-25 16:03:09'),
('30', '100', '[\"0\",\"1\",\"new_0\"]', '[\"31\"]', '4444', '2025-10-14 10:32:17');


-- Table structure for `dashboard_tasks`
DROP TABLE IF EXISTS `dashboard_tasks`;
CREATE TABLE `dashboard_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') DEFAULT 'medium',
  `status` enum('pending','in_progress','completed','cancelled') DEFAULT 'pending',
  `due_date` date DEFAULT NULL,
  `due_time` time DEFAULT NULL,
  `reminder_date` date DEFAULT NULL,
  `reminder_time` time DEFAULT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `category` varchar(100) DEFAULT NULL,
  `related_id` int(11) DEFAULT NULL,
  `related_type` varchar(50) DEFAULT NULL,
  `is_reminder` tinyint(1) DEFAULT 0,
  `reminder_sent` tinyint(1) DEFAULT 0,
  `reminder_sent_at` timestamp NULL DEFAULT NULL,
  `completed_at` timestamp NULL DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `created_by` (`created_by`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_assigned_to` (`assigned_to`),
  KEY `idx_status` (`status`),
  KEY `idx_due_date` (`due_date`),
  KEY `idx_reminder_date` (`reminder_date`),
  KEY `idx_category` (`category`),
  KEY `idx_related` (`related_type`,`related_id`),
  CONSTRAINT `dashboard_tasks_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `dashboard_tasks_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `dashboard_tasks_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `dashboard_tasks`
INSERT INTO `dashboard_tasks` (`id`, `user_id`, `title`, `description`, `priority`, `status`, `due_date`, `due_time`, `reminder_date`, `reminder_time`, `assigned_to`, `created_by`, `category`, `related_id`, `related_type`, `is_reminder`, `reminder_sent`, `reminder_sent_at`, `completed_at`, `notes`, `is_active`, `created_at`, `updated_at`) VALUES
('1', NULL, 'asöldölasd', 'sadasd', 'high', 'completed', NULL, NULL, NULL, NULL, '1', '1', 'admin', NULL, NULL, '0', '0', NULL, '2025-11-16 12:19:34', NULL, '1', '2025-11-16 12:13:23', '2025-11-16 12:19:34'),
('2', NULL, 'erwerwer', '', 'medium', 'completed', NULL, NULL, NULL, NULL, '1', '1', 'general', NULL, NULL, '1', '0', NULL, '2025-11-16 12:31:22', NULL, '1', '2025-11-16 12:31:16', '2025-11-16 12:31:22'),
('3', NULL, 'erwerwer', '', 'medium', 'completed', NULL, NULL, NULL, NULL, '1', '1', 'general', NULL, NULL, '1', '0', NULL, NULL, NULL, '1', '2025-11-16 12:31:27', '2025-11-16 20:18:22');


-- Table structure for `dashboard_widgets`
DROP TABLE IF EXISTS `dashboard_widgets`;
CREATE TABLE `dashboard_widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_key` varchar(100) NOT NULL,
  `widget_name` varchar(255) NOT NULL,
  `widget_description` text DEFAULT NULL,
  `widget_icon` varchar(100) NOT NULL,
  `widget_color` varchar(7) NOT NULL DEFAULT '#007AFF',
  `widget_category` varchar(50) DEFAULT 'general',
  `is_default` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `widget_key` (`widget_key`),
  KEY `idx_widget_key` (`widget_key`),
  KEY `idx_category` (`widget_category`),
  KEY `idx_is_default` (`is_default`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_sort_order` (`sort_order`),
  KEY `idx_dashboard_widgets_category` (`widget_category`),
  KEY `idx_dashboard_widgets_is_default` (`is_default`),
  KEY `idx_dashboard_widgets_sort_order` (`sort_order`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `dashboard_widgets`
INSERT INTO `dashboard_widgets` (`id`, `widget_key`, `widget_name`, `widget_description`, `widget_icon`, `widget_color`, `widget_category`, `is_default`, `is_active`, `sort_order`, `created_at`, `updated_at`) VALUES
('1', 'today_appointments', 'Heutige Termine', 'Zeigt alle Termine für heute an', 'fas fa-calendar-day', '#007AFF', 'appointments', '1', '1', '1', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('2', 'upcoming_events', 'Kommende Events', 'Zeigt die nächsten Events an', 'fas fa-calendar-alt', '#34C759', 'events', '1', '1', '2', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('3', 'quick_actions', 'Schnellaktionen', 'Ihre personalisierten Schnellzugriffe', 'fas fa-rocket', '#AF52DE', 'navigation', '1', '1', '3', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('4', 'recent_storage', 'Letzte Lageraktivitäten', 'Zeigt die neuesten Einlagerungen an', 'fas fa-warehouse', '#FF9500', 'storage', '0', '1', '4', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('6', 'system_status', 'System Status', 'Zeigt System-Informationen an', 'fas fa-server', '#FF3B30', 'system', '0', '1', '6', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('7', 'weather_widget', 'Wetter', 'Aktuelle Wetterinformationen', 'fas fa-cloud-sun', '#30B0C7', 'general', '0', '1', '7', '2025-09-25 10:57:41', '2025-09-25 10:57:41'),
('8', 'news_feed', 'News Feed', 'Aktuelle Nachrichten und Updates', 'fas fa-newspaper', '#FF2D92', 'general', '0', '1', '8', '2025-09-25 10:57:41', '2025-09-25 10:57:41');


-- Table structure for `dealerships`
DROP TABLE IF EXISTS `dealerships`;
CREATE TABLE `dealerships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `city` varchar(100) NOT NULL,
  `postal_code` varchar(10) NOT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_city` (`city`),
  KEY `idx_is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `dealerships`

-- Table structure for `deleted_appointments_audit`
DROP TABLE IF EXISTS `deleted_appointments_audit`;
CREATE TABLE `deleted_appointments_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `original_appointment_id` int(11) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `license_plate` varchar(20) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `event_name` varchar(255) DEFAULT NULL,
  `slot_date` date DEFAULT NULL,
  `slot_time` time DEFAULT NULL,
  `storage_number` varchar(50) DEFAULT NULL,
  `tire_order_date` datetime DEFAULT NULL,
  `tire_cancelled` tinyint(1) DEFAULT 0,
  `tire_cancellation_date` datetime DEFAULT NULL,
  `deleted_by_user_id` int(11) DEFAULT NULL,
  `deleted_by_username` varchar(100) DEFAULT NULL,
  `deleted_at` datetime DEFAULT current_timestamp(),
  `deletion_reason` text DEFAULT NULL,
  `admin_notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_deleted_at` (`deleted_at`),
  KEY `idx_deleted_by` (`deleted_by_user_id`),
  KEY `idx_original_id` (`original_appointment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `deleted_appointments_audit`
INSERT INTO `deleted_appointments_audit` (`id`, `original_appointment_id`, `customer_name`, `license_plate`, `phone`, `event_name`, `slot_date`, `slot_time`, `storage_number`, `tire_order_date`, `tire_cancelled`, `tire_cancellation_date`, `deleted_by_user_id`, `deleted_by_username`, `deleted_at`, `deletion_reason`, `admin_notes`, `created_at`, `updated_at`) VALUES
('1', '56', 'Deniz Uludag', 'KI-BE 123', '01782465658', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', NULL, '0', NULL, '1', 'admin', '2025-09-10 10:24:01', '', NULL, '2025-09-10 10:23:55', '2025-09-10 10:24:01'),
('2', '57', 'Deniz Uludag', 'KI-BE 123', '01782465658', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', '2025-09-10 10:24:45', '0', NULL, '1', 'admin', '2025-09-10 10:27:16', 'doppel', NULL, '2025-09-10 10:24:38', '2025-09-10 10:27:16'),
('3', '58', 'Deniz Uludag', 'KI-BE 123', '111', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', '2025-09-10 10:44:42', '0', NULL, '1', 'admin', '2025-09-10 10:44:52', '', NULL, '2025-09-10 10:44:30', '2025-09-10 10:44:52'),
('4', '59', 'Deniz Uludag', 'KI-BE 123', '01782465658', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', '2025-09-10 10:56:05', '0', NULL, '1', 'admin', '2025-09-10 10:56:44', 'test denizuludag', NULL, '2025-09-10 10:47:09', '2025-09-10 10:56:44'),
('5', '60', 'Deniz Uludag', 'KI-BE 123', '01782465658', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', NULL, '0', NULL, '1', 'admin', '2025-09-10 11:01:44', '', NULL, '2025-09-10 11:01:01', '2025-09-10 11:01:44'),
('6', '62', 'Deniz Uludag (Kopie) (Kopie)', 'KI-BE 123', '01782465658', 'Boxxenstop 21.11.225', '2025-11-21', '07:30:00', '9.717.936', NULL, '0', NULL, '1', 'admin', '2025-09-10 11:04:08', '', NULL, '2025-09-10 11:01:17', '2025-09-10 11:04:08'),
('7', '83', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Boxenstop 22.10.2025', '2025-10-22', '08:00:00', '8.491.116', NULL, '0', NULL, '1', 'admin', '2025-09-16 15:26:31', '', NULL, '2025-09-16 15:08:04', '2025-09-16 15:26:31'),
('8', '84', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Boxenstop 22.10.2025', '2025-10-22', '08:00:00', '8.491.116', NULL, '0', NULL, '1', 'admin', '2025-09-16 15:26:31', '', NULL, '2025-09-16 15:08:20', '2025-09-16 15:26:31'),
('9', '85', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Boxenstop 22.10.2025', '2025-10-22', '08:00:00', '8.491.116', NULL, '0', NULL, '1', 'admin', '2025-09-16 15:26:32', '', NULL, '2025-09-16 15:08:36', '2025-09-16 15:26:32'),
('10', '86', 'Deniz Uludag 1', 'Ki-SD 221', '017824658', 'Boxenstop 22.10.2025', '2025-10-22', '07:30:00', '9.718.476', NULL, '0', NULL, '1', 'admin', '2025-09-16 15:26:32', '', NULL, '2025-09-16 15:10:32', '2025-09-16 15:26:32'),
('11', '87', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Boxenstop 22.10.2025', '2025-10-22', '07:30:00', '9.718.476', NULL, '0', NULL, '1', 'admin', '2025-09-16 16:00:58', '', NULL, '2025-09-16 15:52:58', '2025-09-16 16:00:58'),
('12', '88', 'Max Mustermann', 'M-AB 123', '+49 123 456 789', 'Boxenstop 22.10.2025', '2025-01-15', '10:00:00', '9.123.456.789', NULL, '0', NULL, '1', 'admin', '2025-09-16 16:00:58', '', NULL, '2025-09-16 15:57:34', '2025-09-16 16:00:58'),
('13', '91', 'Tatjana Möller', 'KI-SD 221', '01782465658', 'Boxenstop 22.10.2025', '2025-10-22', '10:00:00', '9.329.579', NULL, '0', NULL, '1', 'admin', '2025-09-20 12:09:29', '', '', '2025-09-19 17:25:27', '2025-09-20 12:09:29'),
('14', '96', 'Deniz', 'KI-BE 123', '1782465658', 'Boxenstop 12.11.2025', '2025-11-12', '08:30:00', '9.717.187', '2025-09-21 20:58:37', '0', NULL, '1', 'admin', '2025-09-22 11:23:46', '', '', '2025-09-21 19:15:09', '2025-09-22 11:23:46'),
('15', '97', 'Deniz', '23', '1782465658', 'Boxenstop 12.11.2025', '2025-11-12', '08:00:00', '9.717.187', NULL, '0', NULL, '1', 'admin', '2025-09-22 11:23:46', '', NULL, '2025-09-21 21:26:45', '2025-09-22 11:23:46'),
('16', '98', 'Deniz Uludag', 'KI-BE 123', '0178246568', 'Boxenstop 22.10.2025', '2025-10-22', '07:30:00', '9.717.187', NULL, '0', NULL, '1', 'admin', '2025-09-22 11:23:46', '', NULL, '2025-09-21 21:43:55', '2025-09-22 11:23:46'),
('17', '99', 'Deniz Uludag', 'Ki-be 125', '+491782465658', 'Boxenstop 22.10.2025', '2025-10-22', '07:30:00', '9.437.588', NULL, '0', NULL, '1', 'admin', '2025-09-22 11:23:46', '', NULL, '2025-09-21 21:57:04', '2025-09-22 11:23:46'),
('18', '117', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '17:00:00', '9.365.323.317', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:47:25', '2025-10-27 10:56:43'),
('19', '116', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '14:00:00', '9.535.909.163', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:45:04', '2025-10-27 10:56:43'),
('20', '118', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Testevent ', '2025-10-31', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:54:58', '2025-10-27 10:56:43'),
('21', '111', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:18:44', '2025-10-27 10:56:43'),
('22', '112', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '10:00:00', '9.431.519.834', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:26:08', '2025-10-27 10:56:43'),
('23', '113', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '10:00:00', '9.480.386.060', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:34:10', '2025-10-27 10:56:43'),
('24', '114', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:36:57', '2025-10-27 10:56:43'),
('25', '115', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'Testevent ', '2025-10-31', '10:00:00', '9.553.879.723', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 10:41:52', '2025-10-27 10:56:43'),
('26', '106', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '2.222.22', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 09:16:05', '2025-10-27 10:56:43'),
('27', '107', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '2.222.22', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 09:16:50', '2025-10-27 10:56:43'),
('28', '108', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 09:19:34', '2025-10-27 10:56:43'),
('29', '109', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '2.222.22', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 09:24:13', '2025-10-27 10:56:43'),
('30', '110', 'Deniz Uludag', 'KI-SD 2212', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '2.222.222', NULL, '0', NULL, '1', 'admin', '2025-10-27 10:56:43', 'sad', NULL, '2025-10-27 09:30:10', '2025-10-27 10:56:43'),
('31', '144', 'Deniz Uludag', 'KI-SD 999', '01782465658', 'Deniz Uludag', '2025-11-07', '12:30:00', NULL, NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-31 22:31:07', '2025-11-02 12:52:23'),
('32', '145', 'Deniz Uludag', 'KI-SD 999', '01782465658', 'Deniz Uludag', '2025-11-07', '12:30:00', NULL, NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-31 22:53:28', '2025-11-02 12:52:23'),
('33', '141', 'Deniz Uludag', 'KI-SD 999', '01782465658', 'Deniz Uludag', '2025-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-31 19:09:43', '2025-11-02 12:52:23'),
('34', '142', 'Deniz Uludag', 'KI-SD 999', '01782465658', 'Deniz Uludag', '2025-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-31 20:42:07', '2025-11-02 12:52:23'),
('35', '143', 'Deniz Uludag', 'KI-SD 999', '01782465658', 'Deniz Uludag', '2025-11-07', '10:30:00', NULL, NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-31 22:06:16', '2025-11-02 12:52:23'),
('36', '138', 'Test3 Test4', 'PLÖ-SU100', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '9.163.241', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', '', '2025-10-29 20:09:18', '2025-11-02 12:52:23'),
('37', '139', 'Test3 Test4', 'KI-EL413', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-29 20:15:44', '2025-11-02 12:52:23'),
('38', '140', 'Deniz Uludag', 'KI-SD 221', '01782465658', 'Testevent ', '2025-10-31', '09:30:00', '123123', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-30 08:26:05', '2025-11-02 12:52:23'),
('39', '137', 'Deniz Uludag', 'KI-BE 23', '01782465658', 'weq', '2025-10-29', '11:25:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-02 12:52:23', '', NULL, '2025-10-29 11:26:02', '2025-11-02 12:52:23'),
('40', '149', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2025-11-05', '12:30:00', '1.033.91', NULL, '0', NULL, '1', 'admin', '2025-11-05 10:58:40', '', NULL, '2025-11-04 12:26:05', '2025-11-05 10:58:40'),
('41', '150', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2025-11-05', '08:30:00', '3.333.33', NULL, '0', NULL, '1', 'admin', '2025-11-05 10:58:40', '', NULL, '2025-11-05 10:57:28', '2025-11-05 10:58:40'),
('42', '152', 'Vorname Nachname', 'KI-BE 123', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '9.776.540.211', NULL, '0', NULL, '1', 'admin', '2025-11-11 21:48:05', '', NULL, '2025-11-11 08:46:19', '2025-11-11 21:48:05'),
('43', '151', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2025-11-07', '09:00:00', '1.033.91', NULL, '0', NULL, '1', 'admin', '2025-11-11 21:48:05', '', '', '2025-11-06 21:02:22', '2025-11-11 21:48:05'),
('44', '171', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '16:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:00:36', '2025-11-14 09:09:40'),
('45', '172', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '16:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:00:45', '2025-11-14 09:09:40'),
('46', '173', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '16:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:00:53', '2025-11-14 09:09:40'),
('47', '174', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '16:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:01:22', '2025-11-14 09:09:40'),
('48', '238', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:30:00', '1.033.91', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-14 00:14:19', '2025-11-14 09:09:40'),
('49', '233', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:23', '2025-11-14 09:09:40'),
('50', '234', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:29', '2025-11-14 09:09:40'),
('51', '235', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:34', '2025-11-14 09:09:40'),
('52', '236', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:40', '2025-11-14 09:09:40'),
('53', '237', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '16:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:46', '2025-11-14 09:09:40'),
('54', '228', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:53', '2025-11-14 09:09:40'),
('55', '229', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:59', '2025-11-14 09:09:40'),
('56', '230', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:06', '2025-11-14 09:09:40'),
('57', '231', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:11', '2025-11-14 09:09:40'),
('58', '232', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:26:18', '2025-11-14 09:09:40'),
('59', '155', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '15:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:57:47', '2025-11-14 09:09:40'),
('60', '224', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:30', '2025-11-14 09:09:40'),
('61', '225', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:36', '2025-11-14 09:09:40'),
('62', '226', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:41', '2025-11-14 09:09:40'),
('63', '227', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '15:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:47', '2025-11-14 09:09:40'),
('64', '219', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:26', '2025-11-14 09:09:40'),
('65', '220', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:31', '2025-11-14 09:09:40'),
('66', '221', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:37', '2025-11-14 09:09:40'),
('67', '222', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:51', '2025-11-14 09:09:40'),
('68', '223', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:25:24', '2025-11-14 09:09:40'),
('69', '214', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:53', '2025-11-14 09:09:40'),
('70', '215', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:03', '2025-11-14 09:09:40'),
('71', '216', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:09', '2025-11-14 09:09:40'),
('72', '217', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:15', '2025-11-14 09:09:40'),
('73', '218', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '14:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:24:21', '2025-11-14 09:09:40'),
('74', '209', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:11', '2025-11-14 09:09:40'),
('75', '210', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:17', '2025-11-14 09:09:40'),
('76', '211', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:25', '2025-11-14 09:09:40'),
('77', '212', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:31', '2025-11-14 09:09:40'),
('78', '213', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:47', '2025-11-14 09:09:40'),
('79', '204', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:39', '2025-11-14 09:09:40'),
('80', '205', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:45', '2025-11-14 09:09:40'),
('81', '206', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:51', '2025-11-14 09:09:40'),
('82', '207', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:56', '2025-11-14 09:09:40'),
('83', '208', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '13:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:23:03', '2025-11-14 09:09:40'),
('84', '199', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:02', '2025-11-14 09:09:40'),
('85', '200', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:13', '2025-11-14 09:09:40'),
('86', '201', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:19', '2025-11-14 09:09:40'),
('87', '202', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:25', '2025-11-14 09:09:40'),
('88', '203', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:22:31', '2025-11-14 09:09:40'),
('89', '194', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:31', '2025-11-14 09:09:40'),
('90', '195', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:38', '2025-11-14 09:09:40'),
('91', '196', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:44', '2025-11-14 09:09:40'),
('92', '197', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:50', '2025-11-14 09:09:40'),
('93', '198', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '12:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:56', '2025-11-14 09:09:40'),
('94', '189', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:01', '2025-11-14 09:09:40'),
('95', '190', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:07', '2025-11-14 09:09:40'),
('96', '191', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:13', '2025-11-14 09:09:40'),
('97', '192', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:18', '2025-11-14 09:09:40'),
('98', '193', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:21:24', '2025-11-14 09:09:40'),
('99', '184', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:30', '2025-11-14 09:09:40'),
('100', '185', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:35', '2025-11-14 09:09:40'),
('101', '186', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:41', '2025-11-14 09:09:40'),
('102', '187', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:48', '2025-11-14 09:09:40'),
('103', '188', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '11:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:55', '2025-11-14 09:09:40'),
('104', '156', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:57:56', '2025-11-14 09:09:40'),
('105', '180', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:08', '2025-11-14 09:09:40'),
('106', '181', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:13', '2025-11-14 09:09:40'),
('107', '182', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:19', '2025-11-14 09:09:40'),
('108', '183', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 12:20:24', '2025-11-14 09:09:40'),
('109', '175', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 11:25:01', '2025-11-14 09:09:40'),
('110', '176', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 11:25:39', '2025-11-14 09:09:40'),
('111', '177', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 11:25:45', '2025-11-14 09:09:40'),
('112', '178', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 11:25:50', '2025-11-14 09:09:40'),
('113', '179', 'Vorname Nachname', 'KI-BE 123', '+491782465658', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-13 11:25:57', '2025-11-14 09:09:40'),
('114', '165', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:38', '2025-11-14 09:09:40'),
('115', '166', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:48', '2025-11-14 09:09:40'),
('116', '167', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:55', '2025-11-14 09:09:40'),
('117', '168', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:00:07', '2025-11-14 09:09:40'),
('118', '169', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 07:00:13', '2025-11-14 09:09:40'),
('119', '154', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:57:39', '2025-11-14 09:09:40'),
('120', '161', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:09', '2025-11-14 09:09:40'),
('121', '162', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:16', '2025-11-14 09:09:40'),
('122', '163', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:22', '2025-11-14 09:09:40'),
('123', '164', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '09:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:59:31', '2025-11-14 09:09:40'),
('124', '153', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:57:32', '2025-11-14 09:09:40'),
('125', '157', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:58:05', '2025-11-14 09:09:40'),
('126', '158', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:58:12', '2025-11-14 09:09:40'),
('127', '159', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:58:20', '2025-11-14 09:09:40'),
('128', '160', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', NULL, '2025-11-12 06:58:27', '2025-11-14 09:09:40'),
('129', '170', 'Deniz Uludag', 'M-UH 999', '01782465658', 'Test Event', '2026-11-07', '00:00:00', '103391', NULL, '0', NULL, '1', 'admin', '2025-11-14 09:09:40', '', '', '2025-11-12 07:00:24', '2025-11-14 09:09:40'),
('130', '239', 'Berg Pekgür', 'Ki-BE 74', '015229847486', 'Test Event', '2026-11-07', '10:00:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 15:29:47', '', NULL, '2025-11-14 09:13:28', '2025-11-14 15:29:47'),
('131', '240', 'Test2 Test3', 'KI-B 1304', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 15:29:47', '', NULL, '2025-11-14 15:01:02', '2025-11-14 15:29:47'),
('132', '241', 'Test2 Test3', 'KI-B 1304', '01782465658', 'Test Event', '2026-11-07', '08:30:00', '', NULL, '0', NULL, '1', 'admin', '2025-11-14 15:29:47', '', NULL, '2025-11-14 15:21:13', '2025-11-14 15:29:47');


-- Table structure for `download_log`
DROP TABLE IF EXISTS `download_log`;
CREATE TABLE `download_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL,
  `downloaded_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_downloaded_at` (`downloaded_at`),
  KEY `idx_ip_address` (`ip_address`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `download_log`

-- Table structure for `email_log`
DROP TABLE IF EXISTS `email_log`;
CREATE TABLE `email_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `offer_id` int(11) DEFAULT NULL,
  `recipient_email` varchar(255) NOT NULL,
  `subject` varchar(500) DEFAULT NULL,
  `type` enum('offer','appointment','notification') NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('sent','failed','pending') DEFAULT 'sent',
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_recipient_email` (`recipient_email`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `email_log`

-- Table structure for `email_logs`
DROP TABLE IF EXISTS `email_logs`;
CREATE TABLE `email_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `template_key` varchar(100) DEFAULT NULL,
  `recipient_email` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `status` enum('sent','failed','pending') DEFAULT 'pending',
  `sent_at` datetime DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  CONSTRAINT `email_logs_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `email_logs`
INSERT INTO `email_logs` (`id`, `appointment_id`, `template_key`, `recipient_email`, `subject`, `status`, `sent_at`, `error_message`, `created_at`) VALUES
('1', NULL, NULL, 'uludag@be-automobile.de', 'Test-E-Mail von Boxenstop', 'failed', NULL, 'mail() Funktion fehlgeschlagen', '2025-11-23 23:53:48'),
('2', NULL, NULL, 'uludag@be-automobile.de', 'Test-E-Mail von Boxenstop', 'failed', NULL, 'mail() Funktion fehlgeschlagen', '2025-11-24 00:00:40');


-- Table structure for `email_templates`
DROP TABLE IF EXISTS `email_templates`;
CREATE TABLE `email_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_key` varchar(100) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_key` (`template_key`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `email_templates`
INSERT INTO `email_templates` (`id`, `template_key`, `subject`, `body`, `is_active`, `created_at`, `updated_at`) VALUES
('1', 'appointment_confirmation', 'Terminbestätigung - Boxenstop', 'Liebe/r {{customer_name}},\r\n\r\nvielen Dank für Ihre Terminanfrage für den {{event_name}} am {{appointment_date}} um {{appointment_time}}.\r\n\r\nIhre Termindetails:\r\n- Event: {{event_name}}\r\n- Datum: {{appointment_date}}\r\n- Zeit: {{appointment_time}}\r\n- Kennzeichen: {{license_plate}}\r\n- Services: {{services}}\r\n\r\nIhr Termin wird von unserem Team geprüft und bestätigt. Sie erhalten eine weitere E-Mail sobald der Termin bestätigt wurde.\r\n\r\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\r\n\r\nMit freundlichen Grüßen\r\nIhr Boxenstop Team', '1', '2025-11-23 23:27:25', '2025-11-23 23:27:25'),
('2', 'appointment_approved', 'Termin bestätigt - Boxenstop', 'Liebe/r {{customer_name}},\r\n\r\nIhr Termin für den {{event_name}} am {{appointment_date}} um {{appointment_time}} wurde bestätigt!\r\n\r\nTermindetails:\r\n- Event: {{event_name}}\r\n- Datum: {{appointment_date}}\r\n- Zeit: {{appointment_time}}\r\n- Kennzeichen: {{license_plate}}\r\n- Services: {{services}}\r\n\r\nBitte erscheinen Sie pünktlich zum vereinbarten Termin.\r\n\r\nMit freundlichen Grüßen\r\nIhr Boxenstop Team', '1', '2025-11-23 23:27:25', '2025-11-23 23:27:25'),
('3', 'appointment_reminder', 'Erinnerung: Ihr Termin morgen - Boxenstop', 'Liebe/r {{customer_name}},\r\n\r\ndies ist eine freundliche Erinnerung an Ihren Termin morgen:\r\n\r\nTermindetails:\r\n- Event: {{event_name}}\r\n- Datum: {{appointment_date}}\r\n- Zeit: {{appointment_time}}\r\n- Kennzeichen: {{license_plate}}\r\n- Services: {{services}}\r\n\r\nBitte erscheinen Sie pünktlich zum vereinbarten Termin.\r\n\r\nMit freundlichen Grüßen\r\nIhr Boxenstop Team', '1', '2025-11-23 23:27:25', '2025-11-23 23:27:25'),
('4', 'appointment_rejected', 'Termin leider nicht verfügbar - Boxenstop', 'Liebe/r {{customer_name}},\r\n\r\nleider können wir Ihren gewünschten Termin für den {{event_name}} am {{appointment_date}} um {{appointment_time}} nicht bestätigen.\r\n\r\nGrund: {{rejection_reason}}\r\n\r\nBitte wählen Sie einen anderen verfügbaren Termin aus.\r\n\r\nMit freundlichen Grüßen\r\nIhr Boxenstop Team', '1', '2025-11-23 23:27:25', '2025-11-23 23:27:25');


-- Table structure for `events`
DROP TABLE IF EXISTS `events`;
CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `event_date` date NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `slot_duration` int(11) DEFAULT 30,
  `max_monteure` int(11) DEFAULT 5,
  `pause_start` time DEFAULT NULL,
  `pause_end` time DEFAULT NULL,
  `blocked_start` time DEFAULT NULL,
  `blocked_end` time DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `tire_order_date` date DEFAULT NULL COMMENT 'Datum wann die Reifen aus dem Lager bestellt werden sollen',
  `event_time` time DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_events_tire_order_date` (`tire_order_date`),
  KEY `idx_events_autohaus` (`autohaus_id`),
  KEY `idx_events_is_active` (`is_active`),
  KEY `idx_events_event_date` (`event_date`),
  KEY `idx_events_autohaus_active` (`autohaus_id`,`is_active`),
  KEY `idx_events_complex` (`autohaus_id`,`is_active`,`event_date`),
  KEY `idx_events_autohaus_id` (`autohaus_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `events`
INSERT INTO `events` (`id`, `autohaus_id`, `name`, `event_date`, `start_time`, `end_time`, `slot_duration`, `max_monteure`, `pause_start`, `pause_end`, `blocked_start`, `blocked_end`, `is_active`, `created_at`, `updated_at`, `tire_order_date`, `event_time`, `description`) VALUES
('26', '1', 'Test Event', '2026-11-07', '08:30:00', '17:00:00', '30', '5', NULL, NULL, NULL, NULL, '1', '2025-11-04 12:20:30', '2025-11-08 16:07:40', NULL, NULL, NULL);


-- Table structure for `feedback`
DROP TABLE IF EXISTS `feedback`;
CREATE TABLE `feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `autohaus_id` int(11) DEFAULT NULL,
  `rating` int(11) NOT NULL CHECK (`rating` >= 1 and `rating` <= 5),
  `feedback_text` text NOT NULL,
  `feedback_type` enum('service','booking','general') DEFAULT 'general',
  `page_url` varchar(500) DEFAULT NULL,
  `is_anonymous` tinyint(1) DEFAULT 0,
  `status` enum('new','read','archived') DEFAULT 'new',
  `admin_response` text DEFAULT NULL,
  `admin_response_by` int(11) DEFAULT NULL,
  `admin_response_at` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `admin_response_by` (`admin_response_by`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_feedback_type` (`feedback_type`),
  CONSTRAINT `feedback_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `feedback_ibfk_2` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL,
  CONSTRAINT `feedback_ibfk_3` FOREIGN KEY (`admin_response_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `feedback`
INSERT INTO `feedback` (`id`, `user_id`, `autohaus_id`, `rating`, `feedback_text`, `feedback_type`, `page_url`, `is_anonymous`, `status`, `admin_response`, `admin_response_by`, `admin_response_at`, `created_at`, `updated_at`) VALUES
('5', '65', '1', '5', 'Kendnssmsmamw', 'general', 'index.php', '0', 'read', '!asodjoaisjdoiajosd', '1', '2025-11-13 22:57:23', '2025-11-13 22:57:09', '2025-11-13 22:57:23'),
('6', NULL, '1', '5', 'Gut sehr gut gut!!!!', 'general', 'index.php', '0', 'read', 'Adamsin! süper', '1', '2025-11-14 09:09:10', '2025-11-14 09:08:55', '2025-11-14 09:09:10'),
('7', NULL, '1', '5', 'Serviceassistent Uludag scheint mich mehr zu mögen als normal', 'general', 'index.php', '1', 'read', 'Öptüm dasaklarindan', '1', '2025-11-14 11:27:41', '2025-11-14 11:27:17', '2025-11-14 11:27:41'),
('8', NULL, '1', '5', 'scheisseuuini', 'general', 'profile.php', '0', 'read', 'geil mega', '1', '2025-11-14 13:54:41', '2025-11-14 13:54:06', '2025-11-14 13:54:41');


-- Table structure for `feedback_audit_log`
DROP TABLE IF EXISTS `feedback_audit_log`;
CREATE TABLE `feedback_audit_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feedback_id` int(11) NOT NULL,
  `admin_user_id` int(11) DEFAULT NULL,
  `action_type` enum('status_changed','response_added','response_updated','email_sent','email_failed','viewed','archived','restored') NOT NULL,
  `action_description` text NOT NULL,
  `old_value` varchar(255) DEFAULT NULL,
  `new_value` varchar(255) DEFAULT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_feedback_id` (`feedback_id`),
  KEY `idx_admin_user_id` (`admin_user_id`),
  KEY `idx_action_type` (`action_type`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `feedback_audit_log`
INSERT INTO `feedback_audit_log` (`id`, `feedback_id`, `admin_user_id`, `action_type`, `action_description`, `old_value`, `new_value`, `metadata`, `created_at`) VALUES
('6', '2', '15', 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen', NULL, '2025-11-13 17:51:26'),
('7', '2', '15', 'response_added', 'Admin-Antwort hinzugefügt', 'read', 'read', '{\"response_length\":6}', '2025-11-13 17:51:30'),
('8', '2', '15', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-13 17:51:43'),
('9', '2', '15', 'status_changed', 'Status geändert', 'Gelesen', 'Neu', NULL, '2025-11-13 17:56:13'),
('10', '2', '1', 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen', NULL, '2025-11-13 22:04:38'),
('11', '3', '1', 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen', NULL, '2025-11-13 22:04:45'),
('12', '4', '1', 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen', NULL, '2025-11-13 22:38:19'),
('13', '4', '1', 'response_added', 'Admin-Antwort hinzugefügt', 'read', 'read', '{\"response_length\":12}', '2025-11-13 22:38:24'),
('14', '4', '1', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-13 22:38:37'),
('15', '5', '1', 'response_added', 'Admin-Antwort hinzugefügt', 'new', 'read', '{\"response_length\":19}', '2025-11-13 22:57:23'),
('16', '5', '1', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-13 22:57:36'),
('17', '5', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-13 23:23:26'),
('18', '6', '1', 'viewed', 'Feedback als gelesen markiert', 'Neu', 'Gelesen', NULL, '2025-11-14 09:08:58'),
('19', '6', '1', 'response_added', 'Admin-Antwort hinzugefügt', 'read', 'read', '{\"response_length\":15}', '2025-11-14 09:09:10'),
('20', '6', '1', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-14 09:09:16'),
('21', '7', '1', 'response_added', 'Admin-Antwort hinzugefügt', 'new', 'read', '{\"response_length\":21}', '2025-11-14 11:27:41'),
('22', '7', '1', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-14 11:27:41'),
('23', '7', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-14 12:31:51'),
('24', '5', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-14 12:31:55'),
('25', '8', '1', 'response_added', 'Admin-Antwort hinzugefügt', 'new', 'read', '{\"response_length\":9}', '2025-11-14 13:54:41'),
('26', '8', '1', 'email_sent', 'E-Mail-Benachrichtigung an Benutzer gesendet', NULL, NULL, NULL, '2025-11-14 13:54:53'),
('27', '8', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-18 07:53:12'),
('28', '7', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-18 07:53:14'),
('29', '6', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-18 07:53:16'),
('30', '5', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-18 07:53:18'),
('31', '8', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-23 22:26:38'),
('32', '7', '1', 'viewed', 'Feedback angesehen', NULL, NULL, NULL, '2025-11-23 22:26:41');


-- Table structure for `newsletter_leads`
DROP TABLE IF EXISTS `newsletter_leads`;
CREATE TABLE `newsletter_leads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `newsletter_leads`

-- Table structure for `notification_logs`
DROP TABLE IF EXISTS `notification_logs`;
CREATE TABLE `notification_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notification_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `sent_by` int(11) DEFAULT NULL COMMENT 'Admin-User-ID, wenn manuell gesendet',
  `sent_method` enum('manual','trigger','automatic') DEFAULT 'automatic',
  `trigger_name` varchar(100) DEFAULT NULL COMMENT 'Name des Triggers, falls verwendet',
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `type` varchar(50) NOT NULL,
  `url` varchar(500) DEFAULT NULL,
  `push_sent` tinyint(1) DEFAULT 0,
  `push_success_count` int(11) DEFAULT 0,
  `push_failed_count` int(11) DEFAULT 0,
  `push_devices` text DEFAULT NULL COMMENT 'JSON Array mit Geräte-Informationen',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_notification_id` (`notification_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_sent_by` (`sent_by`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `notification_logs_ibfk_1` FOREIGN KEY (`notification_id`) REFERENCES `user_notifications` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_logs_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `notification_logs_ibfk_3` FOREIGN KEY (`sent_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `notification_logs`
INSERT INTO `notification_logs` (`id`, `notification_id`, `user_id`, `sent_by`, `sent_method`, `trigger_name`, `title`, `message`, `type`, `url`, `push_sent`, `push_success_count`, `push_failed_count`, `push_devices`, `created_at`) VALUES
('4', '166', '65', '1', 'manual', NULL, 'super es klappt danke!', 'osajdoijasoidjsaod', 'success', '/profile.php', '1', '3', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":4,\"endpoint\":\"https:\\/\\/jmt17.google.com\\/fcm\\/send\\/dKjWlCi-0IQ:APA91bGYf9_xZWHi64aq9KTqp4wrVfdRGuiyr2-K7T0O7HcwGAYOW48XknHUBVtzsdDHWMTcVOLFtWILedsXVmXtP9mB-NKSQHVwzkoy5DoFJpgSWeZXJEcVRD0Rnz-_uIBLdWShXxpH\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1},{\"id\":5,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QACD3U7GT09ZGitUDi56XpVL_Sg61d762-vc1Zo1MmyJTIe-QytYRDAaXthbE2-nld54-pO03tFzI-_ndbPxZQT2mP4VhxHuJqt_OL9R2NETv8IXmo01H1HvuekesarFArQDf6GfXlBs0gbWgM_raX_V9W91j8dp4BS1ubvWNa0\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-13 23:26:36'),
('6', '168', '64', '1', 'manual', NULL, 'super es klappt danke!', 'osajdoijasoidjsaod', 'success', '/profile.php', '1', '0', '0', '[]', '2025-11-13 23:26:36'),
('10', '172', '64', '1', 'manual', NULL, 'lasdlömaöldmlöasd', 'asödmamdölmsaldö', 'info', '/booking.php', '1', '0', '0', '[]', '2025-11-13 23:38:56'),
('12', '174', '65', '1', 'manual', NULL, 'lasdlömaöldmlöasd', 'asödmamdölmsaldö', 'info', '/booking.php', '1', '3', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":4,\"endpoint\":\"https:\\/\\/jmt17.google.com\\/fcm\\/send\\/dKjWlCi-0IQ:APA91bGYf9_xZWHi64aq9KTqp4wrVfdRGuiyr2-K7T0O7HcwGAYOW48XknHUBVtzsdDHWMTcVOLFtWILedsXVmXtP9mB-NKSQHVwzkoy5DoFJpgSWeZXJEcVRD0Rnz-_uIBLdWShXxpH\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1},{\"id\":5,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QACD3U7GT09ZGitUDi56XpVL_Sg61d762-vc1Zo1MmyJTIe-QytYRDAaXthbE2-nld54-pO03tFzI-_ndbPxZQT2mP4VhxHuJqt_OL9R2NETv8IXmo01H1HvuekesarFArQDf6GfXlBs0gbWgM_raX_V9W91j8dp4BS1ubvWNa0\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-13 23:38:57'),
('16', '178', '65', '1', 'manual', NULL, 'freut mich super!', 'freut mich super!', 'info', '/profile.php', '1', '3', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":4,\"endpoint\":\"https:\\/\\/jmt17.google.com\\/fcm\\/send\\/dKjWlCi-0IQ:APA91bGYf9_xZWHi64aq9KTqp4wrVfdRGuiyr2-K7T0O7HcwGAYOW48XknHUBVtzsdDHWMTcVOLFtWILedsXVmXtP9mB-NKSQHVwzkoy5DoFJpgSWeZXJEcVRD0Rnz-_uIBLdWShXxpH\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1},{\"id\":5,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QACD3U7GT09ZGitUDi56XpVL_Sg61d762-vc1Zo1MmyJTIe-QytYRDAaXthbE2-nld54-pO03tFzI-_ndbPxZQT2mP4VhxHuJqt_OL9R2NETv8IXmo01H1HvuekesarFArQDf6GfXlBs0gbWgM_raX_V9W91j8dp4BS1ubvWNa0\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:08:49'),
('17', '179', '65', '1', 'manual', NULL, 'freut mich super!', 'freut mich super!', 'info', '/profile.php', '1', '3', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":4,\"endpoint\":\"https:\\/\\/jmt17.google.com\\/fcm\\/send\\/dKjWlCi-0IQ:APA91bGYf9_xZWHi64aq9KTqp4wrVfdRGuiyr2-K7T0O7HcwGAYOW48XknHUBVtzsdDHWMTcVOLFtWILedsXVmXtP9mB-NKSQHVwzkoy5DoFJpgSWeZXJEcVRD0Rnz-_uIBLdWShXxpH\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1},{\"id\":5,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QACD3U7GT09ZGitUDi56XpVL_Sg61d762-vc1Zo1MmyJTIe-QytYRDAaXthbE2-nld54-pO03tFzI-_ndbPxZQT2mP4VhxHuJqt_OL9R2NETv8IXmo01H1HvuekesarFArQDf6GfXlBs0gbWgM_raX_V9W91j8dp4BS1ubvWNa0\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:08:50'),
('18', '181', '65', '1', 'manual', NULL, 'asdasdasd', 'asdasdasd', 'warning', '/profile.php', '1', '1', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:28:58'),
('19', '182', '65', '1', 'manual', NULL, 'asdasdasd', 'asdasdasd', 'warning', '/profile.php', '1', '1', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:28:59'),
('20', '183', '65', '1', 'manual', NULL, 'asdasd', 'asdasd', 'info', '/profile.php', '1', '2', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":6,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:29:30'),
('21', '184', '65', '1', 'manual', NULL, 'asdasd', 'asdasd', 'info', '/profile.php', '1', '2', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":6,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:29:30'),
('22', '185', '65', '1', 'manual', NULL, 'XyFf', 'Ggff', 'error', '/profile.php', '1', '2', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":6,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:35:42'),
('23', '186', '65', '1', 'manual', NULL, 'XyFf', 'Ggff', 'error', '/profile.php', '1', '2', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":6,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:35:43'),
('28', '191', '64', '1', 'manual', NULL, 'XyFf', 'Ggff', 'error', '/profile.php', '1', '1', '0', '[{\"id\":7,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QDkLB_E7nLrLZIx36uNkHFKwifjg2v6pZ9LbpEsyW_I0hjIz6lJYGmlvOZanwr40pr_s2WaqwLTMCtZUJ4K5L3oY1ZzV45XitoGTi7so_UJazFOrpZMIDOUR66KfB0MbOV3ljQ7zZVRuKdMSiJbVZ8zn9NY3Qd7VGFURyWjkyQ4\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 00:35:44'),
('34', '197', '65', '1', 'manual', NULL, 'Super funktioniert das alles!', 'Super funktioniert das alles!', 'info', '/profile.php', '1', '2', '0', '[{\"id\":3,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1},{\"id\":6,\"endpoint\":\"https:\\/\\/web.push.apple.com\\/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"device_info\":\"{\\\"platform\\\":\\\"unknown\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\\\\\/605.1.15 (KHTML, like Gecko) Version\\\\\\/26.2 Mobile\\\\\\/15E148 Safari\\\\\\/604.1\\\"}\",\"is_active\":1}]', '2025-11-14 08:45:16'),
('41', '240', '78', '1', 'manual', NULL, 'kllknk', 'klknnk', 'info', '/profile.php', '1', '1', '0', '[{\"id\":16,\"endpoint\":\"https:\\/\\/fcm.googleapis.com\\/fcm\\/send\\/fzVa3N-d-10:APA91bHdKBohwnr-JYJHZ_qywVDoXFumzLtSOaEWvLybhPv0zZ34NMKDVGtj066t_0zZUfTp_1bBD5wE8_K3d1C0j288jStLM9zFQtGQhJoXJgtfuQ6tlhYl6GVd_LTLSTaZCpiaoChh\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1}]', '2025-11-22 19:07:07'),
('42', '241', '78', '1', 'manual', NULL, 'kllknk', 'klknnk', 'info', '/profile.php', '1', '1', '0', '[{\"id\":16,\"endpoint\":\"https:\\/\\/fcm.googleapis.com\\/fcm\\/send\\/fzVa3N-d-10:APA91bHdKBohwnr-JYJHZ_qywVDoXFumzLtSOaEWvLybhPv0zZ34NMKDVGtj066t_0zZUfTp_1bBD5wE8_K3d1C0j288jStLM9zFQtGQhJoXJgtfuQ6tlhYl6GVd_LTLSTaZCpiaoChh\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"device_info\":\"{\\\"platform\\\":\\\"\\\\\\\"macOS\\\\\\\"\\\",\\\"user_agent\\\":\\\"Mozilla\\\\\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\\\\\/537.36 (KHTML, like Gecko) Chrome\\\\\\/142.0.0.0 Safari\\\\\\/537.36\\\"}\",\"is_active\":1}]', '2025-11-22 19:07:08');


-- Table structure for `notifications`
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `type` enum('status_change','document_review','system','info') NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_is_read` (`is_read`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_user_unread` (`user_id`,`is_read`),
  KEY `idx_type_created` (`type`,`created_at`),
  CONSTRAINT `fk_notifications_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `notifications`

-- Table structure for `offer_customer_selections`
DROP TABLE IF EXISTS `offer_customer_selections`;
CREATE TABLE `offer_customer_selections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL COMMENT 'Angebot-ID',
  `selected_wheel_ids` text DEFAULT NULL COMMENT 'IDs ausgewählter Reifen (JSON)',
  `selected_service_ids` text DEFAULT NULL COMMENT 'IDs ausgewählter Services (JSON)',
  `customer_notes` text DEFAULT NULL COMMENT 'Kundenanmerkungen',
  `selection_status` enum('pending','confirmed','cancelled') DEFAULT 'pending',
  `confirmation_sent_at` datetime DEFAULT NULL COMMENT 'Zeitpunkt der Bestätigungsmail',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_selection_status` (`selection_status`),
  CONSTRAINT `offer_customer_selections_ibfk_1` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `offer_customer_selections`

-- Table structure for `offer_new_tires`
DROP TABLE IF EXISTS `offer_new_tires`;
CREATE TABLE `offer_new_tires` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL COMMENT 'Angebot-ID',
  `brand` varchar(100) NOT NULL COMMENT 'Marke',
  `type` varchar(100) NOT NULL COMMENT 'Typ/Modell',
  `size` varchar(50) NOT NULL COMMENT 'Größe (z.B. 225/45R17)',
  `quantity` int(11) NOT NULL DEFAULT 1 COMMENT 'Anzahl',
  `unit_price` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Einzelpreis',
  `total_price` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Gesamtpreis',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  CONSTRAINT `offer_new_tires_ibfk_1` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `offer_new_tires`

-- Table structure for `offer_services`
DROP TABLE IF EXISTS `offer_services`;
CREATE TABLE `offer_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL COMMENT 'Angebot-ID',
  `service_id` int(11) DEFAULT NULL COMMENT 'Service-ID aus autohaus_services (optional)',
  `service_name` varchar(255) NOT NULL COMMENT 'Service-Name',
  `service_price` decimal(10,2) DEFAULT 0.00 COMMENT 'Service-Preis',
  `show_price` tinyint(1) DEFAULT 1 COMMENT 'Preis anzeigen',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_service_id` (`service_id`),
  CONSTRAINT `offer_services_ibfk_1` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `offer_services`

-- Table structure for `offer_templates`
DROP TABLE IF EXISTS `offer_templates`;
CREATE TABLE `offer_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `template_name` varchar(255) NOT NULL,
  `template_content` text NOT NULL,
  `is_default` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_is_default` (`is_default`),
  KEY `idx_is_active` (`is_active`),
  CONSTRAINT `offer_templates_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `offer_templates`
INSERT INTO `offer_templates` (`id`, `autohaus_id`, `template_name`, `template_content`, `is_default`, `is_active`, `created_at`, `updated_at`) VALUES
('1', '1', 'Standard Reifenangebot', 'die Vorbereitungen für unseren nächsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden müssten, siehe Prüfbericht.\n\nDaher erhalten Sie mit diesem Schreiben das beigefügte Angebot.', '1', '1', '2025-09-19 00:20:10', '2025-09-19 00:20:10'),
('3', '3', 'Standard Reifenangebot', 'die Vorbereitungen für unseren nächsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden müssten, siehe Prüfbericht.\n\nDaher erhalten Sie mit diesem Schreiben das beigefügte Angebot.', '1', '1', '2025-09-19 00:20:10', '2025-09-19 00:20:10');


-- Table structure for `offer_tokens`
DROP TABLE IF EXISTS `offer_tokens`;
CREATE TABLE `offer_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `token` varchar(255) NOT NULL,
  `expires_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_token` (`token`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `offer_tokens`

-- Table structure for `offer_tracking`
DROP TABLE IF EXISTS `offer_tracking`;
CREATE TABLE `offer_tracking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) DEFAULT NULL,
  `wheelset_number` varchar(50) DEFAULT NULL,
  `stored_wheelset_id` int(11) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `offer_type` enum('created','sent') NOT NULL DEFAULT 'created',
  `customer_accepted` tinyint(1) DEFAULT 0,
  `teams_notification_sent` tinyint(1) DEFAULT 0,
  `status_update` varchar(255) DEFAULT NULL,
  `status_updated_at` timestamp NULL DEFAULT NULL,
  `teams_message_id` varchar(255) DEFAULT NULL,
  `offer_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `pdf_filename` varchar(255) DEFAULT NULL,
  `email_recipient` varchar(255) DEFAULT NULL,
  `email_subject` varchar(255) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_offer_type` (`offer_type`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_wheelset_number` (`wheelset_number`),
  KEY `idx_stored_wheelset_id` (`stored_wheelset_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `offer_tracking`
INSERT INTO `offer_tracking` (`id`, `appointment_id`, `wheelset_number`, `stored_wheelset_id`, `user_id`, `username`, `offer_type`, `customer_accepted`, `teams_notification_sent`, `status_update`, `status_updated_at`, `teams_message_id`, `offer_data`, `pdf_filename`, `email_recipient`, `email_subject`, `created_at`, `updated_at`) VALUES
('1', '92', NULL, NULL, '1', 'Current User', 'created', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[38,31],\"offerContent\":\"\\n                <p><strong>B&amp;E Autocentrum GmbH<\\/strong><\\/p>\\n                <p>Kiel, 20.9.2025<\\/p>\\n                <br>\\n                <p>Sehr geehrte Damen und Herren,<\\/p>\\n                <br>\\n                <p>die Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.<\\/p>\\n                <br>\\n                <p>Daher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.<\\/p>\\n                <br>\\n                <p><strong>Auszutauschender Reifen:<\\/strong><\\/p>\\n            <p>- Goodyear EfficientGrip Performance 2 (225\\/50R17) - Position: HL - Austausch notwendig<\\/p><br><p><strong>Neue Reifen:<\\/strong><\\/p><p>- 1 (1) - 4x 1,00\\u20ac<\\/p>\\n                <br>\\n                <p><strong>Kosten inkl. Reifenmontage:<\\/strong><\\/p>\\n                <p>Zzgl.<\\/p>\\n                <p>R\\u00e4dermontage                    49,99\\u20ac<\\/p>\\n                <p>Einlagerung der Sommerreifen     85,00\\u20ac<\\/p>\\n            <p>Achsvermessung                120,00\\u20ac<\\/p><p>20% Wischerbl\\u00e4tter + 1L Wischwasser0,00\\u20ac<\\/p>\\n                <br>\\n                <p>F\\u00fcr R\\u00fcckfragen stehen wir Ihnen gerne unter Tel: 0431\\/54 63 00 zur Verf\\u00fcgung.<\\/p>\\n                <br>\\n                <p>Mit freundlichem Gru\\u00df<br>Deniz Uludag<br>B&amp;E Autocentrum GmbH<\\/p>\\n                <br>\\n                <p style=\\\"font-size: 0.8em; color: #dc2626;\\\">Dieses Dokument wurde maschinell erstellt und ist ohne Unterschrift g\\u00fcltig<\\/p>\\n            \",\"canvasData\":null}', 'Angebot_Katrin_Ilker_2025-09-20.pdf', NULL, NULL, '2025-09-20 22:16:03', '2025-09-20 22:16:03'),
('2', '92', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:20:47', '2025-09-20 22:20:47'),
('3', '92', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Test 1\",\"euLabel\":\"1111\",\"size\":\"11111\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8},{\"id\":2,\"brand\":\"Test 2\",\"euLabel\":\"111111\",\"size\":\"1111\",\"price\":11,\"mounting\":11,\"quantity\":4,\"total\":88}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:22:52', '2025-09-20 22:22:52'),
('4', '92', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:24:19', '2025-09-20 22:24:19'),
('5', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:39:39', '2025-09-20 22:39:39'),
('6', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:48:35', '2025-09-20 22:48:35'),
('7', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"2\",\"euLabel\":\"2\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:49:06', '2025-09-20 22:49:06'),
('8', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"2\",\"euLabel\":\"2\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:49:33', '2025-09-20 22:49:33'),
('9', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 22:55:42', '2025-09-20 22:55:42'),
('10', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"7,3 mm\",\"profileMiddle\":\"7,5 mm\",\"profileOuter\":\"7,1 mm\"},{\"position\":\"VR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"7,5 mm\",\"profileOuter\":\"7,1 mm\"},{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"},{\"position\":\"HR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"7,8 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:01:00', '2025-09-20 23:01:00'),
('11', '92', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"123\",\"euLabel\":\"123\",\"size\":\"123\",\"price\":3,\"mounting\":3,\"quantity\":4,\"total\":24}],\"selectedServices\":[38]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:05:19', '2025-09-20 23:05:19'),
('12', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"test\",\"euLabel\":\"test\",\"size\":\"test\",\"price\":0,\"mounting\":0,\"quantity\":4,\"total\":0}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:10:51', '2025-09-20 23:10:51'),
('13', '89', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"7,5 mm\",\"profileOuter\":\"7,1 mm\"},{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"},{\"position\":\"HR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"7,8 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:31:35', '2025-10-21 14:05:41'),
('14', '93', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":93,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"22\",\"euLabel\":\"22\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:43:18', '2025-10-21 14:05:41'),
('15', '93', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":93,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"22\",\"euLabel\":\"22\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:51:54', '2025-10-21 14:05:41'),
('16', '93', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":93,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-20 23:55:46', '2025-10-21 14:05:41'),
('17', '94', NULL, NULL, '1', 'Current User', 'sent', '0', '0', 'Neue Reifen bestellt', '2025-09-21 18:56:41', NULL, '{\"appointmentId\":94,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Continental\",\"model\":\"WINTER CONTACT TS870 P\",\"size\":\"255\\/45R20\",\"dot\":\"DOT 1223\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"7,0 mm\",\"profileOuter\":\"6,9 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"47\",\"euLabel\":\"6o+3\",\"size\":\"245\",\"price\":50,\"mounting\":50,\"quantity\":4,\"total\":400}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 08:51:23', '2025-10-21 14:05:41'),
('18', '93', NULL, NULL, '1', 'Current User', 'sent', '0', '1', NULL, NULL, NULL, '{\"appointmentId\":93,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 18:47:56', '2025-09-21 18:48:56'),
('19', '95', NULL, NULL, '1', 'Current User', 'sent', '0', '1', NULL, NULL, 'msg_95_1758474282971', '{\"appointmentId\":95,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Continental ECOmax\",\"euLabel\":\"A A A B 21\",\"size\":\"245\\/50 R19 105Y\",\"price\":245.5,\"mounting\":24.5,\"quantity\":4,\"total\":1080}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 18:59:49', '2025-09-21 19:05:25'),
('20', '95', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Neue Reifen bestellt', '2025-09-21 19:09:13', 'msg_95_1758474281925', '{\"appointmentId\":95,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Continental ECOmax\",\"euLabel\":\"A A A B 21\",\"size\":\"245\\/50 R19 105Y\",\"price\":245.5,\"mounting\":24.5,\"quantity\":4,\"total\":1080}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 19:04:14', '2025-09-21 19:09:13'),
('21', '95', NULL, NULL, '1', 'Current User', 'sent', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":95,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Continental ECOmax\",\"euLabel\":\"A A A B 21\",\"size\":\"245\\/50 R19 105Y\",\"price\":245.5,\"mounting\":24.5,\"quantity\":4,\"total\":1080}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 19:10:17', '2025-09-21 19:10:17'),
('22', '96', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Kunde benachrichtigt', '2025-09-21 19:20:52', 'msg_96_1758475157392', '{\"appointmentId\":96,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Test \",\"euLabel\":\"Test2\",\"size\":\"24123\",\"price\":244,\"mounting\":244,\"quantity\":4,\"total\":1952}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 19:15:39', '2025-09-21 19:20:52'),
('23', '96', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Arbeit abgeschlossen', '2025-09-21 19:32:27', 'msg_96_1758475894250', '{\"appointmentId\":96,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[38,31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 19:30:31', '2025-09-21 19:32:27'),
('24', '96', NULL, NULL, '1', 'Current User', 'sent', '0', '1', NULL, NULL, 'msg_96_1758521187373', '{\"appointmentId\":96,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,6 mm\",\"profileOuter\":\"6,8 mm\"},{\"position\":\"HR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,1 mm\",\"profileOuter\":\"6,7 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Test\",\"euLabel\":\"asdasd\",\"size\":\"asd\",\"price\":22,\"mounting\":22,\"quantity\":4,\"total\":176}],\"selectedServices\":[31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 21:18:10', '2025-09-22 08:06:27'),
('25', '96', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Kunde benachrichtigt', '2025-09-22 08:35:40', 'msg_96_1758521186396', '{\"appointmentId\":96,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,6 mm\",\"profileOuter\":\"6,8 mm\"},{\"position\":\"HR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,1 mm\",\"profileOuter\":\"6,7 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"Test\",\"euLabel\":\"asdasd\",\"size\":\"asd\",\"price\":22,\"mounting\":22,\"quantity\":4,\"total\":176}],\"selectedServices\":[31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 21:25:38', '2025-09-22 08:35:40'),
('26', '97', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Kunde benachrichtigt', '2025-09-21 21:34:01', 'msg_97_1758482911560', '{\"appointmentId\":97,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"},{\"position\":\"HR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"}],\"newTires\":[{\"id\":1,\"brand\":\"2\",\"euLabel\":\"2\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[31]}', NULL, 'duludag16@gmail.com', 'Reifenangebot - Boxenstop', '2025-09-21 21:28:12', '2025-09-21 21:34:01'),
('27', '89', NULL, NULL, '1', 'Current User', 'created', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[],\"selectedServices\":[],\"offerContent\":\"\\n                <p><strong>B&amp;E Autocentrum GmbH<\\/strong><\\/p>\\n                <p>Kiel, 20.9.2025<\\/p>\\n                <br>\\n                <p>Sehr geehrte Damen und Herren,<\\/p>\\n                <br>\\n                <p>die Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.<\\/p>\\n                <br>\\n                <p>Daher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.<\\/p>\\n                <br>\\n                <p><strong>Auszutauschender Reifen:<\\/strong><\\/p>\\n            <p>- Michelin Pilotalpin 5 SUV (235\\/55R19) - Position: VL - Austausch notwendig<\\/p><br><p><strong>Neue Reifen:<\\/strong><\\/p><p>Keine neuen Reifen hinzugef\\u00fcgt<\\/p>\\n                <br>\\n                <p><strong>Kosten inkl. Reifenmontage:<\\/strong><\\/p>\\n                <p>Zzgl.<\\/p>\\n                <p>R\\u00e4dermontage                    49,99\\u20ac<\\/p>\\n                <p>Einlagerung der Sommerreifen     85,00\\u20ac<\\/p>\\n            <p>Keine Services ausgew\\u00e4hlt<\\/p>\\n                <br>\\n                <p>F\\u00fcr R\\u00fcckfragen stehen wir Ihnen gerne unter Tel: 0431\\/54 63 00 zur Verf\\u00fcgung.<\\/p>\\n                <br>\\n                <p>Mit freundlichem Gru\\u00df<br>Deniz Uludag<br>B&amp;E Autocentrum GmbH<\\/p>\\n                <br>\\n                <p style=\\\"font-size: 0.8em; color: #dc2626;\\\">Dieses Dokument wurde maschinell erstellt und ist ohne Unterschrift g\\u00fcltig<\\/p>\\n            \",\"canvasData\":null}', 'Angebot_Deniz Uludag_2025-09-20.pdf', NULL, NULL, '2025-09-22 07:23:46', '2025-09-22 07:23:46'),
('28', '89', NULL, NULL, '1', 'Current User', 'created', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilotalpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"DOT 2022\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"5,9 mm\",\"profileMiddle\":\"6,0 mm\",\"profileOuter\":\"6,3 mm\"}],\"newTires\":[],\"selectedServices\":[],\"offerContent\":\"\\n                <p><strong>B&amp;E Autocentrum GmbH<\\/strong><\\/p>\\n                <p>Kiel, 20.9.2025<\\/p>\\n                <br>\\n                <p>Sehr geehrte Damen und Herren,<\\/p>\\n                <br>\\n                <p>die Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.<\\/p>\\n                <br>\\n                <p>Daher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.<\\/p>\\n                <br>\\n                <p><strong>Auszutauschender Reifen:<\\/strong><\\/p>\\n            <p>- Michelin Pilotalpin 5 SUV (235\\/55R19) - Position: VL - Austausch notwendig<\\/p><br><p><strong>Neue Reifen:<\\/strong><\\/p><p>Keine neuen Reifen hinzugef\\u00fcgt<\\/p>\\n                <br>\\n                <p><strong>Kosten inkl. Reifenmontage:<\\/strong><\\/p>\\n                <p>Zzgl.<\\/p>\\n                <p>R\\u00e4dermontage                    49,99\\u20ac<\\/p>\\n                <p>Einlagerung der Sommerreifen     85,00\\u20ac<\\/p>\\n            <p>Keine Services ausgew\\u00e4hlt<\\/p>\\n                <br>\\n                <p>F\\u00fcr R\\u00fcckfragen stehen wir Ihnen gerne unter Tel: 0431\\/54 63 00 zur Verf\\u00fcgung.<\\/p>\\n                <br>\\n                <p>Mit freundlichem Gru\\u00df<br>Deniz Uludag<br>B&amp;E Autocentrum GmbH<\\/p>\\n                <br>\\n                <p style=\\\"font-size: 0.8em; color: #dc2626;\\\">Dieses Dokument wurde maschinell erstellt und ist ohne Unterschrift g\\u00fcltig<\\/p>\\n            \",\"canvasData\":null}', 'Angebot_Deniz Uludag_2025-09-20.pdf', NULL, NULL, '2025-09-22 07:23:46', '2025-09-22 07:23:46'),
('29', '92', NULL, NULL, '1', 'Current User', 'created', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":92,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[],\"offerContent\":\"\\n                <p><strong>B&amp;E Autocentrum GmbH<\\/strong><\\/p>\\n                <p>Kiel, 20.9.2025<\\/p>\\n                <br>\\n                <p>Sehr geehrte Damen und Herren,<\\/p>\\n                <br>\\n                <p>die Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.<\\/p>\\n                <br>\\n                <p>Daher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.<\\/p>\\n                <br>\\n                <p><strong>Auszutauschender Reifen:<\\/strong><\\/p>\\n            <p>- Goodyear EfficientGrip Performance 2 (225\\/50R17) - Position: HL - Austausch notwendig<\\/p><br><p><strong>Neue Reifen:<\\/strong><\\/p><p>Keine neuen Reifen hinzugef\\u00fcgt<\\/p>\\n                <br>\\n                <p><strong>Kosten inkl. Reifenmontage:<\\/strong><\\/p>\\n                <p>Zzgl.<\\/p>\\n                <p>R\\u00e4dermontage                    49,99\\u20ac<\\/p>\\n                <p>Einlagerung der Sommerreifen     85,00\\u20ac<\\/p>\\n            <p>Keine Services ausgew\\u00e4hlt<\\/p>\\n                <br>\\n                <p>F\\u00fcr R\\u00fcckfragen stehen wir Ihnen gerne unter Tel: 0431\\/54 63 00 zur Verf\\u00fcgung.<\\/p>\\n                <br>\\n                <p>Mit freundlichem Gru\\u00df<br>Deniz Uludag<br>B&amp;E Autocentrum GmbH<\\/p>\\n                <br>\\n                <p style=\\\"font-size: 0.8em; color: #dc2626;\\\">Dieses Dokument wurde maschinell erstellt und ist ohne Unterschrift g\\u00fcltig<\\/p>\\n            \",\"canvasData\":null}', 'Angebot_Katrin Ilker_2025-09-20.pdf', NULL, NULL, '2025-09-22 07:23:46', '2025-09-22 07:23:46'),
('30', '89', NULL, NULL, '1', 'Current User', 'created', '0', '0', NULL, NULL, NULL, '{\"appointmentId\":89,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"7,5 mm\",\"profileOuter\":\"7,1 mm\"},{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[],\"selectedServices\":[],\"offerContent\":\"\\n                <p><strong>B&amp;E Autocentrum GmbH<\\/strong><\\/p>\\n                <p>Kiel, 20.9.2025<\\/p>\\n                <br>\\n                <p>Sehr geehrte Damen und Herren,<\\/p>\\n                <br>\\n                <p>die Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.<\\/p>\\n                <br>\\n                <p>Daher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.<\\/p>\\n                <br>\\n                <p><strong>Auszutauschender Reifen:<\\/strong><\\/p>\\n            <p>- Goodyear EfficientGrip Performance 2 (225\\/50R17) - Position: VR - keine Fehler<\\/p><p>- Goodyear EfficientGrip Performance 2 (225\\/50R17) - Position: HL - Austausch notwendig<\\/p><br><p><strong>Neue Reifen:<\\/strong><\\/p><p>Keine neuen Reifen hinzugef\\u00fcgt<\\/p>\\n                <br>\\n                <p><strong>Kosten inkl. Reifenmontage:<\\/strong><\\/p>\\n                <p>Zzgl.<\\/p>\\n                <p>R\\u00e4dermontage                    49,99\\u20ac<\\/p>\\n                <p>Einlagerung der Sommerreifen     85,00\\u20ac<\\/p>\\n            <p>Keine Services ausgew\\u00e4hlt<\\/p>\\n                <br>\\n                <p>F\\u00fcr R\\u00fcckfragen stehen wir Ihnen gerne unter Tel: 0431\\/54 63 00 zur Verf\\u00fcgung.<\\/p>\\n                <br>\\n                <p>Mit freundlichem Gru\\u00df<br>Deniz Uludag<br>B&amp;E Autocentrum GmbH<\\/p>\\n                <br>\\n                <p style=\\\"font-size: 0.8em; color: #dc2626;\\\">Dieses Dokument wurde maschinell erstellt und ist ohne Unterschrift g\\u00fcltig<\\/p>\\n            \",\"canvasData\":null}', 'Angebot_Deniz_Uludag_2025-09-20.pdf', NULL, NULL, '2025-09-22 07:23:46', '2025-09-22 07:23:46'),
('31', '99', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Arbeit abgeschlossen', '2025-09-22 08:42:58', 'msg_99_1758522951828', '{\"appointmentId\":99,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"\",\"profileMiddle\":\"4.2 mm\",\"profileOuter\":\"5.8 mm\"},{\"position\":\"HR\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"\",\"profileMiddle\":\"4.5 mm\",\"profileOuter\":\"5.9 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"111\",\"euLabel\":\"11\",\"size\":\"111\",\"price\":11,\"mounting\":11,\"quantity\":4,\"total\":88}],\"selectedServices\":[31]}', NULL, 'uludag@be-automobile.de', 'Reifenangebot - Boxenstop', '2025-09-22 07:25:23', '2025-09-22 08:42:58'),
('32', '98', NULL, NULL, '1', 'Current User', 'sent', '0', '1', NULL, NULL, 'msg_98_1758523383600', '{\"appointmentId\":98,\"selectedTires\":[{\"position\":\"VR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,6 mm\",\"profileOuter\":\"6,8 mm\"},{\"position\":\"HR\",\"brand\":\"Nokian\",\"model\":\"Snowproof 2 SUV\",\"size\":\"235\\/60R18\",\"dot\":\"DOT 1623\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"6,1 mm\",\"profileOuter\":\"6,7 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"123123\",\"euLabel\":\"123123\",\"size\":\"123123\",\"price\":1233,\"mounting\":0,\"quantity\":4,\"total\":4932},{\"id\":2,\"brand\":\"123123\",\"euLabel\":\"123\",\"size\":\"123123\",\"price\":123,\"mounting\":123,\"quantity\":4,\"total\":984}],\"selectedServices\":[31]}', NULL, 'uludag@be-automobile.de', 'Reifenangebot - Boxenstop', '2025-09-22 08:41:33', '2025-09-22 08:43:03'),
('33', '100', NULL, NULL, '1', 'Current User', 'sent', '0', '1', NULL, NULL, 'msg_100_1758535595042', '{\"appointmentId\":100,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"},{\"position\":\"VR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"},{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"},{\"position\":\"HR\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"keine Fehler\",\"profileInner\":\"\",\"profileMiddle\":\"\",\"profileOuter\":\"\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"22\",\"size\":\"2\",\"price\":2,\"mounting\":2,\"quantity\":4,\"total\":16}],\"selectedServices\":[31]}', NULL, 'uludag@be-automobile.de', 'Reifenangebot - Boxenstop', '2025-09-22 11:46:53', '2025-09-22 12:06:35'),
('34', '100', NULL, NULL, '1', 'Current User', 'sent', '0', '1', 'Arbeit abgeschlossen', '2025-09-25 16:04:08', 'msg_100_1758809019901', '{\"appointmentId\":100,\"selectedTires\":[{\"position\":\"HL\",\"brand\":\"Goodyear\",\"model\":\"EfficientGrip Performance 2\",\"size\":\"225\\/50R17\",\"dot\":\"DOT 1023\",\"recommendation\":\"Austausch notwendig\",\"profileInner\":\"7,5 mm\",\"profileMiddle\":\"7,9 mm\",\"profileOuter\":\"7,3 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"dfgdfg\",\"euLabel\":\"dfgdfg\",\"size\":\"dfg\",\"price\":0,\"mounting\":0,\"quantity\":4,\"total\":0}],\"selectedServices\":[31]}', NULL, 'uludag@be-automobile.de', 'Reifenangebot - Boxenstop', '2025-09-25 16:02:31', '2025-09-25 16:04:08'),
('35', '100', NULL, NULL, '1', 'Current User', 'sent', '0', '0', 'Arbeit abgeschlossen', '2025-10-14 10:33:57', NULL, '{\"appointmentId\":100,\"selectedTires\":[{\"position\":\"VL\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"6 mm\",\"profileMiddle\":\"4.7 mm\",\"profileOuter\":\"5.8 mm\"},{\"position\":\"VR\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"\",\"profileMiddle\":\"4.2 mm\",\"profileOuter\":\"5.8 mm\"},{\"position\":\"HL\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"6.2 mm\",\"profileMiddle\":\"4.8 mm\",\"profileOuter\":\"5.9 mm\"},{\"position\":\"HR\",\"brand\":\"Michelin\",\"model\":\"Pilot Alpin 5 SUV\",\"size\":\"235\\/55R19\",\"dot\":\"2722\",\"recommendation\":\"Sehr gut\",\"profileInner\":\"\",\"profileMiddle\":\"4.5 mm\",\"profileOuter\":\"5.9 mm\"}],\"newTires\":[{\"id\":1,\"brand\":\"1\",\"euLabel\":\"1\",\"size\":\"1\",\"price\":1,\"mounting\":1,\"quantity\":4,\"total\":8}],\"selectedServices\":[31]}', NULL, 'dobbratz@be-automobile.de', 'Reifenangebot - Boxenstop', '2025-10-14 10:31:14', '2025-10-14 10:33:57'),
('36', NULL, '103391', NULL, '1', 'admin', 'created', '0', '0', NULL, NULL, NULL, '{\"wheelset_number\":\"103391\",\"customer_name\":\"-\",\"license_plate\":\"M-UH999\",\"vin\":\"W0L000051T2125002\",\"oldTires\":[{\"position\":\"VR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"dimension\":\"150\\/-R15\",\"profile\":\"-\",\"pressure\":\"-\"},{\"position\":\"HR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"dimension\":\"150\\/-R15\",\"profile\":\"-\",\"pressure\":\"-\"}],\"newTires\":[{\"manufacturer\":\"123\",\"euLabel\":\"123\",\"dimension\":\"123\",\"rf\":\"\",\"price\":150,\"mountingPrice\":10,\"quantity\":4,\"total\":640}],\"selectedServices\":[40],\"offerText\":\"Sehr geehrte Damen und Herren,\\n\\ndie Vorbereitungen f\\u00fcr unseren n\\u00e4chsten Boxenstopp laufen bereits und dabei ist uns leider aufgefallen, dass die bei uns eingelagerten Reifen ersetzt werden m\\u00fcssten.\\n\\nDaher erhalten Sie mit diesem Schreiben das beigef\\u00fcgte Angebot.\\n\\nMit freundlichen Gr\\u00fc\\u00dfen\\n-\"}', NULL, NULL, NULL, '2025-11-02 12:26:14', '2025-11-02 13:00:15');


-- Table structure for `offer_wheels`
DROP TABLE IF EXISTS `offer_wheels`;
CREATE TABLE `offer_wheels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL COMMENT 'Angebot-ID',
  `wheelset_number` varchar(50) NOT NULL COMMENT 'Radsatz-Nummer',
  `wheel_position` varchar(10) NOT NULL COMMENT 'Position (VL, VR, HL, HR)',
  `wheel_key` varchar(100) DEFAULT NULL COMMENT 'Eindeutiger Key des Reifens',
  `manufacturer` varchar(100) DEFAULT NULL COMMENT 'Marke',
  `model` varchar(100) DEFAULT NULL COMMENT 'Modell',
  `size` varchar(50) DEFAULT NULL COMMENT 'Größe (z.B. 225/45R17)',
  `profile` decimal(5,1) DEFAULT NULL COMMENT 'Profiltiefe in mm',
  `width` int(11) DEFAULT NULL COMMENT 'Reifenbreite',
  `ratio` int(11) DEFAULT NULL COMMENT 'Höhen-Breiten-Verhältnis',
  `diameter` int(11) DEFAULT NULL COMMENT 'Felgendurchmesser',
  `unit_price` decimal(10,2) DEFAULT 0.00 COMMENT 'Einzelpreis',
  `quantity` int(11) DEFAULT 1 COMMENT 'Anzahl',
  `total_price` decimal(10,2) DEFAULT 0.00 COMMENT 'Gesamtpreis (Einzelpreis * Anzahl)',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_wheelset_number` (`wheelset_number`),
  CONSTRAINT `offer_wheels_ibfk_1` FOREIGN KEY (`offer_id`) REFERENCES `offers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `offer_wheels`

-- Table structure for `offers`
DROP TABLE IF EXISTS `offers`;
CREATE TABLE `offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wheelset_number` varchar(50) NOT NULL COMMENT 'Radsatz-Nummer',
  `autohaus_id` int(11) NOT NULL COMMENT 'Autohaus ID',
  `customer_name` varchar(255) NOT NULL COMMENT 'Kundenname',
  `customer_email` varchar(255) NOT NULL COMMENT 'Kunden-E-Mail',
  `customer_phone` varchar(50) DEFAULT NULL COMMENT 'Kunden-Telefon',
  `autohaus_name` varchar(255) DEFAULT NULL COMMENT 'Autohaus-Name',
  `status` enum('draft','sent','accepted','declined') DEFAULT 'draft' COMMENT 'Status',
  `offer_text` text DEFAULT NULL COMMENT 'Angebotstext (HTML/Freitext)',
  `old_tires_condition` varchar(255) DEFAULT NULL COMMENT 'Zustand alter Reifen',
  `old_tires_description` text DEFAULT NULL COMMENT 'Beschreibung alter Reifen',
  `total_price` decimal(10,2) DEFAULT 0.00 COMMENT 'Gesamtpreis',
  `currency` varchar(3) DEFAULT 'EUR' COMMENT 'Währung',
  `token` varchar(64) DEFAULT NULL COMMENT 'Eindeutiger Token für Kundenlink',
  `token_expires_at` datetime DEFAULT NULL COMMENT 'Token-Ablaufzeit (24h)',
  `email_sent_at` datetime DEFAULT NULL COMMENT 'Zeitpunkt der E-Mail-Versendung',
  `email_status` varchar(50) DEFAULT NULL COMMENT 'E-Mail-Status (sent, failed, pending)',
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID des Erstellers',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_wheelset_number` (`wheelset_number`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_token` (`token`),
  KEY `idx_status` (`status`),
  KEY `idx_email_sent_at` (`email_sent_at`),
  KEY `idx_created_at` (`created_at`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `offers_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `offers_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `offers`

-- Table structure for `onboarding_progress`
DROP TABLE IF EXISTS `onboarding_progress`;
CREATE TABLE `onboarding_progress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `step_name` varchar(50) NOT NULL,
  `completed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `step_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`step_data`)),
  PRIMARY KEY (`id`),
  KEY `idx_user_step` (`user_id`,`step_name`),
  CONSTRAINT `onboarding_progress_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `onboarding_progress`

-- Table structure for `order_comments`
DROP TABLE IF EXISTS `order_comments`;
CREATE TABLE `order_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `comment_type` enum('internal','customer','system') DEFAULT 'internal',
  `comment` text NOT NULL,
  `is_important` tinyint(1) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  KEY `idx_created_at` (`created_at`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `order_comments_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_comments_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `order_comments`

-- Table structure for `order_items`
DROP TABLE IF EXISTS `order_items`;
CREATE TABLE `order_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `item_type` enum('tire','service','wheelset','other') NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `item_description` text DEFAULT NULL,
  `quantity` int(11) DEFAULT 1,
  `unit_price` decimal(10,2) DEFAULT 0.00,
  `total_price` decimal(10,2) DEFAULT 0.00,
  `item_data` text DEFAULT NULL COMMENT 'JSON mit spezifischen Item-Daten',
  `status` enum('pending','ordered','in_stock','ready','completed','cancelled') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  KEY `idx_status` (`status`),
  CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `order_items`

-- Table structure for `order_offers`
DROP TABLE IF EXISTS `order_offers`;
CREATE TABLE `order_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `offer_id` int(11) DEFAULT NULL COMMENT 'Verknüpfung zu wheelset_offers oder anderen Angeboten',
  `offer_type` enum('wheelset_offer','general_offer','other') DEFAULT 'general_offer',
  `offer_data` text DEFAULT NULL COMMENT 'JSON mit Angebotsdaten',
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  KEY `idx_offer_id` (`offer_id`),
  CONSTRAINT `order_offers_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `order_offers`

-- Table structure for `order_status_history`
DROP TABLE IF EXISTS `order_status_history`;
CREATE TABLE `order_status_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `old_status` varchar(50) DEFAULT NULL,
  `new_status` varchar(50) NOT NULL,
  `changed_by` int(11) DEFAULT NULL,
  `notes` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_order_id` (`order_id`),
  KEY `idx_created_at` (`created_at`),
  KEY `changed_by` (`changed_by`),
  CONSTRAINT `order_status_history_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `order_status_history_ibfk_2` FOREIGN KEY (`changed_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `order_status_history`

-- Table structure for `orders`
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_number` varchar(50) NOT NULL COMMENT 'Eindeutige Auftragsnummer',
  `autohaus_id` int(11) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `customer_no` varchar(50) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(20) DEFAULT NULL,
  `license_plate` varchar(20) DEFAULT NULL,
  `vin` varchar(50) DEFAULT NULL,
  `vehicle_brand` varchar(100) DEFAULT NULL,
  `vehicle_model` varchar(100) DEFAULT NULL,
  `order_type` enum('tire_order','service_order','wheelset_order','mixed','other') DEFAULT 'other',
  `description` text DEFAULT NULL COMMENT 'Auftragsbeschreibung',
  `priority` enum('low','normal','high','urgent') DEFAULT 'normal',
  `status` enum('new','in_progress','pending_customer','pending_approval','completed','cancelled','on_hold') DEFAULT 'new',
  `assigned_to` int(11) DEFAULT NULL COMMENT 'Zugewiesen an User ID',
  `assigned_team` varchar(100) DEFAULT NULL COMMENT 'Zugewiesenes Team',
  `estimated_completion_date` date DEFAULT NULL,
  `actual_completion_date` date DEFAULT NULL,
  `order_data` text DEFAULT NULL COMMENT 'JSON mit Auftragsdetails, Positionen, etc.',
  `internal_notes` text DEFAULT NULL COMMENT 'Interne Notizen',
  `customer_notes` text DEFAULT NULL COMMENT 'Kundennotizen',
  `teams_notification_sent` tinyint(1) DEFAULT 0,
  `teams_message_id` varchar(255) DEFAULT NULL,
  `teams_thread_id` varchar(255) DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `currency` varchar(3) DEFAULT 'EUR',
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID des Erstellers',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  UNIQUE KEY `idx_order_number` (`order_number`),
  KEY `idx_autohaus` (`autohaus_id`),
  KEY `idx_status` (`status`),
  KEY `idx_assigned_to` (`assigned_to`),
  KEY `idx_priority` (`priority`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_order_type` (`order_type`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `orders_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `orders_ibfk_3` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `orders`

-- Table structure for `p2_customers`
DROP TABLE IF EXISTS `p2_customers`;
CREATE TABLE `p2_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `kunden_adr_id` int(11) NOT NULL,
  `kunden_name1` varchar(255) DEFAULT NULL,
  `kunden_vorname` varchar(255) DEFAULT NULL,
  `kunden_strasse` varchar(255) DEFAULT NULL,
  `kunden_plz` varchar(20) DEFAULT NULL,
  `kunden_ort` varchar(255) DEFAULT NULL,
  `telefon` varchar(50) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `anzahl_auftraege` int(11) DEFAULT 0,
  `gesamt_umsatz` decimal(10,2) DEFAULT 0.00,
  `status` varchar(50) DEFAULT 'aktiv',
  `notizen` text DEFAULT NULL,
  `archiviert` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_customer_autohaus` (`kunden_adr_id`,`autohaus_id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_kunden_adr_id` (`kunden_adr_id`),
  KEY `idx_archiviert` (`archiviert`),
  KEY `idx_status` (`status`),
  CONSTRAINT `p2_customers_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `p2_customers`

-- Table structure for `p2_teilenr_mapping`
DROP TABLE IF EXISTS `p2_teilenr_mapping`;
CREATE TABLE `p2_teilenr_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ean` varchar(50) DEFAULT NULL,
  `oem_part_number` varchar(100) DEFAULT NULL,
  `manufacturer_number` varchar(100) DEFAULT NULL,
  `part_number` varchar(100) DEFAULT NULL,
  `p2_teilenr` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_ean` (`ean`),
  UNIQUE KEY `unique_oem_part_number` (`oem_part_number`),
  UNIQUE KEY `unique_manufacturer_number` (`manufacturer_number`),
  UNIQUE KEY `unique_part_number` (`part_number`),
  KEY `idx_p2_teilenr` (`p2_teilenr`),
  KEY `idx_ean` (`ean`),
  KEY `idx_oem_part_number` (`oem_part_number`),
  KEY `idx_manufacturer_number` (`manufacturer_number`),
  KEY `idx_part_number` (`part_number`)
) ENGINE=InnoDB AUTO_INCREMENT=547 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `p2_teilenr_mapping`
INSERT INTO `p2_teilenr_mapping` (`id`, `ean`, `oem_part_number`, `manufacturer_number`, `part_number`, `p2_teilenr`, `created_at`, `updated_at`) VALUES
('1', '4019238322378', NULL, '0316014000', NULL, 'RE0316014000', '2025-11-22 11:15:53', '2025-11-22 11:15:53'),
('2', '4019238036954', NULL, '0311209000', NULL, 'RE0311209000', '2025-11-22 12:31:26', '2025-11-22 12:31:26'),
('4', '3188649820504', NULL, '528970', NULL, 'VOGODUN528970', '2025-11-22 12:35:40', '2025-11-22 12:35:40'),
('5', '5452000448125', NULL, '530998', NULL, 'VOGOFUL530998', '2025-11-22 12:35:53', '2025-11-22 12:35:53'),
('6', '5452000655943', NULL, '528521', NULL, 'VOGODUN528521', '2025-11-22 12:36:06', '2025-11-22 12:36:06'),
('7', '4038526321824', NULL, '565776', NULL, 'VODUDUN565776', '2025-11-22 12:36:50', '2025-11-22 12:36:50'),
('8', '3188649811571', NULL, '526898', NULL, 'VOGODUN526898', '2025-11-22 12:37:04', '2025-11-22 12:37:04'),
('9', '3188649819256', NULL, '528523', NULL, 'VOGODUN528523', '2025-11-22 12:37:17', '2025-11-22 12:37:17'),
('10', '8019227205602', NULL, '2056000', NULL, 'VOPIPIR2056000', '2025-11-22 12:37:30', '2025-11-22 12:37:30'),
('11', '5452000421227', NULL, '529227', NULL, 'VO3529227', '2025-11-22 12:37:44', '2025-11-22 12:37:44'),
('12', '8019227227284', NULL, '2272800', NULL, 'VOPIPIR2272800', '2025-11-22 12:37:57', '2025-11-22 12:37:57'),
('13', '8019227212389', NULL, '2123800', NULL, 'VOPIPIR2123800', '2025-11-22 12:38:41', '2025-11-22 12:38:41'),
('14', '4038526320360', NULL, '523186', NULL, 'VODUDUN523186', '2025-11-22 12:39:24', '2025-11-22 12:39:24'),
('15', '5452000448675', NULL, '531028', NULL, 'VOWUWUE0715531028', '2025-11-22 12:39:37', '2025-11-22 12:39:37'),
('16', '3188649818754', NULL, '528461', NULL, 'VOGODUN528461', '2025-11-22 12:39:51', '2025-11-22 12:39:51'),
('17', '3528701117232', NULL, '111723', NULL, 'VO11111723', '2025-11-22 12:40:04', '2025-11-22 12:40:04'),
('18', '8019227190137', NULL, '1901300', NULL, 'VOPIPIR1901300', '2025-11-22 12:40:18', '2025-11-22 12:40:18'),
('19', '5452000448644', NULL, '531023', NULL, 'VOGOFUL531023', '2025-11-22 12:40:31', '2025-11-22 12:40:31'),
('20', '8019227191660', NULL, '1916600', NULL, 'VOPIPIR1916600', '2025-11-22 12:40:45', '2025-11-22 12:40:45'),
('21', '8019227182538', NULL, '1825300', NULL, 'VOPIPIR1825300', '2025-11-22 12:40:59', '2025-11-22 12:40:59'),
('22', '3188649818938', NULL, '528478', NULL, 'VO3528478', '2025-11-22 12:41:42', '2025-11-22 12:41:42'),
('23', '8019227190144', NULL, '1901400', NULL, 'VOPIPIR1901400', '2025-11-22 12:41:56', '2025-11-22 12:41:56'),
('24', '3188649819263', NULL, '528524', NULL, 'VOGODUN528524', '2025-11-22 12:42:54', '2025-11-22 12:42:54'),
('25', '5452000655622', NULL, '528503', NULL, 'VO3528503', '2025-11-22 12:43:08', '2025-11-22 12:43:08'),
('26', '3528703783473', NULL, '378347', NULL, 'VOMIMIC378347', '2025-11-22 12:43:51', '2025-11-22 12:43:51'),
('27', '5452000391490', NULL, '526808', NULL, 'VOGOFUL526808', '2025-11-22 12:44:04', '2025-11-22 12:44:04'),
('28', '5452000367068', NULL, '522664', NULL, 'VOGOFUL522664', '2025-11-22 12:44:18', '2025-11-22 12:44:18'),
('29', '3528709809566', NULL, '980956', NULL, 'VO39809564', '2025-11-22 12:45:31', '2025-11-22 12:45:31'),
('30', '8019227233223', NULL, '2332200', NULL, 'VOPIPIR2332200', '2025-11-22 12:45:45', '2025-11-22 12:45:45'),
('31', '3188649819287', NULL, '528526', NULL, 'VOGODUN528526', '2025-11-22 12:45:58', '2025-11-22 12:45:58'),
('32', '5452000366238', NULL, '522323', NULL, 'VOGOFUL522323', '2025-11-22 12:46:11', '2025-11-22 12:46:11'),
('33', '5452000429780', NULL, '529568', NULL, 'VOGODUN529568', '2025-11-22 12:46:25', '2025-11-22 12:46:25'),
('34', '3528706901355', NULL, '690135', NULL, 'VOMIMIC690135', '2025-11-22 12:46:38', '2025-11-22 12:46:38'),
('35', '4038526409027', NULL, '595476', NULL, 'VOGODUN595476', '2025-11-22 12:47:52', '2025-11-22 12:47:52'),
('36', '3286340564717', NULL, '5647', NULL, 'VO1295647', '2025-11-22 12:48:05', '2025-11-22 12:48:05'),
('37', '8019227253962', NULL, '2539600', NULL, 'REPIPIR2539600', '2025-11-22 12:48:19', '2025-11-22 12:48:19'),
('39', '3286342748214', NULL, '27482', NULL, 'VO31274828', '2025-11-22 12:49:25', '2025-11-22 12:49:25'),
('40', '5452000485557', NULL, '532207', NULL, 'VOGOSAV532207', '2025-11-22 12:50:09', '2025-11-22 12:50:09'),
('41', '3286342033013', NULL, '20330', NULL, 'VO1203303', '2025-11-22 12:50:50', '2025-11-22 12:50:50'),
('42', '3528708612853', NULL, '861285', NULL, 'VO8612855', '2025-11-22 12:51:03', '2025-11-22 12:51:03'),
('43', '5452000485519', NULL, '532348', NULL, 'VOGODUN532348', '2025-11-22 12:51:16', '2025-11-22 12:51:16'),
('44', '3286340599511', NULL, '5995', NULL, 'VO1159954', '2025-11-22 12:52:00', '2025-11-22 12:52:00'),
('45', '3286340655316', NULL, '6553', NULL, 'VOWUWUE06553', '2025-11-22 12:52:13', '2025-11-22 12:52:13'),
('46', '8019227282177', NULL, '2821700', NULL, 'VOPIPIR2821700', '2025-11-22 12:52:57', '2025-11-22 12:52:57'),
('47', '3286341766011', NULL, '17660', NULL, 'VO121766066', '2025-11-22 12:53:41', '2025-11-22 12:53:41'),
('48', '5452000470522', NULL, '532002', NULL, 'VOGODUN532002', '2025-11-22 12:54:54', '2025-11-22 12:54:54'),
('49', '3286340221313', NULL, '2213', NULL, 'VO32213162', '2025-11-22 12:55:08', '2025-11-22 12:55:08'),
('50', '3286342033211', NULL, '20332', NULL, 'VO1203320', '2025-11-22 12:55:21', '2025-11-22 12:55:21'),
('51', '3286340676618', NULL, '6766', NULL, 'VO31676617', '2025-11-22 12:55:35', '2025-11-22 12:55:35'),
('52', '3286340655613', NULL, '6556', NULL, 'VO32266556', '2025-11-22 12:56:15', '2025-11-22 12:56:15'),
('53', '3528708260191', NULL, '826019', NULL, 'VOMIMIC826019', '2025-11-22 12:56:28', '2025-11-22 12:56:28'),
('54', '3286340880114', NULL, '8801', NULL, 'VO32288017', '2025-11-22 12:57:53', '2025-11-22 12:57:53'),
('55', '3286340891912', NULL, '8919', NULL, 'VO1308919', '2025-11-22 12:59:33', '2025-11-22 12:59:33'),
('56', '3528707640697', NULL, '764069', NULL, 'VO30764069', '2025-11-22 13:02:13', '2025-11-22 13:02:13'),
('57', '5452000807236', NULL, '548013', NULL, 'VO3548013', '2025-11-22 13:02:27', '2025-11-22 13:02:27'),
('58', '3286342244013', NULL, '22440', NULL, 'VO32224407', '2025-11-22 13:03:40', '2025-11-22 13:03:40'),
('59', '3528704546534', NULL, '454653', NULL, 'VO31454653', '2025-11-22 13:03:54', '2025-11-22 13:03:54'),
('60', '3286342033518', NULL, '20335', NULL, 'VO30720335', '2025-11-22 13:04:37', '2025-11-22 13:04:37'),
('61', '4038526336583', NULL, '586273', NULL, 'VOGOGOD586273', '2025-11-22 13:05:48', '2025-11-22 13:05:48'),
('62', '4038526343697', NULL, '587146', NULL, 'VOGOFUL587146', '2025-11-22 13:07:01', '2025-11-22 13:07:01'),
('63', '3286342054216', NULL, '20542', NULL, 'VO30620542', '2025-11-22 13:07:15', '2025-11-22 13:07:15'),
('64', '3286342840314', NULL, '28403', NULL, 'VO30728403', '2025-11-22 13:07:28', '2025-11-22 13:07:28'),
('65', '3286340296113', NULL, '2961', NULL, 'VO32296100', '2025-11-22 13:08:12', '2025-11-22 13:08:12'),
('66', '8019227413595', NULL, '4135900', NULL, 'VOPIPIR4135900', '2025-11-22 13:09:23', '2025-11-22 13:09:23'),
('67', '4038526020536', NULL, '576022', NULL, 'VOGOGOD576022', '2025-11-22 13:09:36', '2025-11-22 13:09:36'),
('68', '3286342033617', NULL, '20336', NULL, 'VO1220336', '2025-11-22 13:09:49', '2025-11-22 13:09:49'),
('69', '3286342828312', NULL, '28283', NULL, 'VO31428283', '2025-11-22 13:10:30', '2025-11-22 13:10:30'),
('70', '3286341937510', NULL, '19375', NULL, 'VO1219375', '2025-11-22 13:13:34', '2025-11-22 13:13:34'),
('71', '3286342389813', NULL, '23898', NULL, 'VOFOFOE1623898', '2025-11-22 13:14:18', '2025-11-22 13:14:18'),
('72', '3528708454484', NULL, '845448', NULL, 'VO39845448', '2025-11-22 13:14:31', '2025-11-22 13:14:31'),
('73', '3286340841016', NULL, '8410', NULL, 'VO32248410', '2025-11-22 13:14:45', '2025-11-22 13:14:45'),
('74', '3286340729819', NULL, '7298', NULL, 'VO1272986', '2025-11-22 13:14:58', '2025-11-22 13:14:58'),
('75', '3286342280417', NULL, '22804', NULL, 'VO8622804', '2025-11-22 13:17:35', '2025-11-22 13:17:35'),
('76', '3528707446343', NULL, '744634', NULL, 'VOMIMIC744634', '2025-11-22 13:17:49', '2025-11-22 13:17:49'),
('77', '4038526407993', NULL, '595491', NULL, 'VOMIMIC595491', '2025-11-22 13:19:26', '2025-11-22 13:19:26'),
('78', '3528706032172', NULL, '603217', NULL, 'VO8603217', '2025-11-22 13:19:39', '2025-11-22 13:19:39'),
('79', '3286341883619', NULL, '18836', NULL, 'VO1188364', '2025-11-22 13:19:52', '2025-11-22 13:19:52'),
('80', '3286342054018', NULL, '20540', NULL, 'VO32220540', '2025-11-22 13:21:06', '2025-11-22 13:21:06'),
('81', '5452000470164', NULL, '531971', NULL, 'VOGODEB531971', '2025-11-22 13:22:20', '2025-11-22 13:22:20'),
('82', '3286342053912', NULL, '20539', NULL, 'VO32205391', '2025-11-22 13:23:33', '2025-11-22 13:23:33'),
('83', '3286340619219', NULL, '6192', NULL, 'VO1286192', '2025-11-22 13:25:14', '2025-11-22 13:25:14'),
('84', '3286342149813', NULL, '21498', NULL, 'VO32149844', '2025-11-22 13:25:27', '2025-11-22 13:25:27'),
('85', '3286341883510', NULL, '18835', NULL, 'VO31418835', '2025-11-22 13:25:40', '2025-11-22 13:25:40'),
('86', '3528704861323', NULL, '486132', NULL, 'VO3486132', '2025-11-22 13:26:54', '2025-11-22 13:26:54'),
('87', '3286341937411', NULL, '19374', NULL, 'VO30619374', '2025-11-22 13:27:49', '2025-11-22 13:27:49'),
('88', '3286341535914', NULL, '15359', NULL, 'VO31415359', '2025-11-22 13:28:29', '2025-11-22 13:28:29'),
('89', '3286340488310', NULL, '4883', NULL, 'VO32144883', '2025-11-22 13:29:42', '2025-11-22 13:29:42'),
('90', '4038526407986', NULL, '595490', NULL, 'VOGODUN595490', '2025-11-22 13:30:52', '2025-11-22 13:30:52'),
('91', '5452000829825', NULL, '574271', NULL, 'VOGOFUL574271', '2025-11-22 13:31:32', '2025-11-22 13:31:32'),
('92', '3286343109816', NULL, '31098', NULL, 'VO1310988', '2025-11-22 13:32:15', '2025-11-22 13:32:15'),
('93', '3286340767118', NULL, '7671', NULL, 'VO31497671', '2025-11-22 13:32:55', '2025-11-22 13:32:55'),
('94', '3286342053813', NULL, '20538', NULL, 'VO32205389', '2025-11-22 13:33:09', '2025-11-22 13:33:09'),
('95', '3286341935714', NULL, '19357', NULL, 'VO31319357', '2025-11-22 13:33:22', '2025-11-22 13:33:22'),
('96', '4038526420596', NULL, '596475', NULL, 'VOGODUN596475', '2025-11-22 13:33:35', '2025-11-22 13:33:35'),
('97', '4038526020130', NULL, '575958', NULL, 'VOGODUN575958', '2025-11-22 13:35:12', '2025-11-22 13:35:12'),
('98', '3286342033815', NULL, '20338', NULL, 'VO31420338', '2025-11-22 13:35:56', '2025-11-22 13:35:56'),
('99', '3286340214117', NULL, '2141', NULL, 'VO32141125', '2025-11-22 13:36:09', '2025-11-22 13:36:09'),
('100', '3286341937312', NULL, '19373', NULL, 'VO32219373', '2025-11-22 13:37:23', '2025-11-22 13:37:23'),
('101', '5452000470126', NULL, '531967', NULL, 'VOGOSAV531967', '2025-11-22 13:38:06', '2025-11-22 13:38:06'),
('102', '3286341806519', NULL, '18065', NULL, 'VO30618065', '2025-11-22 13:38:50', '2025-11-22 13:38:50'),
('103', '5452000470119', NULL, '531966', NULL, 'VOGOSAV531966', '2025-11-22 13:39:33', '2025-11-22 13:39:33'),
('104', '8019227263862', NULL, '2638600', NULL, 'VOPIPIR2638600', '2025-11-22 13:39:46', '2025-11-22 13:39:46'),
('105', '3286341406313', NULL, '14063', NULL, 'VO30714063', '2025-11-22 13:40:27', '2025-11-22 13:40:27'),
('106', '5452000470102', NULL, '531965', NULL, 'VOGOSAV531965', '2025-11-22 13:42:52', '2025-11-22 13:42:52'),
('107', '4038526421616', NULL, '596487', NULL, 'VOGODUN596487', '2025-11-22 13:43:05', '2025-11-22 13:43:05'),
('108', '3286342053615', NULL, '20536', NULL, 'VO30620536', '2025-11-22 13:43:19', '2025-11-22 13:43:19'),
('109', '3286341406511', NULL, '14065', NULL, 'VO30714065', '2025-11-22 13:43:32', '2025-11-22 13:43:32'),
('110', '3286342157610', NULL, '21576', NULL, 'VO31215760', '2025-11-22 13:43:46', '2025-11-22 13:43:46'),
('111', '3286342325712', NULL, '23257', NULL, 'VO30723257', '2025-11-22 13:43:59', '2025-11-22 13:43:59'),
('112', '5452000470096', NULL, '531964', NULL, 'VOGOSAV531964', '2025-11-22 13:44:43', '2025-11-22 13:44:43'),
('113', '8019227206555', NULL, '2065500', NULL, 'VOPIPIR2065500', '2025-11-22 13:44:56', '2025-11-22 13:44:56'),
('114', '3286340647212', NULL, '6472', NULL, 'VO1246472', '2025-11-22 13:46:06', '2025-11-22 13:46:06'),
('115', '4038526421791', NULL, '596503', NULL, 'VOGODUN596503', '2025-11-22 13:47:12', '2025-11-22 13:47:12'),
('116', '5452000433534', NULL, '529774', NULL, 'VO3529774', '2025-11-22 13:47:56', '2025-11-22 13:47:56'),
('117', '3286340855815', NULL, '8558', NULL, 'VO1288558', '2025-11-22 13:48:09', '2025-11-22 13:48:09'),
('118', '3286342034119', NULL, '20341', NULL, 'VO3520341', '2025-11-22 13:49:23', '2025-11-22 13:49:23'),
('119', '3286340971317', NULL, '9713', NULL, 'VO32297136', '2025-11-22 13:49:36', '2025-11-22 13:49:36'),
('120', '3286340781213', NULL, '7812', NULL, 'VO32147812', '2025-11-22 13:51:10', '2025-11-22 13:51:10'),
('121', '3286342670713', NULL, '26707', NULL, 'VO1326707', '2025-11-22 13:51:23', '2025-11-22 13:51:23'),
('122', '8019227263916', NULL, '2639100', NULL, 'VOPIPIR2639100', '2025-11-22 13:51:37', '2025-11-22 13:51:37'),
('123', '3286340428712', NULL, '4287', NULL, 'VO32142871', '2025-11-22 13:52:20', '2025-11-22 13:52:20'),
('124', '8019227282153', NULL, '2821500', NULL, 'VOPIPIR2821500', '2025-11-22 13:52:33', '2025-11-22 13:52:33'),
('125', '5452000470089', NULL, '531963', NULL, 'VOGOSAV531963', '2025-11-22 13:52:47', '2025-11-22 13:52:47'),
('126', '3286342927411', NULL, '29274', NULL, 'VO31429274', '2025-11-22 13:53:00', '2025-11-22 13:53:00'),
('127', '3286342842110', NULL, '28421', NULL, 'VO1228421', '2025-11-22 13:53:15', '2025-11-22 13:53:15'),
('128', '3528706510717', NULL, '651071', NULL, 'VO30651071', '2025-11-22 13:53:28', '2025-11-22 13:53:28'),
('129', '3286342034218', NULL, '20342', NULL, 'VO3520342', '2025-11-22 13:53:42', '2025-11-22 13:53:42'),
('130', '8019227168860', NULL, '1688600', NULL, 'VOPIPIR1688600', '2025-11-22 13:53:55', '2025-11-22 13:53:55'),
('131', '3286340729611', NULL, '7296', NULL, 'VO1257296', '2025-11-22 13:54:39', '2025-11-22 13:54:39'),
('132', '3286342386218', NULL, '23862', NULL, 'VO31323862', '2025-11-22 13:55:22', '2025-11-22 13:55:22'),
('133', '3286342053516', NULL, '20535', NULL, 'VO3205355', '2025-11-22 13:55:36', '2025-11-22 13:55:36'),
('134', '3286342034317', NULL, '20343', NULL, 'VO30720343', '2025-11-22 13:55:49', '2025-11-22 13:55:49'),
('135', '3286340495318', NULL, '4953', NULL, 'VO1264953', '2025-11-22 13:56:03', '2025-11-22 13:56:03'),
('136', '3286342121017', NULL, '21210', NULL, 'VO3121210', '2025-11-22 13:56:46', '2025-11-22 13:56:46'),
('137', '3286340729116', NULL, '7291', NULL, 'VOWUWUE0997729127', '2025-11-22 13:57:00', '2025-11-22 13:57:00'),
('138', '3286342459615', NULL, '24596', NULL, 'VO30824596', '2025-11-22 13:57:13', '2025-11-22 13:57:13'),
('139', '3286342032917', NULL, '20329', NULL, 'VO30720329', '2025-11-22 13:57:28', '2025-11-22 13:57:28'),
('140', '3286342034416', NULL, '20344', NULL, 'VO120344', '2025-11-22 13:58:09', '2025-11-22 13:58:09'),
('141', '8019227413588', NULL, '4135800', NULL, 'VOPIPIR4135800', '2025-11-22 13:58:22', '2025-11-22 13:58:22'),
('142', '8019227412208', NULL, '4122000', NULL, 'REPI4122000', '2025-11-22 13:58:35', '2025-11-22 13:58:35'),
('144', '3286342277912', NULL, '22779', NULL, 'VO32277960', '2025-11-22 13:58:49', '2025-11-22 13:58:49'),
('145', '3286342672113', NULL, '26721', NULL, 'VO3526721', '2025-11-22 13:59:32', '2025-11-22 13:59:32'),
('146', '3286342390413', NULL, '23904', NULL, 'VO30623904', '2025-11-22 13:59:46', '2025-11-22 13:59:46'),
('147', '5452000470072', NULL, '531962', NULL, 'VOGOSAV531962', '2025-11-22 13:59:59', '2025-11-22 13:59:59'),
('148', '3286340495516', NULL, '4955', NULL, 'VO1154955', '2025-11-22 14:00:15', '2025-11-22 14:00:15'),
('149', '8019227411737', NULL, '4117300', NULL, 'VOPIPIR4117300', '2025-11-22 14:00:28', '2025-11-22 14:00:28'),
('150', '3286340509619', NULL, '5096', NULL, 'VO1215096', '2025-11-22 14:00:41', '2025-11-22 14:00:41'),
('151', '8019227434781', NULL, '4347800', NULL, 'VOPIPIR4347800', '2025-11-22 14:00:55', '2025-11-22 14:00:55'),
('152', '5452000470058', NULL, '531960', NULL, 'VOGOFUL531960', '2025-11-22 14:02:05', '2025-11-22 14:02:05'),
('153', '3286342034515', NULL, '20345', NULL, 'VO30720345', '2025-11-22 14:02:18', '2025-11-22 14:02:18'),
('154', '3286342386713', NULL, '23867', NULL, 'VO30723867', '2025-11-22 14:03:02', '2025-11-22 14:03:02'),
('155', '8019227256956', NULL, '2569500', NULL, 'VOPIPIR2569500', '2025-11-22 14:03:42', '2025-11-22 14:03:42'),
('156', '3286340728911', NULL, '7289', NULL, 'VO1272893', '2025-11-22 14:03:55', '2025-11-22 14:03:55'),
('157', '3286342034812', NULL, '20348', NULL, 'VO1320348', '2025-11-22 14:05:32', '2025-11-22 14:05:32'),
('158', '3286341003017', NULL, '10030', NULL, 'VO1310030', '2025-11-22 14:05:46', '2025-11-22 14:05:46'),
('159', '3286342386812', NULL, '23868', NULL, 'VO30623868', '2025-11-22 14:06:25', '2025-11-22 14:06:25'),
('160', '3286341881516', NULL, '18815', NULL, 'VO31218815', '2025-11-22 14:07:09', '2025-11-22 14:07:09'),
('161', '3286341881615', NULL, '18816', NULL, 'VO31218816', '2025-11-22 14:07:22', '2025-11-22 14:07:22'),
('162', '4038526421821', NULL, '596506', NULL, 'VOGODUN596506', '2025-11-22 14:07:36', '2025-11-22 14:07:36'),
('163', '8019227376975', NULL, '3769700', NULL, 'VOPIPIR3769700', '2025-11-22 14:08:20', '2025-11-22 14:08:20'),
('164', '3286342828213', NULL, '28282', NULL, 'VO31428282', '2025-11-22 14:08:33', '2025-11-22 14:08:33'),
('165', '3286340998017', NULL, '9980', NULL, 'VO32209980', '2025-11-22 14:08:47', '2025-11-22 14:08:47'),
('166', '3286342386911', NULL, '23869', NULL, 'VO30623869', '2025-11-22 14:09:00', '2025-11-22 14:09:00'),
('167', '8019227163926', NULL, '1639200', NULL, 'VOPIPIR1639200', '2025-11-22 14:09:13', '2025-11-22 14:09:13'),
('168', '3286342053318', NULL, '20533', NULL, 'VO32220533', '2025-11-22 14:09:27', '2025-11-22 14:09:27'),
('169', '8019227376951', NULL, '3769500', NULL, 'VOPIPIR3769500', '2025-11-22 14:09:40', '2025-11-22 14:09:40'),
('170', '3286341338218', NULL, '13382', NULL, 'VO1338248', '2025-11-22 14:09:54', '2025-11-22 14:09:54'),
('171', '3286341897616', NULL, '18976', NULL, 'VO31218976', '2025-11-22 14:10:37', '2025-11-22 14:10:37'),
('172', '3286340730013', NULL, '7300', NULL, 'VOWUWUE0557300252', '2025-11-22 14:11:21', '2025-11-22 14:11:21'),
('173', '3286340876315', NULL, '8763', NULL, 'VOMIBFG218763', '2025-11-22 14:12:43', '2025-11-22 14:12:43'),
('174', '3286342387215', NULL, '23872', NULL, 'VO9123872', '2025-11-22 14:12:56', '2025-11-22 14:12:56'),
('175', '3286342387314', NULL, '23873', NULL, 'VO30723873', '2025-11-22 14:14:10', '2025-11-22 14:14:10'),
('176', '3286340965316', NULL, '9653', NULL, 'VO1239653', '2025-11-22 14:14:53', '2025-11-22 14:14:53'),
('177', '3528703526346', NULL, '352634', NULL, 'VO31352634', '2025-11-22 14:15:34', '2025-11-22 14:15:34'),
('178', '3286342387611', NULL, '23876', NULL, 'VO238762', '2025-11-22 14:15:47', '2025-11-22 14:15:47'),
('179', '3286342872315', NULL, '28723', NULL, 'VO32287236', '2025-11-22 14:16:01', '2025-11-22 14:16:01'),
('180', '3528706760655', NULL, '676065', NULL, 'VO31676065', '2025-11-22 14:16:44', '2025-11-22 14:16:44'),
('181', '5452000473585', NULL, '532079', NULL, 'VOGOGOD532079', '2025-11-22 14:16:58', '2025-11-22 14:16:58'),
('182', '3286341897814', NULL, '18978', NULL, 'VO31218978', '2025-11-22 14:17:11', '2025-11-22 14:17:11'),
('183', '5452000807229', NULL, '547992', NULL, 'VOGOGOD547992', '2025-11-22 14:17:55', '2025-11-22 14:17:55'),
('184', '4038526068972', NULL, '580727', NULL, 'VOGOGOD580727', '2025-11-22 14:18:08', '2025-11-22 14:18:08'),
('185', '3286342387710', NULL, '23877', NULL, 'VO3523877', '2025-11-22 14:19:15', '2025-11-22 14:19:15'),
('186', '3286342034911', NULL, '20349', NULL, 'VO1220349', '2025-11-22 14:20:28', '2025-11-22 14:20:28'),
('187', '3286340885119', NULL, '8851', NULL, 'VO1188510', '2025-11-22 14:20:41', '2025-11-22 14:20:41'),
('188', '3528706144790', NULL, '614479', NULL, 'VOMIMIC614479', '2025-11-22 14:21:25', '2025-11-22 14:21:25'),
('189', '8019227267129', NULL, '2671200', NULL, 'VOPIPIR2671200', '2025-11-22 14:22:09', '2025-11-22 14:22:09'),
('190', '5452000470041', NULL, '531959', NULL, 'VOGOFUL531959', '2025-11-22 14:26:21', '2025-11-22 14:26:21'),
('191', '3286340962216', NULL, '9622', NULL, 'VOWUWUE0962200001', '2025-11-22 14:26:34', '2025-11-22 14:26:34'),
('192', '3528703916222', NULL, '391622', NULL, 'VOMIMIC391622', '2025-11-22 14:27:18', '2025-11-22 14:27:18'),
('193', '4038526073778', NULL, '581329', NULL, 'VOGOGOD581329', '2025-11-22 14:28:01', '2025-11-22 14:28:01'),
('194', '3286341900811', NULL, '19008', NULL, 'VOFOFOE0190083', '2025-11-22 14:28:41', '2025-11-22 14:28:41'),
('195', '3286341513110', NULL, '15131', NULL, 'VOWUWUE0715131645', '2025-11-22 14:28:55', '2025-11-22 14:28:55'),
('196', '3528705735289', NULL, '573528', NULL, 'VOMIMIC573528', '2025-11-22 14:31:02', '2025-11-22 14:31:02'),
('197', '3286341301618', NULL, '13016', NULL, 'VO30713016', '2025-11-22 14:31:46', '2025-11-22 14:31:46'),
('198', '3286340615013', NULL, '6150', NULL, 'VO1161500', '2025-11-22 14:31:59', '2025-11-22 14:31:59'),
('199', '3528704094271', NULL, '409427', NULL, 'VOMIMIC409427', '2025-11-22 14:32:12', '2025-11-22 14:32:12'),
('200', '3286342035116', NULL, '20351', NULL, 'VO39820351', '2025-11-22 14:32:56', '2025-11-22 14:32:56'),
('201', '4038526020710', NULL, '576030', NULL, 'VOGOGOD576030', '2025-11-22 14:33:10', '2025-11-22 14:33:10'),
('202', '3286341006018', NULL, '10060', NULL, 'VO11006051', '2025-11-22 14:33:23', '2025-11-22 14:33:23'),
('203', '3286340618618', NULL, '6186', NULL, 'VOPIPIR3618600', '2025-11-22 14:33:36', '2025-11-22 14:33:36'),
('204', '4038526394705', NULL, '594029', NULL, 'VOGOGOD594029', '2025-11-22 14:33:50', '2025-11-22 14:33:50'),
('205', '8019227232325', NULL, '2323200', NULL, 'VOPIPIR2323200', '2025-11-22 14:35:00', '2025-11-22 14:35:00'),
('206', '3286342068411', NULL, '20684', NULL, 'VO1206840', '2025-11-22 14:35:43', '2025-11-22 14:35:43'),
('207', '3286342149516', NULL, '21495', NULL, 'VO32149562', '2025-11-22 14:36:23', '2025-11-22 14:36:23'),
('208', '3286340883412', NULL, '8834', NULL, 'VO1158834', '2025-11-22 14:37:30', '2025-11-22 14:37:30'),
('209', '6419440464626', NULL, 'T431977', NULL, 'VONONOKT431977', '2025-11-22 14:40:14', '2025-11-22 14:40:14'),
('210', '3286340829915', NULL, '8299', NULL, 'VO121678299', '2025-11-22 14:40:57', '2025-11-22 14:40:57'),
('211', '8019227286304', NULL, '2863000', NULL, 'VOCOUNI0362863000', '2025-11-22 14:41:41', '2025-11-22 14:41:41'),
('212', '3286341807813', NULL, '18078', NULL, 'VO30618078', '2025-11-22 14:41:54', '2025-11-22 14:41:54'),
('213', '3286342068510', NULL, '20685', NULL, 'VO1206855', '2025-11-22 14:42:07', '2025-11-22 14:42:07'),
('214', '3286342068619', NULL, '20686', NULL, 'VO32206866', '2025-11-22 14:42:21', '2025-11-22 14:42:21'),
('215', '3286341006315', NULL, '10063', NULL, 'VO30710063', '2025-11-22 14:43:04', '2025-11-22 14:43:04'),
('216', '3286342068718', NULL, '20687', NULL, 'VO32206878', '2025-11-22 14:43:17', '2025-11-22 14:43:17'),
('217', '3286342068817', NULL, '20688', NULL, 'VO1206880', '2025-11-22 14:43:31', '2025-11-22 14:43:31'),
('218', '3286342315713', NULL, '23157', NULL, 'VO1323157', '2025-11-22 14:44:15', '2025-11-22 14:44:15'),
('219', '4038526054548', NULL, '579402', NULL, 'VOGOSAV579402', '2025-11-22 14:44:55', '2025-11-22 14:44:55'),
('220', '3286342068916', NULL, '20689', NULL, 'VO1206891', '2025-11-22 14:45:39', '2025-11-22 14:45:39'),
('221', '4038526388452', NULL, '593151', NULL, 'VOGODEB593151', '2025-11-22 14:47:15', '2025-11-22 14:47:15'),
('222', '5452000477224', NULL, '568600', NULL, 'RECOCON0355686000', '2025-11-22 14:47:59', '2025-11-22 14:47:59'),
('224', '3286342035215', NULL, '20352', NULL, 'VO1320352', '2025-11-22 14:48:12', '2025-11-22 14:48:12'),
('225', '3286340618816', NULL, '6188', NULL, 'VOPIPIR3618800', '2025-11-22 14:48:25', '2025-11-22 14:48:25'),
('226', '3286342069012', NULL, '20690', NULL, 'VO1206901', '2025-11-22 14:51:37', '2025-11-22 14:51:37'),
('227', '3286342846019', NULL, '28460', NULL, 'VO1284602', '2025-11-22 14:51:50', '2025-11-22 14:51:50'),
('228', '3286341832518', NULL, '18325', NULL, 'VO1318325', '2025-11-22 14:52:34', '2025-11-22 14:52:34'),
('229', '5452000470034', NULL, '531958', NULL, 'VOGOFUL531958', '2025-11-22 14:53:47', '2025-11-22 14:53:47'),
('230', '3286342294612', NULL, '22946', NULL, 'VO30822946', '2025-11-22 14:54:01', '2025-11-22 14:54:01'),
('231', '3286340937016', NULL, '9370', NULL, 'VO31689370', '2025-11-22 14:54:14', '2025-11-22 14:54:14'),
('232', '3286342045610', NULL, '20456', NULL, 'VO1204564', '2025-11-22 14:55:28', '2025-11-22 14:55:28'),
('233', '5452000477071', NULL, '568571', NULL, 'VOGODUN568571', '2025-11-22 14:56:11', '2025-11-22 14:56:11'),
('234', '3528703411987', NULL, '341198', NULL, 'VOMIMIC341198', '2025-11-22 14:56:24', '2025-11-22 14:56:24'),
('235', '3286342671918', NULL, '26719', NULL, 'VO32267190', '2025-11-22 14:56:38', '2025-11-22 14:56:38'),
('236', '3286342618517', NULL, '26185', NULL, 'VO32261857', '2025-11-22 14:56:51', '2025-11-22 14:56:51'),
('237', '4038526433824', NULL, '598618', NULL, 'VOGOGOD598618', '2025-11-22 14:57:04', '2025-11-22 14:57:04'),
('238', '3286340813310', NULL, '8133', NULL, 'VO1158133', '2025-11-22 14:57:48', '2025-11-22 14:57:48'),
('239', '3286342453613', NULL, '24536', NULL, 'VO1324536', '2025-11-22 14:58:01', '2025-11-22 14:58:01'),
('240', '3286342828015', NULL, '28280', NULL, 'VO32282800', '2025-11-22 14:58:14', '2025-11-22 14:58:14'),
('241', '3286341406917', NULL, '14069', NULL, 'VO31406909', '2025-11-22 14:58:54', '2025-11-22 14:58:54'),
('242', '3286340878913', NULL, '8789', NULL, 'VOFOFOE3287899', '2025-11-22 14:59:08', '2025-11-22 14:59:08'),
('243', '3286340583312', NULL, '5833', NULL, 'VO1158338', '2025-11-22 14:59:21', '2025-11-22 14:59:21'),
('244', '8019227192476', NULL, '1924700', NULL, 'VOPIPIR1924700', '2025-11-22 15:00:20', '2025-11-22 15:00:20'),
('245', '8019227431353', NULL, '4313500', NULL, 'VOPIPIR4313500', '2025-11-22 15:01:33', '2025-11-22 15:01:33'),
('246', '3286340583411', NULL, '5834', NULL, 'VO1158342', '2025-11-22 15:02:47', '2025-11-22 15:02:47'),
('247', '8019227278255', NULL, '2782500', NULL, 'VOPIPIR2782500', '2025-11-22 15:03:00', '2025-11-22 15:03:00'),
('248', '3286342069111', NULL, '20691', NULL, 'VO1206911', '2025-11-22 15:03:44', '2025-11-22 15:03:44'),
('249', '3286340619714', NULL, '6197', NULL, 'VO1236197', '2025-11-22 15:04:54', '2025-11-22 15:04:54'),
('250', '3286342827919', NULL, '28279', NULL, 'VO32282799', '2025-11-22 15:06:38', '2025-11-22 15:06:38'),
('251', '8019227376944', NULL, '3769400', NULL, 'VOPIPIR3769400', '2025-11-22 15:06:51', '2025-11-22 15:06:51'),
('252', '3286341816914', NULL, '18169', NULL, 'VO31218169', '2025-11-22 15:07:04', '2025-11-22 15:07:04'),
('253', '3286342069210', NULL, '20692', NULL, 'VO1206921', '2025-11-22 15:08:19', '2025-11-22 15:08:19'),
('254', '4038526415196', NULL, '596011', NULL, 'VOFOFOE9596011', '2025-11-22 15:08:59', '2025-11-22 15:08:59'),
('255', '4038526388469', NULL, '593152', NULL, 'VOGOSAV593152', '2025-11-22 15:09:38', '2025-11-22 15:09:38'),
('256', '3286342471518', NULL, '24715', NULL, 'VO1247150', '2025-11-22 15:09:52', '2025-11-22 15:09:52'),
('257', '3286342827810', NULL, '28278', NULL, 'VO31428278', '2025-11-22 15:10:05', '2025-11-22 15:10:05'),
('258', '3286340740319', NULL, '7403', NULL, 'VO32374030', '2025-11-22 15:10:19', '2025-11-22 15:10:19'),
('259', '4038526389008', NULL, '593497', NULL, 'VOGODUN593497', '2025-11-22 15:11:02', '2025-11-22 15:11:02'),
('260', '4038526388964', NULL, '593493', NULL, 'VOGODUN593493', '2025-11-22 15:11:16', '2025-11-22 15:11:16'),
('261', '3286341882810', NULL, '18828', NULL, 'VO32218828', '2025-11-22 15:12:00', '2025-11-22 15:12:00'),
('262', '3286341357615', NULL, '13576', NULL, 'VO1357603', '2025-11-22 15:12:13', '2025-11-22 15:12:13'),
('263', '3286342388410', NULL, '23884', NULL, 'VO1323884', '2025-11-22 15:12:42', '2025-11-22 15:12:42'),
('264', '3286342390512', NULL, '23905', NULL, 'VO32239054', '2025-11-22 15:12:56', '2025-11-22 15:12:56'),
('265', '3286341825411', NULL, '18254', NULL, 'VO1318254', '2025-11-22 15:13:09', '2025-11-22 15:13:09'),
('266', '5452000680204', NULL, '542076', NULL, 'VOGODUN542076', '2025-11-22 15:14:42', '2025-11-22 15:14:42'),
('267', '5452000470027', NULL, '531957', NULL, 'VOGOFUL531957', '2025-11-22 15:14:56', '2025-11-22 15:14:56'),
('268', '3286342069517', NULL, '20695', NULL, 'VO1206952', '2025-11-22 15:15:10', '2025-11-22 15:15:10'),
('269', '3286340669818', NULL, '6698', NULL, 'VOMIMIC866987', '2025-11-22 15:15:24', '2025-11-22 15:15:24'),
('270', '5452000470010', NULL, '531956', NULL, 'VOGOFUL531956', '2025-11-22 15:16:07', '2025-11-22 15:16:07'),
('271', '3286340647410', NULL, '6474', NULL, 'VO1526474', '2025-11-22 15:16:20', '2025-11-22 15:16:20'),
('272', '3286342395012', NULL, '23950', NULL, 'VO31423950', '2025-11-22 15:16:34', '2025-11-22 15:16:34'),
('273', '3528705688165', NULL, '568816', NULL, 'VOMIMIC568816', '2025-11-22 15:17:17', '2025-11-22 15:17:17'),
('274', '3286342983011', NULL, '29830', NULL, 'VO31298300', '2025-11-22 15:17:31', '2025-11-22 15:17:31'),
('275', '8019227256963', NULL, '2569600', NULL, 'VOPIPIR2569600', '2025-11-22 15:17:44', '2025-11-22 15:17:44'),
('276', '3286342621319', NULL, '26213', NULL, 'VO31262138', '2025-11-22 15:17:58', '2025-11-22 15:17:58'),
('277', '3286342053110', NULL, '20531', NULL, 'VO31420531', '2025-11-22 15:18:11', '2025-11-22 15:18:11'),
('278', '4038526388926', NULL, '593219', NULL, 'VOGODUN593219', '2025-11-22 15:18:24', '2025-11-22 15:18:24'),
('279', '3286342678511', NULL, '26785', NULL, 'VO1267850', '2025-11-22 15:19:08', '2025-11-22 15:19:08'),
('280', '3286342035413', NULL, '20354', NULL, 'VO3120354', '2025-11-22 15:19:51', '2025-11-22 15:19:51'),
('281', '3286342272313', NULL, '22723', NULL, 'VO30622723', '2025-11-22 15:21:35', '2025-11-22 15:21:35'),
('282', '3528703716013', NULL, '371601', NULL, 'VO31371601', '2025-11-22 15:21:48', '2025-11-22 15:21:48'),
('283', '3528702458532', NULL, '245853', NULL, 'VO32245853', '2025-11-22 15:22:02', '2025-11-22 15:22:02'),
('284', '3286341883312', NULL, '18833', NULL, 'VO3518833', '2025-11-22 15:22:15', '2025-11-22 15:22:15'),
('285', '3286342035819', NULL, '20358', NULL, 'VO31320358', '2025-11-22 15:22:28', '2025-11-22 15:22:28'),
('286', '5452000470003', NULL, '531955', NULL, 'VOGOFUL531955', '2025-11-22 15:25:10', '2025-11-22 15:25:10'),
('287', '3286340936316', NULL, '9363', NULL, 'VO1399363', '2025-11-22 15:25:23', '2025-11-22 15:25:23'),
('288', '8019227267136', NULL, '2671300', NULL, 'VOPIPIR2671300', '2025-11-22 15:25:37', '2025-11-22 15:25:37'),
('289', '5452000469991', NULL, '531954', NULL, 'VOGOFUL531954', '2025-11-22 15:25:50', '2025-11-22 15:25:50'),
('290', '8019227444391', NULL, '4443900', NULL, 'VOPIPIR4443900', '2025-11-22 15:27:03', '2025-11-22 15:27:03'),
('291', '3286341937213', NULL, '19372', NULL, 'VO30619372', '2025-11-22 15:27:47', '2025-11-22 15:27:47'),
('292', '4038526417831', NULL, '596200', NULL, 'VOPIPIR2596200', '2025-11-22 15:28:00', '2025-11-22 15:28:00'),
('293', '3286342274317', NULL, '22743', NULL, 'VO32274316', '2025-11-22 15:30:37', '2025-11-22 15:30:37'),
('294', '5452000469984', NULL, '531953', NULL, 'VOGOFUL531953', '2025-11-22 15:30:51', '2025-11-22 15:30:51'),
('295', '5452000469977', NULL, '531952', NULL, 'VOGOFUL531952', '2025-11-22 15:31:04', '2025-11-22 15:31:04'),
('296', '3528702437636', NULL, '243763', NULL, 'VOMIMIC243763', '2025-11-22 15:31:17', '2025-11-22 15:31:17'),
('297', '4038526388902', NULL, '593217', NULL, 'VOFOFOE1593217', '2025-11-22 15:31:57', '2025-11-22 15:31:57'),
('298', '3286342035918', NULL, '20359', NULL, 'VO31320359', '2025-11-22 15:35:31', '2025-11-22 15:35:31'),
('299', '3286342859910', NULL, '28599', NULL, 'VO1228599', '2025-11-22 15:35:45', '2025-11-22 15:35:45'),
('300', '3286342036014', NULL, '20360', NULL, 'VO31320360', '2025-11-22 15:37:25', '2025-11-22 15:37:25'),
('301', '4038526359810', NULL, '588740', NULL, 'VOGOGOD588740', '2025-11-22 15:38:35', '2025-11-22 15:38:35'),
('302', '3286340936613', NULL, '9366', NULL, 'VO1129366', '2025-11-22 15:39:18', '2025-11-22 15:39:18'),
('303', '3286342036113', NULL, '20361', NULL, 'VO1203617', '2025-11-22 15:39:32', '2025-11-22 15:39:32'),
('304', '3286340921312', NULL, '9213', NULL, 'VO31689213', '2025-11-22 15:40:15', '2025-11-22 15:40:15'),
('305', '3286342036212', NULL, '20362', NULL, 'VO32203628', '2025-11-22 15:40:55', '2025-11-22 15:40:55'),
('306', '3286342606910', NULL, '26069', NULL, 'VO32260692', '2025-11-22 15:41:09', '2025-11-22 15:41:09'),
('307', '3286341401417', NULL, '14014', NULL, 'VO31401401', '2025-11-22 15:41:52', '2025-11-22 15:41:52'),
('308', '5452000469922', NULL, '531947', NULL, 'VOGOFUL531947', '2025-11-22 15:45:00', '2025-11-22 15:45:00'),
('309', '8019227239836', NULL, '2398300', NULL, 'VOPIPIR2398300', '2025-11-22 15:45:14', '2025-11-22 15:45:14'),
('310', '3286342036311', NULL, '20363', NULL, 'VO1203630', '2025-11-22 15:45:57', '2025-11-22 15:45:57'),
('311', '3286341097313', NULL, '10973', NULL, 'VO11110973', '2025-11-22 15:46:11', '2025-11-22 15:46:11'),
('312', '3286342152110', NULL, '21521', NULL, 'VOPIPIR2152100', '2025-11-22 15:46:24', '2025-11-22 15:46:24'),
('313', '8019227173772', NULL, '1737700', NULL, 'VOPIPIR1737700', '2025-11-22 15:47:04', '2025-11-22 15:47:04'),
('314', '3286342036410', NULL, '20364', NULL, 'VO1203646', '2025-11-22 15:47:48', '2025-11-22 15:47:48'),
('315', '3286340681711', NULL, '6817', NULL, 'VO1268173', '2025-11-22 15:48:01', '2025-11-22 15:48:01'),
('316', '3286342663616', NULL, '26636', NULL, 'VO32226636', '2025-11-22 15:48:14', '2025-11-22 15:48:14'),
('317', '3286342551517', NULL, '25515', NULL, 'VO1255157', '2025-11-22 15:48:28', '2025-11-22 15:48:28'),
('318', '3286340988919', NULL, '9889', NULL, 'VO1219889', '2025-11-22 15:49:11', '2025-11-22 15:49:11'),
('319', '3286340767019', NULL, '7670', NULL, 'VOWUWUE0997670412', '2025-11-22 15:49:25', '2025-11-22 15:49:25'),
('320', '3286342036519', NULL, '20365', NULL, 'VO1203658', '2025-11-22 15:49:38', '2025-11-22 15:49:38'),
('321', '3528701209210', NULL, '120921', NULL, 'VOMIMIC120921', '2025-11-22 15:50:22', '2025-11-22 15:50:22'),
('322', '3286342036618', NULL, '20366', NULL, 'VO1203666', '2025-11-22 15:50:36', '2025-11-22 15:50:36'),
('323', '3286342036717', NULL, '20367', NULL, 'VO31420367', '2025-11-22 15:51:19', '2025-11-22 15:51:19'),
('324', '3286342672410', NULL, '26724', NULL, 'VO1267240', '2025-11-22 15:51:33', '2025-11-22 15:51:33'),
('325', '4038526355850', NULL, '588325', NULL, 'VOGOGOD588325', '2025-11-22 15:51:46', '2025-11-22 15:51:46'),
('326', '3286341407211', NULL, '14072', NULL, 'VO31314072', '2025-11-22 15:51:59', '2025-11-22 15:51:59'),
('327', '3286340873413', NULL, '8734', NULL, 'VOMIMIC187346', '2025-11-22 15:52:13', '2025-11-22 15:52:13'),
('328', '3286342729916', NULL, '27299', NULL, 'VO272991', '2025-11-22 15:52:26', '2025-11-22 15:52:26'),
('329', '3286340936811', NULL, '9368', NULL, 'VO31493688', '2025-11-22 15:52:39', '2025-11-22 15:52:39'),
('330', '3286342036816', NULL, '20368', NULL, 'VO1203680', '2025-11-22 15:54:20', '2025-11-22 15:54:20'),
('331', '3286340883214', NULL, '8832', NULL, 'VO1268832', '2025-11-22 15:54:34', '2025-11-22 15:54:34'),
('332', '3286341411218', NULL, '14112', NULL, 'VO32141125', '2025-11-22 15:54:47', '2025-11-22 15:54:47'),
('333', '3528704638765', NULL, '463876', NULL, 'VO31463876', '2025-11-22 15:55:31', '2025-11-22 15:55:31'),
('334', '8019227241389', NULL, '2413800', NULL, 'VOPIPIR2413800', '2025-11-22 15:56:44', '2025-11-22 15:56:44'),
('335', '8019227282054', NULL, '2820500', NULL, 'VOPIPIR2820500', '2025-11-22 15:57:43', '2025-11-22 15:57:43'),
('336', '3286340332613', NULL, '3326', NULL, 'VO1203326', '2025-11-22 15:57:57', '2025-11-22 15:57:57'),
('337', '3286342983417', NULL, '29834', NULL, 'VO31298348', '2025-11-22 15:58:10', '2025-11-22 15:58:10'),
('338', '4038526475282', NULL, '721235', NULL, 'VO30721235', '2025-11-22 15:58:23', '2025-11-22 15:58:23'),
('339', '3286340989114', NULL, '9891', NULL, 'VO1319891', '2025-11-22 15:58:37', '2025-11-22 15:58:37'),
('340', '8019227173796', NULL, '1737900', NULL, 'VOPIPIR1737900', '2025-11-22 15:59:20', '2025-11-22 15:59:20'),
('341', '3286340247917', NULL, '2479', NULL, 'VO32247928', '2025-11-22 15:59:33', '2025-11-22 15:59:33'),
('342', '4038526355812', NULL, '588321', NULL, 'VOGOGOD588321', '2025-11-22 15:59:47', '2025-11-22 15:59:47'),
('343', '3286341414219', NULL, '14142', NULL, 'VO30714142', '2025-11-22 16:00:28', '2025-11-22 16:00:28'),
('344', '3286342827711', NULL, '28277', NULL, 'VO31428277', '2025-11-22 16:01:08', '2025-11-22 16:01:08'),
('345', '4038526355539', NULL, '588278', NULL, 'VOGOGOD588278', '2025-11-22 16:02:22', '2025-11-22 16:02:22'),
('346', '3528702831557', NULL, '283155', NULL, 'VOMIMIC283155', '2025-11-22 16:03:05', '2025-11-22 16:03:05'),
('347', '8019227242171', NULL, '2421700', NULL, 'VOPIPIR2421700', '2025-11-22 16:08:40', '2025-11-22 16:08:40'),
('348', '3286340646918', NULL, '6469', NULL, 'VO39796469', '2025-11-22 16:09:23', '2025-11-22 16:09:23'),
('349', '3286342036915', NULL, '20369', NULL, 'VO1203698', '2025-11-22 16:09:37', '2025-11-22 16:09:37'),
('350', '3286342152318', NULL, '21523', NULL, 'VOPIPIR2152300', '2025-11-22 16:10:50', '2025-11-22 16:10:50'),
('351', '3286340248013', NULL, '2480', NULL, 'VO32222480', '2025-11-22 16:11:30', '2025-11-22 16:11:30'),
('352', '5452000469304', NULL, '531910', NULL, 'VOGODUN531910', '2025-11-22 16:12:14', '2025-11-22 16:12:14'),
('353', '3286342673813', NULL, '26738', NULL, 'VO1267382', '2025-11-22 16:12:43', '2025-11-22 16:12:43'),
('354', '3286340802611', NULL, '8026', NULL, 'VO1218026', '2025-11-22 16:13:26', '2025-11-22 16:13:26'),
('355', '5452000469298', NULL, '531909', NULL, 'VOGODUN531909', '2025-11-22 16:14:10', '2025-11-22 16:14:10'),
('356', '3286340729512', NULL, '7295', NULL, 'VOFOFOE3307295', '2025-11-22 16:18:17', '2025-11-22 16:18:17'),
('357', '3286342870915', NULL, '28709', NULL, 'VO3528709', '2025-11-22 16:19:54', '2025-11-22 16:19:54'),
('358', '5452000837813', NULL, '575932', NULL, 'VOGODUN575932', '2025-11-22 16:21:38', '2025-11-22 16:21:38'),
('359', '3286342390116', NULL, '23901', NULL, 'VO30723901', '2025-11-22 16:22:17', '2025-11-22 16:22:17'),
('360', '3286341765410', NULL, '17654', NULL, 'VO39817654', '2025-11-22 16:22:57', '2025-11-22 16:22:57'),
('361', '3528704333851', NULL, '433385', NULL, 'VOMIMIC433385', '2025-11-22 16:23:11', '2025-11-22 16:23:11'),
('362', '5452000732224', NULL, '545700', NULL, 'VOGOFUL545700', '2025-11-22 16:23:25', '2025-11-22 16:23:25'),
('363', '3286342037011', NULL, '20370', NULL, 'VO3203708', '2025-11-22 16:24:05', '2025-11-22 16:24:05'),
('364', '8019227444551', NULL, '4445500', NULL, 'VOPIPIR4445500', '2025-11-22 16:24:19', '2025-11-22 16:24:19'),
('365', '3286342037110', NULL, '20371', NULL, 'VO1203717', '2025-11-22 16:25:02', '2025-11-22 16:25:02'),
('366', '3286341052312', NULL, '10523', NULL, 'VO11110523', '2025-11-22 16:25:16', '2025-11-22 16:25:16'),
('367', '8019227267938', NULL, '2679300', NULL, 'VOPIPIR2679300', '2025-11-22 16:25:59', '2025-11-22 16:25:59'),
('368', '3286342037219', NULL, '20372', NULL, 'VO32203725', '2025-11-22 16:27:42', '2025-11-22 16:27:42'),
('369', '3286340623513', NULL, '6235', NULL, 'VO31686235', '2025-11-22 16:28:25', '2025-11-22 16:28:25'),
('370', '8019227282146', NULL, '2821400', NULL, 'VOPIPIR2821400', '2025-11-22 16:28:38', '2025-11-22 16:28:38'),
('371', '3286342871110', NULL, '28711', NULL, 'VO31428711', '2025-11-22 16:28:52', '2025-11-22 16:28:52'),
('372', '3286342610719', NULL, '26107', NULL, 'VOWUWUE0770261075', '2025-11-22 16:30:34', '2025-11-22 16:30:34'),
('373', '5452000468529', NULL, '531865', NULL, 'VOGODUN531865', '2025-11-22 16:30:47', '2025-11-22 16:30:47'),
('374', '3286341937015', NULL, '19370', NULL, 'VO32219370', '2025-11-22 16:31:01', '2025-11-22 16:31:01'),
('375', '8019227445008', NULL, '4450000', NULL, 'RECOCON0354450000', '2025-11-22 16:31:44', '2025-11-22 16:31:44'),
('377', '3286341388510', NULL, '13885', NULL, 'VO1388522', '2025-11-22 16:31:57', '2025-11-22 16:31:57'),
('378', '3286342892719', NULL, '28927', NULL, 'VO9128927', '2025-11-22 16:33:46', '2025-11-22 16:33:46'),
('379', '3286340999311', NULL, '9993', NULL, 'VO31439993', '2025-11-22 16:35:24', '2025-11-22 16:35:24'),
('380', '3286342037318', NULL, '20373', NULL, 'VO1203735', '2025-11-22 16:37:07', '2025-11-22 16:37:07'),
('381', '3286341836615', NULL, '18366', NULL, 'VO1218366', '2025-11-22 16:37:21', '2025-11-22 16:37:21'),
('382', '3286340936019', NULL, '9360', NULL, 'VO31689360', '2025-11-22 16:37:34', '2025-11-22 16:37:34'),
('383', '3286342152516', NULL, '21525', NULL, 'VO1215252', '2025-11-22 16:38:45', '2025-11-22 16:38:45'),
('384', '8019227446968', NULL, '4469600', NULL, 'VOPIPIR4469600', '2025-11-22 16:39:25', '2025-11-22 16:39:25'),
('385', '5452000488077', NULL, '532418', NULL, 'VOGOGOD532418', '2025-11-22 16:41:25', '2025-11-22 16:41:25'),
('386', '3286340882910', NULL, '8829', NULL, 'VO1188293', '2025-11-22 16:41:38', '2025-11-22 16:41:38'),
('387', '3286342877419', NULL, '28774', NULL, 'VO1287740', '2025-11-22 16:41:52', '2025-11-22 16:41:52'),
('388', '5452000488084', NULL, '532419', NULL, 'VOGOGOD532419', '2025-11-22 16:45:03', '2025-11-22 16:45:03'),
('389', '3286342152714', NULL, '21527', NULL, 'VO1215272', '2025-11-22 16:47:40', '2025-11-22 16:47:40'),
('390', '3286342037417', NULL, '20374', NULL, 'VO1320374', '2025-11-22 16:47:53', '2025-11-22 16:47:53'),
('391', '3286342037516', NULL, '20375', NULL, 'VO1320375', '2025-11-22 16:48:06', '2025-11-22 16:48:06'),
('392', '3286342827612', NULL, '28276', NULL, 'VO1328276', '2025-11-22 16:48:20', '2025-11-22 16:48:20'),
('393', '3286342152813', NULL, '21528', NULL, 'VO1215281', '2025-11-22 16:49:03', '2025-11-22 16:49:03'),
('394', '3286342037615', NULL, '20376', NULL, 'VO1220376', '2025-11-22 16:49:17', '2025-11-22 16:49:17'),
('395', '8019227275162', NULL, '2751600', NULL, 'VOPIPIR2751600', '2025-11-22 16:50:27', '2025-11-22 16:50:27'),
('396', '3286340999410', NULL, '9994', NULL, 'VO31209994', '2025-11-22 16:51:07', '2025-11-22 16:51:07'),
('397', '3286340729017', NULL, '7290', NULL, 'VO32217290', '2025-11-22 16:51:20', '2025-11-22 16:51:20'),
('398', '3286340754217', NULL, '7542', NULL, 'VO1275421', '2025-11-22 16:53:26', '2025-11-22 16:53:26'),
('399', '3286340689212', NULL, '6892', NULL, 'VO31689209', '2025-11-22 16:54:36', '2025-11-22 16:54:36'),
('400', '3286342966915', NULL, '29669', NULL, 'VO31296691', '2025-11-22 16:54:49', '2025-11-22 16:54:49'),
('401', '8019227255324', NULL, '2553200', NULL, 'VOPIPIR2553200', '2025-11-22 16:55:03', '2025-11-22 16:55:03'),
('402', '3286342890616', NULL, '28906', NULL, 'VO30728906', '2025-11-22 16:55:16', '2025-11-22 16:55:16'),
('403', '3286342827513', NULL, '28275', NULL, 'VO31428275', '2025-11-22 16:55:30', '2025-11-22 16:55:30'),
('404', '3286342390710', NULL, '23907', NULL, 'VO1323907', '2025-11-22 16:55:43', '2025-11-22 16:55:43'),
('405', '8019227176728', NULL, '1767200', NULL, 'VOPIPIR1767200', '2025-11-22 16:57:25', '2025-11-22 16:57:25'),
('406', '3286342037714', NULL, '20377', NULL, 'VO1203778', '2025-11-22 16:57:53', '2025-11-22 16:57:53'),
('407', '8019227176735', NULL, '1767300', NULL, 'VOPIPIR1767300', '2025-11-22 16:58:06', '2025-11-22 16:58:06'),
('408', '3286340999519', NULL, '9995', NULL, 'MA3999588', '2025-11-22 16:58:20', '2025-11-22 16:58:20'),
('409', '3286340999618', NULL, '9996', NULL, 'VO31209996', '2025-11-22 16:58:33', '2025-11-22 16:58:33'),
('410', '5452000703149', NULL, '543056', NULL, 'VOGODUN543056', '2025-11-22 16:59:43', '2025-11-22 16:59:43'),
('411', '8019227256345', NULL, '2563400', NULL, 'VOPIPIR2563400', '2025-11-22 16:59:57', '2025-11-22 16:59:57'),
('412', '3286341765212', NULL, '17652', NULL, 'VO31217652', '2025-11-22 17:02:37', '2025-11-22 17:02:37'),
('413', '3286342996813', NULL, '29968', NULL, 'VO1299680', '2025-11-22 17:03:20', '2025-11-22 17:03:20'),
('414', '5452000432766', NULL, '529675', NULL, 'VOGOGOD529675', '2025-11-22 17:03:34', '2025-11-22 17:03:34'),
('415', '8019227256369', NULL, '2563600', NULL, 'VOPIPIR2563600', '2025-11-22 17:04:17', '2025-11-22 17:04:17'),
('416', '3188649808861', NULL, '525895', NULL, 'VOGODUN525895', '2025-11-22 17:04:31', '2025-11-22 17:04:31'),
('417', '3286341838817', NULL, '18388', NULL, 'VO1218388', '2025-11-22 17:07:09', '2025-11-22 17:07:09'),
('418', '3286342053011', NULL, '20530', NULL, 'VO32205302', '2025-11-22 17:08:24', '2025-11-22 17:08:24'),
('419', '8019227256406', NULL, '2564000', NULL, 'VOPIPIR2564000', '2025-11-22 17:09:08', '2025-11-22 17:09:08'),
('420', '3286342279312', NULL, '22793', NULL, 'VO30622793', '2025-11-22 17:11:44', '2025-11-22 17:11:44'),
('421', '3286342997018', NULL, '29970', NULL, 'VO1299701', '2025-11-22 17:11:58', '2025-11-22 17:11:58'),
('422', '3286342153216', NULL, '21532', NULL, 'VOPIPIR2153200', '2025-11-22 17:12:43', '2025-11-22 17:12:43'),
('423', '3286340668811', NULL, '6688', NULL, 'VO39796688', '2025-11-22 17:14:53', '2025-11-22 17:14:53'),
('424', '3286342891118', NULL, '28911', NULL, 'VO30728911', '2025-11-22 17:15:35', '2025-11-22 17:15:35'),
('425', '3286342998015', NULL, '29980', NULL, 'VO31329980', '2025-11-22 17:15:48', '2025-11-22 17:15:48'),
('426', '3286342153315', NULL, '21533', NULL, 'VO32221533', '2025-11-22 17:17:25', '2025-11-22 17:17:25'),
('427', '3188649809738', NULL, '526253', NULL, 'VOGODUN526253', '2025-11-22 17:17:38', '2025-11-22 17:17:38'),
('428', '3528703030980', NULL, '303098', NULL, 'VOFOFOE3030980', '2025-11-22 17:17:51', '2025-11-22 17:17:51'),
('429', '3286342390819', NULL, '23908', NULL, 'VO32239085', '2025-11-22 17:20:02', '2025-11-22 17:20:02'),
('430', '3286340960816', NULL, '9608', NULL, 'VO32369608', '2025-11-22 17:20:16', '2025-11-22 17:20:16'),
('431', '3286341936919', NULL, '19369', NULL, 'VO32219369', '2025-11-22 17:20:29', '2025-11-22 17:20:29'),
('432', '3286342855912', NULL, '28559', NULL, 'VO1228559', '2025-11-22 17:21:13', '2025-11-22 17:21:13'),
('433', '3286342891415', NULL, '28914', NULL, 'VO32228914', '2025-11-22 17:21:26', '2025-11-22 17:21:26'),
('434', '3286340937719', NULL, '9377', NULL, 'VO1159377', '2025-11-22 17:22:10', '2025-11-22 17:22:10'),
('435', '3286343114315', NULL, '31143', NULL, 'VO32131143', '2025-11-22 17:23:46', '2025-11-22 17:23:46'),
('436', '3286342153414', NULL, '21534', NULL, 'VO30621534', '2025-11-22 17:23:59', '2025-11-22 17:23:59'),
('437', '3286340875318', NULL, '8753', NULL, 'VO39798753', '2025-11-22 17:24:13', '2025-11-22 17:24:13'),
('438', '3286341414417', NULL, '14144', NULL, 'VO31214144', '2025-11-22 17:24:57', '2025-11-22 17:24:57'),
('439', '3286341000016', NULL, '10000', NULL, 'VO11000016', '2025-11-22 17:27:48', '2025-11-22 17:27:48'),
('440', '3286340878418', NULL, '8784', NULL, 'VO32248784', '2025-11-22 17:28:02', '2025-11-22 17:28:02'),
('441', '3286342052816', NULL, '20528', NULL, 'VO32205280', '2025-11-22 17:28:45', '2025-11-22 17:28:45'),
('442', '3286340768917', NULL, '7689', NULL, 'VO31676894', '2025-11-22 17:29:29', '2025-11-22 17:29:29'),
('443', '3286342892115', NULL, '28921', NULL, 'VO1328921', '2025-11-22 17:30:42', '2025-11-22 17:30:42'),
('444', '4038526352705', NULL, '588151', NULL, 'VOGOSAV588151', '2025-11-22 17:30:56', '2025-11-22 17:30:56'),
('445', '3286340882514', NULL, '8825', NULL, 'VO1378825', '2025-11-22 17:34:25', '2025-11-22 17:34:25'),
('446', '3286340729710', NULL, '7297', NULL, 'VO1257297', '2025-11-22 17:36:26', '2025-11-22 17:36:26'),
('447', '3286342052717', NULL, '20527', NULL, 'VO31420527', '2025-11-22 17:36:39', '2025-11-22 17:36:39'),
('448', '4038526432292', NULL, '598586', NULL, 'VOGOGOD598586', '2025-11-22 17:36:52', '2025-11-22 17:36:52'),
('449', '3286342153711', NULL, '21537', NULL, 'VO3121537', '2025-11-22 17:37:06', '2025-11-22 17:37:06'),
('450', '3286342153810', NULL, '21538', NULL, 'VO1215380', '2025-11-22 17:37:19', '2025-11-22 17:37:19'),
('451', '3286342153919', NULL, '21539', NULL, 'VO1215391', '2025-11-22 17:38:03', '2025-11-22 17:38:03'),
('452', '3286342303017', NULL, '23030', NULL, 'VO1323030', '2025-11-22 17:38:17', '2025-11-22 17:38:17'),
('453', '3286341925814', NULL, '19258', NULL, 'VO39819258', '2025-11-22 17:38:30', '2025-11-22 17:38:30'),
('454', '3286341002713', NULL, '10027', NULL, 'VO1310027', '2025-11-22 17:39:10', '2025-11-22 17:39:10'),
('455', '3286342303314', NULL, '23033', NULL, 'VO3523033', '2025-11-22 17:39:23', '2025-11-22 17:39:23'),
('456', '3286341936810', NULL, '19368', NULL, 'VO1219368', '2025-11-22 17:40:33', '2025-11-22 17:40:33'),
('457', '5452000488268', NULL, '532433', NULL, 'VOGODUN532433', '2025-11-22 17:40:47', '2025-11-22 17:40:47'),
('458', '4038526433558', NULL, '598600', NULL, 'VO1598600', '2025-11-22 17:41:30', '2025-11-22 17:41:30'),
('459', '3286341009613', NULL, '10096', NULL, 'VO36010096', '2025-11-22 17:41:43', '2025-11-22 17:41:43'),
('460', '3286342033419', NULL, '20334', NULL, 'VO1203344', '2025-11-22 17:41:57', '2025-11-22 17:41:57'),
('461', '4038526352637', NULL, '588140', NULL, 'VOGOSAV588140', '2025-11-22 17:42:10', '2025-11-22 17:42:10'),
('462', '3286343135617', NULL, '31356', NULL, 'VO31313563', '2025-11-22 17:42:23', '2025-11-22 17:42:23'),
('463', '3286341414516', NULL, '14145', NULL, 'VO31214145', '2025-11-22 17:44:05', '2025-11-22 17:44:05'),
('464', '3286340882415', NULL, '8824', NULL, 'VO36018824', '2025-11-22 17:45:19', '2025-11-22 17:45:19'),
('465', '5452000432117', NULL, '529728', NULL, 'VOGODUN529728', '2025-11-22 17:46:56', '2025-11-22 17:46:56'),
('466', '3286340985017', NULL, '9850', NULL, 'VOFOFOE9850026', '2025-11-22 17:47:09', '2025-11-22 17:47:09'),
('467', '3286343135815', NULL, '31358', NULL, 'VO1313580', '2025-11-22 17:48:23', '2025-11-22 17:48:23'),
('468', '3286342052618', NULL, '20526', NULL, 'VO31420526', '2025-11-22 17:49:33', '2025-11-22 17:49:33'),
('469', '3286340334112', NULL, '3341', NULL, 'VO40003341', '2025-11-22 17:50:43', '2025-11-22 17:50:43'),
('470', '3286342034010', NULL, '20340', NULL, 'VO1203405', '2025-11-22 17:51:26', '2025-11-22 17:51:26'),
('471', '8019227275148', NULL, '2751400', NULL, 'VOPIPIR2751400', '2025-11-22 17:51:40', '2025-11-22 17:51:40'),
('472', '3286341936711', NULL, '19367', NULL, 'VO30619367', '2025-11-22 17:51:54', '2025-11-22 17:51:54'),
('473', '3286343088012', NULL, '30880', NULL, 'VO31430880', '2025-11-22 17:52:07', '2025-11-22 17:52:07'),
('474', '3286341936612', NULL, '19366', NULL, 'VO30619366', '2025-11-22 17:54:18', '2025-11-22 17:54:18'),
('475', '3286342051710', NULL, '20517', NULL, 'VO122051761', '2025-11-22 17:55:01', '2025-11-22 17:55:01'),
('476', '3286342392318', NULL, '23923', NULL, 'VO9423923', '2025-11-22 17:55:15', '2025-11-22 17:55:15'),
('477', '8019227400373', NULL, '4003700', NULL, 'VOPIPIR4003700', '2025-11-22 17:55:58', '2025-11-22 17:55:58'),
('478', '3286340882316', NULL, '8823', NULL, 'VO1158823', '2025-11-22 17:57:08', '2025-11-22 17:57:08'),
('479', '5452000485601', NULL, '532210', NULL, 'VOCOCON0353221000', '2025-11-22 17:57:22', '2025-11-22 17:57:22'),
('480', '8019227398045', NULL, '3980400', NULL, 'VO39804000', '2025-11-22 17:57:50', '2025-11-22 17:57:50'),
('481', '3286340337014', NULL, '3370', NULL, 'VO40003370', '2025-11-22 17:59:04', '2025-11-22 17:59:04'),
('482', '8019227260717', NULL, '2607100', NULL, 'VOPIPIR2607100', '2025-11-22 17:59:47', '2025-11-22 17:59:47'),
('483', '3286342052014', NULL, '20520', NULL, 'VO122052059', '2025-11-22 18:00:31', '2025-11-22 18:00:31'),
('484', '3286342154411', NULL, '21544', NULL, 'VO30621544', '2025-11-22 18:00:44', '2025-11-22 18:00:44'),
('485', '3286342154510', NULL, '21545', NULL, 'VO1215459', '2025-11-22 18:00:58', '2025-11-22 18:00:58'),
('486', '3286343084618', NULL, '30846', NULL, 'VO32130846', '2025-11-22 18:01:42', '2025-11-22 18:01:42'),
('487', '3286341935516', NULL, '19355', NULL, 'VO30619355', '2025-11-22 18:01:55', '2025-11-22 18:01:55'),
('488', '3286343214510', NULL, '32145', NULL, 'VO39832145', '2025-11-22 18:02:08', '2025-11-22 18:02:08'),
('489', '3286340647717', NULL, '6477', NULL, 'VO1346477', '2025-11-22 18:02:21', '2025-11-22 18:02:21'),
('490', '3286341818819', NULL, '18188', NULL, 'VO1218188', '2025-11-22 18:04:05', '2025-11-22 18:04:05'),
('491', '3286341960716', NULL, '19607', NULL, 'VO30619607', '2025-11-22 18:05:19', '2025-11-22 18:05:19'),
('492', '3286342064710', NULL, '20647', NULL, 'VO1206478', '2025-11-22 18:05:32', '2025-11-22 18:05:32'),
('493', '4038526434999', NULL, '598753', NULL, 'VO1598753', '2025-11-22 18:06:16', '2025-11-22 18:06:16'),
('494', '8019227275131', NULL, '2751300', NULL, 'VOPIPIR2751300', '2025-11-22 18:09:30', '2025-11-22 18:09:30'),
('495', '3286342297514', NULL, '22975', NULL, 'VO30822975', '2025-11-22 18:09:43', '2025-11-22 18:09:43'),
('496', '3286340360418', NULL, '3604', NULL, 'VOWUWUEM416136041', '2025-11-22 18:09:57', '2025-11-22 18:09:57'),
('497', '3528708775107', NULL, '877510', NULL, 'VOMIMIC877510', '2025-11-22 18:11:04', '2025-11-22 18:11:04'),
('498', '3528706633423', NULL, '663342', NULL, 'VOMIMIC663342', '2025-11-22 18:12:46', '2025-11-22 18:12:46'),
('499', '3286342949215', NULL, '29492', NULL, 'VO31329492', '2025-11-22 18:14:56', '2025-11-22 18:14:56'),
('500', '5452000727947', NULL, '545361', NULL, 'VOGODUN545361', '2025-11-22 18:15:10', '2025-11-22 18:15:10'),
('501', '3286342313610', NULL, '23136', NULL, 'VO1323136', '2025-11-22 18:16:20', '2025-11-22 18:16:20'),
('502', '3286342155012', NULL, '21550', NULL, '215501795YSFU', '2025-11-22 18:16:33', '2025-11-22 18:16:33'),
('503', '4038526054531', NULL, '579401', NULL, 'VOGOFUL579401', '2025-11-22 18:19:10', '2025-11-22 18:19:10'),
('504', '3286340852012', NULL, '8520', NULL, 'VO1158520', '2025-11-22 18:19:23', '2025-11-22 18:19:23'),
('505', '8019227241327', NULL, '2413200', NULL, 'VOPIPIR2413200', '2025-11-22 18:20:37', '2025-11-22 18:20:37'),
('506', '3286341938319', NULL, '19383', NULL, 'VO32219383', '2025-11-22 18:20:50', '2025-11-22 18:20:50'),
('507', '3286342967011', NULL, '29670', NULL, 'VO31296700', '2025-11-22 18:21:04', '2025-11-22 18:21:04'),
('508', '3286340971812', NULL, '9718', NULL, 'VO1297182', '2025-11-22 18:22:17', '2025-11-22 18:22:17'),
('509', '6419440464596', NULL, 'T431993', NULL, 'VONONOKT431993', '2025-11-22 18:23:01', '2025-11-22 18:23:01'),
('510', '3528701242620', NULL, '124262', NULL, 'VO1242620', '2025-11-22 18:23:14', '2025-11-22 18:23:14'),
('511', '4038526054524', NULL, '579400', NULL, 'VOWUWUE0579400314', '2025-11-22 18:23:55', '2025-11-22 18:23:55'),
('512', '3286342386010', NULL, '23860', NULL, 'VO30623860', '2025-11-22 18:25:09', '2025-11-22 18:25:09'),
('513', '3286341814019', NULL, '18140', NULL, 'VO30618140', '2025-11-22 18:25:22', '2025-11-22 18:25:22'),
('514', '5452000488374', NULL, '532438', NULL, 'VOGOGOD532438', '2025-11-22 18:26:05', '2025-11-22 18:26:05'),
('515', '3286340911016', NULL, '9110', NULL, 'VO1159110', '2025-11-22 18:29:16', '2025-11-22 18:29:16'),
('516', '4038526442888', NULL, '720073', NULL, 'VO30720073', '2025-11-22 18:29:29', '2025-11-22 18:29:29'),
('517', '3286340921015', NULL, '9210', NULL, 'VO31689210', '2025-11-22 18:30:14', '2025-11-22 18:30:14'),
('518', '3286342894218', NULL, '28942', NULL, 'VO8628942', '2025-11-22 18:30:27', '2025-11-22 18:30:27'),
('519', '4038526336002', NULL, '586119', NULL, 'VOGOGOD586119', '2025-11-22 18:31:41', '2025-11-22 18:31:41'),
('520', '3528707514721', NULL, '751472', NULL, 'VOMIMIC751472', '2025-11-22 18:32:54', '2025-11-22 18:32:54'),
('521', '3286342155517', NULL, '21555', NULL, 'VO31215553', '2025-11-22 18:33:08', '2025-11-22 18:33:08'),
('522', '3286342894614', NULL, '28946', NULL, 'VO30728946', '2025-11-22 18:33:21', '2025-11-22 18:33:21'),
('523', '3528709996310', NULL, '999631', NULL, 'VO39999631', '2025-11-22 18:33:34', '2025-11-22 18:33:34'),
('524', '8019227398038', NULL, '3980300', NULL, 'VO39803000', '2025-11-22 18:34:48', '2025-11-22 18:34:48'),
('525', '3286342155715', NULL, '21557', NULL, 'VO3121557', '2025-11-22 18:35:01', '2025-11-22 18:35:01'),
('526', '3286340657310', NULL, '6573', NULL, 'VO31657307', '2025-11-22 18:35:41', '2025-11-22 18:35:41'),
('527', '4038526447906', NULL, '720171', NULL, 'VO30720171', '2025-11-22 18:36:51', '2025-11-22 18:36:51'),
('528', '3286342156019', NULL, '21560', NULL, 'VO31215601', '2025-11-22 18:38:01', '2025-11-22 18:38:01'),
('529', '3286342156118', NULL, '21561', NULL, 'VO1215611', '2025-11-22 18:38:42', '2025-11-22 18:38:42'),
('530', '3286342967219', NULL, '29672', NULL, 'VO1329672', '2025-11-22 18:39:25', '2025-11-22 18:39:25'),
('531', '3286341320312', NULL, '13203', NULL, 'VO1320306', '2025-11-22 18:40:09', '2025-11-22 18:40:09'),
('532', '4038526448804', NULL, '720234', NULL, 'VO30720234', '2025-11-22 18:40:52', '2025-11-22 18:40:52'),
('533', '3286343218112', NULL, '32181', NULL, 'VO31432181', '2025-11-22 18:41:06', '2025-11-22 18:41:06'),
('534', '3286343222416', NULL, '32224', NULL, 'VO32224407', '2025-11-22 18:41:45', '2025-11-22 18:41:45'),
('535', '3528702630914', NULL, '263091', NULL, 'VO31263091', '2025-11-22 18:42:59', '2025-11-22 18:42:59'),
('536', '3528701414584', NULL, '141458', NULL, 'VO31414581', '2025-11-22 18:45:39', '2025-11-22 18:45:39'),
('537', '3286341043310', NULL, '10433', NULL, 'VO3104330', '2025-11-22 18:46:23', '2025-11-22 18:46:23'),
('538', '4038526054401', NULL, '579348', NULL, 'VOGODUN579348', '2025-11-22 18:48:03', '2025-11-22 18:48:03'),
('539', '4038526450029', NULL, '720313', NULL, 'VO30720313', '2025-11-22 18:48:46', '2025-11-22 18:48:46'),
('540', '3286342987019', NULL, '29870', NULL, 'VO1229870', '2025-11-22 18:50:51', '2025-11-22 18:50:51'),
('541', '3286343297513', NULL, '32975', NULL, 'VO1232975', '2025-11-22 18:52:31', '2025-11-22 18:52:31'),
('542', '3286343114810', NULL, '31148', NULL, 'VO32131148', '2025-11-22 18:52:44', '2025-11-22 18:52:44'),
('543', '3286341414813', NULL, '14148', NULL, 'VO31214148', '2025-11-22 18:55:51', '2025-11-22 18:55:51'),
('544', '3286342860015', NULL, '28600', NULL, 'VO31428600', '2025-11-22 18:56:04', '2025-11-22 18:56:04'),
('545', '3528706602597', NULL, '660259', NULL, 'VOMIMIC660259', '2025-11-22 18:56:52', '2025-11-22 18:56:52'),
('546', '3286343110010', NULL, '31100', NULL, 'VO30731100', '2025-11-22 18:57:06', '2025-11-22 18:57:06');


-- Table structure for `p2_tire_offers`
DROP TABLE IF EXISTS `p2_tire_offers`;
CREATE TABLE `p2_tire_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kunden_adr_id` int(11) NOT NULL,
  `autohaus_id` int(11) NOT NULL,
  `customer_name` varchar(255) DEFAULT NULL,
  `customer_vorname` varchar(255) DEFAULT NULL,
  `license_plate` varchar(20) DEFAULT NULL,
  `vin` varchar(50) DEFAULT NULL,
  `auftrag_nr` int(11) DEFAULT NULL,
  `offer_data` text DEFAULT NULL,
  `letter_content` text DEFAULT NULL,
  `employee_name` varchar(255) DEFAULT NULL,
  `token` varchar(64) DEFAULT NULL,
  `token_expires_at` datetime DEFAULT NULL,
  `token_used_at` datetime DEFAULT NULL,
  `email_sent` tinyint(1) DEFAULT 0,
  `email_sent_at` datetime DEFAULT NULL,
  `pdf_filename` varchar(255) DEFAULT NULL,
  `status` enum('draft','sent','accepted','declined','new_request','viewed','processed') DEFAULT 'draft',
  `customer_selection` text DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT 0.00,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `token` (`token`),
  KEY `idx_kunden_adr_id` (`kunden_adr_id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_license_plate` (`license_plate`),
  KEY `idx_auftrag_nr` (`auftrag_nr`),
  KEY `idx_status` (`status`),
  KEY `idx_token` (`token`),
  KEY `idx_created_at` (`created_at`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `p2_tire_offers_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `p2_tire_offers_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `p2_tire_offers`
INSERT INTO `p2_tire_offers` (`id`, `kunden_adr_id`, `autohaus_id`, `customer_name`, `customer_vorname`, `license_plate`, `vin`, `auftrag_nr`, `offer_data`, `letter_content`, `employee_name`, `token`, `token_expires_at`, `token_used_at`, `email_sent`, `email_sent_at`, `pdf_filename`, `status`, `customer_selection`, `total_amount`, `created_by`, `created_at`, `updated_at`) VALUES
('1', '139048', '1', 'Uludag', 'Deniz', 'KI-SD 221', '', '58256', '{\"new_tires\":[{\"brand_model\":\"Fulda - Kristall Montero 3 MS\",\"dimension\":\"195/65 R 15 91 T\",\"eu_label\":\"C C B 72\",\"rf\":\"\",\"price\":67,\"mounting\":0,\"quantity\":1,\"total\":67,\"ean\":\"5452000448125\",\"oem_part_number\":\"GOFUL530998\",\"part_number\":\"\",\"manufacturer_number\":\"530998\",\"execution\":\"SL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":56.3,\"ek\":37.63,\"oem_ek\":44.8,\"rabatt\":44,\"kb\":80,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[\"mounting\",\"storage\"],\"total_amount\":201.99}', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nKunde: Uludag Deniz\nKennzeichen: KI-SD 221\n\nMit freundlichen Grüßen\nB&E Autocentrum GmbH', 'Deniz Uludag', '7b3352643a018be9b8216e63ad758deb8165ad6edeb70db47913d315666b1e2c', '2025-12-23 19:53:13', NULL, '0', NULL, NULL, 'draft', NULL, '201.99', '1', '2025-11-23 19:53:13', '2025-11-23 19:53:13'),
('2', '139048', '1', 'Uludag', 'Deniz', 'KI-SD 221', '', '58256', '{\"new_tires\":[{\"brand_model\":\"Fulda - Kristall Montero 3 MS\",\"dimension\":\"195/65 R 15 91 T\",\"eu_label\":\"C C B 72\",\"rf\":\"\",\"price\":67,\"mounting\":0,\"quantity\":1,\"total\":67,\"ean\":\"5452000448125\",\"oem_part_number\":\"GOFUL530998\",\"part_number\":\"\",\"manufacturer_number\":\"530998\",\"execution\":\"SL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":56.3,\"ek\":37.63,\"oem_ek\":44.8,\"rabatt\":44,\"kb\":80,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[\"mounting\",\"storage\"],\"total_amount\":201.99}', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nKunde: Uludag Deniz\nKennzeichen: KI-SD 221\n\nMit freundlichen Grüßen\nB&E Autocentrum GmbH', 'Deniz Uludag', 'd5db0216f1f80cf37a82511d7cb18d46f61f3e69658bb5ec3541597e4585a309', '2025-12-23 19:57:28', NULL, '0', NULL, NULL, 'draft', NULL, '201.99', '1', '2025-11-23 19:57:28', '2025-11-23 19:57:28'),
('3', '139048', '1', 'Uludag', 'Deniz', 'KI-SD 221', '', '58256', '{\"new_tires\":[{\"brand_model\":\"Continental - ContiSportContact 5\",\"dimension\":\"235/40 R 18 95 W\",\"eu_label\":\"D B B 72\",\"rf\":\"\",\"price\":181,\"mounting\":0,\"quantity\":1,\"total\":181,\"ean\":\"4019238492156\",\"oem_part_number\":\"COCON0350994\",\"part_number\":\"\",\"manufacturer_number\":\"0350994000\",\"execution\":\"FP, XL, Seal\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Sommer\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"D\",\"price_net\":152.1,\"ek\":111.66,\"oem_ek\":121.37,\"rabatt\":47,\"kb\":229,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[\"mounting\",\"storage\"],\"total_amount\":315.99}', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nKunde: Uludag Deniz\nKennzeichen: KI-SD 221\n\nMit freundlichen Grüßen\nB&E Autocentrum GmbH', 'Deniz Uludag', 'ea25be03d2c915a5f6e8d3df0f1bcb648bd5d44a1ece077108e6593cc87b5b4f', '2025-12-23 20:10:41', NULL, '1', '2025-11-23 20:31:40', NULL, 'sent', NULL, '315.99', '1', '2025-11-23 20:10:41', '2025-11-23 20:31:40'),
('4', '139048', '1', 'Uludag', 'Deniz', 'KI-SD 221', '', '58256', '{\"new_tires\":[{\"brand_model\":\"Fulda - Kristall Montero 3 MS\",\"dimension\":\"195/65 R 15 91 T\",\"eu_label\":\"C C B 72\",\"rf\":\"\",\"price\":67,\"mounting\":0,\"quantity\":1,\"total\":67,\"ean\":\"5452000448125\",\"oem_part_number\":\"GOFUL530998\",\"part_number\":\"\",\"manufacturer_number\":\"530998\",\"execution\":\"SL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":56.3,\"ek\":37.63,\"oem_ek\":44.8,\"rabatt\":44,\"kb\":80,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[\"mounting\",\"storage\"],\"total_amount\":201.99}', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nKunde: Uludag Deniz\nKennzeichen: KI-SD 221\n\nMit freundlichen Grüßen\nB&E Autocentrum GmbH', 'Deniz Uludag', 'a026f249caa718183f9bf7f7d2e35435f79cff87ac5ec62b79280718c726104d', '2025-12-23 20:14:46', NULL, '1', '2025-11-23 20:14:56', NULL, 'sent', NULL, '201.99', '1', '2025-11-23 20:14:46', '2025-11-23 20:14:56'),
('5', '139048', '1', 'Uludag', 'Deniz', 'KI-SD 221', '', '58256', '{\"new_tires\":[{\"brand_model\":\"Continental - ContiSportContact 5\",\"dimension\":\"235/40 R 18 95 W\",\"eu_label\":\"D B B 72\",\"rf\":\"\",\"price\":181,\"mounting\":0,\"quantity\":1,\"total\":181,\"ean\":\"4019238492156\",\"oem_part_number\":\"COCON0350994\",\"part_number\":\"\",\"manufacturer_number\":\"0350994000\",\"execution\":\"FP, XL, Seal\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Sommer\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"D\",\"price_net\":152.1,\"ek\":111.66,\"oem_ek\":121.37,\"rabatt\":47,\"kb\":229,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Dunlop - SP Winter Sport 3D MS\",\"dimension\":\"235/65 R 17 104 H\",\"eu_label\":\"E C B 72\",\"rf\":\"\",\"price\":213,\"mounting\":0,\"quantity\":1,\"total\":213,\"ean\":\"4038526321824\",\"oem_part_number\":\"GODUN565776\",\"part_number\":\"\",\"manufacturer_number\":\"565776\",\"execution\":\"SL\",\"marking\":\"AO\",\"runflat\":\"\",\"vehicle_type\":\"Offroad\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"E\",\"price_net\":178.99,\"ek\":119.95,\"oem_ek\":142.8,\"rabatt\":44,\"kb\":255,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Dunlop - SP Winter Sport 4D MS\",\"dimension\":\"225/55 R 16 95 H\",\"eu_label\":\"E C B 70\",\"rf\":\"\",\"price\":182,\"mounting\":0,\"quantity\":1,\"total\":182,\"ean\":\"3188649811571\",\"oem_part_number\":\"GODUN526898\",\"part_number\":\"\",\"manufacturer_number\":\"526898\",\"execution\":\"FP, SL\",\"marking\":\"BMW*\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"70\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"E\",\"price_net\":152.94,\"ek\":102.55,\"oem_ek\":122.08,\"rabatt\":44,\"kb\":218,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[\"mounting\",\"storage\"],\"total_amount\":710.99}', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nKunde: Uludag Deniz\nKennzeichen: KI-SD 221\n\nMit freundlichen Grüßen\nB&E Autocentrum GmbH', 'Deniz Uludag', '0cd9c05dfbad7d8cbf1eb7eb3291cd946267963a157e3c33c8e7292596a07fba', '2025-12-23 20:42:42', '2025-11-23 21:03:13', '1', '2025-11-23 21:02:55', NULL, 'accepted', '{\"action\":\"accepted\",\"tires\":[\"1\"],\"services\":[],\"notes\":\"\"}', '710.99', '1', '2025-11-23 20:42:42', '2025-11-23 21:03:13');


-- Table structure for `project_offers`
DROP TABLE IF EXISTS `project_offers`;
CREATE TABLE `project_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(50) NOT NULL COMMENT 'Kunden-ID aus Projekt-Server',
  `customer_no` varchar(50) DEFAULT NULL COMMENT 'Kundennummer',
  `customer_name` varchar(255) DEFAULT NULL,
  `license_plate` varchar(20) DEFAULT NULL COMMENT 'Kennzeichen',
  `vin` varchar(50) DEFAULT NULL,
  `autohaus_id` int(11) NOT NULL,
  `offer_data` text DEFAULT NULL COMMENT 'JSON mit Reifendaten, Services, etc.',
  `letter_content` text DEFAULT NULL COMMENT 'Brieftext',
  `employee_name` varchar(255) DEFAULT NULL COMMENT 'Name des Mitarbeiters der das Angebot erstellt',
  `token` varchar(64) DEFAULT NULL COMMENT 'Token für Kundenauswahl',
  `token_expires_at` datetime DEFAULT NULL COMMENT 'Token-Ablaufzeit (24h)',
  `token_used_at` datetime DEFAULT NULL COMMENT 'Wann wurde Token verwendet',
  `email_sent` tinyint(1) DEFAULT 0 COMMENT 'Wurde Email versendet',
  `email_sent_at` datetime DEFAULT NULL,
  `pdf_filename` varchar(255) DEFAULT NULL,
  `status` enum('draft','sent','viewed','accepted','declined','new_request','processed') DEFAULT 'draft',
  `customer_selection` text DEFAULT NULL COMMENT 'JSON mit Kundenauswahl',
  `total_amount` decimal(10,2) DEFAULT NULL,
  `teams_notified` tinyint(1) DEFAULT 0 COMMENT 'Wurde Teams-Benachrichtigung gesendet',
  `teams_notified_at` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_customer_autohaus` (`customer_id`,`autohaus_id`),
  KEY `idx_license_plate` (`license_plate`),
  KEY `idx_token` (`token`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `project_offers`

-- Table structure for `push_notification_queue`
DROP TABLE IF EXISTS `push_notification_queue`;
CREATE TABLE `push_notification_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `custom_data` text DEFAULT NULL,
  `status` enum('pending','sent','failed') DEFAULT 'pending',
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `sent_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `fk_push_queue_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `push_notification_queue`

-- Table structure for `push_notification_settings`
DROP TABLE IF EXISTS `push_notification_settings`;
CREATE TABLE `push_notification_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `appointment_confirmations` tinyint(1) DEFAULT 1,
  `appointment_reminders` tinyint(1) DEFAULT 1,
  `reminder_hours_before` int(11) DEFAULT 24,
  `marketing_notifications` tinyint(1) DEFAULT 0,
  `system_notifications` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_settings` (`user_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `push_notification_settings`

-- Table structure for `push_notifications_log`
DROP TABLE IF EXISTS `push_notifications_log`;
CREATE TABLE `push_notifications_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `success` tinyint(1) DEFAULT 1,
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_sent_at` (`sent_at`),
  KEY `idx_success` (`success`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `push_notifications_log`

-- Table structure for `push_subscriptions`
DROP TABLE IF EXISTS `push_subscriptions`;
CREATE TABLE `push_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `autohaus_id` int(11) DEFAULT NULL,
  `endpoint` text NOT NULL,
  `p256dh_key` varchar(255) NOT NULL,
  `auth_key` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `is_active` tinyint(1) DEFAULT 1,
  `p256dh` varchar(200) NOT NULL,
  `auth` varchar(50) NOT NULL,
  `user_agent` text DEFAULT NULL,
  `device_info` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_endpoint` (`user_id`,`endpoint`(255)),
  UNIQUE KEY `unique_endpoint` (`endpoint`) USING HASH,
  KEY `idx_user_id` (`user_id`),
  KEY `idx_active` (`is_active`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  CONSTRAINT `fk_push_subscriptions_autohaus` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL,
  CONSTRAINT `push_subscriptions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `push_subscriptions`
INSERT INTO `push_subscriptions` (`id`, `user_id`, `autohaus_id`, `endpoint`, `p256dh_key`, `auth_key`, `created_at`, `updated_at`, `is_active`, `p256dh`, `auth`, `user_agent`, `device_info`) VALUES
('3', '65', NULL, 'https://web.push.apple.com/QMrkqfAXY3BjUtw0cjFLOVP2Be6v8qGOTGo2WcsIad19jUEm61qyz7WcvuuefrnQedsOXIrTvvdMC3Dq_tpq9QPVJHAoYuOFCMFK8PCCxARxBXbQsncpeRaFwtpY-H8KK-Anbfh4Tccklym2rWruW4otn9QGZnZAjcw8cul3Y84', '', '', '2025-11-13 22:37:58', '2025-11-13 22:37:58', '1', 'BBs68gh3HakkmNOHped4g7yUl79laXka0Og-PyNyMnP4UBaHjKIDvbWKqSqGFfDoPedIR7wPniER4SvrprMBWXM', 'jDNDjMUIiMOIqTNPHRFbPQ', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.2 Mobile/15E148 Safari/604.1', '{\"platform\":\"unknown\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}'),
('6', '65', NULL, 'https://web.push.apple.com/QOQVJ6Z5YWqK9dMFh3Z5FHqjMP5kdlvfYY51g_D563wCA0RKHEdH_LRGBCBTrhfD1jE5bKtLkHOkWzCZRn-xqZ95ND2CfSjyzoMEgale7tsNH3484RAQr5VF0TYGhFfKi4W2Uo1DMzLIw1K72ftZnZvV9AYWzs_kv1VL5pH9i0A', '', '', '2025-11-14 00:29:16', '2025-11-14 00:29:16', '1', 'BHauOvQmlStMeC1tvNsBVarWrcdudS4Z6OZLbt5RM9_yT5ik6-BEnZnYwDbup3DyEUp83JvS15ITXZvckMUqOTI', '5fwtQOG_6rPVI9AZpb9VVA', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.2 Mobile/15E148 Safari/604.1', '{\"platform\":\"unknown\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}'),
('7', '64', NULL, 'https://web.push.apple.com/QDkLB_E7nLrLZIx36uNkHFKwifjg2v6pZ9LbpEsyW_I0hjIz6lJYGmlvOZanwr40pr_s2WaqwLTMCtZUJ4K5L3oY1ZzV45XitoGTi7so_UJazFOrpZMIDOUR66KfB0MbOV3ljQ7zZVRuKdMSiJbVZ8zn9NY3Qd7VGFURyWjkyQ4', '', '', '2025-11-14 00:34:29', '2025-11-14 00:34:29', '1', 'BMoryf97xEZBo1ydtSj0lFIxFVu7nOscZdB-FQ2G5ulO8iTZG-zwU32qC2WHjOxv0q1dw5d6ggOgLyRnVmXyZtg', 'Dr0xqV690CoYNIS5vdskEA', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.2 Mobile/15E148 Safari/604.1', '{\"platform\":\"unknown\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}'),
('8', '64', NULL, 'https://web.push.apple.com/QNI0y4yy05dr1UDE_78fr_uNAP5CaXjMlLLshqHXba-AEbuOZimYiTAPAEXoeHd10dRw1dAw3VvalVTqy-4CxGCfUu6WvgogArsWLgD8yvp75RWjDoZZkW5q4xEuhvxKR1U0JjuBLJ8D7PuL3Odi7omXFmoH33XKWanpQDXl8S8', '', '', '2025-11-14 09:05:54', '2025-11-14 09:05:54', '1', 'BHJ13JJ_AN1w1DqA0XNMJpAvNf5XH2KPKAaCNs6PCgaIK6-anpDurKhQSbaWWNFz2q7h4tx4KRdVc5QXAExwo3Y', 'EfKYOlMB2kCu_xfSaLndTg', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.2 Mobile/15E148 Safari/604.1', '{\"platform\":\"unknown\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}'),
('12', '65', NULL, 'https://fcm.googleapis.com/fcm/send/fhZ6z4U7hPU:APA91bFyRyZy1sm8OuOt9MM6dtQwRJ1BNQ2ImKwtsbPgH4VcWq6NbVc85CFB3jYqNoBTiUxxb-31tvJQ8CgQwO_NT7yKIULgdu72A8CjX0vkvvA7pItXZnswgrocf5B_fgdggeGHhunv', '', '', '2025-11-14 20:37:05', '2025-11-14 20:37:05', '1', 'BEilE3mZu__e6fGlzX8-IKuDDdiMkQi7az6lubh7-pnzHzYBjuVFVl6QnZFXfQzcBw1yt5VSiMEb2sMeXr5YOo0', 'TKXOlUcwRBifIrLjeq1l9A', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '{\"platform\":\"\\\"macOS\\\"\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}'),
('13', '65', NULL, 'https://web.push.apple.com/QMo1os_ZlLg_XtFIbbtXKLZUD-FfH-QBpKoEYoQSHEvTkQC5yfZVXYyntXSRr-yjtE1Qqzr3JvWpb0urs5_K2atALN5TYP0ukMWOSxFIv7fZizPMLBnsDPp3AinJFofpvezF49ypbLoRrg4s1vqecX1Vpo8cpK0nBQu2Amx76Pg', '', '', '2025-11-14 22:37:33', '2025-11-14 22:37:33', '1', 'BKyHEWZYBrZ9Pczue13zLGFnVflcCAHwAwf4I6JYbNNKkZOIe85bTVILGADCdcY1wszSvPK5MFMQKggKCEVqi9w', 'iLpAMKaf0kXBZXtIHW5pNQ', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/26.2 Mobile/15E148 Safari/604.1', '{\"platform\":\"unknown\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}'),
('15', '64', NULL, 'https://fcm.googleapis.com/fcm/send/dGuNdr7pLNk:APA91bECZX_293uDipE413asi2jFsrGj-415CurqN3kedhfjO8jnqrX8J6aQBpMfhhXbGSF3rhyLmAIr2-tEW32Les-oHs3a9jWdRmkyeZvE0KS5Np3rXwiwpjAMdNFBKIml3MjBQYOD', '', '', '2025-11-17 07:47:50', '2025-11-17 07:47:50', '1', 'BLgpuuEDmSkOL1q0x8SukZEYr48n-5JYRbFPcLVxLtOW932n0SQqTIeoZQcVgnhsQD0_lC9rY-mPn0i6gbHkzhc', 'f4iWzbODY1wdmzRNBX08RA', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '{\"platform\":\"\\\"Windows\\\"\",\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}'),
('16', '78', NULL, 'https://fcm.googleapis.com/fcm/send/fzVa3N-d-10:APA91bHdKBohwnr-JYJHZ_qywVDoXFumzLtSOaEWvLybhPv0zZ34NMKDVGtj066t_0zZUfTp_1bBD5wE8_K3d1C0j288jStLM9zFQtGQhJoXJgtfuQ6tlhYl6GVd_LTLSTaZCpiaoChh', '', '', '2025-11-19 19:59:02', '2025-11-19 19:59:02', '1', 'BKVJwG8iM3ZL16UwFOicGKEcCfvGywORtn0R9cvqOdUX3Icl7KvfgibErGmZQ__DbB6LFDwNRwTC6KNjdzBmXNA', '-kNK2LXs12-rHR7BYa4ffA', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '{\"platform\":\"\\\"macOS\\\"\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}');


-- Table structure for `quick_actions`
DROP TABLE IF EXISTS `quick_actions`;
CREATE TABLE `quick_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `icon` varchar(50) NOT NULL DEFAULT 'fas fa-star',
  `url` varchar(500) NOT NULL,
  `target` varchar(10) DEFAULT '_self',
  `background_color` varchar(7) DEFAULT '#007bff',
  `text_color` varchar(7) DEFAULT '#ffffff',
  `position_order` int(11) DEFAULT 0,
  `is_active` tinyint(4) DEFAULT 1,
  `user_id` int(11) DEFAULT NULL,
  `autohaus_id` int(11) DEFAULT NULL,
  `share_token` varchar(32) DEFAULT NULL,
  `is_public` tinyint(4) DEFAULT 0,
  `created_by` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_active_order` (`is_active`,`position_order`),
  KEY `idx_user_autohaus` (`user_id`,`autohaus_id`),
  KEY `autohaus_id` (`autohaus_id`),
  KEY `idx_share_token` (`share_token`),
  KEY `idx_is_public` (`is_public`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_quick_actions_user_id` (`user_id`),
  KEY `idx_quick_actions_position_order` (`position_order`),
  KEY `idx_quick_actions_is_active` (`is_active`),
  CONSTRAINT `quick_actions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `quick_actions_ibfk_2` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `quick_actions`
INSERT INTO `quick_actions` (`id`, `title`, `description`, `icon`, `url`, `target`, `background_color`, `text_color`, `position_order`, `is_active`, `user_id`, `autohaus_id`, `share_token`, `is_public`, `created_by`, `created_at`, `updated_at`) VALUES
('1', 'Neues Event', 'Erstelle ein neues Event', 'fas fa-plus', 'events.php?action=create', '_self', '#28a745', '#ffffff', '1', '1', NULL, NULL, NULL, '0', NULL, '2025-09-23 21:35:03', '2025-09-23 21:35:03'),
('57', 'Performance', NULL, 'fas fa-chart-line', 'performance.php', '_self', '#FFCC00', '#ffffff', '0', '0', '1', NULL, NULL, '0', NULL, '2025-09-26 09:31:03', '2025-10-22 09:21:47'),
('58', 'Frontend anzeigen', NULL, 'fas fa-external-link-alt', '../index.php', '_self', '#30B0C7', '#ffffff', '0', '1', '1', NULL, NULL, '0', NULL, '2025-09-26 11:34:53', '2025-09-26 11:34:53'),
('60', 'Lager verwalten', NULL, 'fas fa-warehouse', 'storage.php', '_self', '#FF9500', '#ffffff', '0', '0', '1', NULL, NULL, '0', NULL, '2025-09-29 14:48:00', '2025-10-22 09:21:55'),
('61', 'Einstellungen', NULL, 'fas fa-cog', 'settings.php', '_self', '#5856D6', '#ffffff', '0', '0', '1', NULL, NULL, '0', NULL, '2025-09-29 14:48:00', '2025-10-22 09:21:54'),
('62', 'Profil bearbeiten', NULL, 'fas fa-user-edit', 'profile.php', '_self', '#00C7BE', '#ffffff', '0', '0', '1', NULL, NULL, '0', NULL, '2025-09-29 14:48:01', '2025-10-22 09:21:53'),
('63', 'Dashboard', NULL, 'fas fa-tachometer-alt', 'index.php', '_self', '#FF2D92', '#ffffff', '0', '0', '1', NULL, NULL, '0', NULL, '2025-09-29 14:48:02', '2025-10-22 09:21:52'),
('64', 'Benutzerverwaltung', NULL, 'fas fa-users', 'https://be-automobileapps.de/admin/admin_dashboard.php', '_self', '#ff2d92', '#ffffff', '0', '1', '1', NULL, NULL, '0', NULL, '2025-10-23 13:12:28', '2025-11-16 20:14:30'),
('68', 'Cache Management', NULL, 'fas fa-database', 'cache_management.php', '_self', '#10b981', '#ffffff', '1', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:41:55', '2025-11-17 04:41:55'),
('69', 'Profil', NULL, 'fas fa-user', 'profile.php', '_self', '#007aff', '#ffffff', '2', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:10', '2025-11-17 04:42:10'),
('70', 'Aufgaben Manager', NULL, 'fas fa-tasks', 'tasks_manager.php', '_self', '#f59e0b', '#ffffff', '3', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:15', '2025-11-17 04:42:15'),
('71', 'Performance', NULL, 'fas fa-chart-line', 'performance.php', '_self', '#8b5cf6', '#ffffff', '4', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:19', '2025-11-17 04:42:19'),
('72', 'Audit Log', NULL, 'fas fa-clipboard-list', 'audit_log.php', '_self', '#6366f1', '#ffffff', '5', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:24', '2025-11-17 04:42:24'),
('73', 'Cache Management', NULL, 'fas fa-database', 'cache_management.php', '_self', '#10b981', '#ffffff', '6', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:31', '2025-11-17 04:42:31'),
('74', 'RESY Import', NULL, 'fas fa-upload', 'import_resy_data.php', '_self', '#06b6d4', '#ffffff', '7', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:35', '2025-11-17 04:42:35'),
('75', 'Project Server', NULL, 'fas fa-server', 'project_server.php', '_self', '#ef4444', '#ffffff', '8', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:38', '2025-11-17 04:42:38'),
('76', 'Schnellaktionen Manager', NULL, 'fas fa-rocket', 'quick_actions_manager.php', '_self', '#af52de', '#ffffff', '9', '1', '1', NULL, NULL, '0', NULL, '2025-11-17 04:42:42', '2025-11-17 04:42:42');


-- Table structure for `resy_data_cache`
DROP TABLE IF EXISTS `resy_data_cache`;
CREATE TABLE `resy_data_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `einlagerungsnummer` varchar(50) NOT NULL,
  `appointment_id` int(11) DEFAULT NULL,
  `vehicle_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`vehicle_data`)),
  `tire_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`tire_data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `expires_at` timestamp NOT NULL DEFAULT (current_timestamp() + interval 30 day),
  PRIMARY KEY (`id`),
  KEY `idx_einlagerungsnummer` (`einlagerungsnummer`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `resy_data_cache`
INSERT INTO `resy_data_cache` (`id`, `einlagerungsnummer`, `appointment_id`, `vehicle_data`, `tire_data`, `created_at`, `updated_at`, `expires_at`) VALUES
('64', '9716706', '100', '{\"fahrzeughalter\":\"Carsten Mutschinski Elektrotechnik\",\"kennzeichen\":\"KI-CM105E\",\"fin\":\"LYVUZH1V8PB247375\",\"eingangsnummer\":\"9.716.706\",\"ladestelle\":\"113 B & E \\/ Kiel\",\"bemerkung\":\"\",\"ruecklieferungsdatum\":\"16.10.2025\",\"rueckgabe_bemerkung\":\"Termin am 21.10.\"}', '{\"VR\":{\"position\":\"VR\",\"size\":\"255\\/45R20\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"3321\",\"profile_depth\":\"6,4 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"6,5 mm\",\"profile_depth_middle\":\"6,5 mm\",\"profile_depth_outer\":\"6,4 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76620&FN=ShowPruefDoc\",\"lgfoto_id\":\"76620\",\"onclick\":\"openbox(\\\"9716706 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76620&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76620&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76619&FN=ShowPruefDoc\",\"lgfoto_id\":\"76619\",\"onclick\":\"openbox(\\\"9716706 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76619&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76619&appointment_id=100\"}]},\"VL\":{\"position\":\"VL\",\"size\":\"255\\/45R20\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"3321\",\"profile_depth\":\"6,3 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"6,7 mm\",\"profile_depth_middle\":\"7,0 mm\",\"profile_depth_outer\":\"6,3 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76618&FN=ShowPruefDoc\",\"lgfoto_id\":\"76618\",\"onclick\":\"openbox(\\\"9716706 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76618&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76618&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76617&FN=ShowPruefDoc\",\"lgfoto_id\":\"76617\",\"onclick\":\"openbox(\\\"9716706 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76617&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76617&appointment_id=100\"}]},\"HL\":{\"position\":\"HL\",\"size\":\"255\\/45R20\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"3321\",\"profile_depth\":\"6,8 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"6,8 mm\",\"profile_depth_middle\":\"6,9 mm\",\"profile_depth_outer\":\"6,9 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76622&FN=ShowPruefDoc\",\"lgfoto_id\":\"76622\",\"onclick\":\"openbox(\\\"9716706 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76622&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76622&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76621&FN=ShowPruefDoc\",\"lgfoto_id\":\"76621\",\"onclick\":\"openbox(\\\"9716706 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76621&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76621&appointment_id=100\"}]},\"HR\":{\"position\":\"HR\",\"size\":\"255\\/45R20\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"3321\",\"profile_depth\":\"6,7 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"6,7 mm\",\"profile_depth_middle\":\"6,7 mm\",\"profile_depth_outer\":\"6,7 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76624&FN=ShowPruefDoc\",\"lgfoto_id\":\"76624\",\"onclick\":\"openbox(\\\"9716706 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76624&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76624&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76623&FN=ShowPruefDoc\",\"lgfoto_id\":\"76623\",\"onclick\":\"openbox(\\\"9716706 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76623&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76623&appointment_id=100\"}]}}', '2025-09-26 22:13:59', '2025-09-26 22:13:59', '2025-09-27 22:13:59'),
('65', '9.718.351', '102', '{\"fahrzeughalter\":\"Roger Schwarz\",\"kennzeichen\":\"KI-R230E\",\"fin\":\"YV1XZBBVFM2615100\",\"eingangsnummer\":\"9.718.351\",\"ladestelle\":\"113 B & E \\/ Kiel\",\"bemerkung\":\"\",\"ruecklieferungsdatum\":\"\",\"rueckgabe_bemerkung\":\"\"}', '{\"VR\":{\"position\":\"VR\",\"size\":\"235\\/55R19\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2519\",\"profile_depth\":\"4,4 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"4,4 mm\",\"profile_depth_middle\":\"4,7 mm\",\"profile_depth_outer\":\"4,8 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76927&FN=ShowPruefDoc\",\"lgfoto_id\":\"76927\",\"onclick\":\"openbox(\\\"9718351 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76927&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76927&appointment_id=102\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76926&FN=ShowPruefDoc\",\"lgfoto_id\":\"76926\",\"onclick\":\"openbox(\\\"9718351 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76926&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76926&appointment_id=102\"}]},\"VL\":{\"position\":\"VL\",\"size\":\"235\\/55R19\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2519\",\"profile_depth\":\"4,9 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"Austausch notwendig\",\"condition\":\"bad\",\"condition_color\":\"red\",\"row_class\":\"WheelsBad\",\"profile_depth_inner\":\"5,2 mm\",\"profile_depth_middle\":\"5,0 mm\",\"profile_depth_outer\":\"4,9 mm\",\"tire_recommendation\":\"Austausch notwendig\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"Austausch notwendig\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76924&FN=ShowPruefDoc\",\"lgfoto_id\":\"76924\",\"onclick\":\"openbox(\\\"9718351 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76924&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76924&appointment_id=102\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76925&FN=ShowPruefDoc\",\"lgfoto_id\":\"76925\",\"onclick\":\"openbox(\\\"9718351 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76925&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76925&appointment_id=102\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76923&FN=ShowPruefDoc\",\"lgfoto_id\":\"76923\",\"onclick\":\"openbox(\\\"9718351 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76923&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76923&appointment_id=102\"}]},\"HL\":{\"position\":\"HL\",\"size\":\"235\\/55R19\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2519\",\"profile_depth\":\"7,2 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"7,3 mm\",\"profile_depth_middle\":\"7,4 mm\",\"profile_depth_outer\":\"7,2 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76929&FN=ShowPruefDoc\",\"lgfoto_id\":\"76929\",\"onclick\":\"openbox(\\\"9718351 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76929&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76929&appointment_id=102\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76928&FN=ShowPruefDoc\",\"lgfoto_id\":\"76928\",\"onclick\":\"openbox(\\\"9718351 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76928&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76928&appointment_id=102\"}]},\"HR\":{\"position\":\"HR\",\"size\":\"235\\/55R19\",\"load_index_1\":\"105\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Nokian\",\"model\":\"WR SUV4\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2519\",\"profile_depth\":\"6,8 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"6,8 mm\",\"profile_depth_middle\":\"6,9 mm\",\"profile_depth_outer\":\"6,8 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76931&FN=ShowPruefDoc\",\"lgfoto_id\":\"76931\",\"onclick\":\"openbox(\\\"9718351 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76931&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76931&appointment_id=102\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76930&FN=ShowPruefDoc\",\"lgfoto_id\":\"76930\",\"onclick\":\"openbox(\\\"9718351 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=76930&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=76930&appointment_id=102\"}]}}', '2025-09-26 22:14:06', '2025-09-26 22:14:06', '2025-09-27 22:14:06'),
('66', '9.329.579', '101', '{\"fahrzeughalter\":\"Hans-Peter H\\u00fcbner\",\"kennzeichen\":\"KI-PH171\",\"fin\":\"YV1MW084282416047\",\"eingangsnummer\":\"9.329.579\",\"ladestelle\":\"113 B & E \\/ Kiel\",\"bemerkung\":\"\",\"ruecklieferungsdatum\":\"\",\"rueckgabe_bemerkung\":\"\"}', '{\"VR\":{\"position\":\"VR\",\"size\":\"205\\/55R16\",\"load_index_1\":\"91\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"H\",\"brand\":\"Dunlop\",\"model\":\"WINTER SPORT 5\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2716\",\"profile_depth\":\"6,0 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"Austausch notwendig\",\"condition\":\"bad\",\"condition_color\":\"red\",\"row_class\":\"WheelsBad\",\"profile_depth_inner\":\"6,3 mm\",\"profile_depth_middle\":\"6,0 mm\",\"profile_depth_outer\":\"6,1 mm\",\"tire_recommendation\":\"Austausch notwendig\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"Austausch notwendig\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54502&FN=ShowPruefDoc\",\"lgfoto_id\":\"54502\",\"onclick\":\"openbox(\\\"9329579 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54502&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54502&appointment_id=101\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54501&FN=ShowPruefDoc\",\"lgfoto_id\":\"54501\",\"onclick\":\"openbox(\\\"9329579 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54501&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54501&appointment_id=101\"}]},\"VL\":{\"position\":\"VL\",\"size\":\"205\\/55R16\",\"load_index_1\":\"91\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"H\",\"brand\":\"Dunlop\",\"model\":\"WINTER SPORT 5\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2716\",\"profile_depth\":\"5,5 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"Austausch notwendig\",\"condition\":\"bad\",\"condition_color\":\"red\",\"row_class\":\"WheelsBad\",\"profile_depth_inner\":\"6,3 mm\",\"profile_depth_middle\":\"5,9 mm\",\"profile_depth_outer\":\"5,5 mm\",\"tire_recommendation\":\"Austausch notwendig\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"Austausch notwendig\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54500&FN=ShowPruefDoc\",\"lgfoto_id\":\"54500\",\"onclick\":\"openbox(\\\"9329579 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54500&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54500&appointment_id=101\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54499&FN=ShowPruefDoc\",\"lgfoto_id\":\"54499\",\"onclick\":\"openbox(\\\"9329579 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54499&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54499&appointment_id=101\"}]},\"HL\":{\"position\":\"HL\",\"size\":\"205\\/55R16\",\"load_index_1\":\"91\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"H\",\"brand\":\"Dunlop\",\"model\":\"WINTER SPORT 5\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2716\",\"profile_depth\":\"7,5 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"Austausch notwendig\",\"condition\":\"bad\",\"condition_color\":\"red\",\"row_class\":\"WheelsBad\",\"profile_depth_inner\":\"7,5 mm\",\"profile_depth_middle\":\"8,0 mm\",\"profile_depth_outer\":\"7,7 mm\",\"tire_recommendation\":\"Austausch notwendig\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"Austausch notwendig\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54504&FN=ShowPruefDoc\",\"lgfoto_id\":\"54504\",\"onclick\":\"openbox(\\\"9329579 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54504&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54504&appointment_id=101\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54503&FN=ShowPruefDoc\",\"lgfoto_id\":\"54503\",\"onclick\":\"openbox(\\\"9329579 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54503&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54503&appointment_id=101\"}]},\"HR\":{\"position\":\"HR\",\"size\":\"205\\/55R16\",\"load_index_1\":\"91\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"H\",\"brand\":\"Dunlop\",\"model\":\"WINTER SPORT 5\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"2716\",\"profile_depth\":\"7,7 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"Austausch notwendig\",\"condition\":\"bad\",\"condition_color\":\"red\",\"row_class\":\"WheelsBad\",\"profile_depth_inner\":\"7,7 mm\",\"profile_depth_middle\":\"8,1 mm\",\"profile_depth_outer\":\"7,9 mm\",\"tire_recommendation\":\"Austausch notwendig\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"Austausch notwendig\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54506&FN=ShowPruefDoc\",\"lgfoto_id\":\"54506\",\"onclick\":\"openbox(\\\"9329579 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54506&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54506&appointment_id=101\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54505&FN=ShowPruefDoc\",\"lgfoto_id\":\"54505\",\"onclick\":\"openbox(\\\"9329579 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=54505&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=54505&appointment_id=101\"}]}}', '2025-09-26 22:14:13', '2025-09-26 22:14:13', '2025-09-27 22:14:13'),
('67', '9.876.727', '100', '{\"fahrzeughalter\":\"Birte Dr. Stelck\",\"kennzeichen\":\"ECK-BE254\",\"fin\":\"YV1PWK5VCN1181200\",\"eingangsnummer\":\"9.876.727\",\"ladestelle\":\"113 B & E \\/ Kiel\",\"bemerkung\":\"\",\"ruecklieferungsdatum\":\"23.10.2025\",\"rueckgabe_bemerkung\":\"Kunde hat am 29.10. Termin\"}', '{\"VR\":{\"position\":\"VR\",\"size\":\"245\\/45R18\",\"load_index_1\":\"100\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Continental\",\"model\":\"WINTER CONTACT TS870 P\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"1323\",\"profile_depth\":\"5,3 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"5,7 mm\",\"profile_depth_middle\":\"5,4 mm\",\"profile_depth_outer\":\"5,3 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72651&FN=ShowPruefDoc\",\"lgfoto_id\":\"72651\",\"onclick\":\"openbox(\\\"9876727 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72651&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72651&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72650&FN=ShowPruefDoc\",\"lgfoto_id\":\"72650\",\"onclick\":\"openbox(\\\"9876727 | VR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72650&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72650&appointment_id=100\"}]},\"VL\":{\"position\":\"VL\",\"size\":\"245\\/45R18\",\"load_index_1\":\"100\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Continental\",\"model\":\"WINTER CONTACT TS870 P\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"1323\",\"profile_depth\":\"5,9 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"5,9 mm\",\"profile_depth_middle\":\"6,3 mm\",\"profile_depth_outer\":\"6,3 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72649&FN=ShowPruefDoc\",\"lgfoto_id\":\"72649\",\"onclick\":\"openbox(\\\"9876727 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72649&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72649&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72648&FN=ShowPruefDoc\",\"lgfoto_id\":\"72648\",\"onclick\":\"openbox(\\\"9876727 | VL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72648&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72648&appointment_id=100\"}]},\"HL\":{\"position\":\"HL\",\"size\":\"245\\/45R18\",\"load_index_1\":\"100\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Continental\",\"model\":\"WINTER CONTACT TS870 P\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"1323\",\"profile_depth\":\"7,1 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"7,1 mm\",\"profile_depth_middle\":\"7,5 mm\",\"profile_depth_outer\":\"7,4 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72653&FN=ShowPruefDoc\",\"lgfoto_id\":\"72653\",\"onclick\":\"openbox(\\\"9876727 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72653&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72653&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72652&FN=ShowPruefDoc\",\"lgfoto_id\":\"72652\",\"onclick\":\"openbox(\\\"9876727 | HL\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72652&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72652&appointment_id=100\"}]},\"HR\":{\"position\":\"HR\",\"size\":\"245\\/45R18\",\"load_index_1\":\"100\",\"load_index_2\":\"\\u00a0\",\"speed_index\":\"V\",\"brand\":\"Continental\",\"model\":\"WINTER CONTACT TS870 P\",\"manufacturer_code\":\"\\u00a0\",\"dot\":\"1323\",\"profile_depth\":\"7,1 mm\",\"runflat\":\"N\",\"tire_type\":\"Winterreifen\",\"rim_type\":\"\\u00a0\",\"recommendation\":\"keine Fehler\",\"condition\":\"good\",\"condition_color\":\"green\",\"row_class\":\"WheelsGood\",\"profile_depth_inner\":\"7,4 mm\",\"profile_depth_middle\":\"7,4 mm\",\"profile_depth_outer\":\"7,1 mm\",\"tire_recommendation\":\"keine Fehler\",\"rim_recommendation\":\"keine Fehler\",\"overall_recommendation\":\"keine Fehler\",\"images\":[{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72655&FN=ShowPruefDoc\",\"lgfoto_id\":\"72655\",\"onclick\":\"openbox(\\\"9876727 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72655&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72655&appointment_id=100\"},{\"src\":\"https:\\/\\/resy.dtm-reifen.de\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72654&FN=ShowPruefDoc\",\"lgfoto_id\":\"72654\",\"onclick\":\"openbox(\\\"9876727 | HR\\\", \\\"box\\\", this )\",\"original_src\":\".\\/index.php?m=wheelphoto&a=show&LGFOTO_ID=72654&FN=ShowPruefDoc\",\"proxy_url\":\"..\\/api\\/resy_image_proxy.php?lgfoto_id=72654&appointment_id=100\"}]}}', '2025-09-27 09:34:33', '2025-09-27 09:34:33', '2025-09-28 09:34:33');


-- Table structure for `resy_html_cache`
DROP TABLE IF EXISTS `resy_html_cache`;
CREATE TABLE `resy_html_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `einlagerungsnummer` varchar(50) NOT NULL,
  `appointment_id` int(11) DEFAULT NULL,
  `html_content` longtext DEFAULT NULL,
  `resy_base_url` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `expires_at` timestamp NOT NULL DEFAULT (current_timestamp() + interval 7 day),
  PRIMARY KEY (`id`),
  KEY `idx_einlagerungsnummer` (`einlagerungsnummer`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `resy_html_cache`
INSERT INTO `resy_html_cache` (`id`, `einlagerungsnummer`, `appointment_id`, `html_content`, `resy_base_url`, `created_at`, `updated_at`, `expires_at`) VALUES
('56', '9716706', '100', '﻿<!DOCTYPE html>\n<html lang=\"DE\">\n  <head>\n    <meta charset=\"utf-8\">\n    \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge\">\n  <title>Übersicht Räder</title>\n    <link href=\'.//framework/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/framework.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/application.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/fotos.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/wheelset.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <script type=\'text/javascript\' src=\'.//framework/javascript/cookietools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/formtools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/tabletools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/cart.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/form.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/fotos.js\'></script>\n  </head>\n  <body>\n    <!-- View: wheelset -->\n    <!-- Action: edit -->\n    <div class =\'application\'>\n      <header>\n        \r\n  <div class=\"header-title\">\r\n    <h1>RESY Websystem</h1>\r\n    <a href=./index.php?m=dashboard&a=preload>\r\n      <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\' class=\"resylogo\">\r\n    </a>\r\n    <h3>Übersicht Räder</h3>\r\n   <!-- <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\'> -->\r\n  </div>\r\n          <nav>\n   <ul>\n     <li class=\"dropdown item\"><a href=\'#\'>Übersicht</a>\n           <div class=\"dropdown-content\">\n             <ul>\n               <li><a href=\'./index.php?m=ubersicht&a=preload\'>Komplette Übersicht</a></li>\n               <li><a href=\'./index.php?m=dashboard&a=preload\'>Lagerbestand</a></li>\n               <li><a href=\'./index.php?m=bestellterucklieferungen&a=preload\'>Bestellte Rücklieferungen</a></li>\n               <li><a href=\'./index.php?m=bestellteabholung&a=index\'>Bestellte Abholungen</a></li>\n               <li><a href=\'./index.php?m=bestehenderollregale&a=index\'>Bestehende Rollregale</a></li>\n              \n             </ul>\n           </div>\n         </li>\n\n        <li class=\"dropdown item\"><a href=\'#\'>Rücklieferungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Rücklieferungen bestellen</a></li><li><a href=\'./index.php?m=RueckEinsehenStonieren&a=search\'>Rücklieferungen einsehen / stonieren</a></li>\n          </ul>\n        </div>\n      </li>\n\n         \n\n      \n               <li class=\"dropdown item\"><a href=\'#\'>Abholung</a>\n            <div class=\"dropdown-content\">\n              <ul>\n                <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Abholung bestellen</a></li>\n                <li><a href=\'./index.php?m=abholungeinsehenstornieren&a=search\'>Abholung einsehen / stonieren</a></li>\n              </ul>\n             </div>\n            </li>\n       \n        <li class=\"dropdown item\"><a href=\"#\"><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Sätze suchen</a></a>\n        <!-- <div class=\"dropdown-content\">\n          <ul >\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Suchen</a></li>\n          </ul>\n        </div> -->\n      </li>\n       \n      <li class=\"dropdown item\"><a href=\'#\'>Bestellungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=bestellung&a=index\'>Übersicht</a></li>          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\" id=\"menu_cart_lgsCart\"><img src=\'./application/view/img/shopping_cart.png\' alt=\'Vorgemerkte\'  ><span><a href=\'./index.php?m=returnorder&a=index\'> Rücklieferungen</a></span>\n        <span id=\'cart_counter_lgsCart\' class=\'cart_counter\'></span>\n      </li>\n\n    \n\n\n      <li class=\"dropdown item\"><a href=\'#\'>Stammdaten</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=ladeplatz&a=index\'>Ladestellen</a></li>\n            <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Fahrzeug suchen</a></li>\n          </ul>\n        </div>\n      </li>\n      \n      <!-- todo ab hier rechtsbündig und mit Icons -->\n\n      <li class=\"action item\"><a href=\"javascript:window.print()\"><img src=\'./application/view/img/drucker_icon.svg\' alt=\'resy drucker\' class = \'resyDrucker\' ></a></li>\n\n      <li class=\"dropdown item\"><a href=\"#\"><img src=\'./application/view/img/benutzer_box_white.svg\' alt=\'resy benutzer\'  ><span class=\"resyBenutzerName\"> D.ULUDAG</span></a>\n       <div class=\"dropdown-content\">\n          <ul >\n            <li class=\"action item\"><a href=\'./index.php?m=mitarbeiter&a=profil\'>Benutzerprofil</a></li>\n            <li class=\"action item\"><a href=\'./index.php?m=login&a=changepassword\'>Kennwort ändern</a></li>            <li class=\"action item\"><a href=\'./index.php?m=login&a=logout\'>Abmelden</a></li>\n          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\"><a href=\'./application/help/de/index.html#Wheelset_edit\' target=\'_blank\' ><img src=\'./application/view/img/help_center_white.svg\' alt=\'helpIcon\' class = \'helpIcon\' ></a></li>    </ul>\n\n  </nav>\n      </header>\n            <div class=\'main\'>\n            <div class=\"container\">\n                <div class=\'data\'>\n                  <h1 class =\'headerTitle\'>Übersicht Räder</h1>\n                  \n  <div id=\"Messages\">\n      </div>\n  \n  <div class=\"Data\">\n  \n    <div id=\"infobox\">\n   \n      <fieldset><legend>Einlagerungsinformationen</legend><div><label for=\'WheelLGS_ID\' class=\'Label\'>Satznummer: </label><p id=\'WheelLGS_ID\' name=\'\' class=\'InputNormal\'><b>9.716.706 </b></p></div><div><label for=\'WheelEINGANG\' class=\'Label\'>Eingangsdatum: </label><p id=\'WheelEINGANG\' name=\'\' class=\'InputNormal\'><b>08.04.2025</b></p></div><div><label for=\'WheelSERV_ID\' class=\'Label\'>Serviceart: </label><p id=\'WheelSERV_ID\' name=\'\' class=\'InputNormal\'><b>Lagern, Reinigen, Prüfen</b></p></div><div><label for=\'WheelAUSGANG\' class=\'Label\'>Ausgangsdatum: </label><p id=\'WheelAUSGANG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelFORMATLAGERPLATZ\' class=\'Label\'>Lagerplatz: </label><p id=\'WheelFORMATLAGERPLATZ\' name=\'\' class=\'InputNormal\'><b>05.0.014.007.1</b></p></div><div><label for=\'WheelKD_ID\' class=\'Label\'>Autohaus: </label><p id=\'WheelKD_ID\' name=\'\' class=\'InputNormal\'><b>113 B & E / Kiel</b></p></div><form action=\'./index.php?m=wheelset&a=edit\' method=\'post\' name=\'KundenBemerk\' onsubmit=\'disableButtons(this); return true;\' ><input type=\'hidden\' name=\'FN\' value=\'KundenBemerk\' /><input type=\'hidden\' name=\'LGS_ID\' value=\'9716706\' /><div class=\'KDBemerk\'><div><label for=\'WheelKDBEMERK\' class=\'Label\'>Bemerkung: </label><textarea type=\'text\' name=\'KDBEMERK\' cols=\'30\' rows=\'5\' class=\'InputNormal\' ></textarea></div></div><button type=\'submit\' class=\'ButtonSubmit\' name=\'button\' value=\'submit\'>Ändern</button></form><div  class=\'pdfDownload\'><a href=\'./index.php?m=checkreport&a=download&PRUFDOC_ID=184866&FN=WheelsetResult\'><img src=\'./application/view/img/pdf-file.png\' alt=\'Prüfbericht\'> Prüfbericht</a></div></fieldset><fieldset><legend>Fahrzeugdaten</legend><div><label for=\'WheelKENNZEICHEN\' class=\'Label\'>Kennzeichen: </label><p id=\'WheelKENNZEICHEN\' name=\'\' class=\'InputNormal\'><b>KI-CM105E</b></p></div><div><label for=\'WheelFAHRGESTNR\' class=\'Label\'>FIN: </label><p id=\'WheelFAHRGESTNR\' name=\'\' class=\'InputNormal\'><b>LYVUZH1V8PB247375</b></p></div><div><label for=\'WheelBEZEICHNUNG\' class=\'Label\'>Fzg. Bezeichnung: </label><p id=\'WheelBEZEICHNUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelANREDE_ID\' class=\'Label\'>Anrede: </label><p id=\'WheelANREDE_ID\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelHALTERNAME\' class=\'Label\'>Haltername: </label><p id=\'WheelHALTERNAME\' name=\'\' class=\'InputNormal\'><b>Carsten Mutschinski Elektrotechnik</b></p></div><div><label for=\'WheelSTRASS1\' class=\'Label\'>Straße: </label><p id=\'WheelSTRASS1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelORT\' class=\'Label\'>Ort: </label><p id=\'WheelORT\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelTELEFON1\' class=\'Label\'>Telefon: </label><p id=\'WheelTELEFON1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelEMAIL\' class=\'Label\'>E-Mail: </label><p id=\'WheelEMAIL\' name=\'\' class=\'InputNormal\'><b></b></p></div><div  class=\'fahrzeugeLink\'><a href=\'./index.php?m=fahrzeuge&a=edit&FZG_ID=509276&FN=FahrzeugDetails\'>Fahrzeugdaten anzeigen / ändern</a></div></fieldset><fieldset><legend>Rücklieferungen und Expresslieferung</legend>        <div id = \"RaderDeatailsButton\">\n             <a href=\'./index.php?m=wheelset&a=cancel&LGS_ID=9716706&FN=WheelsetResult\' onclick=\'return confirm(\"Bestellung für Satz 9716706 stornieren?\");\'><button id=\'ButtonDetailsCancelOrder\' type=\'button\'class=\'ButtonSubmit\'>Bestellung stornieren</button></a>        </div>\n    \n        <div id=\"RaderDetailsLadestelle\">\n          <div><label for=\'WheelRUECKLIEFERTERMIN\' class=\'Label\'>Rückliefertermin: </label><p id=\'WheelRUECKLIEFERTERMIN\' name=\'\' class=\'InputNormal\'><b>16.10.2025</b></p></div><div><label for=\'WEBUSER\' class=\'Label\'>bestellt durch: </label><p id=\'WEBUSER\' name=\'\' class=\'InputNormal\'><b>A.ZARGE</b></p></div><div><label for=\'wheelsRUECK.LADESTELLE\' class=\'Label\'>Ladestelle: </label><p id=\'wheelsRUECK.LADESTELLE\' name=\'\' class=\'InputNormal\'><b>113 B &amp; E / Kiel</b></p></div><div><label for=\'WheelRUECKAKTBEMERKUNG\' class=\'Label\'>Rückgabe Bemerkung: </label><p id=\'WheelRUECKAKTBEMERKUNG\' name=\'\' class=\'InputNormal\'><b>Termin am 21.10.</b></p></div>        </div>\n      \n        </fieldset>  <div><table id=\'WheelsetViewWheels\' class=\'ResultTable\' name=\'WheelsetViewWheels\'><caption>Geprüfte Räder</caption><colgroup><col class=\'DataCol\' id=\'WheelsetViewWheelsPOS_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFGROSSFMTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDX2DataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsSPEEDINDEXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFHERST_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFMODELL_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsHERSTKENN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsDOTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsPROFILDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRUNFLAT_FLGDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsREIFEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsFELGEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsEMPFEHL_IDDataCol\'></colgroup><thead><tr><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Position</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifengröße</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L1</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L2</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>SI</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenhersteller</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenmodell</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Herstellerkennung</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>DOT</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>Profil</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Notlaufeigenschaften</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Felgenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Empfehlung</th></tr></thead><tfoot><tr class=\'tablestatfooter\'><td align=\'left\' class=\'DataCol\'>Anz= 4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><tr></tfoot><tbody><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>VR</td><td align=\'left\' class=\'DataCol\'>255/45R20</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>3321</td><td align=\'right\' class=\'DataCol\'>6,4 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>VL</td><td align=\'left\' class=\'DataCol\'>255/45R20</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>3321</td><td align=\'right\' class=\'DataCol\'>6,3 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HL</td><td align=\'left\' class=\'DataCol\'>255/45R20</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>3321</td><td align=\'right\' class=\'DataCol\'>6,8 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HR</td><td align=\'left\' class=\'DataCol\'>255/45R20</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>3321</td><td align=\'right\' class=\'DataCol\'>6,7 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr></tbody></table></div><div id =\'raderBox\'><div id=\'raderUbersicht\'><div id =\'linkbox\'><div id =\'VL\'><div class=\'header-title\'>VL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,7 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>7,0 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,3 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id=\"popupInfos\" ><div id=\"tooltipBox\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div><div id =\'HL\'><div class=\'header-title\'>HL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,8 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,9 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,9 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div><div id =\'mittebox\'>\r\n                          <img src=\'./application/view/img/resyauto.png\' alt=\'resy auto\' class = \'carImage\' >           \r\n                 </div><div id =\'rechtbox\'><div id =\'VR\'><div class=\'header-title\'>VR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,5 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,5 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,4 mm</b></p></div></div></div><div  id=UberskeinFehler>X</div><div  id=\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div><div id =\'HR\'><div class=\'header-title\'>HR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,7 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,7 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,7 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\" ><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div></div></div><div id=\"filter\"></div>\n             <div id=\"box\" class=\"box\">\n                <div id=\"boximage\">\n                </div>\n                <p id=\"boxtitle_box\" class=\"boxtitle\"></p>\n            </div><div id = fotoGallery><div id =BildContent><div class = VLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76618&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76617&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VL</b></p></div></div><div class = VRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76620&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76619&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VR</b></p></div></div><div class = HLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76622&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76621&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HL</b></p></div></div><div class = HRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76624&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9716706 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76623&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HR</b></p></div></div></div></div>  </div>\n\n  </div>                </div>\n            </div>\n      </div>\n      <footer>\n        \r\n  <div class=\"logo\">\r\n    <p class=\'Impressum\'><a href=\'./index.php?m=impress&a=index\'>Impressum</a> | <a href=\'./index.php?m=privacy&a=index\'>Datenschutzerklärung</a> </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Stand der angezeigten Daten: 26.09.2025 22:13    </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Programmversion: <a href=\'./index.php?m=versionhistory&a=index\'>3.6.0</a>      Datenbankversion: 216      Frameworkversion: 0.16.1    </p>\r\n\r\n     <p class =\"Copyright\">  © Copyright by MMC GmbH </p>\r\n  \r\n  </div>\r\n          <!-- Laufzeit 0.066 Sekunden davon Datenbank 0.079 Sekunden -->\n<!-- Framework Version 0.16.1 -->\n<script type=\'text/javascript\'>function OnSelectionChange(tableId, selectedCount){}</script><script type=\'text/javascript\'>SortTable(document.getElementById(\'WheelsetViewWheels\'));</script><script type=\'text/javascript\'>OnSelectionChange(\'WheelsetViewWheels\', CountSelectedRow(\'WheelsetViewWheels\'));</script>      </footer>\n    </div>\n      </body>\n</html>', 'https://resy.dtm-reifen.de', '2025-09-26 22:13:59', '2025-09-26 22:13:59', '2025-09-27 22:13:59'),
('57', '9.718.351', '102', '﻿<!DOCTYPE html>\n<html lang=\"DE\">\n  <head>\n    <meta charset=\"utf-8\">\n    \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge\">\n  <title>Übersicht Räder</title>\n    <link href=\'.//framework/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/framework.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/application.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/fotos.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/wheelset.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <script type=\'text/javascript\' src=\'.//framework/javascript/cookietools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/formtools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/tabletools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/cart.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/form.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/fotos.js\'></script>\n  </head>\n  <body>\n    <!-- View: wheelset -->\n    <!-- Action: edit -->\n    <div class =\'application\'>\n      <header>\n        \r\n  <div class=\"header-title\">\r\n    <h1>RESY Websystem</h1>\r\n    <a href=./index.php?m=dashboard&a=preload>\r\n      <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\' class=\"resylogo\">\r\n    </a>\r\n    <h3>Übersicht Räder</h3>\r\n   <!-- <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\'> -->\r\n  </div>\r\n          <nav>\n   <ul>\n     <li class=\"dropdown item\"><a href=\'#\'>Übersicht</a>\n           <div class=\"dropdown-content\">\n             <ul>\n               <li><a href=\'./index.php?m=ubersicht&a=preload\'>Komplette Übersicht</a></li>\n               <li><a href=\'./index.php?m=dashboard&a=preload\'>Lagerbestand</a></li>\n               <li><a href=\'./index.php?m=bestellterucklieferungen&a=preload\'>Bestellte Rücklieferungen</a></li>\n               <li><a href=\'./index.php?m=bestellteabholung&a=index\'>Bestellte Abholungen</a></li>\n               <li><a href=\'./index.php?m=bestehenderollregale&a=index\'>Bestehende Rollregale</a></li>\n              \n             </ul>\n           </div>\n         </li>\n\n        <li class=\"dropdown item\"><a href=\'#\'>Rücklieferungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Rücklieferungen bestellen</a></li><li><a href=\'./index.php?m=RueckEinsehenStonieren&a=search\'>Rücklieferungen einsehen / stonieren</a></li>\n          </ul>\n        </div>\n      </li>\n\n         \n\n      \n               <li class=\"dropdown item\"><a href=\'#\'>Abholung</a>\n            <div class=\"dropdown-content\">\n              <ul>\n                <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Abholung bestellen</a></li>\n                <li><a href=\'./index.php?m=abholungeinsehenstornieren&a=search\'>Abholung einsehen / stonieren</a></li>\n              </ul>\n             </div>\n            </li>\n       \n        <li class=\"dropdown item\"><a href=\"#\"><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Sätze suchen</a></a>\n        <!-- <div class=\"dropdown-content\">\n          <ul >\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Suchen</a></li>\n          </ul>\n        </div> -->\n      </li>\n       \n      <li class=\"dropdown item\"><a href=\'#\'>Bestellungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=bestellung&a=index\'>Übersicht</a></li>          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\" id=\"menu_cart_lgsCart\"><img src=\'./application/view/img/shopping_cart.png\' alt=\'Vorgemerkte\'  ><span><a href=\'./index.php?m=returnorder&a=index\'> Rücklieferungen</a></span>\n        <span id=\'cart_counter_lgsCart\' class=\'cart_counter\'></span>\n      </li>\n\n    \n\n\n      <li class=\"dropdown item\"><a href=\'#\'>Stammdaten</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=ladeplatz&a=index\'>Ladestellen</a></li>\n            <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Fahrzeug suchen</a></li>\n          </ul>\n        </div>\n      </li>\n      \n      <!-- todo ab hier rechtsbündig und mit Icons -->\n\n      <li class=\"action item\"><a href=\"javascript:window.print()\"><img src=\'./application/view/img/drucker_icon.svg\' alt=\'resy drucker\' class = \'resyDrucker\' ></a></li>\n\n      <li class=\"dropdown item\"><a href=\"#\"><img src=\'./application/view/img/benutzer_box_white.svg\' alt=\'resy benutzer\'  ><span class=\"resyBenutzerName\"> D.ULUDAG</span></a>\n       <div class=\"dropdown-content\">\n          <ul >\n            <li class=\"action item\"><a href=\'./index.php?m=mitarbeiter&a=profil\'>Benutzerprofil</a></li>\n            <li class=\"action item\"><a href=\'./index.php?m=login&a=changepassword\'>Kennwort ändern</a></li>            <li class=\"action item\"><a href=\'./index.php?m=login&a=logout\'>Abmelden</a></li>\n          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\"><a href=\'./application/help/de/index.html#Wheelset_edit\' target=\'_blank\' ><img src=\'./application/view/img/help_center_white.svg\' alt=\'helpIcon\' class = \'helpIcon\' ></a></li>    </ul>\n\n  </nav>\n      </header>\n            <div class=\'main\'>\n            <div class=\"container\">\n                <div class=\'data\'>\n                  <h1 class =\'headerTitle\'>Übersicht Räder</h1>\n                  \n  <div id=\"Messages\">\n      </div>\n  \n  <div class=\"Data\">\n  \n    <div id=\"infobox\">\n   \n      <fieldset><legend>Einlagerungsinformationen</legend><div><label for=\'WheelLGS_ID\' class=\'Label\'>Satznummer: </label><p id=\'WheelLGS_ID\' name=\'\' class=\'InputNormal\'><b>9.718.351 </b></p></div><div><label for=\'WheelEINGANG\' class=\'Label\'>Eingangsdatum: </label><p id=\'WheelEINGANG\' name=\'\' class=\'InputNormal\'><b>15.04.2025</b></p></div><div><label for=\'WheelSERV_ID\' class=\'Label\'>Serviceart: </label><p id=\'WheelSERV_ID\' name=\'\' class=\'InputNormal\'><b>Lagern, Reinigen, Prüfen</b></p></div><div><label for=\'WheelAUSGANG\' class=\'Label\'>Ausgangsdatum: </label><p id=\'WheelAUSGANG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelFORMATLAGERPLATZ\' class=\'Label\'>Lagerplatz: </label><p id=\'WheelFORMATLAGERPLATZ\' name=\'\' class=\'InputNormal\'><b>05.0.015.002.1</b></p></div><div><label for=\'WheelKD_ID\' class=\'Label\'>Autohaus: </label><p id=\'WheelKD_ID\' name=\'\' class=\'InputNormal\'><b>113 B & E / Kiel</b></p></div><form action=\'./index.php?m=wheelset&a=edit\' method=\'post\' name=\'KundenBemerk\' onsubmit=\'disableButtons(this); return true;\' ><input type=\'hidden\' name=\'FN\' value=\'KundenBemerk\' /><input type=\'hidden\' name=\'LGS_ID\' value=\'9718351\' /><div class=\'KDBemerk\'><div><label for=\'WheelKDBEMERK\' class=\'Label\'>Bemerkung: </label><textarea type=\'text\' name=\'KDBEMERK\' cols=\'30\' rows=\'5\' class=\'InputNormal\' >Vorab bewerten \r\n\r\n07.08.2025 DVH</textarea></div></div><button type=\'submit\' class=\'ButtonSubmit\' name=\'button\' value=\'submit\'>Ändern</button></form><div  class=\'pdfDownload\'><a href=\'./index.php?m=checkreport&a=download&PRUFDOC_ID=184801&FN=WheelsetResult\'><img src=\'./application/view/img/pdf-file.png\' alt=\'Prüfbericht\'> Prüfbericht</a></div></fieldset><fieldset><legend>Fahrzeugdaten</legend><div><label for=\'WheelKENNZEICHEN\' class=\'Label\'>Kennzeichen: </label><p id=\'WheelKENNZEICHEN\' name=\'\' class=\'InputNormal\'><b>KI-R230E</b></p></div><div><label for=\'WheelFAHRGESTNR\' class=\'Label\'>FIN: </label><p id=\'WheelFAHRGESTNR\' name=\'\' class=\'InputNormal\'><b>YV1XZBBVFM2615100</b></p></div><div><label for=\'WheelBEZEICHNUNG\' class=\'Label\'>Fzg. Bezeichnung: </label><p id=\'WheelBEZEICHNUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelANREDE_ID\' class=\'Label\'>Anrede: </label><p id=\'WheelANREDE_ID\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelHALTERNAME\' class=\'Label\'>Haltername: </label><p id=\'WheelHALTERNAME\' name=\'\' class=\'InputNormal\'><b>Roger Schwarz</b></p></div><div><label for=\'WheelSTRASS1\' class=\'Label\'>Straße: </label><p id=\'WheelSTRASS1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelORT\' class=\'Label\'>Ort: </label><p id=\'WheelORT\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelTELEFON1\' class=\'Label\'>Telefon: </label><p id=\'WheelTELEFON1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelEMAIL\' class=\'Label\'>E-Mail: </label><p id=\'WheelEMAIL\' name=\'\' class=\'InputNormal\'><b></b></p></div><div  class=\'fahrzeugeLink\'><a href=\'./index.php?m=fahrzeuge&a=edit&FZG_ID=511593&FN=FahrzeugDetails\'>Fahrzeugdaten anzeigen / ändern</a></div></fieldset><fieldset><legend>Rücklieferungen und Expresslieferung</legend>        <div id = \"RaderDeatailsButton\">\n                     </div>\n    \n        <div id=\"RaderDetailsLadestelle\">\n          <div><label for=\'WheelRUECKLIEFERTERMIN\' class=\'Label\'>Rückliefertermin: </label><p id=\'WheelRUECKLIEFERTERMIN\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'wheelsRUECK.LADESTELLE\' class=\'Label\'>Ladestelle: </label><p id=\'wheelsRUECK.LADESTELLE\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelRUECKAKTBEMERKUNG\' class=\'Label\'>Rückgabe Bemerkung: </label><p id=\'WheelRUECKAKTBEMERKUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div>        </div>\n      \n        </fieldset>  <div><table id=\'WheelsetViewWheels\' class=\'ResultTable\' name=\'WheelsetViewWheels\'><caption>Geprüfte Räder</caption><colgroup><col class=\'DataCol\' id=\'WheelsetViewWheelsPOS_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFGROSSFMTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDX2DataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsSPEEDINDEXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFHERST_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFMODELL_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsHERSTKENN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsDOTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsPROFILDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRUNFLAT_FLGDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsREIFEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsFELGEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsEMPFEHL_IDDataCol\'></colgroup><thead><tr><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Position</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifengröße</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L1</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L2</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>SI</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenhersteller</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenmodell</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Herstellerkennung</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>DOT</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>Profil</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Notlaufeigenschaften</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Felgenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Empfehlung</th></tr></thead><tfoot><tr class=\'tablestatfooter\'><td align=\'left\' class=\'DataCol\'>Anz= 4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><tr></tfoot><tbody><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>VR</td><td align=\'left\' class=\'DataCol\'>235/55R19</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2519</td><td align=\'right\' class=\'DataCol\'>4,4 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsBad\'><td align=\'left\' class=\'DataCol\'>VL</td><td align=\'left\' class=\'DataCol\'>235/55R19</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2519</td><td align=\'right\' class=\'DataCol\'>4,9 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>Austausch notwendig</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HL</td><td align=\'left\' class=\'DataCol\'>235/55R19</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2519</td><td align=\'right\' class=\'DataCol\'>7,2 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HR</td><td align=\'left\' class=\'DataCol\'>235/55R19</td><td align=\'right\' class=\'DataCol\'>105 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Nokian</td><td align=\'left\' class=\'DataCol\'>WR SUV4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2519</td><td align=\'right\' class=\'DataCol\'>6,8 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr></tbody></table></div><div id =\'raderBox\'><div id=\'raderUbersicht\'><div id =\'linkbox\'><div id =\'VL\'><div class=\'header-title\'>VL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>5,2 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>5,0 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>4,9 mm</b></p></div></div></div><div  id=UbersAustausch> X</div><div id=\"popupInfos\" ><div id=\"tooltipBox\"><div class=\"RundFtittle\">  Rad- und Felgenfehler </div><ol><li><p id=\'RadUndFelgen\' name=\'\' class=\'InputNormal\'><b>Schnittverletzung</b></p></li></ol><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div></div></div></div></div><div id =\'HL\'><div class=\'header-title\'>HL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>7,3 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>7,4 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>7,2 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div><div id =\'mittebox\'>\r\n                          <img src=\'./application/view/img/resyauto.png\' alt=\'resy auto\' class = \'carImage\' >           \r\n                 </div><div id =\'rechtbox\'><div id =\'VR\'><div class=\'header-title\'>VR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>4,4 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>4,7 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>4,8 mm</b></p></div></div></div><div  id=UberskeinFehler>X</div><div  id=\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div><div id =\'HR\'><div class=\'header-title\'>HR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,8 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,9 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,8 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\" ><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div></div></div><div id=\"filter\"></div>\n             <div id=\"box\" class=\"box\">\n                <div id=\"boximage\">\n                </div>\n                <p id=\"boxtitle_box\" class=\"boxtitle\"></p>\n            </div><div id = fotoGallery><div id =BildContent><div class = VLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76924&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76925&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76923&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VL</b></p></div></div><div class = VRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76927&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76926&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VR</b></p></div></div><div class = HLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76929&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76928&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HL</b></p></div></div><div class = HRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76931&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9718351 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=76930&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HR</b></p></div></div></div></div>  </div>\n\n  </div>                </div>\n            </div>\n      </div>\n      <footer>\n        \r\n  <div class=\"logo\">\r\n    <p class=\'Impressum\'><a href=\'./index.php?m=impress&a=index\'>Impressum</a> | <a href=\'./index.php?m=privacy&a=index\'>Datenschutzerklärung</a> </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Stand der angezeigten Daten: 26.09.2025 22:14    </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Programmversion: <a href=\'./index.php?m=versionhistory&a=index\'>3.6.0</a>      Datenbankversion: 216      Frameworkversion: 0.16.1    </p>\r\n\r\n     <p class =\"Copyright\">  © Copyright by MMC GmbH </p>\r\n  \r\n  </div>\r\n          <!-- Laufzeit 0.054 Sekunden davon Datenbank 0.065 Sekunden -->\n<!-- Framework Version 0.16.1 -->\n<script type=\'text/javascript\'>function OnSelectionChange(tableId, selectedCount){}</script><script type=\'text/javascript\'>SortTable(document.getElementById(\'WheelsetViewWheels\'));</script><script type=\'text/javascript\'>OnSelectionChange(\'WheelsetViewWheels\', CountSelectedRow(\'WheelsetViewWheels\'));</script>      </footer>\n    </div>\n      </body>\n</html>', 'https://resy.dtm-reifen.de', '2025-09-26 22:14:06', '2025-09-26 22:14:06', '2025-09-27 22:14:06'),
('58', '9.329.579', '101', '﻿<!DOCTYPE html>\n<html lang=\"DE\">\n  <head>\n    <meta charset=\"utf-8\">\n    \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge\">\n  <title>Übersicht Räder</title>\n    <link href=\'.//framework/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/framework.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/application.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/fotos.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/wheelset.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <script type=\'text/javascript\' src=\'.//framework/javascript/cookietools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/formtools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/tabletools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/cart.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/form.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/fotos.js\'></script>\n  </head>\n  <body>\n    <!-- View: wheelset -->\n    <!-- Action: edit -->\n    <div class =\'application\'>\n      <header>\n        \r\n  <div class=\"header-title\">\r\n    <h1>RESY Websystem</h1>\r\n    <a href=./index.php?m=dashboard&a=preload>\r\n      <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\' class=\"resylogo\">\r\n    </a>\r\n    <h3>Übersicht Räder</h3>\r\n   <!-- <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\'> -->\r\n  </div>\r\n          <nav>\n   <ul>\n     <li class=\"dropdown item\"><a href=\'#\'>Übersicht</a>\n           <div class=\"dropdown-content\">\n             <ul>\n               <li><a href=\'./index.php?m=ubersicht&a=preload\'>Komplette Übersicht</a></li>\n               <li><a href=\'./index.php?m=dashboard&a=preload\'>Lagerbestand</a></li>\n               <li><a href=\'./index.php?m=bestellterucklieferungen&a=preload\'>Bestellte Rücklieferungen</a></li>\n               <li><a href=\'./index.php?m=bestellteabholung&a=index\'>Bestellte Abholungen</a></li>\n               <li><a href=\'./index.php?m=bestehenderollregale&a=index\'>Bestehende Rollregale</a></li>\n              \n             </ul>\n           </div>\n         </li>\n\n        <li class=\"dropdown item\"><a href=\'#\'>Rücklieferungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Rücklieferungen bestellen</a></li><li><a href=\'./index.php?m=RueckEinsehenStonieren&a=search\'>Rücklieferungen einsehen / stonieren</a></li>\n          </ul>\n        </div>\n      </li>\n\n         \n\n      \n               <li class=\"dropdown item\"><a href=\'#\'>Abholung</a>\n            <div class=\"dropdown-content\">\n              <ul>\n                <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Abholung bestellen</a></li>\n                <li><a href=\'./index.php?m=abholungeinsehenstornieren&a=search\'>Abholung einsehen / stonieren</a></li>\n              </ul>\n             </div>\n            </li>\n       \n        <li class=\"dropdown item\"><a href=\"#\"><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Sätze suchen</a></a>\n        <!-- <div class=\"dropdown-content\">\n          <ul >\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Suchen</a></li>\n          </ul>\n        </div> -->\n      </li>\n       \n      <li class=\"dropdown item\"><a href=\'#\'>Bestellungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=bestellung&a=index\'>Übersicht</a></li>          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\" id=\"menu_cart_lgsCart\"><img src=\'./application/view/img/shopping_cart.png\' alt=\'Vorgemerkte\'  ><span><a href=\'./index.php?m=returnorder&a=index\'> Rücklieferungen</a></span>\n        <span id=\'cart_counter_lgsCart\' class=\'cart_counter\'></span>\n      </li>\n\n    \n\n\n      <li class=\"dropdown item\"><a href=\'#\'>Stammdaten</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=ladeplatz&a=index\'>Ladestellen</a></li>\n            <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Fahrzeug suchen</a></li>\n          </ul>\n        </div>\n      </li>\n      \n      <!-- todo ab hier rechtsbündig und mit Icons -->\n\n      <li class=\"action item\"><a href=\"javascript:window.print()\"><img src=\'./application/view/img/drucker_icon.svg\' alt=\'resy drucker\' class = \'resyDrucker\' ></a></li>\n\n      <li class=\"dropdown item\"><a href=\"#\"><img src=\'./application/view/img/benutzer_box_white.svg\' alt=\'resy benutzer\'  ><span class=\"resyBenutzerName\"> D.ULUDAG</span></a>\n       <div class=\"dropdown-content\">\n          <ul >\n            <li class=\"action item\"><a href=\'./index.php?m=mitarbeiter&a=profil\'>Benutzerprofil</a></li>\n            <li class=\"action item\"><a href=\'./index.php?m=login&a=changepassword\'>Kennwort ändern</a></li>            <li class=\"action item\"><a href=\'./index.php?m=login&a=logout\'>Abmelden</a></li>\n          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\"><a href=\'./application/help/de/index.html#Wheelset_edit\' target=\'_blank\' ><img src=\'./application/view/img/help_center_white.svg\' alt=\'helpIcon\' class = \'helpIcon\' ></a></li>    </ul>\n\n  </nav>\n      </header>\n            <div class=\'main\'>\n            <div class=\"container\">\n                <div class=\'data\'>\n                  <h1 class =\'headerTitle\'>Übersicht Räder</h1>\n                  \n  <div id=\"Messages\">\n      </div>\n  \n  <div class=\"Data\">\n  \n    <div id=\"infobox\">\n   \n      <fieldset><legend>Einlagerungsinformationen</legend><div><label for=\'WheelLGS_ID\' class=\'Label\'>Satznummer: </label><p id=\'WheelLGS_ID\' name=\'\' class=\'InputNormal\'><b>9.329.579 </b></p></div><div><label for=\'WheelEINGANG\' class=\'Label\'>Eingangsdatum: </label><p id=\'WheelEINGANG\' name=\'\' class=\'InputNormal\'><b>20.03.2025</b></p></div><div><label for=\'WheelSERV_ID\' class=\'Label\'>Serviceart: </label><p id=\'WheelSERV_ID\' name=\'\' class=\'InputNormal\'><b>Lagern, Reinigen, Prüfen</b></p></div><div><label for=\'WheelAUSGANG\' class=\'Label\'>Ausgangsdatum: </label><p id=\'WheelAUSGANG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelFORMATLAGERPLATZ\' class=\'Label\'>Lagerplatz: </label><p id=\'WheelFORMATLAGERPLATZ\' name=\'\' class=\'InputNormal\'><b>05.0.023.002.3</b></p></div><div><label for=\'WheelKD_ID\' class=\'Label\'>Autohaus: </label><p id=\'WheelKD_ID\' name=\'\' class=\'InputNormal\'><b>113 B & E / Kiel</b></p></div><form action=\'./index.php?m=wheelset&a=edit\' method=\'post\' name=\'KundenBemerk\' onsubmit=\'disableButtons(this); return true;\' ><input type=\'hidden\' name=\'FN\' value=\'KundenBemerk\' /><input type=\'hidden\' name=\'LGS_ID\' value=\'9329579\' /><div class=\'KDBemerk\'><div><label for=\'WheelKDBEMERK\' class=\'Label\'>Bemerkung: </label><textarea type=\'text\' name=\'KDBEMERK\' cols=\'30\' rows=\'5\' class=\'InputNormal\' >alle vier Reifen aus KW 27/2016 ; Empfehlung : vier neue Winterreifen montieren ; OJ 06.08.2025</textarea></div></div><button type=\'submit\' class=\'ButtonSubmit\' name=\'button\' value=\'submit\'>Ändern</button></form><div  class=\'pdfDownload\'><a href=\'./index.php?m=checkreport&a=download&PRUFDOC_ID=185058&FN=WheelsetResult\'><img src=\'./application/view/img/pdf-file.png\' alt=\'Prüfbericht\'> Prüfbericht</a></div></fieldset><fieldset><legend>Fahrzeugdaten</legend><div><label for=\'WheelKENNZEICHEN\' class=\'Label\'>Kennzeichen: </label><p id=\'WheelKENNZEICHEN\' name=\'\' class=\'InputNormal\'><b>KI-PH171</b></p></div><div><label for=\'WheelFAHRGESTNR\' class=\'Label\'>FIN: </label><p id=\'WheelFAHRGESTNR\' name=\'\' class=\'InputNormal\'><b>YV1MW084282416047</b></p></div><div><label for=\'WheelBEZEICHNUNG\' class=\'Label\'>Fzg. Bezeichnung: </label><p id=\'WheelBEZEICHNUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelANREDE_ID\' class=\'Label\'>Anrede: </label><p id=\'WheelANREDE_ID\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelHALTERNAME\' class=\'Label\'>Haltername: </label><p id=\'WheelHALTERNAME\' name=\'\' class=\'InputNormal\'><b>Hans-Peter H&uuml;bner</b></p></div><div><label for=\'WheelSTRASS1\' class=\'Label\'>Straße: </label><p id=\'WheelSTRASS1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelORT\' class=\'Label\'>Ort: </label><p id=\'WheelORT\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelTELEFON1\' class=\'Label\'>Telefon: </label><p id=\'WheelTELEFON1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelEMAIL\' class=\'Label\'>E-Mail: </label><p id=\'WheelEMAIL\' name=\'\' class=\'InputNormal\'><b></b></p></div><div  class=\'fahrzeugeLink\'><a href=\'./index.php?m=fahrzeuge&a=edit&FZG_ID=509274&FN=FahrzeugDetails\'>Fahrzeugdaten anzeigen / ändern</a></div></fieldset><fieldset><legend>Rücklieferungen und Expresslieferung</legend>        <div id = \"RaderDeatailsButton\">\n                     </div>\n    \n        <div id=\"RaderDetailsLadestelle\">\n          <div><label for=\'WheelRUECKLIEFERTERMIN\' class=\'Label\'>Rückliefertermin: </label><p id=\'WheelRUECKLIEFERTERMIN\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'wheelsRUECK.LADESTELLE\' class=\'Label\'>Ladestelle: </label><p id=\'wheelsRUECK.LADESTELLE\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelRUECKAKTBEMERKUNG\' class=\'Label\'>Rückgabe Bemerkung: </label><p id=\'WheelRUECKAKTBEMERKUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div>        </div>\n      \n        </fieldset>  <div><table id=\'WheelsetViewWheels\' class=\'ResultTable\' name=\'WheelsetViewWheels\'><caption>Geprüfte Räder</caption><colgroup><col class=\'DataCol\' id=\'WheelsetViewWheelsPOS_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFGROSSFMTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDX2DataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsSPEEDINDEXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFHERST_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFMODELL_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsHERSTKENN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsDOTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsPROFILDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRUNFLAT_FLGDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsREIFEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsFELGEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsEMPFEHL_IDDataCol\'></colgroup><thead><tr><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Position</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifengröße</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L1</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L2</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>SI</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenhersteller</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenmodell</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Herstellerkennung</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>DOT</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>Profil</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Notlaufeigenschaften</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Felgenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Empfehlung</th></tr></thead><tfoot><tr class=\'tablestatfooter\'><td align=\'left\' class=\'DataCol\'>Anz= 4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><tr></tfoot><tbody><tr class=\'WheelsBad\'><td align=\'left\' class=\'DataCol\'>VR</td><td align=\'left\' class=\'DataCol\'>205/55R16</td><td align=\'right\' class=\'DataCol\'>91 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>H</td><td align=\'left\' class=\'DataCol\'>Dunlop</td><td align=\'left\' class=\'DataCol\'>WINTER SPORT 5</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2716</td><td align=\'right\' class=\'DataCol\'>6,0 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>Austausch notwendig</td></tr><tr class=\'WheelsBad\'><td align=\'left\' class=\'DataCol\'>VL</td><td align=\'left\' class=\'DataCol\'>205/55R16</td><td align=\'right\' class=\'DataCol\'>91 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>H</td><td align=\'left\' class=\'DataCol\'>Dunlop</td><td align=\'left\' class=\'DataCol\'>WINTER SPORT 5</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2716</td><td align=\'right\' class=\'DataCol\'>5,5 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>Austausch notwendig</td></tr><tr class=\'WheelsBad\'><td align=\'left\' class=\'DataCol\'>HL</td><td align=\'left\' class=\'DataCol\'>205/55R16</td><td align=\'right\' class=\'DataCol\'>91 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>H</td><td align=\'left\' class=\'DataCol\'>Dunlop</td><td align=\'left\' class=\'DataCol\'>WINTER SPORT 5</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2716</td><td align=\'right\' class=\'DataCol\'>7,5 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>Austausch notwendig</td></tr><tr class=\'WheelsBad\'><td align=\'left\' class=\'DataCol\'>HR</td><td align=\'left\' class=\'DataCol\'>205/55R16</td><td align=\'right\' class=\'DataCol\'>91 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>H</td><td align=\'left\' class=\'DataCol\'>Dunlop</td><td align=\'left\' class=\'DataCol\'>WINTER SPORT 5</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>2716</td><td align=\'right\' class=\'DataCol\'>7,7 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>Austausch notwendig</td></tr></tbody></table></div><div id =\'raderBox\'><div id=\'raderUbersicht\'><div id =\'linkbox\'><div id =\'VL\'><div class=\'header-title\'>VL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,3 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>5,9 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>5,5 mm</b></p></div></div></div><div  id=UbersAustausch> X</div><div id=\"popupInfos\" ><div id=\"tooltipBox\"><div class=\"RundFtittle\">  Rad- und Felgenfehler </div><ol><li><p id=\'RadUndFelgen\' name=\'\' class=\'InputNormal\'><b>DOT zu alt</b></p></li></ol><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div></div></div></div></div><div id =\'HL\'><div class=\'header-title\'>HL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>7,5 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>8,0 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>7,7 mm</b></p></div></div></div><div  id=UbersAustausch> X</div><div id =\"popupInfos\"><div class=\"RundFtittle\">  Rad- und Felgenfehler </div><ol><li><p id=\'RadUndFelgen\' name=\'\' class=\'InputNormal\'><b>DOT zu alt</b></p></li></ol><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div></div></div></div></div><div id =\'mittebox\'>\r\n                          <img src=\'./application/view/img/resyauto.png\' alt=\'resy auto\' class = \'carImage\' >           \r\n                 </div><div id =\'rechtbox\'><div id =\'VR\'><div class=\'header-title\'>VR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>6,3 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,0 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,1 mm</b></p></div></div></div><div  id=UbersAustausch>X</div><div  id=\"popupInfos\"><div class=\"RundFtittle\">  Rad- und Felgenfehler </div><ol><li><p id=\'RadUndFelgen\' name=\'\' class=\'InputNormal\'><b>DOT zu alt</b></p></li></ol><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div></div></div></div><div id =\'HR\'><div class=\'header-title\'>HR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>7,7 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>8,1 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>7,9 mm</b></p></div></div></div><div  id=UbersAustausch> X</div><div id =\"popupInfos\" ><div class=\"RundFtittle\">  Rad- und Felgenfehler </div><ol><li><p id=\'RadUndFelgen\' name=\'\' class=\'InputNormal\'><b>DOT zu alt</b></p></li></ol><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>Austausch notwendig</b></p></div></div></div></div></div></div></div></div><div id=\"filter\"></div>\n             <div id=\"box\" class=\"box\">\n                <div id=\"boximage\">\n                </div>\n                <p id=\"boxtitle_box\" class=\"boxtitle\"></p>\n            </div><div id = fotoGallery><div id =BildContent><div class = VLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54500&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54499&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VL</b></p></div></div><div class = VRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54502&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54501&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VR</b></p></div></div><div class = HLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54504&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54503&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HL</b></p></div></div><div class = HRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54506&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9329579 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=54505&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HR</b></p></div></div></div></div>  </div>\n\n  </div>                </div>\n            </div>\n      </div>\n      <footer>\n        \r\n  <div class=\"logo\">\r\n    <p class=\'Impressum\'><a href=\'./index.php?m=impress&a=index\'>Impressum</a> | <a href=\'./index.php?m=privacy&a=index\'>Datenschutzerklärung</a> </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Stand der angezeigten Daten: 26.09.2025 22:14    </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Programmversion: <a href=\'./index.php?m=versionhistory&a=index\'>3.6.0</a>      Datenbankversion: 216      Frameworkversion: 0.16.1    </p>\r\n\r\n     <p class =\"Copyright\">  © Copyright by MMC GmbH </p>\r\n  \r\n  </div>\r\n          <!-- Laufzeit 0.102 Sekunden davon Datenbank 0.138 Sekunden -->\n<!-- Framework Version 0.16.1 -->\n<script type=\'text/javascript\'>function OnSelectionChange(tableId, selectedCount){}</script><script type=\'text/javascript\'>SortTable(document.getElementById(\'WheelsetViewWheels\'));</script><script type=\'text/javascript\'>OnSelectionChange(\'WheelsetViewWheels\', CountSelectedRow(\'WheelsetViewWheels\'));</script>      </footer>\n    </div>\n      </body>\n</html>', 'https://resy.dtm-reifen.de', '2025-09-26 22:14:13', '2025-09-26 22:14:13', '2025-09-27 22:14:13'),
('59', '9.876.727', '100', '﻿<!DOCTYPE html>\n<html lang=\"DE\">\n  <head>\n    <meta charset=\"utf-8\">\n    \n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=Edge\">\n  <title>Übersicht Räder</title>\n    <link href=\'.//framework/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/framework.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//framework/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/application.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/common.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/desktop.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobile.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobilelandscape.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/mobileportrait.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/printer.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/fotos.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <link href=\'.//application/view/wheelset/wheelset.css\' rel=\'stylesheet\' type=\'text/css\' />\n    <script type=\'text/javascript\' src=\'.//framework/javascript/cookietools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/formtools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//framework/javascript/tabletools.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/cart.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/form.js\'></script>\n    <script type=\'text/javascript\' src=\'.//application/javascript/fotos.js\'></script>\n  </head>\n  <body>\n    <!-- View: wheelset -->\n    <!-- Action: edit -->\n    <div class =\'application\'>\n      <header>\n        \r\n  <div class=\"header-title\">\r\n    <h1>RESY Websystem</h1>\r\n    <a href=./index.php?m=dashboard&a=preload>\r\n      <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\' class=\"resylogo\">\r\n    </a>\r\n    <h3>Übersicht Räder</h3>\r\n   <!-- <img src=\'./application/view/img/resy_logo.png\' alt=\'RESY\'> -->\r\n  </div>\r\n          <nav>\n   <ul>\n     <li class=\"dropdown item\"><a href=\'#\'>Übersicht</a>\n           <div class=\"dropdown-content\">\n             <ul>\n               <li><a href=\'./index.php?m=ubersicht&a=preload\'>Komplette Übersicht</a></li>\n               <li><a href=\'./index.php?m=dashboard&a=preload\'>Lagerbestand</a></li>\n               <li><a href=\'./index.php?m=bestellterucklieferungen&a=preload\'>Bestellte Rücklieferungen</a></li>\n               <li><a href=\'./index.php?m=bestellteabholung&a=index\'>Bestellte Abholungen</a></li>\n               <li><a href=\'./index.php?m=bestehenderollregale&a=index\'>Bestehende Rollregale</a></li>\n              \n             </ul>\n           </div>\n         </li>\n\n        <li class=\"dropdown item\"><a href=\'#\'>Rücklieferungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Rücklieferungen bestellen</a></li><li><a href=\'./index.php?m=RueckEinsehenStonieren&a=search\'>Rücklieferungen einsehen / stonieren</a></li>\n          </ul>\n        </div>\n      </li>\n\n         \n\n      \n               <li class=\"dropdown item\"><a href=\'#\'>Abholung</a>\n            <div class=\"dropdown-content\">\n              <ul>\n                <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Abholung bestellen</a></li>\n                <li><a href=\'./index.php?m=abholungeinsehenstornieren&a=search\'>Abholung einsehen / stonieren</a></li>\n              </ul>\n             </div>\n            </li>\n       \n        <li class=\"dropdown item\"><a href=\"#\"><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Sätze suchen</a></a>\n        <!-- <div class=\"dropdown-content\">\n          <ul >\n            <li><a class=\'active\' href=\'./index.php?m=wheelset&a=search\'>Suchen</a></li>\n          </ul>\n        </div> -->\n      </li>\n       \n      <li class=\"dropdown item\"><a href=\'#\'>Bestellungen</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=bestellung&a=index\'>Übersicht</a></li>          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\" id=\"menu_cart_lgsCart\"><img src=\'./application/view/img/shopping_cart.png\' alt=\'Vorgemerkte\'  ><span><a href=\'./index.php?m=returnorder&a=index\'> Rücklieferungen</a></span>\n        <span id=\'cart_counter_lgsCart\' class=\'cart_counter\'></span>\n      </li>\n\n    \n\n\n      <li class=\"dropdown item\"><a href=\'#\'>Stammdaten</a>\n        <div class=\"dropdown-content\">\n          <ul>\n            <li><a href=\'./index.php?m=ladeplatz&a=index\'>Ladestellen</a></li>\n            <li><a href=\'./index.php?m=fahrzeuge&a=search\'>Fahrzeug suchen</a></li>\n          </ul>\n        </div>\n      </li>\n      \n      <!-- todo ab hier rechtsbündig und mit Icons -->\n\n      <li class=\"action item\"><a href=\"javascript:window.print()\"><img src=\'./application/view/img/drucker_icon.svg\' alt=\'resy drucker\' class = \'resyDrucker\' ></a></li>\n\n      <li class=\"dropdown item\"><a href=\"#\"><img src=\'./application/view/img/benutzer_box_white.svg\' alt=\'resy benutzer\'  ><span class=\"resyBenutzerName\"> D.ULUDAG</span></a>\n       <div class=\"dropdown-content\">\n          <ul >\n            <li class=\"action item\"><a href=\'./index.php?m=mitarbeiter&a=profil\'>Benutzerprofil</a></li>\n            <li class=\"action item\"><a href=\'./index.php?m=login&a=changepassword\'>Kennwort ändern</a></li>            <li class=\"action item\"><a href=\'./index.php?m=login&a=logout\'>Abmelden</a></li>\n          </ul>\n        </div>\n      </li>\n\n      <li class=\"action item\"><a href=\'./application/help/de/index.html#Wheelset_edit\' target=\'_blank\' ><img src=\'./application/view/img/help_center_white.svg\' alt=\'helpIcon\' class = \'helpIcon\' ></a></li>    </ul>\n\n  </nav>\n      </header>\n            <div class=\'main\'>\n            <div class=\"container\">\n                <div class=\'data\'>\n                  <h1 class =\'headerTitle\'>Übersicht Räder</h1>\n                  \n  <div id=\"Messages\">\n      </div>\n  \n  <div class=\"Data\">\n  \n    <div id=\"infobox\">\n   \n      <fieldset><legend>Einlagerungsinformationen</legend><div><label for=\'WheelLGS_ID\' class=\'Label\'>Satznummer: </label><p id=\'WheelLGS_ID\' name=\'\' class=\'InputNormal\'><b>9.876.727 </b></p></div><div><label for=\'WheelEINGANG\' class=\'Label\'>Eingangsdatum: </label><p id=\'WheelEINGANG\' name=\'\' class=\'InputNormal\'><b>12.06.2025</b></p></div><div><label for=\'WheelSERV_ID\' class=\'Label\'>Serviceart: </label><p id=\'WheelSERV_ID\' name=\'\' class=\'InputNormal\'><b>Lagern, Reinigen, Prüfen</b></p></div><div><label for=\'WheelAUSGANG\' class=\'Label\'>Ausgangsdatum: </label><p id=\'WheelAUSGANG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelFORMATLAGERPLATZ\' class=\'Label\'>Lagerplatz: </label><p id=\'WheelFORMATLAGERPLATZ\' name=\'\' class=\'InputNormal\'><b>05.0.005.008.3</b></p></div><div><label for=\'WheelKD_ID\' class=\'Label\'>Autohaus: </label><p id=\'WheelKD_ID\' name=\'\' class=\'InputNormal\'><b>113 B & E / Kiel</b></p></div><form action=\'./index.php?m=wheelset&a=edit\' method=\'post\' name=\'KundenBemerk\' onsubmit=\'disableButtons(this); return true;\' ><input type=\'hidden\' name=\'FN\' value=\'KundenBemerk\' /><input type=\'hidden\' name=\'LGS_ID\' value=\'9876727\' /><div class=\'KDBemerk\'><div><label for=\'WheelKDBEMERK\' class=\'Label\'>Bemerkung: </label><textarea type=\'text\' name=\'KDBEMERK\' cols=\'30\' rows=\'5\' class=\'InputNormal\' ></textarea></div></div><button type=\'submit\' class=\'ButtonSubmit\' name=\'button\' value=\'submit\'>Ändern</button></form><div  class=\'pdfDownload\'><a href=\'./index.php?m=checkreport&a=download&PRUFDOC_ID=184549&FN=WheelsetResult\'><img src=\'./application/view/img/pdf-file.png\' alt=\'Prüfbericht\'> Prüfbericht</a></div></fieldset><fieldset><legend>Fahrzeugdaten</legend><div><label for=\'WheelKENNZEICHEN\' class=\'Label\'>Kennzeichen: </label><p id=\'WheelKENNZEICHEN\' name=\'\' class=\'InputNormal\'><b>ECK-BE254</b></p></div><div><label for=\'WheelFAHRGESTNR\' class=\'Label\'>FIN: </label><p id=\'WheelFAHRGESTNR\' name=\'\' class=\'InputNormal\'><b>YV1PWK5VCN1181200</b></p></div><div><label for=\'WheelBEZEICHNUNG\' class=\'Label\'>Fzg. Bezeichnung: </label><p id=\'WheelBEZEICHNUNG\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelANREDE_ID\' class=\'Label\'>Anrede: </label><p id=\'WheelANREDE_ID\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelHALTERNAME\' class=\'Label\'>Haltername: </label><p id=\'WheelHALTERNAME\' name=\'\' class=\'InputNormal\'><b>Birte Dr. Stelck</b></p></div><div><label for=\'WheelSTRASS1\' class=\'Label\'>Straße: </label><p id=\'WheelSTRASS1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelORT\' class=\'Label\'>Ort: </label><p id=\'WheelORT\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelTELEFON1\' class=\'Label\'>Telefon: </label><p id=\'WheelTELEFON1\' name=\'\' class=\'InputNormal\'><b></b></p></div><div><label for=\'WheelEMAIL\' class=\'Label\'>E-Mail: </label><p id=\'WheelEMAIL\' name=\'\' class=\'InputNormal\'><b></b></p></div><div  class=\'fahrzeugeLink\'><a href=\'./index.php?m=fahrzeuge&a=edit&FZG_ID=509919&FN=FahrzeugDetails\'>Fahrzeugdaten anzeigen / ändern</a></div></fieldset><fieldset><legend>Rücklieferungen und Expresslieferung</legend>        <div id = \"RaderDeatailsButton\">\n             <a href=\'./index.php?m=wheelset&a=cancel&LGS_ID=9876727&FN=WheelsetResult\' onclick=\'return confirm(\"Bestellung für Satz 9876727 stornieren?\");\'><button id=\'ButtonDetailsCancelOrder\' type=\'button\'class=\'ButtonSubmit\'>Bestellung stornieren</button></a>        </div>\n    \n        <div id=\"RaderDetailsLadestelle\">\n          <div><label for=\'WheelRUECKLIEFERTERMIN\' class=\'Label\'>Rückliefertermin: </label><p id=\'WheelRUECKLIEFERTERMIN\' name=\'\' class=\'InputNormal\'><b>23.10.2025</b></p></div><div><label for=\'WEBUSER\' class=\'Label\'>bestellt durch: </label><p id=\'WEBUSER\' name=\'\' class=\'InputNormal\'><b>K.NEISE</b></p></div><div><label for=\'wheelsRUECK.LADESTELLE\' class=\'Label\'>Ladestelle: </label><p id=\'wheelsRUECK.LADESTELLE\' name=\'\' class=\'InputNormal\'><b>113 B &amp; E / Kiel</b></p></div><div><label for=\'WheelRUECKAKTBEMERKUNG\' class=\'Label\'>Rückgabe Bemerkung: </label><p id=\'WheelRUECKAKTBEMERKUNG\' name=\'\' class=\'InputNormal\'><b>Kunde hat am 29.10. Termin</b></p></div>        </div>\n      \n        </fieldset>  <div><table id=\'WheelsetViewWheels\' class=\'ResultTable\' name=\'WheelsetViewWheels\'><caption>Geprüfte Räder</caption><colgroup><col class=\'DataCol\' id=\'WheelsetViewWheelsPOS_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFGROSSFMTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFLOADINDX2DataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsSPEEDINDEXDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFHERST_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRFMODELL_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsHERSTKENN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsDOTDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsPROFILDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsRUNFLAT_FLGDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsREIFEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsFELGEN_IDDataCol\'><col class=\'DataCol\' id=\'WheelsetViewWheelsEMPFEHL_IDDataCol\'></colgroup><thead><tr><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Position</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifengröße</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L1</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>L2</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>SI</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenhersteller</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenmodell</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Herstellerkennung</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>DOT</th><th scope=\'col\' align=\'right\' class=\'DataCol locale_de\'>Profil</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Notlaufeigenschaften</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Reifenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Felgenart</th><th scope=\'col\' align=\'left\' class=\'DataCol ignore_case sort_string\'>Empfehlung</th></tr></thead><tfoot><tr class=\'tablestatfooter\'><td align=\'left\' class=\'DataCol\'>Anz= 4</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><tr></tfoot><tbody><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>VR</td><td align=\'left\' class=\'DataCol\'>245/45R18</td><td align=\'right\' class=\'DataCol\'>100 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Continental</td><td align=\'left\' class=\'DataCol\'>WINTER CONTACT TS870 P</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>1323</td><td align=\'right\' class=\'DataCol\'>5,3 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>VL</td><td align=\'left\' class=\'DataCol\'>245/45R18</td><td align=\'right\' class=\'DataCol\'>100 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Continental</td><td align=\'left\' class=\'DataCol\'>WINTER CONTACT TS870 P</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>1323</td><td align=\'right\' class=\'DataCol\'>5,9 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HL</td><td align=\'left\' class=\'DataCol\'>245/45R18</td><td align=\'right\' class=\'DataCol\'>100 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Continental</td><td align=\'left\' class=\'DataCol\'>WINTER CONTACT TS870 P</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>1323</td><td align=\'right\' class=\'DataCol\'>7,1 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr><tr class=\'WheelsGood\'><td align=\'left\' class=\'DataCol\'>HR</td><td align=\'left\' class=\'DataCol\'>245/45R18</td><td align=\'right\' class=\'DataCol\'>100 </td><td align=\'right\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>V</td><td align=\'left\' class=\'DataCol\'>Continental</td><td align=\'left\' class=\'DataCol\'>WINTER CONTACT TS870 P</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>1323</td><td align=\'right\' class=\'DataCol\'>7,1 mm</td><td align=\'left\' class=\'DataCol\'>N</td><td align=\'left\' class=\'DataCol\'>Winterreifen</td><td align=\'left\' class=\'DataCol\'>&nbsp;</td><td align=\'left\' class=\'DataCol\'>keine Fehler</td></tr></tbody></table></div><div id =\'raderBox\'><div id=\'raderUbersicht\'><div id =\'linkbox\'><div id =\'VL\'><div class=\'header-title\'>VL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>5,9 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>6,3 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>6,3 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id=\"popupInfos\" ><div id=\"tooltipBox\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div><div id =\'HL\'><div class=\'header-title\'>HL</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>7,1 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>7,5 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>7,4 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div><div id =\'mittebox\'>\r\n                          <img src=\'./application/view/img/resyauto.png\' alt=\'resy auto\' class = \'carImage\' >           \r\n                 </div><div id =\'rechtbox\'><div id =\'VR\'><div class=\'header-title\'>VR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>5,7 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>5,4 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>5,3 mm</b></p></div></div></div><div  id=UberskeinFehler>X</div><div  id=\"popupInfos\"><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div><div id =\'HR\'><div class=\'header-title\'>HR</div><div id =\'Ubersinfos\'><div id =\'UbersPosition\'><div id =\'Profilinnen\'><div><label for=\'RadProfilinnen\' class=\'Label\'>I: </label><p id=\'RadProfilinnen\' name=\'\' class=\'InputNormal\'><b>7,4 mm</b></p></div></div><div id =\'Profilmitte\'><div><label for=\'RadProfilmitte\' class=\'Label\'>M: </label><p id=\'RadProfilmitte\' name=\'\' class=\'InputNormal\'><b>7,4 mm</b></p></div></div><div id =\'Profilaussen\'><div><label for=\'RadProfilaussen\' class=\'Label\'>A: </label><p id=\'RadProfilaussen\' name=\'\' class=\'InputNormal\'><b>7,1 mm</b></p></div></div></div><div  id=UberskeinFehler> X</div><div id =\"popupInfos\" ><div id =\'EmpfehlungReifen\'><div><label for=\'RFEMPFEHL_ID\' class=\'Label\'>Empfehlung Reifen: </label><p id=\'RFEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungFelgen\'><div><label for=\'FGEMPFEHL_ID\' class=\'Label\'>Empfehlung Felgen: </label><p id=\'FGEMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div><div id =\'EmpfehlungPrüfergebnis\'><div><label for=\'EMPFEHL_ID\' class=\'Label\'>Empfehlung: </label><p id=\'EMPFEHL_ID\' name=\'\' class=\'InputNormal\'><b>keine Fehler</b></p></div></div></div></div></div></div></div></div><div id=\"filter\"></div>\n             <div id=\"box\" class=\"box\">\n                <div id=\"boximage\">\n                </div>\n                <p id=\"boxtitle_box\" class=\"boxtitle\"></p>\n            </div><div id = fotoGallery><div id =BildContent><div class = VLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72649&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | VL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72648&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VL</b></p></div></div><div class = VRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72651&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | VR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72650&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>VR</b></p></div></div><div class = HLbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72653&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | HL\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72652&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HL</b></p></div></div><div class = HRbild><div class=\'imgLine\'><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72655&FN=ShowPruefDoc\'></div><div class=imgBox><img  id=\'myImg\'  onclick=\'openbox(\"9876727 | HR\", \"box\", this )\' src=\'./index.php?m=wheelphoto&a=show&LGFOTO_ID=72654&FN=ShowPruefDoc\'></div></div><div class=\'RadPosition\'><label for=\'RadPos\' class=\'Label\'>Position: </label><p id=\'RadPos\' name=\'\' class=\'InputNormal\'><b>HR</b></p></div></div></div></div>  </div>\n\n  </div>                </div>\n            </div>\n      </div>\n      <footer>\n        \r\n  <div class=\"logo\">\r\n    <p class=\'Impressum\'><a href=\'./index.php?m=impress&a=index\'>Impressum</a> | <a href=\'./index.php?m=privacy&a=index\'>Datenschutzerklärung</a> </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Stand der angezeigten Daten: 27.09.2025 09:34    </p>\r\n  \r\n    <p class=\"VersionInfo\">\r\n      Programmversion: <a href=\'./index.php?m=versionhistory&a=index\'>3.6.0</a>      Datenbankversion: 216      Frameworkversion: 0.16.1    </p>\r\n\r\n     <p class =\"Copyright\">  © Copyright by MMC GmbH </p>\r\n  \r\n  </div>\r\n          <!-- Laufzeit 0.057 Sekunden davon Datenbank 0.081 Sekunden -->\n<!-- Framework Version 0.16.1 -->\n<script type=\'text/javascript\'>function OnSelectionChange(tableId, selectedCount){}</script><script type=\'text/javascript\'>SortTable(document.getElementById(\'WheelsetViewWheels\'));</script><script type=\'text/javascript\'>OnSelectionChange(\'WheelsetViewWheels\', CountSelectedRow(\'WheelsetViewWheels\'));</script>      </footer>\n    </div>\n      </body>\n</html>', 'https://resy.dtm-reifen.de', '2025-09-27 09:34:33', '2025-09-27 09:34:33', '2025-09-28 09:34:33');


-- Table structure for `resy_sessions`
DROP TABLE IF EXISTS `resy_sessions`;
CREATE TABLE `resy_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `session_id` varchar(255) NOT NULL,
  `cookie_data` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_used_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `expires_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_autohaus` (`autohaus_id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `resy_sessions`

-- Table structure for `resy_tire_data`
DROP TABLE IF EXISTS `resy_tire_data`;
CREATE TABLE `resy_tire_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `einlagerungsnummer` varchar(50) NOT NULL,
  `satznummer` varchar(50) NOT NULL,
  `eingangsdatum` date NOT NULL,
  `serviceart` varchar(255) DEFAULT 'Lagern, Reinigen, Prüfen',
  `autohaus_id` int(11) DEFAULT NULL,
  `kennzeichen` varchar(20) NOT NULL,
  `fin` varchar(50) NOT NULL,
  `haltername` varchar(255) NOT NULL,
  `fahrzeugtyp` varchar(255) DEFAULT NULL,
  `baujahr` varchar(10) DEFAULT NULL,
  `km_stand` varchar(20) DEFAULT NULL,
  `reifen_vl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`reifen_vl`)),
  `reifen_vr` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`reifen_vr`)),
  `reifen_hl` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`reifen_hl`)),
  `reifen_hr` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`reifen_hr`)),
  `images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`images`)),
  `bemerkung` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `einlagerungsnummer` (`einlagerungsnummer`),
  KEY `idx_einlagerungsnummer` (`einlagerungsnummer`),
  KEY `idx_kennzeichen` (`kennzeichen`),
  KEY `idx_fin` (`fin`),
  KEY `idx_autohaus` (`autohaus_id`),
  KEY `idx_eingangsdatum` (`eingangsdatum`),
  CONSTRAINT `resy_tire_data_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `resy_tire_data`

-- Table structure for `settings`
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting_key` varchar(100) NOT NULL,
  `setting_value` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `setting_key` (`setting_key`)
) ENGINE=InnoDB AUTO_INCREMENT=689 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `settings`
INSERT INTO `settings` (`id`, `setting_key`, `setting_value`, `description`, `updated_at`) VALUES
('1', 'company_name', 'B & E Vertriebsgesellschaft mbH', 'Name des Unternehmens', '2025-09-10 14:17:06'),
('2', 'company_logo', 'assets/images/BE-Logo-FINAL_Schwarz-1.png', 'Pfad zum Firmenlogo', '2025-10-26 19:54:57'),
('3', 'default_slot_duration', '30', 'Standard Slot-Dauer in Minuten', '2025-09-04 08:13:05'),
('4', 'max_monteure', '5', 'Maximale Anzahl Monteure', '2025-09-04 08:13:05'),
('5', 'contact_phone', '0431546300', 'Kontakttelefonnummer', '2025-09-04 08:30:21'),
('7', 'setup_completed', '1', 'Einrichtungsassistent abgeschlossen', '2025-09-04 08:32:40'),
('8', 'price_wheel_change', '49.99', NULL, '2025-09-04 10:51:28'),
('9', 'price_storage', '89.00', NULL, '2025-09-04 10:33:01'),
('11', 'price_spring_check', '39.00', NULL, '2025-09-04 10:33:01'),
('12', 'price_winter_check', '39.00', NULL, '2025-09-04 10:33:01'),
('13', 'company_phone', '040 5236076', NULL, '2025-09-10 14:17:06'),
('15', 'company_address', 'Niendorfer Str. 27, 22848 Norderstedt', NULL, '2025-09-10 14:17:06'),
('84', 'server_port', '8080', NULL, '2025-09-08 15:06:49'),
('85', 'domain_name', '172.24.10.114:8080', NULL, '2025-09-08 15:06:49'),
('115', 'admin_pending_notification_enabled', '1', NULL, '2025-09-08 18:42:01'),
('126', 'price_wiper_blades', 'auf_anfrage', NULL, '2025-09-09 14:00:51'),
('127', 'appointment_approval_required', '1', 'Terminbestätigung durch Admin erforderlich', '2025-09-09 19:25:04'),
('128', 'email_notifications_enabled', '1', 'E-Mail-Benachrichtigungen aktiviert', '2025-09-09 19:25:04'),
('129', 'auto_approve_appointments', '0', 'Termine automatisch genehmigen', '2025-09-09 19:25:04'),
('130', 'appointment_reminder_days', '1,3,7', 'Erinnerungstage vor Termin (kommagetrennt)', '2025-09-09 19:25:04'),
('131', 'smtp_server', 'smtp-mail.outlook.com', 'SMTP-Server', '2025-09-09 19:25:04'),
('132', 'smtp_port', '587', 'SMTP-Port', '2025-09-09 19:25:04'),
('133', 'smtp_username', 'rentacar-kiel@be-automobile.de', 'SMTP-Benutzername', '2025-09-09 19:25:04'),
('134', 'smtp_password', 'W@050373011206af', 'SMTP-Passwort', '2025-09-09 19:25:04'),
('135', 'smtp_use_tls', '1', 'SMTP TLS verwenden', '2025-09-09 19:25:04'),
('136', 'smtp_use_ssl', '0', 'SMTP SSL verwenden', '2025-09-09 19:25:04'),
('137', 'mail_from_email', 'rentacar-kiel@be-automobile.de', 'Absender-E-Mail', '2025-09-09 19:25:04'),
('138', 'mail_from_name', 'Boxenstop Volvo Service', 'Absender-Name', '2025-09-09 19:25:04'),
('139', 'multi_autohaus_enabled', '1', 'Multi-Autohaus-System aktiviert', '2025-09-10 11:22:22'),
('140', 'default_autohaus_id', '1', 'Standard-Autohaus ID', '2025-09-10 11:22:22'),
('141', 'autohaus_selection_required', '1', 'Autohaus-Auswahl f├╝r Kunden erforderlich', '2025-09-10 11:22:22'),
('142', 'admin_can_switch_autohaus', '1', 'Admins k├Ânnen zwischen Autoh├ñusern wechseln', '2025-09-10 11:22:22'),
('149', 'company_email', 'norderstedt@be-automobile.de', NULL, '2025-09-10 14:17:06'),
('163', 'app_name', 'Boxenstop', NULL, '2025-10-22 09:29:53'),
('164', 'timezone', 'Europe/Berlin', NULL, '2025-09-29 14:51:08'),
('165', 'date_format', 'd.m.Y', NULL, '2025-09-29 14:51:08'),
('166', 'time_format', 'H:i', NULL, '2025-09-29 14:51:08'),
('167', 'language', 'de', NULL, '2025-09-29 14:51:08'),
('168', 'max_appointments_per_slot', '5', NULL, '2025-09-29 14:51:08'),
('169', 'booking_advance_days', '30', NULL, '2025-09-29 14:51:08'),
('170', 'cancellation_hours', '24', NULL, '2025-09-29 14:51:08'),
('179', 'maintenance_mode', '1', NULL, '2025-11-23 11:39:03'),
('234', 'launch_date', '', NULL, '2025-10-22 12:44:04'),
('262', 'launch_date_text', 'Frühjahr 2026', NULL, '2025-10-22 12:44:29'),
('644', 'vapid_public_key', 'BEdIbV0RMbl1_aGVLF3KKVNrIbBb4o_oEvLIO-XyrYe-jYrdSawaDx9Aw_qejeq1sViyz95I3UykjSM-LikTDIs', NULL, '2025-11-13 22:31:32'),
('645', 'vapid_private_key', 'jeku-6xblAdXMyH2aAfWb5iu2dF-DaXWYl56z_6c9s4', NULL, '2025-11-13 22:31:32'),
('646', 'trigger_enabled_tire_offer_available', '1', NULL, '2025-11-13 23:43:44'),
('681', 'email_smtp_host', 'smtp-mail.outlook.com', NULL, '2025-11-23 23:27:25'),
('682', 'email_smtp_port', '587', NULL, '2025-11-23 23:27:25'),
('683', 'email_smtp_username', 'rentacar-kiel@be-automobile.de', NULL, '2025-11-23 23:27:25'),
('684', 'email_smtp_password', 'W@050373011206af', NULL, '2025-11-23 23:27:25'),
('685', 'email_from', 'rentacar-kiel@be-automobile.de', NULL, '2025-11-23 23:27:25'),
('686', 'email_from_name', 'Boxenstop', NULL, '2025-11-23 23:27:25'),
('687', 'email_use_tls', '1', NULL, '2025-11-23 23:27:25'),
('688', 'email_use_ssl', '0', NULL, '2025-11-23 23:27:25');


-- Table structure for `storage`
DROP TABLE IF EXISTS `storage`;
CREATE TABLE `storage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) DEFAULT NULL,
  `storage_number` varchar(50) NOT NULL,
  `customer_name` varchar(255) NOT NULL,
  `license_plate` varchar(20) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `storage_date` date NOT NULL,
  `status` enum('stored','retrieved') DEFAULT 'stored',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `storage_number` (`storage_number`),
  KEY `idx_storage_autohaus` (`autohaus_id`),
  CONSTRAINT `storage_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `storage`

-- Table structure for `teams_reactions`
DROP TABLE IF EXISTS `teams_reactions`;
CREATE TABLE `teams_reactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `teams_message_id` varchar(255) NOT NULL,
  `reaction_type` enum('tire_ordered','work_completed','customer_notified') NOT NULL,
  `reacted_by` varchar(255) NOT NULL,
  `reacted_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_reaction` (`appointment_id`,`teams_message_id`,`reaction_type`,`reacted_by`),
  CONSTRAINT `teams_reactions_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `teams_reactions`

-- Table structure for `tire_cancellations_audit`
DROP TABLE IF EXISTS `tire_cancellations_audit`;
CREATE TABLE `tire_cancellations_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `storage_number` varchar(50) NOT NULL,
  `event_name` varchar(255) DEFAULT NULL,
  `cancelled_by_user_id` int(11) DEFAULT NULL,
  `cancelled_by_username` varchar(100) DEFAULT NULL,
  `cancelled_at` datetime DEFAULT current_timestamp(),
  `cancellation_reason` text DEFAULT NULL,
  `resy_response` text DEFAULT NULL,
  `success` tinyint(1) DEFAULT 0,
  `error_message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_cancelled_at` (`cancelled_at`),
  KEY `idx_storage_number` (`storage_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `tire_cancellations_audit`

-- Table structure for `tire_checks`
DROP TABLE IF EXISTS `tire_checks`;
CREATE TABLE `tire_checks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `einlagerungsnummer` varchar(100) NOT NULL,
  `status` enum('checking','completed','error') DEFAULT 'checking',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `error` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_autohaus_einlagerung` (`autohaus_id`,`einlagerungsnummer`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `tire_checks_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=317 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `tire_checks`

-- Table structure for `tire_offers`
DROP TABLE IF EXISTS `tire_offers`;
CREATE TABLE `tire_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auftrag_nr` int(11) DEFAULT NULL COMMENT 'Auftragsnummer aus API',
  `kunden_adr_id` int(11) DEFAULT NULL COMMENT 'Kunden-Adress-ID aus API',
  `customer_name` varchar(255) DEFAULT NULL COMMENT 'Kundenname',
  `customer_firstname` varchar(255) DEFAULT NULL COMMENT 'Kundenvorname',
  `license_plate` varchar(20) DEFAULT NULL COMMENT 'Kennzeichen',
  `vin` varchar(50) DEFAULT NULL COMMENT 'Fahrgestellnummer',
  `customer_street` varchar(255) DEFAULT NULL,
  `customer_zip` varchar(10) DEFAULT NULL,
  `customer_city` varchar(255) DEFAULT NULL,
  `customer_phone` varchar(50) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL,
  `offer_data` text DEFAULT NULL COMMENT 'JSON mit Reifendaten, Services, etc.',
  `letter_content` text DEFAULT NULL COMMENT 'Brieftext',
  `employee_name` varchar(255) DEFAULT NULL COMMENT 'Name des Mitarbeiters der das Angebot erstellt',
  `token` varchar(64) DEFAULT NULL COMMENT 'Token für Kundenauswahl',
  `token_expires_at` datetime DEFAULT NULL COMMENT 'Token-Ablaufzeit (24h)',
  `token_used_at` datetime DEFAULT NULL COMMENT 'Wann wurde Token verwendet',
  `email_sent` tinyint(1) DEFAULT 0 COMMENT 'Wurde Email versendet',
  `email_sent_at` datetime DEFAULT NULL,
  `pdf_filename` varchar(255) DEFAULT NULL,
  `status` enum('draft','sent','viewed','accepted','declined','new_request') DEFAULT 'draft',
  `customer_selection` text DEFAULT NULL COMMENT 'JSON mit Kundenauswahl',
  `total_amount` decimal(10,2) DEFAULT NULL,
  `autohaus_id` int(11) DEFAULT NULL COMMENT 'Autohaus-ID',
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_auftrag_nr` (`auftrag_nr`),
  KEY `idx_kunden_adr_id` (`kunden_adr_id`),
  KEY `idx_license_plate` (`license_plate`),
  KEY `idx_token` (`token`),
  KEY `idx_status` (`status`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_autohaus_id` (`autohaus_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `tire_offers`
INSERT INTO `tire_offers` (`id`, `auftrag_nr`, `kunden_adr_id`, `customer_name`, `customer_firstname`, `license_plate`, `vin`, `customer_street`, `customer_zip`, `customer_city`, `customer_phone`, `customer_email`, `offer_data`, `letter_content`, `employee_name`, `token`, `token_expires_at`, `token_used_at`, `email_sent`, `email_sent_at`, `pdf_filename`, `status`, `customer_selection`, `total_amount`, `autohaus_id`, `created_by`, `created_at`, `updated_at`) VALUES
('1', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:09:15\"}', '', 'Deniz Uludag', '21ddb9a23690046a2643d26ace28fff86a6d1d3f54ff6eb3b21b8c46e32ed48b', '2025-11-05 22:09:15', NULL, '1', '2025-11-04 22:09:15', NULL, 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:09:15', '2025-11-04 22:09:15'),
('2', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[{\"brand_model\":\"123123\",\"dimension\":\"123123\",\"eu_label\":\"123123\",\"rf\":\"\",\"price\":133,\"mounting\":312,\"quantity\":234,\"total\":104130}],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:19:31\"}', 'asd', 'Deniz Uludag', '5df83bc7919be7859db99cee7edbd6455ed2442c96d065bf4a0d7e145f1183be', '2025-11-05 22:19:31', NULL, '0', NULL, NULL, 'draft', NULL, '104250.00', '1', '1', '2025-11-04 22:19:31', '2025-11-04 22:19:31'),
('3', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:23:11\"}', 'asd', 'Deniz Uludag', '06fc654bb2f1b41e5e7691e9d31380268bedb545928799dd7ba7ad4413ec5727', '2025-11-05 22:23:11', NULL, '1', '2025-11-04 22:23:18', 'angebot_57905_20251104_222311.pdf', 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:23:11', '2025-11-04 22:23:18'),
('4', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:23:18\"}', 'asd', 'Deniz Uludag', 'a3e4a40cdb110b50a28b9456897f348b559b77ca3b38f36852c7e7d63079c535', '2025-11-05 22:23:18', NULL, '1', '2025-11-04 22:23:52', 'angebot_57905_20251104_222346.pdf', 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:23:18', '2025-11-04 22:23:52'),
('5', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:23:18\"}', 'asd', 'Deniz Uludag', 'c1f692ce76e5f2f2194318b5c19995138556cbeb898c38e13d6ca1df7a011e05', '2025-11-05 22:23:18', NULL, '1', '2025-11-04 22:23:58', 'angebot_57905_20251104_222352.pdf', 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:23:18', '2025-11-04 22:23:58'),
('6', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:31:26\"}', 'asd', 'Deniz Uludag', '78e9a83cb3f92649fdff1fcf71e3a40acb63b8adf66a3efea7b0425f59f7d513', '2025-11-05 22:31:26', NULL, '1', '2025-11-04 22:31:32', 'angebot_57905_20251104_223126.pdf', 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:31:26', '2025-11-04 22:31:32'),
('7', '57905', NULL, 'Uludag', 'Deniz', 'KI-SD 221', NULL, '', '', '', NULL, 'duludag16@gmail.com', '{\"new_tires\":[],\"selected_services\":[44],\"created_at\":\"2025-11-04 22:35:14\"}', '', 'Deniz Uludag', '93d5f899cc25f30195e1faa4eefafb5145103cb1c4cfec7c6eb9cd0e426bb4b9', '2025-11-05 22:35:14', NULL, '1', '2025-11-04 22:35:20', 'angebot_57905_20251104_223514.pdf', 'sent', NULL, '120.00', '1', '1', '2025-11-04 22:35:14', '2025-11-04 22:35:20');


-- Table structure for `tire_orders`
DROP TABLE IF EXISTS `tire_orders`;
CREATE TABLE `tire_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` int(11) NOT NULL,
  `tire_order_date` date NOT NULL,
  `notes` text DEFAULT NULL,
  `status` enum('pending','ordered','delivered','cancelled') DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_tire_order_date` (`tire_order_date`),
  KEY `idx_status` (`status`),
  CONSTRAINT `tire_orders_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `tire_orders`

-- Table structure for `tire_suggestions`
DROP TABLE IF EXISTS `tire_suggestions`;
CREATE TABLE `tire_suggestions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) NOT NULL,
  `brand_model` varchar(255) NOT NULL,
  `eu_label` varchar(50) DEFAULT NULL,
  `size_pattern` varchar(100) DEFAULT NULL,
  `usage_count` int(11) DEFAULT 1,
  `last_used` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_brand_model` (`brand_model`),
  KEY `idx_usage_count` (`usage_count`),
  KEY `idx_last_used` (`last_used`),
  CONSTRAINT `tire_suggestions_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `tire_suggestions`
INSERT INTO `tire_suggestions` (`id`, `autohaus_id`, `brand_model`, `eu_label`, `size_pattern`, `usage_count`, `last_used`, `created_at`) VALUES
('1', '1', 'Continental EcoContact 6 Q', 'A B B 71', '245/45 R19', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('2', '1', 'Michelin Primacy 4', 'A A B 71', '225/55 R17', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('3', '1', 'Bridgestone Turanza T005', 'A B B 71', '235/45 R18', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('4', '1', 'Pirelli P Zero', 'A A B 71', '255/40 R20', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('5', '1', 'Goodyear EfficientGrip Performance', 'A B B 71', '215/60 R16', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('6', '1', 'Dunlop Sport Maxx RT2', 'A A B 71', '245/40 R19', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('7', '1', 'Hankook Ventus Prime3 K125', 'A B B 71', '225/50 R17', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03'),
('8', '1', 'Falken Azenis FK510', 'A B B 71', '235/45 R18', '1', '2025-09-19 14:32:03', '2025-09-19 14:32:03');


-- Table structure for `tirecard_configs`
DROP TABLE IF EXISTS `tirecard_configs`;
CREATE TABLE `tirecard_configs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `display_name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `template_html` text DEFAULT NULL,
  `template_text` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`),
  KEY `idx_type` (`type`),
  KEY `idx_is_active` (`is_active`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `tirecard_configs`
INSERT INTO `tirecard_configs` (`id`, `type`, `display_name`, `description`, `template_html`, `template_text`, `is_active`, `created_at`, `updated_at`) VALUES
('1', 'standard', 'Standard Tirecard', 'Standard-Reifenangebot für alle Fahrzeugtypen', NULL, NULL, '1', '2025-09-16 13:17:34', '2025-09-16 13:17:34'),
('2', 'premium', 'Premium Tirecard', 'Hochwertige Reifenangebote mit erweiterten Services', NULL, NULL, '1', '2025-09-16 13:17:34', '2025-09-16 13:17:34'),
('3', 'winter', 'Winter Tirecard', 'Spezielle Winterreifen-Angebote', NULL, NULL, '1', '2025-09-16 13:17:34', '2025-09-16 13:17:34'),
('4', 'summer', 'Sommer Tirecard', 'Sommerreifen-Angebote für optimale Performance', NULL, NULL, '1', '2025-09-16 13:17:34', '2025-09-16 13:17:34'),
('5', 'allseason', 'Ganzjahres Tirecard', 'Ganzjahresreifen für alle Wetterbedingungen', NULL, NULL, '1', '2025-09-16 13:17:34', '2025-09-16 13:17:34');


-- Table structure for `user_activity_log`
DROP TABLE IF EXISTS `user_activity_log`;
CREATE TABLE `user_activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `action_type` enum('profile_updated','vehicle_added','vehicle_updated','vehicle_deleted','appointment_created','appointment_cancelled','appointment_rescheduled','document_uploaded','password_changed','login','logout') NOT NULL,
  `description` text NOT NULL,
  `metadata` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`metadata`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_action_type` (`action_type`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `user_activity_log_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_activity_log`
INSERT INTO `user_activity_log` (`id`, `user_id`, `action_type`, `description`, `metadata`, `created_at`) VALUES
('40', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"149\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2025-11-05\",\"slot_time\":\"12:30:00\"}', '2025-11-04 12:26:05'),
('41', '64', 'appointment_cancelled', 'Termin storniert für M-UH 999', NULL, '2025-11-05 00:06:41'),
('42', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"150\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2025-11-05\",\"slot_time\":\"08:30:00\"}', '2025-11-05 10:57:28'),
('43', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"151\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2025-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-06 21:02:22'),
('44', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"152\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-11 08:46:19'),
('45', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"153\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-12 06:57:32'),
('46', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"154\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-12 06:57:39'),
('47', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"155\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:00:00\"}', '2025-11-12 06:57:47'),
('48', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"156\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:30:00\"}', '2025-11-12 06:57:56'),
('49', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"157\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-12 06:58:05'),
('50', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"158\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-12 06:58:12'),
('51', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"159\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-12 06:58:20'),
('52', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"160\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"08:30:00\"}', '2025-11-12 06:58:27'),
('53', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"161\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-12 06:59:09'),
('54', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"162\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-12 06:59:16'),
('55', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"163\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-12 06:59:22'),
('56', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"164\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-12 06:59:31'),
('57', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"165\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:30:00\"}', '2025-11-12 06:59:38'),
('58', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"166\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:30:00\"}', '2025-11-12 06:59:48'),
('59', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"167\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:30:00\"}', '2025-11-12 06:59:55'),
('60', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"168\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:30:00\"}', '2025-11-12 07:00:07'),
('61', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"169\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:30:00\"}', '2025-11-12 07:00:13'),
('62', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"170\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-12 07:00:24'),
('63', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"171\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-12 07:00:36'),
('64', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"172\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-12 07:00:45'),
('65', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"173\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-12 07:00:53'),
('66', '64', 'appointment_created', 'Termin gebucht für M-UH 999', '{\"appointment_id\":\"174\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-12 07:01:22'),
('67', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"175\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:00:00\"}', '2025-11-13 11:25:01'),
('68', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"176\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:00:00\"}', '2025-11-13 11:25:39'),
('69', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"177\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:00:00\"}', '2025-11-13 11:25:45'),
('70', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"178\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:00:00\"}', '2025-11-13 11:25:50'),
('71', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"179\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:00:00\"}', '2025-11-13 11:25:57'),
('72', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"180\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:30:00\"}', '2025-11-13 12:20:08'),
('73', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"181\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:30:00\"}', '2025-11-13 12:20:13'),
('74', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"182\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:30:00\"}', '2025-11-13 12:20:19'),
('75', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"183\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"10:30:00\"}', '2025-11-13 12:20:24'),
('76', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"184\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:00:00\"}', '2025-11-13 12:20:30'),
('77', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"185\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:00:00\"}', '2025-11-13 12:20:35'),
('78', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"186\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:00:00\"}', '2025-11-13 12:20:41'),
('79', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"187\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:00:00\"}', '2025-11-13 12:20:48'),
('80', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"188\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:00:00\"}', '2025-11-13 12:20:55'),
('81', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"189\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:30:00\"}', '2025-11-13 12:21:01'),
('82', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"190\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:30:00\"}', '2025-11-13 12:21:07'),
('83', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"191\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:30:00\"}', '2025-11-13 12:21:13'),
('84', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"192\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:30:00\"}', '2025-11-13 12:21:18'),
('85', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"193\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"11:30:00\"}', '2025-11-13 12:21:24'),
('86', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"194\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:00:00\"}', '2025-11-13 12:21:31'),
('87', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"195\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:00:00\"}', '2025-11-13 12:21:38'),
('88', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"196\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:00:00\"}', '2025-11-13 12:21:44'),
('89', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"197\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:00:00\"}', '2025-11-13 12:21:50'),
('90', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"198\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:00:00\"}', '2025-11-13 12:21:56'),
('91', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"199\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:30:00\"}', '2025-11-13 12:22:02'),
('92', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"200\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:30:00\"}', '2025-11-13 12:22:13'),
('93', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"201\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:30:00\"}', '2025-11-13 12:22:19'),
('94', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"202\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:30:00\"}', '2025-11-13 12:22:25'),
('95', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"203\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"12:30:00\"}', '2025-11-13 12:22:31'),
('96', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"204\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-13 12:22:39'),
('97', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"205\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-13 12:22:45'),
('98', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"206\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-13 12:22:51'),
('99', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"207\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-13 12:22:56'),
('100', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"208\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-13 12:23:03'),
('101', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"209\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:30:00\"}', '2025-11-13 12:23:11'),
('102', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"210\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:30:00\"}', '2025-11-13 12:23:17'),
('103', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"211\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:30:00\"}', '2025-11-13 12:23:25'),
('104', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"212\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:30:00\"}', '2025-11-13 12:23:31'),
('105', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"213\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:30:00\"}', '2025-11-13 12:23:47'),
('106', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"214\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:00:00\"}', '2025-11-13 12:23:53'),
('107', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"215\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:00:00\"}', '2025-11-13 12:24:03'),
('108', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"216\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:00:00\"}', '2025-11-13 12:24:09'),
('109', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"217\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:00:00\"}', '2025-11-13 12:24:15'),
('110', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"218\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:00:00\"}', '2025-11-13 12:24:21'),
('111', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"219\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:30:00\"}', '2025-11-13 12:24:26'),
('112', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"220\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:30:00\"}', '2025-11-13 12:24:31'),
('113', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"221\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:30:00\"}', '2025-11-13 12:24:37'),
('114', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"222\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:30:00\"}', '2025-11-13 12:24:51'),
('115', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"223\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"14:30:00\"}', '2025-11-13 12:25:24'),
('116', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"224\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:00:00\"}', '2025-11-13 12:25:30'),
('117', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"225\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:00:00\"}', '2025-11-13 12:25:36'),
('118', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"226\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:00:00\"}', '2025-11-13 12:25:41'),
('119', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"227\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:00:00\"}', '2025-11-13 12:25:47'),
('120', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"228\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:30:00\"}', '2025-11-13 12:25:53'),
('121', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"229\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:30:00\"}', '2025-11-13 12:25:59'),
('122', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"230\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:30:00\"}', '2025-11-13 12:26:06'),
('123', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"231\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:30:00\"}', '2025-11-13 12:26:11'),
('124', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"232\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"15:30:00\"}', '2025-11-13 12:26:18'),
('125', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"233\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:00:00\"}', '2025-11-13 12:26:23'),
('126', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"234\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:00:00\"}', '2025-11-13 12:26:29'),
('127', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"235\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:00:00\"}', '2025-11-13 12:26:34'),
('128', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"236\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:00:00\"}', '2025-11-13 12:26:40'),
('129', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"237\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:00:00\"}', '2025-11-13 12:26:46'),
('130', '65', 'appointment_created', 'Termin gebucht für KI-BE 123', '{\"appointment_id\":\"238\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"16:30:00\"}', '2025-11-14 00:14:19'),
('139', '65', 'appointment_created', 'Termin gebucht für Tes-b 1', '{\"appointment_id\":\"248\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"13:00:00\"}', '2025-11-14 22:37:02'),
('140', '65', 'appointment_cancelled', 'Termin storniert für Tes-b 1', NULL, '2025-11-14 22:37:25'),
('141', '64', 'login', 'Login von google_signin - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":null,\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 12:41:04'),
('142', '65', 'login', 'Login von apple_signin - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Kronshagen\",\"latitude\":54.3344,\"longitude\":10.0914,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\"},\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 12:43:07'),
('143', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"176.4.7.244\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\"},\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_7 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/26.2 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-15 12:45:55'),
('144', '65', 'appointment_created', 'Termin gebucht für TES-T 10', '{\"appointment_id\":\"249\",\"event_name\":\"Unbekannt\",\"slot_date\":\"2026-11-07\",\"slot_time\":\"09:00:00\"}', '2025-11-15 12:52:49'),
('145', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"176.4.7.244\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\"},\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-15 13:06:21'),
('146', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"176.4.7.244\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\"},\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-15 17:14:42'),
('147', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 18:59:57'),
('148', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 19:05:14'),
('149', '64', 'login', 'Login von google_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 19:07:52'),
('153', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 19:31:48'),
('154', '64', 'login', 'Login von google_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-15 19:46:04'),
('155', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"176.4.1.58\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-16 07:56:58'),
('156', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"46.128.117.37\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPad; CPU OS 18_7_1 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPad; CPU OS 18_7_1 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-16 08:54:15'),
('157', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"176.4.1.58\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-16 17:51:07'),
('158', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-17 05:45:26'),
('159', '77', 'login', 'Login von google_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-17 05:56:50'),
('160', '64', 'login', 'Login von google_signin - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Kronshagen\",\"latitude\":54.3344,\"longitude\":10.0914,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-17 07:47:48'),
('161', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-17 20:11:18'),
('162', '64', 'login', 'Login von google_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-17 20:11:42'),
('163', '64', 'login', 'Login von google_signin - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Kronshagen\",\"latitude\":54.3344,\"longitude\":10.0914,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-18 07:41:00'),
('164', '65', 'login', 'Login von apple_signin - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Kronshagen\",\"latitude\":54.3344,\"longitude\":10.0914,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-18 10:57:37'),
('165', '65', 'login', 'Login von apple_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-18 19:25:38'),
('166', '64', 'login', 'Login von google_signin - Mac', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Mac\",\"device_info\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"google_signin\",\"login_source\":\"google_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-18 21:13:47'),
('167', '65', 'login', 'Login von apple_signin - iOS', '{\"ip_address\":\"46.128.117.37\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"apple_signin\",\"login_source\":\"apple_signin\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-19 00:41:01'),
('168', '78', 'login', 'Login von web - iOS', '{\"ip_address\":\"79.223.95.158\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"Celle, Lower Saxony, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Lower Saxony\",\"city\":\"Celle\",\"latitude\":52.6103,\"longitude\":10.1041,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Celle, Lower Saxony, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-19 20:02:45'),
('169', '78', 'login', 'Login von web - iOS', '{\"ip_address\":\"79.223.95.158\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"Celle, Lower Saxony, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Lower Saxony\",\"city\":\"Celle\",\"latitude\":52.6103,\"longitude\":10.1041,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Celle, Lower Saxony, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-19 20:02:46'),
('170', '78', 'login', 'Login von web - iOS', '{\"ip_address\":\"79.223.95.158\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"Celle, Lower Saxony, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Lower Saxony\",\"city\":\"Celle\",\"latitude\":52.6103,\"longitude\":10.1041,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Celle, Lower Saxony, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) Version\\/18.6 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-19 20:07:42'),
('171', '78', 'login', 'Login von web - Android', '{\"ip_address\":\"46.128.117.37\",\"device\":\"Android\",\"device_info\":\"Mozilla\\/5.0 (Linux; Android 6.0; Nexus 5 Build\\/MRA58N) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Mobile Safari\\/537.36\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Selent\",\"latitude\":54.2861,\"longitude\":10.4219,\"isp\":\"16 originated by AS35244\",\"location\":\"Selent, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Linux; Android 6.0; Nexus 5 Build\\/MRA58N) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Mobile Safari\\/537.36\"}', '2025-11-19 20:52:38'),
('172', '78', 'login', 'Login von web - Windows', '{\"ip_address\":\"217.85.29.163\",\"device\":\"Windows\",\"device_info\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"Kronshagen\",\"latitude\":54.3344,\"longitude\":10.0914,\"isp\":\"Deutsche Telekom AG\",\"location\":\"Kronshagen, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/142.0.0.0 Safari\\/537.36\"}', '2025-11-20 07:24:15'),
('173', '78', 'login', 'Login von web - iOS', '{\"ip_address\":\"176.4.3.108\",\"device\":\"iOS\",\"device_info\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\",\"source\":\"web\",\"login_source\":\"web\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"location_data\":{\"country\":\"Germany\",\"region\":\"Schleswig-Holstein\",\"city\":\"L\\u00fcbeck\",\"latitude\":53.8638,\"longitude\":10.6508,\"isp\":\"Telefonica Germany GmbH & Co.OHG\",\"location\":\"L\\u00fcbeck, Schleswig-Holstein, Germany\",\"source\":\"geoip\"},\"location_source\":\"geoip\",\"user_agent\":\"Mozilla\\/5.0 (iPhone; CPU iPhone OS 26_2_0 like Mac OS X) AppleWebKit\\/605.1.15 (KHTML, like Gecko) CriOS\\/142.0.7444.148 Mobile\\/15E148 Safari\\/604.1\"}', '2025-11-20 17:25:28');


-- Table structure for `user_analytics`
DROP TABLE IF EXISTS `user_analytics`;
CREATE TABLE `user_analytics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `event_type` varchar(50) NOT NULL,
  `event_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`event_data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_event` (`user_id`,`event_type`),
  KEY `idx_created_at` (`created_at`),
  CONSTRAINT `user_analytics_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_analytics`

-- Table structure for `user_authentication_methods`
DROP TABLE IF EXISTS `user_authentication_methods`;
CREATE TABLE `user_authentication_methods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `method_type` enum('email_password','apple_signin','biometric') NOT NULL,
  `method_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`method_data`)),
  `is_primary` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_method` (`user_id`,`method_type`),
  CONSTRAINT `user_authentication_methods_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_authentication_methods`

-- Table structure for `user_dashboard_config`
DROP TABLE IF EXISTS `user_dashboard_config`;
CREATE TABLE `user_dashboard_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `config_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`config_data`)),
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_config` (`user_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_updated_at` (`updated_at`),
  KEY `idx_user_dashboard_config_user_id` (`user_id`),
  KEY `idx_user_dashboard_config_updated_at` (`updated_at`),
  CONSTRAINT `user_dashboard_config_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `admin_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_dashboard_config`
INSERT INTO `user_dashboard_config` (`id`, `user_id`, `config_data`, `created_at`, `updated_at`) VALUES
('1', '1', '{\"layout\":\"default\",\"widgets\":[\"performance_metrics\",\"today_appointments\",\"upcoming_events\",\"quick_actions\",\"task_reminders\",\"quick_stats\",\"notifications\",\"recent_storage\"],\"quick_actions\":[],\"show_welcome\":true,\"auto_refresh\":true,\"refresh_interval\":300}', '2025-09-25 10:57:42', '2025-11-23 22:57:42'),
('26', '12', '{\"layout\":\"default\",\"widgets\":[\"upcoming_events\",\"quick_actions\",\"today_appointments\"],\"quick_actions\":[\"events\",\"appointments\",\"storage\",\"users\",\"settings\",\"frontend\"],\"theme\":\"light\",\"show_welcome\":1,\"auto_refresh\":1,\"refresh_interval\":\"300\"}', '2025-09-25 13:06:26', '2025-09-25 13:06:26'),
('40', '17', '{\"layout\":\"wide\",\"widgets\":[\"today_appointments\",\"upcoming_events\",\"quick_actions\"],\"quick_actions\":[],\"theme\":\"light\",\"show_welcome\":1,\"auto_refresh\":1,\"refresh_interval\":\"300\"}', '2025-11-05 12:15:22', '2025-11-05 12:15:22'),
('41', '15', '{\"layout\":\"default\",\"widgets\":[\"today_appointments\",\"upcoming_events\",\"quick_actions\",\"recent_storage\"],\"quick_actions\":[],\"theme\":\"light\",\"show_welcome\":1,\"auto_refresh\":1,\"refresh_interval\":\"300\"}', '2025-11-13 14:15:53', '2025-11-13 14:15:53'),
('42', '16', '{\"layout\":\"wide\",\"widgets\":[\"today_appointments\",\"upcoming_events\",\"quick_actions\",\"recent_storage\",\"performance_metrics\"],\"quick_actions\":[],\"theme\":\"light\",\"show_welcome\":1,\"auto_refresh\":1,\"refresh_interval\":\"300\"}', '2025-11-13 15:18:01', '2025-11-14 17:46:14'),
('45', '14', '{\"layout\":\"default\",\"widgets\":[\"today_appointments\",\"upcoming_events\",\"quick_actions\",\"recent_storage\",\"performance_metrics\"],\"quick_actions\":[],\"theme\":\"light\",\"show_welcome\":1,\"auto_refresh\":1,\"refresh_interval\":\"300\"}', '2025-11-15 09:53:28', '2025-11-15 09:53:28');


-- Table structure for `user_device_tokens`
DROP TABLE IF EXISTS `user_device_tokens`;
CREATE TABLE `user_device_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` varchar(255) NOT NULL,
  `device_type` enum('ios','android') DEFAULT 'ios',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_user_device` (`user_id`,`device_token`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_device_token` (`device_token`),
  CONSTRAINT `fk_user_device_tokens_user` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_device_tokens`

-- Table structure for `user_notifications`
DROP TABLE IF EXISTS `user_notifications`;
CREATE TABLE `user_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` enum('account_approved','account_rejected','document_uploaded','document_approved','document_rejected','verification_required') NOT NULL,
  `title` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `is_read` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `read_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_type` (`type`),
  KEY `idx_is_read` (`is_read`),
  CONSTRAINT `user_notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_notifications`
INSERT INTO `user_notifications` (`id`, `user_id`, `type`, `title`, `message`, `is_read`, `created_at`, `read_at`) VALUES
('116', '64', '', 'Termin storniert', 'Ihr Termin wurde erfolgreich storniert.', '1', '2025-11-05 00:06:41', NULL),
('117', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '1', '2025-11-13 16:44:48', NULL),
('118', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 16:45:01', NULL),
('119', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 16:45:26', NULL),
('120', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 16:49:34', NULL),
('121', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 16:56:32', NULL),
('122', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 17:04:44', NULL),
('123', '64', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 17:51:43', NULL),
('124', '65', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 22:38:37', NULL),
('125', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:46:06', NULL),
('126', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:47:33', NULL),
('127', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:49:17', NULL),
('128', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:50:41', NULL),
('129', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:54:20', NULL),
('130', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:54:23', NULL),
('131', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:54:38', NULL),
('132', '65', '', 'Test-Benachrichtigung', 'Dies ist eine Test-Push-Benachrichtigung', '0', '2025-11-13 22:56:13', NULL),
('133', '65', '', 'Antwort auf Ihr Feedback', 'Sie haben eine Antwort auf Ihr Feedback erhalten.', '0', '2025-11-13 22:57:36', NULL),
('138', '65', '', 'asdasdasd', 'asdasdadasd', '0', '2025-11-13 23:09:42', NULL),
('140', '64', '', 'asdasdasd', 'asdasdadasd', '0', '2025-11-13 23:09:43', NULL),
('145', '65', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '0', '2025-11-13 23:14:42', NULL),
('147', '64', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '0', '2025-11-13 23:14:43', NULL),
('152', '65', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '0', '2025-11-13 23:14:57', NULL),
('154', '64', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '0', '2025-11-13 23:14:58', NULL),
('159', '65', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '1', '2025-11-13 23:15:05', NULL),
('161', '64', '', 'Geil es klappt!', 'oasndoiansoidnaosidnoasnod', '0', '2025-11-13 23:15:06', NULL),
('166', '65', '', 'super es klappt danke!', 'osajdoijasoidjsaod', '0', '2025-11-13 23:26:35', NULL),
('168', '64', '', 'super es klappt danke!', 'osajdoijasoidjsaod', '1', '2025-11-13 23:26:36', NULL),
('172', '64', '', 'lasdlömaöldmlöasd', 'asödmamdölmsaldö', '0', '2025-11-13 23:38:56', NULL),
('174', '65', '', 'lasdlömaöldmlöasd', 'asödmamdölmsaldö', '0', '2025-11-13 23:38:56', NULL),
('178', '65', '', 'freut mich super!', 'freut mich super!', '1', '2025-11-14 00:08:48', NULL),
('179', '65', '', 'freut mich super!', 'freut mich super!', '1', '2025-11-14 00:08:49', NULL),
('180', '65', '', 'Account gesperrt', 'Ihr Account wurde von einem Administrator gesperrt. Grund: sadsad', '1', '2025-11-14 00:27:32', NULL),
('181', '65', '', 'asdasdasd', 'asdasdasd', '0', '2025-11-14 00:28:58', NULL),
('182', '65', '', 'asdasdasd', 'asdasdasd', '0', '2025-11-14 00:28:58', NULL),
('183', '65', '', 'asdasd', 'asdasd', '1', '2025-11-14 00:29:29', NULL),
('184', '65', '', 'asdasd', 'asdasd', '0', '2025-11-14 00:29:30', NULL),
('185', '65', '', 'XyFf', 'Ggff', '0', '2025-11-14 00:35:41', NULL),
('186', '65', '', 'XyFf', 'Ggff', '0', '2025-11-14 00:35:42', NULL),
('191', '64', '', 'XyFf', 'Ggff', '0', '2025-11-14 00:35:43', NULL),
('197', '65', '', 'Super funktioniert das alles!', 'Super funktioniert das alles!', '0', '2025-11-14 08:45:15', NULL),
('216', '65', '', 'Account gesperrt', 'Ihr Account wurde von einem Administrator gesperrt. Grund: weil ich das so will', '0', '2025-11-14 15:39:15', NULL),
('221', '65', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-14 20:22:10', NULL),
('222', '65', '', 'Termin storniert', 'Ihr Termin wurde erfolgreich storniert.', '0', '2025-11-14 22:37:25', NULL),
('223', '76', '', 'Dokument hochgeladen', 'Ihr Verifikationsdokument wurde erfolgreich hochgeladen und wird nun geprüft. Sie erhalten eine Benachrichtigung, sobald die Prüfung abgeschlossen ist.', '0', '2025-11-15 09:55:29', NULL),
('224', '76', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-15 09:55:50', NULL),
('226', '76', '', 'Account gesperrt', 'Ihr Account wurde von einem Administrator gesperrt. Grund: Das ist nur ein Test', '0', '2025-11-16 11:01:21', NULL),
('227', '76', '', 'Account freigeschaltet', 'Ihr Account wurde erfolgreich freigeschaltet. Sie können sich jetzt anmelden.', '0', '2025-11-16 11:05:54', NULL),
('228', '76', '', 'Account gesperrt', 'Ihr Account wurde von einem Administrator gesperrt. Grund: terst', '0', '2025-11-16 11:06:59', NULL),
('229', '76', '', 'Account entsperrt', 'Ihr Account wurde von einem Administrator entsperrt. Grund: rtasdsd', '0', '2025-11-16 11:08:19', NULL),
('230', '76', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-16 11:08:30', NULL),
('231', '65', '', 'Account gesperrt', 'Ihr Account wurde von einem Administrator gesperrt. Grund: Test', '0', '2025-11-16 11:11:45', NULL),
('232', '65', '', 'Account entsperrt', 'Ihr Account wurde von einem Administrator entsperrt. Grund: asdasd', '0', '2025-11-16 11:16:45', NULL),
('233', '65', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-16 11:18:38', NULL),
('234', '65', '', 'Verifizierung abgelehnt', 'Ihr Verifizierungsantrag wurde abgelehnt. Grund: ölmsda', '0', '2025-11-17 05:47:48', NULL),
('235', '65', '', 'Dokument hochgeladen', 'Ihr Verifikationsdokument wurde erfolgreich hochgeladen und wird nun geprüft. Sie erhalten eine Benachrichtigung, sobald die Prüfung abgeschlossen ist.', '0', '2025-11-17 05:51:40', NULL),
('236', '65', '', 'Dokument hochgeladen', 'Ihr Verifikationsdokument wurde erfolgreich hochgeladen und wird nun geprüft. Sie erhalten eine Benachrichtigung, sobald die Prüfung abgeschlossen ist.', '0', '2025-11-17 05:55:36', NULL),
('237', '65', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-17 07:58:03', NULL),
('238', '78', '', 'Dokument hochgeladen', 'Ihr Verifikationsdokument wurde erfolgreich hochgeladen und wird nun geprüft. Sie erhalten eine Benachrichtigung, sobald die Prüfung abgeschlossen ist.', '0', '2025-11-19 19:59:14', NULL),
('239', '78', '', 'Verifizierung erfolgreich', 'Ihr Konto wurde erfolgreich verifiziert und freigeschaltet. Bitte vervollständigen Sie Ihr Profil!', '0', '2025-11-19 19:59:50', NULL),
('240', '78', '', 'kllknk', 'klknnk', '1', '2025-11-22 19:07:07', NULL),
('241', '78', '', 'kllknk', 'klknnk', '1', '2025-11-22 19:07:07', NULL);


-- Table structure for `user_profile_images`
DROP TABLE IF EXISTS `user_profile_images`;
CREATE TABLE `user_profile_images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `image_url` varchar(500) NOT NULL,
  `image_size` int(11) DEFAULT NULL,
  `mime_type` varchar(100) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_is_active` (`is_active`),
  CONSTRAINT `user_profile_images_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_profile_images`

-- Table structure for `user_sessions`
DROP TABLE IF EXISTS `user_sessions`;
CREATE TABLE `user_sessions` (
  `id` varchar(128) NOT NULL,
  `data` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_sessions`

-- Table structure for `user_vehicles`
DROP TABLE IF EXISTS `user_vehicles`;
CREATE TABLE `user_vehicles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `license_plate` varchar(20) NOT NULL,
  `vehicle_brand` varchar(100) DEFAULT NULL,
  `vehicle_model` varchar(100) DEFAULT NULL,
  `vehicle_year` int(11) DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT 0,
  `is_active` tinyint(1) DEFAULT 1,
  `notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_license_plate` (`license_plate`),
  KEY `idx_is_default` (`is_default`),
  CONSTRAINT `user_vehicles_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `user_vehicles`
INSERT INTO `user_vehicles` (`id`, `user_id`, `license_plate`, `vehicle_brand`, `vehicle_model`, `vehicle_year`, `is_default`, `is_active`, `notes`, `created_at`, `updated_at`) VALUES
('13', '64', 'M-UH 999', 'Volvo', 'Xc60', '2025', '1', '1', '', '2025-11-03 21:05:43', '2025-11-08 21:49:23'),
('15', '64', 'KI-SD 999', 'Volvo', 'ES90', '2025', '0', '1', '', '2025-11-10 08:19:03', '2025-11-10 08:19:03'),
('16', '65', 'KI-BE 123', 'Volvo', '08', '2025', '0', '1', 'Super auto', '2025-11-11 06:03:38', '2025-11-14 21:11:13'),
('17', '65', 'Test 1', 'Volvo', 'XC60', NULL, '0', '1', '', '2025-11-11 20:55:40', '2025-11-11 20:55:40'),
('18', '65', 'KI-SD 221', '', 'XC40', NULL, '0', '1', '', '2025-11-11 20:55:59', '2025-11-11 20:55:59'),
('19', '65', 'Tes-b 1', '', 'ec40', NULL, '0', '1', '', '2025-11-11 20:56:41', '2025-11-11 20:56:41'),
('20', '65', 'TES-t 2', 'Volvo', 'es90', '0', '0', '1', '', '2025-11-11 20:57:00', '2025-11-11 20:59:03'),
('21', '65', 'TES-T 3', 'Volvo', 'EX30', NULL, '0', '1', '', '2025-11-11 21:00:11', '2025-11-11 21:00:11'),
('22', '65', 'TES-T 4', 'Volvo', 'EX40', NULL, '0', '1', '', '2025-11-11 21:00:30', '2025-11-11 21:00:30'),
('23', '65', 'TES-T 5', 'Volvo', 'EX90', NULL, '0', '0', '', '2025-11-11 21:00:57', '2025-11-11 21:08:33'),
('24', '65', 'TES-T 6', 'Volvo', 'S60', NULL, '0', '1', '', '2025-11-11 21:01:23', '2025-11-11 21:01:23'),
('25', '65', 'TES-T 7', 'Volvo', 'S90', NULL, '0', '1', '', '2025-11-11 21:01:41', '2025-11-11 21:01:41'),
('26', '65', 'TES-T 8', 'Volvo', 'v60', NULL, '0', '1', '', '2025-11-11 21:02:06', '2025-11-11 21:02:06'),
('27', '65', 'TES-T 9', 'Volvo', 'V90', NULL, '0', '1', '', '2025-11-11 21:02:51', '2025-11-11 21:02:51'),
('28', '65', 'TES-T 10', 'Volvo', 'XC60', '0', '1', '1', '', '2025-11-11 21:03:16', '2025-11-14 21:11:13'),
('29', '65', 'TES-T 11', 'Volvo', 'XC90', NULL, '0', '0', '', '2025-11-11 21:03:44', '2025-11-11 21:08:21'),
('34', '78', 'KI-BE 105', 'Volvo', 'XC60', '2025', '1', '1', '', '2025-11-19 20:01:05', '2025-11-19 20:01:05');


-- Table structure for `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_user_id` int(11) DEFAULT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone_number` varchar(20) NOT NULL,
  `license_plate` varchar(20) NOT NULL,
  `preferred_dealership_id` int(11) DEFAULT NULL,
  `profile_image_url` varchar(500) DEFAULT NULL,
  `is_leasing_vehicle` tinyint(1) DEFAULT 0,
  `is_contract_vehicle` tinyint(1) DEFAULT 0,
  `password_hash` varchar(255) DEFAULT NULL,
  `apple_user_id` varchar(255) DEFAULT NULL,
  `google_user_id` varchar(255) DEFAULT NULL,
  `auth_token` varchar(500) DEFAULT NULL,
  `token_expires_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `email_verified` tinyint(1) DEFAULT 0,
  `status` enum('pending','approved','rejected','suspended') DEFAULT 'pending',
  `verification_document_url` varchar(500) DEFAULT NULL,
  `verification_document_type` varchar(50) DEFAULT NULL,
  `admin_notes` text DEFAULT NULL,
  `approved_by` int(11) DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `rejected_by` int(11) DEFAULT NULL,
  `rejected_at` datetime DEFAULT NULL,
  `rejection_reason` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `verification_status` enum('pending','approved','rejected') DEFAULT 'pending',
  `verification_document` varchar(500) DEFAULT NULL,
  `verification_reason` text DEFAULT NULL,
  `verified_by` int(11) DEFAULT NULL,
  `verified_at` datetime DEFAULT NULL,
  `registration_source` enum('web','ios','android','apple_signin','google_signin','unknown') DEFAULT 'unknown',
  `registration_device` varchar(100) DEFAULT NULL,
  `registration_ip` varchar(45) DEFAULT NULL,
  `last_login_source` varchar(100) DEFAULT NULL,
  `last_login_device` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `postal_code` varchar(10) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `profile_image` varchar(255) DEFAULT NULL,
  `verification_banner_viewed_count` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `apple_user_id` (`apple_user_id`),
  UNIQUE KEY `google_user_id` (`google_user_id`),
  KEY `idx_email` (`email`),
  KEY `idx_apple_user_id` (`apple_user_id`),
  KEY `idx_auth_token` (`auth_token`),
  KEY `idx_license_plate` (`license_plate`),
  KEY `idx_preferred_dealership` (`preferred_dealership_id`),
  KEY `idx_status` (`status`),
  KEY `idx_approved_by` (`approved_by`),
  KEY `idx_rejected_by` (`rejected_by`),
  KEY `idx_verification_status` (`verification_status`),
  KEY `idx_registration_source` (`registration_source`),
  KEY `idx_google_user_id` (`google_user_id`),
  KEY `idx_admin_user_id` (`admin_user_id`),
  CONSTRAINT `fk_users_admin_user` FOREIGN KEY (`admin_user_id`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `users`
INSERT INTO `users` (`id`, `admin_user_id`, `first_name`, `last_name`, `email`, `phone_number`, `license_plate`, `preferred_dealership_id`, `profile_image_url`, `is_leasing_vehicle`, `is_contract_vehicle`, `password_hash`, `apple_user_id`, `google_user_id`, `auth_token`, `token_expires_at`, `is_active`, `email_verified`, `status`, `verification_document_url`, `verification_document_type`, `admin_notes`, `approved_by`, `approved_at`, `rejected_by`, `rejected_at`, `rejection_reason`, `created_at`, `updated_at`, `verification_status`, `verification_document`, `verification_reason`, `verified_by`, `verified_at`, `registration_source`, `registration_device`, `registration_ip`, `last_login_source`, `last_login_device`, `address`, `postal_code`, `city`, `profile_image`, `verification_banner_viewed_count`) VALUES
('64', '1', 'Deniz', 'Uludag', 'duludag16@gmail.com', '01782465658', '', '1', NULL, '0', '0', NULL, NULL, '107919363008496677078', 'e926699ae8b0f32fea8afd802d76b02f24825b2046362a5fae85194080080eb3', '2025-12-18 21:13:47', '1', '1', 'approved', NULL, 'image', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-03 21:04:55', '2025-11-18 21:13:47', 'approved', 'uploads/verification_documents/verif_64_20251103211302_b828e882.png', NULL, '1', '2025-11-03 21:13:15', 'google_signin', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.', '46.128.117.37', 'google_signin', 'Mac', 'Hangstr 30', '24148', 'Kiel', 'uploads/profile_images/user_64_1763354428.webp', '5'),
('65', NULL, 'Deniz', 'Uludag', 'denizuludag439@gmail.com', '+491782465658', 'PLÖ-TW 240', '1', NULL, '0', '0', NULL, '001463.eb702e10246a4724b08df93ae739b6c0.1919', '105659686157770352945', '8c56844ec0d65705cfb2137dd191f26a2bd8dad0ee1922208e9317a155bb2d67', '2025-12-19 00:41:01', '1', '1', 'approved', NULL, 'image', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-05 00:11:50', '2025-11-19 00:41:01', 'approved', 'uploads/verification_documents/verif_65_20251117055536_9cb3267f.jpeg', 'ölmsda', '1', '2025-11-17 07:58:03', 'apple_signin', 'Mozilla/5.0 (iPhone; CPU iPhone OS 26_1_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Cr', '46.128.117.37', 'apple_signin', 'iOS', 'Hangstr 30', '24148', 'Kiel (Wellingdorf)', 'uploads/profile_images/user_65_1762297934.jpeg', '5'),
('76', '14', 'Andreas', 'Dobbratz', 'dobbratz@be-automobile.de', '0431546300', 'SE-SF 443E', '2', NULL, '0', '0', '$2y$10$ICYzEvMCTscZlfnWYnH7juHqfK/VSCylOxVWA2G6w7KMz3K31.vmC', NULL, NULL, '802ab2f1f25703634c2911bd263262387624e225d1afda8b7035dfe9d1d2be47', '2025-12-15 09:51:39', '1', '0', 'approved', NULL, 'image', 'Freischaltungsbegründung: Alles zum testen', '1', '2025-11-16 11:05:54', NULL, NULL, NULL, '2025-11-15 09:51:39', '2025-11-16 11:08:30', 'approved', 'uploads/verification_documents/verif_76_20251115095528_b4505eda.png', NULL, '1', '2025-11-16 11:08:30', 'web', 'Mac', '217.85.29.163', NULL, NULL, NULL, NULL, NULL, NULL, '1'),
('77', NULL, 'Deniz', 'Uludag', 'dsuludag16@gmail.com', '', '', '1', NULL, '0', '0', NULL, NULL, '112107058552945364156', 'd90ea00d2d70b5a0d1c64673a89b15a181f5c8e3ea5da93fe995c736d3788d4f', '2025-12-17 05:56:50', '1', '1', 'pending', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-17 05:56:50', '2025-11-17 06:07:56', 'pending', NULL, NULL, NULL, NULL, 'google_signin', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.', '46.128.117.37', 'google_signin', 'Mac', '', '', '', 'uploads/profile_images/user_77_1763356076.png', '0'),
('78', NULL, 'Erdmannsky', 'Autohaus', 'melanie@testzugang.de', '01782465658', 'KI-BE 105', '1', NULL, '0', '0', '$2y$10$OkWNx3yuKJ3.XAhsDDpcMeWYgdmWSr.JxRpNlfYqq0VVhkGEDG3iK', NULL, NULL, 'df4e38f1542d1d11bb0b0ab77b364a2702aa1e5a7e03ee2fcdff2f4446c16e24', '2025-12-20 17:25:28', '1', '0', 'approved', NULL, 'image', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-19 19:58:54', '2025-11-20 17:25:28', 'approved', 'uploads/verification_documents/verif_78_20251119195914_e05cde03.jpeg', NULL, '1', '2025-11-19 19:59:50', 'web', 'Mac', '46.128.117.37', 'web', 'iOS', 'Elbberg 8', '22767', 'Hamburg', 'uploads/profile_images/user_78_1763578882.jpeg', '5');


-- Table structure for `verification_documents`
DROP TABLE IF EXISTS `verification_documents`;
CREATE TABLE `verification_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `document_type` enum('invoice','contract','insurance','other') DEFAULT 'invoice',
  `file_name` varchar(255) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_size` int(11) NOT NULL,
  `mime_type` varchar(100) NOT NULL,
  `upload_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `reviewed_by` int(11) DEFAULT NULL,
  `reviewed_at` datetime DEFAULT NULL,
  `review_status` enum('pending','approved','rejected') DEFAULT 'pending',
  `review_notes` text DEFAULT NULL,
  `rejection_reason` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`),
  KEY `idx_document_type` (`document_type`),
  KEY `reviewed_by` (`reviewed_by`),
  CONSTRAINT `verification_documents_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `verification_documents_ibfk_2` FOREIGN KEY (`reviewed_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `verification_documents`

-- Table structure for `whatsapp_message_log`
DROP TABLE IF EXISTS `whatsapp_message_log`;
CREATE TABLE `whatsapp_message_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `autohaus_id` int(11) DEFAULT NULL,
  `appointment_id` int(11) DEFAULT NULL,
  `recipient_phone` varchar(20) NOT NULL,
  `message_type` enum('appointment_approved','appointment_rejected','appointment_rescheduled','reminder','test') NOT NULL,
  `message_content` text NOT NULL,
  `api_response` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`api_response`)),
  `success` tinyint(1) NOT NULL,
  `error_message` text DEFAULT NULL,
  `sent_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_appointment_id` (`appointment_id`),
  KEY `idx_recipient_phone` (`recipient_phone`),
  KEY `idx_message_type` (`message_type`),
  KEY `idx_success` (`success`),
  KEY `idx_sent_at` (`sent_at`),
  CONSTRAINT `whatsapp_message_log_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE SET NULL,
  CONSTRAINT `whatsapp_message_log_ibfk_2` FOREIGN KEY (`appointment_id`) REFERENCES `appointments` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table `whatsapp_message_log`
INSERT INTO `whatsapp_message_log` (`id`, `autohaus_id`, `appointment_id`, `recipient_phone`, `message_type`, `message_content`, `api_response`, `success`, `error_message`, `sent_at`) VALUES
('1', '1', NULL, '+49123456789', 'test', 'Test-Nachricht für WhatsApp-Integration', NULL, '1', NULL, '2025-09-21 19:37:17'),
('2', NULL, NULL, '+49987654321', 'test', 'Test-Nachricht für WhatsApp-Integration', NULL, '1', NULL, '2025-09-21 19:37:17');


-- Table structure for `wheelset_comments`
DROP TABLE IF EXISTS `wheelset_comments`;
CREATE TABLE `wheelset_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wheelset_number` varchar(50) NOT NULL COMMENT 'RESY Wheelset Nummer',
  `autohaus_id` int(11) NOT NULL COMMENT 'Autohaus ID',
  `comment` text DEFAULT NULL COMMENT 'Kommentar-Text',
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID der den Kommentar erstellt hat',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_wheelset_comment` (`wheelset_number`,`autohaus_id`),
  KEY `idx_wheelset_number` (`wheelset_number`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_created_at` (`created_at`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `wheelset_comments_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `wheelset_comments_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `wheelset_comments`
INSERT INTO `wheelset_comments` (`id`, `wheelset_number`, `autohaus_id`, `comment`, `created_by`, `created_at`, `updated_at`) VALUES
('7', '103391', '1', 'xvdfdsfsdf', '1', '2025-11-13 13:50:15', '2025-11-13 13:50:15');


-- Table structure for `wheelset_offer_history`
DROP TABLE IF EXISTS `wheelset_offer_history`;
CREATE TABLE `wheelset_offer_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `offer_id` int(11) NOT NULL COMMENT 'Referenz zum Angebot',
  `action` varchar(50) NOT NULL COMMENT 'Aktion: created, updated, sent, viewed',
  `changes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Geänderte Felder (optional)' CHECK (json_valid(`changes`)),
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID der die Änderung vorgenommen hat',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_offer_id` (`offer_id`),
  KEY `idx_created_at` (`created_at`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `wheelset_offer_history_ibfk_1` FOREIGN KEY (`offer_id`) REFERENCES `wheelset_offers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `wheelset_offer_history_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `wheelset_offer_history`

-- Table structure for `wheelset_offers`
DROP TABLE IF EXISTS `wheelset_offers`;
CREATE TABLE `wheelset_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wheelset_number` varchar(50) NOT NULL COMMENT 'RESY Wheelset Nummer',
  `autohaus_id` int(11) NOT NULL COMMENT 'Autohaus ID',
  `total_amount` decimal(10,2) DEFAULT NULL,
  `customer_selection` text DEFAULT NULL COMMENT 'JSON mit Kundenauswahl',
  `pdf_filename` varchar(255) DEFAULT NULL,
  `token` varchar(64) DEFAULT NULL COMMENT 'Token für Kundenauswahl',
  `employee_name` varchar(255) DEFAULT NULL COMMENT 'Name des Mitarbeiters der das Angebot erstellt',
  `letter_content` text DEFAULT NULL COMMENT 'Brieftext',
  `offer_data` text DEFAULT NULL COMMENT 'JSON mit Reifendaten, Services, etc.',
  `customer_name` varchar(255) DEFAULT NULL COMMENT 'Kundenname',
  `customer_no` varchar(50) DEFAULT NULL,
  `customer_email` varchar(255) DEFAULT NULL COMMENT 'Kunden-E-Mail',
  `license_plate` varchar(20) DEFAULT NULL COMMENT 'Kennzeichen',
  `vin` varchar(50) DEFAULT NULL,
  `customer_autohaus` varchar(255) DEFAULT NULL COMMENT 'Autohaus des Kunden',
  `offer_text` text DEFAULT NULL COMMENT 'Angebotstext (Freitext)',
  `signature` varchar(255) DEFAULT NULL COMMENT 'Unterschrift/Mitarbeitername',
  `tire_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Angebotene Reifen (Hersteller, Dimension, EU-Label, Preis, Montage)' CHECK (json_valid(`tire_data`)),
  `selected_services` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Ausgewählte Service-IDs' CHECK (json_valid(`selected_services`)),
  `selection_token` varchar(64) DEFAULT NULL COMMENT 'Token für einmalige Kunden-Auswahl',
  `token_expires_at` datetime DEFAULT NULL COMMENT 'Token-Ablaufzeitpunkt',
  `token_used_at` datetime DEFAULT NULL COMMENT 'Zeitpunkt der Token-Verwendung',
  `old_tires_description` text DEFAULT NULL COMMENT 'Beschreibung alter Reifen (optional)',
  `offer_items` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Array von Angebotspositionen (Marke, Typ, Größe, Anzahl, Preis etc.)' CHECK (json_valid(`offer_items`)),
  `services` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Array von Serviceleistungen' CHECK (json_valid(`services`)),
  `total_price` decimal(10,2) DEFAULT 0.00 COMMENT 'Gesamtpreis',
  `status` enum('draft','sent','viewed','accepted','declined','new_request','processed') DEFAULT 'draft',
  `created_by` int(11) DEFAULT NULL COMMENT 'User ID der das Angebot erstellt hat',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `email_sent` tinyint(1) DEFAULT 0 COMMENT 'Ob E-Mail versendet wurde',
  `email_sent_at` timestamp NULL DEFAULT NULL COMMENT 'Zeitpunkt des E-Mail-Versands',
  `customer_selected_tires` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Vom Kunden ausgewählte Reifen' CHECK (json_valid(`customer_selected_tires`)),
  `customer_selected_services` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Vom Kunden ausgewählte Services' CHECK (json_valid(`customer_selected_services`)),
  `customer_notes` text DEFAULT NULL COMMENT 'Kunden-Anmerkungen',
  `teams_notification_sent` tinyint(1) DEFAULT 0 COMMENT 'Ob Teams-Benachrichtigung gesendet wurde',
  `teams_notification_sent_at` timestamp NULL DEFAULT NULL COMMENT 'Zeitpunkt der Teams-Benachrichtigung',
  PRIMARY KEY (`id`),
  UNIQUE KEY `selection_token` (`selection_token`),
  KEY `idx_wheelset_number` (`wheelset_number`),
  KEY `idx_autohaus_id` (`autohaus_id`),
  KEY `idx_created_at` (`created_at`),
  KEY `idx_status` (`status`),
  KEY `created_by` (`created_by`),
  KEY `idx_wheelset_autohaus` (`wheelset_number`,`autohaus_id`),
  KEY `idx_token` (`token`),
  CONSTRAINT `wheelset_offers_ibfk_1` FOREIGN KEY (`autohaus_id`) REFERENCES `autohaus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `wheelset_offers_ibfk_2` FOREIGN KEY (`created_by`) REFERENCES `admin_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `wheelset_offers`
INSERT INTO `wheelset_offers` (`id`, `wheelset_number`, `autohaus_id`, `total_amount`, `customer_selection`, `pdf_filename`, `token`, `employee_name`, `letter_content`, `offer_data`, `customer_name`, `customer_no`, `customer_email`, `license_plate`, `vin`, `customer_autohaus`, `offer_text`, `signature`, `tire_data`, `selected_services`, `selection_token`, `token_expires_at`, `token_used_at`, `old_tires_description`, `offer_items`, `services`, `total_price`, `status`, `created_by`, `created_at`, `updated_at`, `email_sent`, `email_sent_at`, `customer_selected_tires`, `customer_selected_services`, `customer_notes`, `teams_notification_sent`, `teams_notification_sent_at`) VALUES
('19', '103391', '1', '120.00', '{\"action\":\"new_request\",\"request_notes\":\"\"}', 'angebot_103391_20251104_122627.pdf', 'b5b5ff01ff184f90cfce65379974fd2a5d750fda4f79b3218423b4bede2dbad0', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[],\"selected_services\":[44],\"total_amount\":120}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-05 12:26:27', '2025-11-04 12:27:28', NULL, NULL, NULL, '0.00', 'new_request', '1', '2025-11-04 12:26:27', '2025-11-04 12:27:28', '1', '2025-11-04 12:26:34', NULL, NULL, NULL, '0', NULL),
('20', '103391', '1', '120.00', '{\"action\":\"declined\",\"decline_reason\":\"kmmk\"}', 'angebot_103391_20251104_223801.pdf', 'a2cf749fdf212dacae50dcd2d798d711d622a5327eaed485bee41fc17d278d7b', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[],\"selected_services\":[44],\"total_amount\":120}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-05 22:38:01', '2025-11-05 00:06:27', NULL, NULL, NULL, '0.00', 'declined', '1', '2025-11-04 22:38:01', '2025-11-05 00:06:27', '1', '2025-11-04 22:38:07', NULL, NULL, NULL, '0', NULL),
('21', '103391', '1', '212.00', '{\"action\":\"accepted\",\"tires\":[\"0\"],\"services\":[],\"notes\":\"fasda\"}', 'angebot_103391_20251104_225134.pdf', '1add4ba97e58a5d9a01cc10413cc362196b5b2e4daec04502e93e851ae245244', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[{\"brand_model\":\"123123\",\"dimension\":\"234\",\"eu_label\":\"\",\"rf\":\"\",\"price\":22,\"mounting\":24,\"quantity\":2,\"total\":92}],\"selected_services\":[44],\"total_amount\":212}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-05 22:51:34', '2025-11-04 22:53:15', NULL, NULL, NULL, '0.00', 'accepted', '1', '2025-11-04 22:51:34', '2025-11-04 22:53:15', '1', '2025-11-04 22:51:40', NULL, NULL, NULL, '0', NULL),
('22', '103391', '1', '4152.00', '{\"action\":\"accepted\",\"tires\":[\"0\"],\"services\":[\"44\"],\"notes\":\"\"}', 'angebot_103391_20251105_090928.pdf', '462c6caf550f654ff19724d639ecaac2099c6db13d15ceb0225e453520c37e21', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[{\"brand_model\":\"iasndiuasndin\",\"dimension\":\"2555\",\"eu_label\":\"\",\"rf\":\"\",\"price\":244,\"mounting\":44,\"quantity\":14,\"total\":4032}],\"selected_services\":[44],\"total_amount\":4152}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-06 09:09:28', '2025-11-05 09:10:08', NULL, NULL, NULL, '0.00', 'processed', '1', '2025-11-05 09:09:28', '2025-11-05 09:19:23', '1', '2025-11-05 09:09:34', NULL, NULL, NULL, '0', NULL),
('23', '103379', '1', '125566.00', '{\"action\":\"declined\",\"decline_reason\":\"will ich nicht\"}', 'angebot_103379_20251113_135102.pdf', '550acf8d1e70fa929d27fed082228b5cb661b6e0b632f769e6fc0cb1f62ce768', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[{\"brand_model\":\"sdasdsad213\",\"dimension\":\"asasd\",\"eu_label\":\"ssad\",\"rf\":\"asdas\",\"price\":2323,\"mounting\":123123,\"quantity\":1,\"total\":125446}],\"selected_services\":[44],\"total_amount\":125566}', 'D-ST1234', '201', NULL, 'D-ST1234', 'W0L000051T2125000', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-14 13:51:02', '2025-11-13 13:57:28', NULL, NULL, NULL, '0.00', 'processed', '1', '2025-11-13 13:51:02', '2025-11-13 13:58:01', '1', '2025-11-13 13:51:09', NULL, NULL, NULL, '0', NULL),
('24', '103391', '1', '738858.00', NULL, 'angebot_103391_20251114_001453.pdf', '4402f799b8524bd6f752a0d0c637df4861e725543fa65d4e96b3bc7c6483c4b9', 'Deniz Uludag', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludag', '{\"new_tires\":[{\"brand_model\":\"123123123\",\"dimension\":\"123123\",\"eu_label\":\"12313\",\"rf\":\"12312\",\"price\":123123,\"mounting\":123123,\"quantity\":3,\"total\":738738}],\"selected_services\":[44],\"total_amount\":738858}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-15 00:14:53', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-14 00:14:53', '2025-11-14 00:15:06', '1', '2025-11-14 00:15:06', NULL, NULL, NULL, '0', NULL),
('25', '103379', '1', '700.00', '{\"action\":\"accepted\",\"tires\":[\"0\",\"1\",\"2\"],\"services\":[],\"notes\":\"\"}', 'angebot_103379_20251119_185932.pdf', '8e885398cda6de8ff8f89635fec4447527cdd6e4c8d59246e393c8ce66d17fba', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Continental - ContiSportContact 5\",\"dimension\":\"235/40 R 18 95 W\",\"eu_label\":\"D B B 72\",\"rf\":\"\",\"price\":181,\"mounting\":0,\"quantity\":1,\"total\":181,\"ean\":\"4019238492156\",\"oem_part_number\":\"COCON0350994\",\"part_number\":\"\",\"manufacturer_number\":\"0350994000\",\"execution\":\"FP, XL, Seal\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Sommer\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"D\",\"price_net\":152.1,\"ek\":111.66,\"oem_ek\":121.37,\"rabatt\":47,\"kb\":229,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Continental - 4x4WinterContact\",\"dimension\":\"235/60 R 18 107 H\",\"eu_label\":\"D C B 72\",\"rf\":\"\",\"price\":194,\"mounting\":0,\"quantity\":1,\"total\":194,\"ean\":\"4019238203042\",\"oem_part_number\":\"COCON0354725\",\"part_number\":\"\",\"manufacturer_number\":\"0354725000\",\"execution\":\"FP, XL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"Offroad\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"D\",\"price_net\":163.03,\"ek\":119.53,\"oem_ek\":129.92,\"rabatt\":42,\"kb\":224,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Continental - 4x4WinterContact\",\"dimension\":\"235/65 R 17 104 H\",\"eu_label\":\"D C B 72\",\"rf\":\"\",\"price\":205,\"mounting\":0,\"quantity\":1,\"total\":205,\"ean\":\"4019238311266\",\"oem_part_number\":\"COCON0354688\",\"part_number\":\"\",\"manufacturer_number\":\"0354688000\",\"execution\":\"FP\",\"marking\":\"MO\",\"runflat\":\"\",\"vehicle_type\":\"Offroad\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"D\",\"price_net\":172.27,\"ek\":126.2,\"oem_ek\":137.17,\"rabatt\":42,\"kb\":236.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[44],\"total_amount\":700}', 'D-ST1234', '201', NULL, 'D-ST1234', 'W0L000051T2125000', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-20 18:59:32', '2025-11-19 19:01:43', NULL, NULL, NULL, '0.00', 'processed', '1', '2025-11-19 18:59:32', '2025-11-19 19:19:31', '1', '2025-11-19 18:59:46', NULL, NULL, NULL, '0', NULL),
('26', '103379', '1', '83.00', NULL, 'angebot_103379_20251119_192507.pdf', '97c1852a36bcee44d3e1607875d8f95eb5346d4495454494c4e2cff185a499fa', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Dunlop - Winter Response 2 MS\",\"dimension\":\"195/65 R 15 91 T\",\"eu_label\":\"C C B 70\",\"rf\":\"\",\"price\":83,\"mounting\":0,\"quantity\":1,\"total\":83,\"ean\":\"3188649820504\",\"oem_part_number\":\"GODUN528970\",\"part_number\":\"\",\"manufacturer_number\":\"528970\",\"execution\":\"SL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"70\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":69.75,\"ek\":46.33,\"oem_ek\":55.16,\"rabatt\":44,\"kb\":98.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[],\"total_amount\":83}', 'D-ST1234', '201', NULL, 'D-ST1234', 'W0L000051T2125000', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-20 19:25:07', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-19 19:25:07', '2025-11-19 19:25:20', '1', '2025-11-19 19:25:20', NULL, NULL, NULL, '0', NULL),
('27', '103379', '1', '67.00', NULL, 'angebot_103379_20251119_192822.pdf', '20262ad5aa85f1a8ece280653fd7d638a249c0183eb6073be059596a43ef75ce', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Fulda - Kristall Montero 3 MS\",\"dimension\":\"195/65 R 15 91 T\",\"eu_label\":\"C C B 72\",\"rf\":\"\",\"price\":67,\"mounting\":0,\"quantity\":1,\"total\":67,\"ean\":\"5452000448125\",\"oem_part_number\":\"GOFUL530998\",\"part_number\":\"\",\"manufacturer_number\":\"530998\",\"execution\":\"SL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"Winter\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":56.3,\"ek\":37.63,\"oem_ek\":44.8,\"rabatt\":44,\"kb\":80,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[],\"total_amount\":67}', 'D-ST1234', '201', NULL, 'D-ST1234', 'W0L000051T2125000', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-20 19:28:22', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-19 19:28:22', '2025-11-19 19:28:34', '1', '2025-11-19 19:28:34', NULL, NULL, NULL, '0', NULL),
('28', '103391', '1', '4499.00', NULL, 'angebot_103391_20251119_204026.pdf', '89b0065b51881681d5cccd318ca8577efb2ff08b262edf413823950388610caa', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Dunlop - All Season 2\",\"dimension\":\"215/65 R 17 103 V\",\"eu_label\":\"B B B 72\",\"rf\":\"\",\"price\":148,\"mounting\":0,\"quantity\":4,\"total\":592,\"ean\":\"4038526420596\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"596475\",\"execution\":\"XL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"Offroad\",\"application_area\":\"All-Season\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"B\",\"price_net\":124.37,\"ek\":83.5,\"oem_ek\":99.4,\"rabatt\":44,\"kb\":177.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Dunlop - Econodrive AS\",\"dimension\":\"185/75 R 16C 104/102 R\",\"eu_label\":\"D C B 74\",\"rf\":\"\",\"price\":143,\"mounting\":0,\"quantity\":4,\"total\":572,\"ean\":\"4038526407696\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"595179\",\"execution\":\"\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"LLKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"74\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"D\",\"price_net\":120.17,\"ek\":80.2,\"oem_ek\":95.48,\"rabatt\":44,\"kb\":170.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Bridgestone - Dueler All Terrain A/T002\",\"dimension\":\"265/70 R 15 112 T\",\"eu_label\":\"C C B 72\",\"rf\":\"\",\"price\":198,\"mounting\":0,\"quantity\":3,\"total\":594,\"ean\":\"3286342033815\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"20338\",\"execution\":\"\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"Offroad\",\"application_area\":\"All-Season\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"C\",\"rolling_resistance\":\"C\",\"price_net\":166.39,\"ek\":121.99,\"oem_ek\":132.6,\"rabatt\":40,\"kb\":221,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Continental - Allseasoncontact 2\",\"dimension\":\"255/40 R 20 101 H\",\"eu_label\":\"\",\"rf\":\"\",\"price\":296,\"mounting\":0,\"quantity\":4,\"total\":1184,\"ean\":\"4019238999488\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"0316962000\",\"execution\":\"FP, XL\",\"marking\":\"EVc\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"\",\"noise_class\":\"\",\"wet_grip\":\"\",\"rolling_resistance\":\"\",\"price_net\":248.74,\"ek\":182.61,\"oem_ek\":198.49,\"rabatt\":47,\"kb\":374.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Dunlop - All Season 2\",\"dimension\":\"235/45 R 17 97 Y\",\"eu_label\":\"B B B 71\",\"rf\":\"\",\"price\":143,\"mounting\":0,\"quantity\":3,\"total\":429,\"ean\":\"4038526421616\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"596487\",\"execution\":\"FP, XL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"71\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"B\",\"price_net\":120.17,\"ek\":80.2,\"oem_ek\":95.48,\"rabatt\":44,\"kb\":170.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Bridgestone - Weather Control A005\",\"dimension\":\"235/50 R 18 101 H\",\"eu_label\":\"A B B 72\",\"rf\":\"\",\"price\":188,\"mounting\":0,\"quantity\":6,\"total\":1128,\"ean\":\"3286341406511\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"14065\",\"execution\":\"XL\",\"marking\":\"\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"B\",\"rolling_resistance\":\"A\",\"price_net\":157.98,\"ek\":115.92,\"oem_ek\":126,\"rabatt\":40,\"kb\":210,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[],\"total_amount\":4499}', 'M-UH999', '201', NULL, 'M-UH999', 'W0L000051T2125002', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-20 20:40:26', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-19 20:40:26', '2025-11-19 20:40:39', '1', '2025-11-19 20:40:39', NULL, NULL, NULL, '0', NULL),
('29', '103379', '1', '628.00', NULL, 'angebot_103379_20251120_085813.pdf', 'fa4b15dc7e714abebbedb69b0e9ec65aa579eed2693fdcdb43e16c2a3c25f2e7', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Continental - Allseasoncontact 2\",\"dimension\":\"255/45 R 20 105 Y\",\"eu_label\":\"\",\"rf\":\"\",\"price\":302,\"mounting\":0,\"quantity\":1,\"total\":302,\"ean\":\"4019238999440\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"0316964000\",\"execution\":\"FP, XL\",\"marking\":\"EVc\",\"runflat\":\"\",\"vehicle_type\":\"PKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"\",\"noise_class\":\"\",\"wet_grip\":\"\",\"rolling_resistance\":\"\",\"price_net\":253.78,\"ek\":186.75,\"oem_ek\":202.99,\"rabatt\":47,\"kb\":383,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"},{\"brand_model\":\"Continental - Vancontact A/S Ultra\",\"dimension\":\"235/50 R 19C 111/109 T\",\"eu_label\":\"B B A 72\",\"rf\":\"\",\"price\":326,\"mounting\":0,\"quantity\":1,\"total\":326,\"ean\":\"4019238285666\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"0451979000\",\"execution\":\"\",\"marking\":\"EVc\",\"runflat\":\"\",\"vehicle_type\":\"LLKW\",\"application_area\":\"All-Season\",\"noise_emission\":\"72\",\"noise_class\":\"A\",\"wet_grip\":\"B\",\"rolling_resistance\":\"B\",\"price_net\":273.95,\"ek\":201.63,\"oem_ek\":219.16,\"rabatt\":47,\"kb\":413.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[],\"total_amount\":628}', 'D-ST1234', '201', NULL, 'D-ST1234', 'W0L000051T2125000', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-21 08:58:13', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-20 08:58:13', '2025-11-20 08:58:19', '1', '2025-11-20 08:58:19', NULL, NULL, NULL, '0', NULL),
('30', '103520', '1', '222.00', NULL, 'angebot_103520_20251121_214013.pdf', '2b2af3ef351ed05e177e38e7670cf54d46c3118b8287433ad944bc6dacd71109', 'Deniz Uludagijn', 'Sehr geehrte Damen und Herren,\n\nanbei erhalten Sie Ihr Reifenangebot für den kommenden Boxenstop.\n\nBei Fragen stehen wir Ihnen gerne zur Verfügung.\n\nMit freundlichen Grüßen\nDeniz Uludagijn', '{\"new_tires\":[{\"brand_model\":\"Continental - ContiSportContact 6\",\"dimension\":\"235/40 R 18 95 Y\",\"eu_label\":\"D A B 72\",\"rf\":\"SSR\",\"price\":222,\"mounting\":0,\"quantity\":1,\"total\":222,\"ean\":\"4019238036954\",\"oem_part_number\":\"\",\"part_number\":\"\",\"manufacturer_number\":\"0311209000\",\"execution\":\"FP, XL\",\"marking\":\"EVc\",\"runflat\":\"SSR\",\"vehicle_type\":\"PKW\",\"application_area\":\"Sommer\",\"noise_emission\":\"72\",\"noise_class\":\"B\",\"wet_grip\":\"A\",\"rolling_resistance\":\"D\",\"price_net\":186.55,\"ek\":136.78,\"oem_ek\":148.67,\"rabatt\":47,\"kb\":280.5,\"kb_date\":\"\",\"stock\":\"\",\"warehouse\":\"\",\"notes\":\"\"}],\"selected_services\":[],\"total_amount\":222}', 'BL-UB1234', '201', NULL, 'BL-UB1234', 'WBA12345689912233', NULL, NULL, NULL, NULL, NULL, NULL, '2025-11-22 21:40:13', NULL, NULL, NULL, NULL, '0.00', 'sent', '1', '2025-11-21 21:40:13', '2025-11-21 21:40:27', '1', '2025-11-21 21:40:27', NULL, NULL, NULL, '0', NULL);


-- Table structure for `wheelsets_cache`
DROP TABLE IF EXISTS `wheelsets_cache`;
CREATE TABLE `wheelsets_cache` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cache_key` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `cache_key` (`cache_key`),
  KEY `created_at` (`created_at`),
  KEY `idx_cache_key_created` (`cache_key`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table `wheelsets_cache`
INSERT INTO `wheelsets_cache` (`id`, `cache_key`, `data`, `created_at`) VALUES
('150', 'wheelsets_1_20_2025-11-23-22', '[{\"satznummer\":\"103379\",\"kennzeichen\":\"D-ST1234\",\"fin\":\"W0L000051T2125000\",\"haltername\":\"-\",\"reifenmodell\":\"Pirelli P Zero\",\"reifenart\":\"Winterreifen\",\"saison\":\"Winter\",\"reifengroesse\":\"205R16\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Kiel\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Nur Lagern\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"L\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null}]},{\"satznummer\":\"103391\",\"kennzeichen\":\"M-UH999\",\"fin\":\"W0L000051T2125002\",\"haltername\":\"-\",\"reifenmodell\":\"Continental Modell G\",\"reifenart\":\"Ganzjahresreifen\",\"saison\":\"Ganzjahres\",\"reifengroesse\":\"150R15\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Kiel\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Lagern, Reinigen, Pruefen\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"P\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null}]},{\"satznummer\":\"103380\",\"kennzeichen\":\"HH-RS9911\",\"fin\":\"W0L000051T2125001\",\"haltername\":\"-\",\"reifenmodell\":\"-\",\"reifenart\":\"Unbekannt\",\"saison\":\"Unbekannt\",\"reifengroesse\":\"-\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Kiel\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Lagern und Reinigen\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"R\",\"resy_wheels\":[]},{\"satznummer\":\"103520\",\"kennzeichen\":\"BL-UB1234\",\"fin\":\"WBA12345689912233\",\"haltername\":\"-\",\"reifenmodell\":\"Continental ContiSportContact 5\",\"reifenart\":\"Sommerreifen\",\"saison\":\"Sommer\",\"reifengroesse\":\"235\\/40R18\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Kiel\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Nur Lagern\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"L\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null}]}]', '2025-11-23 22:49:32'),
('151', 'wheelsets_3_20_2025-11-23-23', '[{\"satznummer\":\"103379\",\"kennzeichen\":\"D-ST1234\",\"fin\":\"W0L000051T2125000\",\"haltername\":\"-\",\"reifenmodell\":\"Pirelli P Zero\",\"reifenart\":\"Winterreifen\",\"saison\":\"Winter\",\"reifengroesse\":\"205R16\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Glinde\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Nur Lagern\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"L\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Pirelli\",\"model\":\"P Zero\",\"tireType\":\"WINTER\",\"width\":205,\"ratio\":null,\"diameter\":16,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null}]},{\"satznummer\":\"103391\",\"kennzeichen\":\"M-UH999\",\"fin\":\"W0L000051T2125002\",\"haltername\":\"-\",\"reifenmodell\":\"Continental Modell G\",\"reifenart\":\"Ganzjahresreifen\",\"saison\":\"Ganzjahres\",\"reifengroesse\":\"150R15\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Glinde\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Lagern, Reinigen, Pruefen\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"P\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Continental\",\"model\":\"Modell G\",\"tireType\":\"ALLSEASON\",\"width\":150,\"ratio\":null,\"diameter\":15,\"normalizedWheelSize\":\"\",\"speedIndx\":\"\",\"loadIndx1\":null,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":false,\"seal\":false,\"rimType\":\"Steel\",\"rimWidth\":null,\"rimOffset\":null}]},{\"satznummer\":\"103380\",\"kennzeichen\":\"HH-RS9911\",\"fin\":\"W0L000051T2125001\",\"haltername\":\"-\",\"reifenmodell\":\"-\",\"reifenart\":\"Unbekannt\",\"saison\":\"Unbekannt\",\"reifengroesse\":\"-\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Glinde\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Lagern und Reinigen\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"R\",\"resy_wheels\":[]},{\"satznummer\":\"103520\",\"kennzeichen\":\"BL-UB1234\",\"fin\":\"WBA12345689912233\",\"haltername\":\"-\",\"reifenmodell\":\"Continental ContiSportContact 5\",\"reifenart\":\"Sommerreifen\",\"saison\":\"Sommer\",\"reifengroesse\":\"235\\/40R18\",\"profiltiefe\":\"-\",\"empfehlung\":\"In Ordnung\",\"autohaus\":\"B & E Volvo Glinde\",\"ziel_autohaus\":\"-\",\"eingangsdatum\":\"-\",\"rueckliefertermin\":\"-\",\"lagerplatz\":\"\",\"status\":\"eingelagert\",\"pruefbericht\":\"-\",\"servicePackageName\":\"Nur Lagern\",\"comment\":\"\",\"resy_customer_no\":\"201\",\"resy_service_package\":\"L\",\"resy_wheels\":[{\"position\":\"VL\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"VR\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HL\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null},{\"position\":\"HR\",\"manufacturer\":\"Continental\",\"model\":\"ContiSportContact 5\",\"tireType\":\"SUMMER\",\"width\":235,\"ratio\":40,\"diameter\":18,\"normalizedWheelSize\":\"235\\/40R18\",\"speedIndx\":\"W\",\"loadIndx1\":95,\"loadIndx2\":null,\"dotNumber\":\"\",\"profile\":null,\"pressure\":null,\"pressureControl\":true,\"runFlat\":true,\"seal\":false,\"rimType\":\"Al\",\"rimWidth\":null,\"rimOffset\":null}]}]', '2025-11-23 23:04:12');

