<?php
/**
 * Termine verwalten - Moderne Version
 */

session_start();
require_once '../config/database.php';
require_once 'includes/header.php';
require_once 'includes/navigation.php';

// Check if user is logged in
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$db = new Database();
$conn = $db->getConnection();

// Get current user data
$current_user_id = $_SESSION['admin_user_id'] ?? null;
$current_user_name = 'Administrator';
$current_user_role = 'admin';
$current_user_autohaus_id = null;
$current_user_autohaus_name = null;
$can_switch_autohaus = false;

if ($current_user_id) {
    $stmt = $conn->prepare("
        SELECT u.full_name, u.username, u.role, u.autohaus_id, u.can_switch_autohaus, a.name as autohaus_name
        FROM admin_users u
        LEFT JOIN autohaus a ON u.autohaus_id = a.id
        WHERE u.id = ?
    ");
    $stmt->execute([$current_user_id]);
    $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
    $current_user_name = $user_data['full_name'] ?? $user_data['username'] ?? 'Benutzer';
    $current_user_role = $user_data['role'] ?? 'admin';
    $current_user_autohaus_id = $user_data['autohaus_id'];
    $current_user_autohaus_name = $user_data['autohaus_name'];
    $can_switch_autohaus = $user_data['can_switch_autohaus'] == 1;
}

// Get user theme preference
$current_theme = 'light';
if ($current_user_id) {
    $stmt = $conn->prepare("SELECT setting_value FROM admin_settings WHERE user_id = ? AND setting_key = 'admin_theme'");
    $stmt->execute([$current_user_id]);
    $theme_result = $stmt->fetch();
    $current_theme = $theme_result['setting_value'] ?? 'light';
}

// Theme in Session speichern für Header
$_SESSION['current_theme'] = $current_theme;

// Benutzerdaten für Navigation vorbereiten
$user_data = [
    'name' => $current_user_name,
    'email' => 'admin@boxenstop.de',
    'position' => 'System Administrator',
    'department' => 'IT',
    'avatar' => 'assets/images/default-avatar.png',
    'autohaus_name' => $current_user_autohaus_name,
    'can_switch_autohaus' => $can_switch_autohaus
];

// Header rendern
echo renderAdminHeader(
    'Termine verwalten',
    'Verwalten Sie alle Termine und Buchungen',
    $user_data
);
?>

            <!-- Hier kommt der spezifische Inhalt der Seite -->
            <div class="content-card">
                <div class="card-header">
                    <h3>Termine verwalten</h3>
                </div>
                <div class="card-content">
                    <p>Diese Seite wurde mit der neuen Navigation aktualisiert.</p>
                    <p>Der spezifische Inhalt muss noch implementiert werden.</p>
                </div>
            </div>

<?php
// Footer rendern
echo renderAdminFooter();
?>