<?php
/**
 * Status-Updates für Wheelset-Angebote über Teams-Buttons
 */

// Set headers based on request method
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // For GET requests (from Teams buttons), return HTML
    header('Content-Type: text/html; charset=UTF-8');
} else {
    // For POST requests, return JSON
    header('Content-Type: application/json');
}

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once dirname(__DIR__) . '/config/database.php';

try {
    $method = $_SERVER['REQUEST_METHOD'];
    
    // Unterstütze sowohl GET (für OpenUri) als auch POST (für HttpPOST)
    if ($method === 'POST') {
        $data = json_decode(file_get_contents('php://input'), true);
    } else {
        $data = $_GET;
    }
    
    $offerId = $data['offer_id'] ?? null;
    $action = $data['action'] ?? '';
    $newStatus = $data['status'] ?? null;
    
    if (!$offerId) {
        throw new Exception('offer_id ist erforderlich');
    }
    
    $db = new Database();
    $conn = $db->getConnection();
    
    // Lade Angebot
    $stmt = $conn->prepare("SELECT * FROM wheelset_offers WHERE id = ?");
    $stmt->execute([$offerId]);
    $offer = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$offer) {
        throw new Exception('Angebot nicht gefunden');
    }
    
    // Führe Aktion aus
    if ($action === 'mark_processed' && $newStatus) {
        // Status aktualisieren
        $stmt = $conn->prepare("UPDATE wheelset_offers SET status = ?, updated_at = NOW() WHERE id = ?");
        $stmt->execute([$newStatus, $offerId]);
        
        // Optional: Sende Bestätigungs-Email an Kunde
        // TODO: Implementiere Bestätigungs-Email
        
        if ($_SERVER['REQUEST_METHOD'] === 'GET') {
            // Return HTML page for GET requests (from Teams)
            ?>
            <!DOCTYPE html>
            <html lang="de">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Status aktualisiert</title>
                <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
                <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
                <style>
                    * { margin: 0; padding: 0; box-sizing: border-box; }
                    body {
                        font-family: 'Inter', sans-serif;
                        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
                        min-height: 100vh;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        padding: 20px;
                    }
                    .status-container {
                        background: white;
                        border-radius: 16px;
                        box-shadow: 0 10px 40px rgba(0,0,0,0.1);
                        max-width: 500px;
                        width: 100%;
                        padding: 2rem;
                        text-align: center;
                    }
                    .success-icon {
                        font-size: 3rem;
                        color: #28a745;
                        margin-bottom: 1rem;
                    }
                    .status-title {
                        font-size: 1.5rem;
                        font-weight: 600;
                        margin-bottom: 1rem;
                        color: #333;
                    }
                    .status-message {
                        color: #6c757d;
                        margin-bottom: 1.5rem;
                    }
                    .btn-close {
                        background: #007bff;
                        color: white;
                        border: none;
                        padding: 0.75rem 2rem;
                        border-radius: 8px;
                        font-size: 1rem;
                        cursor: pointer;
                        transition: all 0.3s;
                    }
                    .btn-close:hover {
                        background: #0056b3;
                        transform: translateY(-2px);
                    }
                </style>
                <script>
                    setTimeout(() => window.close(), 3000);
                </script>
            </head>
            <body>
                <div class="status-container">
                    <div class="success-icon">✅</div>
                    <h1 class="status-title">Status aktualisiert!</h1>
                    <p class="status-message">Das Angebot wurde als bearbeitet markiert.</p>
                    <button class="btn-close" onclick="window.close()">Schließen</button>
                </div>
            </body>
            </html>
            <?php
        } else {
            echo json_encode([
                'success' => true,
                'message' => 'Angebot als bearbeitet markiert',
                'status' => $newStatus
            ]);
        }
        
    } elseif ($action === 'resend_email') {
        // Lade Autohaus-Daten
        $stmt = $conn->prepare("
            SELECT name, email_smtp_host, email_smtp_port, email_smtp_username, 
                   email_smtp_password, email_smtp_encryption, email_from_name
            FROM autohaus WHERE id = ?
        ");
        $stmt->execute([$offer['autohaus_id']]);
        $autohaus = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$autohaus || empty($autohaus['email_smtp_host'])) {
            throw new Exception('SMTP-Konfiguration fehlt');
        }
        
        // Frage nach E-Mail-Adresse (für Teams-Integration: verwende eine Standard-E-Mail oder hole aus DB)
        $recipientEmail = $data['recipient_email'] ?? '';
        
        // Falls keine E-Mail übergeben, verwende Kunden-E-Mail aus DB oder zeige Fehler
        if (empty($recipientEmail)) {
            // Versuche E-Mail aus anderen Quellen zu holen
            // Für jetzt: Fehler zurückgeben
            throw new Exception('E-Mail-Adresse erforderlich. Bitte geben Sie die E-Mail-Adresse im Admin-Bereich ein.');
        }
        
        // Sende E-Mail erneut
        require_once 'send_wheelset_offer_email.php';
        $emailResult = sendWheelsetOfferEmail($offer, $autohaus, $recipientEmail, $offer['token']);
        
        if ($emailResult['success']) {
            // Update Email-Status
            $stmt = $conn->prepare("
                UPDATE wheelset_offers 
                SET email_sent = 1, email_sent_at = NOW()
                WHERE id = ?
            ");
            $stmt->execute([$offerId]);
            
            echo json_encode([
                'success' => true,
                'message' => 'E-Mail erfolgreich erneut versendet'
            ]);
        } else {
            throw new Exception($emailResult['error'] ?? 'Fehler beim Versenden der E-Mail');
        }
        
    } else {
        throw new Exception('Unbekannte Aktion');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>

