<?php
// upload_profile_image.php - Profilbild hochladen
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

require_once 'config.php';

try {
    // Token aus Header extrahieren
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';
    
    if (!preg_match('/Bearer\s+(.*)$/i', $auth_header, $matches)) {
        throw new Exception('Authorization token required');
    }
    
    $token = $matches[1];
    
    // Benutzer anhand Token finden
    $stmt = $pdo->prepare("SELECT * FROM users WHERE auth_token = ? AND is_active = 1 AND token_expires_at > NOW()");
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        throw new Exception('Invalid or expired token');
    }
    
    // Prüfen ob Datei hochgeladen wurde
    if (!isset($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('No image uploaded or upload error');
    }
    
    $file = $_FILES['image'];
    
    // Bild-Validierung
    $allowed_types = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif'];
    $max_size = 5 * 1024 * 1024; // 5MB
    
    if (!in_array($file['type'], $allowed_types)) {
        throw new Exception('Invalid image type. Only JPEG, PNG and GIF are allowed');
    }
    
    if ($file['size'] > $max_size) {
        throw new Exception('Image too large. Maximum size is 5MB');
    }
    
    // Upload-Verzeichnis erstellen
    $upload_dir = 'uploads/profile_images/';
    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }
    
    // Eindeutigen Dateinamen generieren
    $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
    $unique_filename = $user['id'] . '_profile_' . time() . '_' . uniqid() . '.' . $file_extension;
    $file_path = $upload_dir . $unique_filename;
    
    // Altes Profilbild löschen (falls vorhanden)
    if (!empty($user['profile_image_url'])) {
        $old_file_path = $user['profile_image_url'];
        if (file_exists($old_file_path)) {
            unlink($old_file_path);
        }
    }
    
    // Bild verschieben
    if (!move_uploaded_file($file['tmp_name'], $file_path)) {
        throw new Exception('Failed to save uploaded image');
    }
    
    // Profilbild-URL in Datenbank aktualisieren
    $stmt = $pdo->prepare("UPDATE users SET profile_image_url = ?, updated_at = NOW() WHERE id = ?");
    $result = $stmt->execute([$file_path, $user['id']]);
    
    if ($result) {
        echo json_encode([
            'success' => true,
            'profile_image_url' => $file_path,
            'message' => 'Profile image uploaded successfully'
        ]);
    } else {
        // Bild löschen falls Datenbank-Update fehlschlägt
        unlink($file_path);
        throw new Exception('Failed to update profile image');
    }
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
