<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    if (!$conn) {
        throw new Exception("Keine Datenbankverbindung möglich");
    }
    
    // Get JSON input
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input || (!isset($input['appointmentId']) && !isset($input['appointment_id']))) {
        throw new Exception('Ungültige Eingabedaten: appointmentId oder appointment_id erforderlich');
    }
    
    $appointmentId = $input['appointmentId'] ?? $input['appointment_id'];
    $offerType = $input['offer_type'] ?? $input['offerType'] ?? 'created'; // 'created' or 'sent'
    $offerData = $input['offer_data'] ?? $input['offerData'] ?? null;
    $pdfFilename = $input['pdf_filename'] ?? $input['pdfFilename'] ?? null;
    $emailRecipient = $input['email_recipient'] ?? $input['emailRecipient'] ?? null;
    $emailSubject = $input['email_subject'] ?? $input['emailSubject'] ?? null;
    
    // Get current user info (you'll need to adapt this based on your auth system)
    $userId = $input['user_id'] ?? $_SESSION['user_id'] ?? 1; // Fallback to user ID 1
    $username = $input['username'] ?? $_SESSION['username'] ?? 'System'; // Fallback to 'System'
    
    // Insert offer tracking record
    $stmt = $conn->prepare("
        INSERT INTO offer_tracking 
        (appointment_id, user_id, username, offer_type, offer_data, pdf_filename, email_recipient, email_subject) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ");
    
    $stmt->execute([
        $appointmentId,
        $userId,
        $username,
        $offerType,
        json_encode($offerData),
        $pdfFilename,
        $emailRecipient,
        $emailSubject
    ]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Angebot erfolgreich getrackt',
        'trackingId' => $conn->lastInsertId()
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
