<?php
/**
 * Test-Seite für Session-Erneuerung
 * Hilft beim Debugging der RESY-Anmeldung
 */

require_once __DIR__ . '/../config/database.php';

// Hole alle Autohaus-Daten
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT id, name, resy_base_url, resy_username, resy_password FROM autohaus WHERE resy_base_url IS NOT NULL");
$stmt->execute();
$autohausList = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>RESY Session-Erneuerung Test</h2>";

foreach ($autohausList as $autohaus) {
    echo "<h3>Autohaus: " . htmlspecialchars($autohaus['name']) . "</h3>";
    echo "<p>URL: " . htmlspecialchars($autohaus['resy_base_url']) . "</p>";
    echo "<p>Username: " . htmlspecialchars($autohaus['resy_username']) . "</p>";
    
    if (isset($_GET['test_login']) && $_GET['test_login'] == $autohaus['id']) {
        echo "<h4>Session-Erneuerung Test:</h4>";
        
        $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
        
        // Lösche alte Cookies
        if (file_exists($cookieFile)) {
            unlink($cookieFile);
            echo "<p>✅ Alte Cookie-Datei gelöscht</p>";
        }
        
        try {
            // Teste ResyDataExtractor
            echo "<h5>1. Teste ResyDataExtractor:</h5>";
            require_once __DIR__ . '/resy_data_extraction_breakthrough.php';
            $extractor = new ResyDataExtractor();
            
            $loginResult = $extractor->performLogin($autohaus['resy_base_url'], $autohaus['resy_username'], $autohaus['resy_password']);
            
            echo "<p>Login-Ergebnis: " . json_encode($loginResult) . "</p>";
            
            if ($loginResult['success'] && file_exists($cookieFile)) {
                $fileSize = filesize($cookieFile);
                echo "<p style='color: green;'>✅ ResyDataExtractor erfolgreich! Cookie-Datei: $fileSize Bytes</p>";
                
                // Teste Bildladen
                echo "<h5>2. Teste Bildladen:</h5>";
                
                // Hole eine LGFOTO_ID aus der Datenbank
                $stmt = $conn->prepare("
                    SELECT DISTINCT lgfoto_id 
                    FROM tire_images ti 
                    JOIN appointments a ON ti.appointment_id = a.id 
                    WHERE a.autohaus_id = ? AND lgfoto_id IS NOT NULL 
                    LIMIT 1
                ");
                $stmt->execute([$autohaus['id']]);
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($result) {
                    $lgfotoId = $result['lgfoto_id'];
                    echo "<p>Teste LGFOTO_ID: " . $lgfotoId . "</p>";
                    
                    // Teste Image Proxy
                    $proxyUrl = "resy_image_proxy.php?lgfoto_id=" . $lgfotoId . "&appointment_id=100";
                    echo "<p><a href='$proxyUrl' target='_blank'>Bild laden</a></p>";
                    echo "<p><img src='$proxyUrl' style='max-width: 200px; border: 1px solid #ccc;' alt='Test-Bild'></p>";
                } else {
                    echo "<p style='color: orange;'>⚠️ Keine LGFOTO_IDs für dieses Autohaus gefunden</p>";
                }
                
            } else {
                echo "<p style='color: red;'>❌ ResyDataExtractor fehlgeschlagen</p>";
                
                // Teste direkte Anmeldung
                echo "<h5>2. Teste direkte Anmeldung:</h5>";
                
                $loginUrl = rtrim($autohaus['resy_base_url'], '/') . '/index.php?m=login&a=login';
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $loginUrl);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                    'username' => $autohaus['resy_username'],
                    'password' => $autohaus['resy_password']
                ]));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
                curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                
                $loginResponse = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $error = curl_error($ch);
                curl_close($ch);
                
                echo "<p>Login URL: " . htmlspecialchars($loginUrl) . "</p>";
                echo "<p>Response Code: $httpCode</p>";
                if ($error) {
                    echo "<p style='color: red;'>cURL Error: $error</p>";
                }
                echo "<p>Response (erste 500 Zeichen):</p>";
                echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 3px; font-size: 12px;'>";
                echo htmlspecialchars(substr($loginResponse, 0, 500));
                echo "</pre>";
                
                if ($httpCode === 200 && !empty($loginResponse) && file_exists($cookieFile)) {
                    $fileSize = filesize($cookieFile);
                    echo "<p style='color: green;'>✅ Direkte Anmeldung erfolgreich! Cookie-Datei: $fileSize Bytes</p>";
                } else {
                    echo "<p style='color: red;'>❌ Direkte Anmeldung fehlgeschlagen</p>";
                    echo "<p>Cookie-Datei existiert: " . (file_exists($cookieFile) ? 'JA' : 'NEIN') . "</p>";
                }
            }
            
        } catch (Exception $e) {
            echo "<p style='color: red;'>❌ Fehler: " . htmlspecialchars($e->getMessage()) . "</p>";
        }
        
    } else {
        echo "<a href='?test_login=" . $autohaus['id'] . "' style='background: #007bff; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Session-Erneuerung testen</a>";
    }
    
    echo "<hr>";
}

echo "<h3>Navigation</h3>";
echo "<p><a href='test_image_proxy.php' style='background: #28a745; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Image Proxy Test</a></p>";
echo "<p><a href='clear_resy_session.php' style='background: #dc3545; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Session-Cookies löschen</a></p>";
echo "<p><a href='../admin/appointments.php' style='background: #6c757d; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Zurück zu Appointments</a></p>";
?>
