<?php
header('Content-Type: application/json');

$input = file_get_contents('php://input');
$data = json_decode($input, true);

if ($data && isset($data['action'])) {
    switch ($data['action']) {
        case 'test':
            echo json_encode([
                'success' => true,
                'message' => 'Minimal API funktioniert!',
                'timestamp' => date('Y-m-d H:i:s'),
                'input' => $data
            ]);
            break;
        case 'login':
            echo json_encode([
                'success' => true,
                'message' => 'Login simuliert',
                'sessionData' => [
                    'loggedIn' => true,
                    'timestamp' => time()
                ]
            ]);
            break;
        default:
            echo json_encode([
                'success' => false,
                'error' => 'Unbekannte Aktion: ' . $data['action']
            ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Keine gültigen Daten empfangen',
        'raw_input' => $input
    ]);
}
?>
