<?php
/**
 * Test-Seite für RESY Image Proxy
 * Hilft beim Debugging von Bildlade-Problemen
 */

require_once __DIR__ . '/../config/database.php';

// Hole alle Autohaus-Daten
$db = new Database();
$conn = $db->getConnection();

$stmt = $conn->prepare("SELECT id, name, resy_base_url, resy_username FROM autohaus WHERE resy_base_url IS NOT NULL");
$stmt->execute();
$autohausList = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<h2>RESY Image Proxy Test</h2>";

foreach ($autohausList as $autohaus) {
    echo "<h3>Autohaus: " . htmlspecialchars($autohaus['name']) . "</h3>";
    echo "<p>URL: " . htmlspecialchars($autohaus['resy_base_url']) . "</p>";
    echo "<p>Username: " . htmlspecialchars($autohaus['resy_username']) . "</p>";
    
    // Teste Session-Status
    $cookieFile = sys_get_temp_dir() . '/resy_cookies_breakthrough.txt';
    
    if (file_exists($cookieFile)) {
        $fileSize = filesize($cookieFile);
        $fileTime = date('Y-m-d H:i:s', filemtime($cookieFile));
        $age = time() - filemtime($cookieFile);
        
        echo "<p><strong>Cookie-Status:</strong></p>";
        echo "<ul>";
        echo "<li>Datei existiert: JA</li>";
        echo "<li>Größe: " . $fileSize . " Bytes</li>";
        echo "<li>Erstellt: " . $fileTime . "</li>";
        echo "<li>Alter: " . $age . " Sekunden (" . round($age/60) . " Minuten)</li>";
        echo "</ul>";
        
        // Session-Erneuerung
        if (isset($_GET['renew_session']) && $_GET['renew_session'] == $autohaus['id']) {
            echo "<h4>Session-Erneuerung:</h4>";
            
            try {
                // Lösche alte Cookies
                if (file_exists($cookieFile)) {
                    unlink($cookieFile);
                    echo "<p>✅ Alte Cookie-Datei gelöscht</p>";
                }
                
                // Versuche Anmeldung
                $loginUrl = rtrim($autohaus['resy_base_url'], '/') . '/index.php?m=login&a=login';
                
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $loginUrl);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                    'username' => $autohaus['resy_username'],
                    'password' => $autohaus['resy_password']
                ]));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
                curl_setopt($ch, CURLOPT_COOKIEJAR, $cookieFile);
                curl_setopt($ch, CURLOPT_COOKIEFILE, $cookieFile);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36');
                curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                
                $loginResponse = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                $error = curl_error($ch);
                curl_close($ch);
                
                echo "<p>Login Response Code: $httpCode</p>";
                if ($error) {
                    echo "<p style='color: red;'>cURL Error: $error</p>";
                }
                
                if ($httpCode === 200 && !empty($loginResponse) && file_exists($cookieFile)) {
                    $fileSize = filesize($cookieFile);
                    echo "<p style='color: green;'>✅ Session-Erneuerung erfolgreich!</p>";
                    echo "<p>Cookie-Datei erstellt: " . $fileSize . " Bytes</p>";
                    echo "<p><a href='?test_image=" . $autohaus['id'] . "' style='background: #007bff; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Jetzt Bild testen</a></p>";
                } else {
                    echo "<p style='color: red;'>❌ Session-Erneuerung fehlgeschlagen</p>";
                    echo "<p>HTTP Code: $httpCode</p>";
                    echo "<p>Cookie-Datei existiert: " . (file_exists($cookieFile) ? 'JA' : 'NEIN') . "</p>";
                }
                
            } catch (Exception $e) {
                echo "<p style='color: red;'>❌ Fehler bei Session-Erneuerung: " . htmlspecialchars($e->getMessage()) . "</p>";
            }
            
        } else if (isset($_GET['test_image']) && $_GET['test_image'] == $autohaus['id']) {
            echo "<h4>Bild-Test:</h4>";
            
            // Hole eine LGFOTO_ID aus der Datenbank
            $stmt = $conn->prepare("
                SELECT DISTINCT lgfoto_id 
                FROM tire_images ti 
                JOIN appointments a ON ti.appointment_id = a.id 
                WHERE a.autohaus_id = ? AND lgfoto_id IS NOT NULL 
                LIMIT 1
            ");
            $stmt->execute([$autohaus['id']]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($result) {
                $lgfotoId = $result['lgfoto_id'];
                echo "<p>Teste LGFOTO_ID: " . $lgfotoId . "</p>";
                
                // Teste Image Proxy
                $proxyUrl = "resy_image_proxy.php?lgfoto_id=" . $lgfotoId . "&appointment_id=100";
                echo "<p><a href='$proxyUrl' target='_blank'>Bild laden</a></p>";
                echo "<p><img src='$proxyUrl' style='max-width: 200px; border: 1px solid #ccc;' alt='Test-Bild'></p>";
            } else {
                echo "<p style='color: orange;'>⚠️ Keine LGFOTO_IDs für dieses Autohaus gefunden</p>";
            }
        } else {
            echo "<a href='?test_image=" . $autohaus['id'] . "' style='background: #007bff; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Bild testen</a>";
        }
        
    } else {
        echo "<p style='color: red;'>❌ Keine Cookie-Datei gefunden</p>";
        echo "<p><a href='?renew_session=" . $autohaus['id'] . "' style='background: #28a745; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Session erstellen</a></p>";
    }
    
    echo "<hr>";
}

echo "<h3>Session-Verwaltung</h3>";
echo "<p><a href='clear_resy_session.php' style='background: #dc3545; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Session-Cookies löschen</a></p>";
echo "<p><a href='../admin/appointments.php' style='background: #28a745; color: white; padding: 5px 10px; text-decoration: none; border-radius: 3px;'>Zurück zu Appointments</a></p>";

echo "<hr>";
echo "<h3>Letzte Log-Einträge</h3>";
$logFile = __DIR__ . '/../logs/resy_image_proxy.log';
if (file_exists($logFile)) {
    $lines = file($logFile);
    $lastLines = array_slice($lines, -20); // Letzte 20 Zeilen
    echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 3px; font-size: 12px;'>";
    foreach ($lastLines as $line) {
        echo htmlspecialchars($line);
    }
    echo "</pre>";
} else {
    echo "<p style='color: orange;'>⚠️ Keine Log-Datei gefunden</p>";
}
?>
