<?php
/**
 * DIREKTER E-Mail-Test - Ohne PHPMailer
 * Verwendet PHP mail() Funktion
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>📧 DIREKTER E-Mail-Test (PHP mail())</h1>";

$to = $_GET['email'] ?? 'rentacar-kiel@be-automobile.de';
$subject = "Test E-Mail - Boxenstop";

$message = "
    <html>
    <head>
        <style>
            body { font-family: Arial, sans-serif; }
            .header { background: #003057; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; }
        </style>
    </head>
    <body>
        <div class='header'>
            <h1>Test E-Mail</h1>
        </div>
        <div class='content'>
            <p>Dies ist eine Test-E-Mail von Boxenstop.</p>
            <p>Wenn Sie diese E-Mail sehen, funktioniert der E-Mail-Versand!</p>
        </div>
    </body>
    </html>
";

// Headers
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
$headers .= "From: Boxenstop <noreply@boxenstop.de>" . "\r\n";
$headers .= "Reply-To: noreply@boxenstop.de" . "\r\n";

echo "<p>Versuche E-Mail zu senden an: <strong>$to</strong></p>";

$result = @mail($to, $subject, $message, $headers);

if ($result) {
    echo "<h2 style='color: green;'>✅ ERFOLG! E-Mail wurde versendet!</h2>";
    echo "<p>Bitte prüfen Sie Ihr Postfach: <strong>$to</strong></p>";
} else {
    echo "<h2 style='color: red;'>❌ FEHLER: E-Mail konnte nicht versendet werden</h2>";
    echo "<p>Das Problem liegt bei der SMTP-Konfiguration.</p>";
}

// Prüfe PHP mail() Funktion
echo "<h2>PHP mail() Status:</h2>";
$ini_mail = ini_get('SMTP');
echo "<p>SMTP Server (php.ini): " . ($ini_mail ?: 'Nicht gesetzt') . "</p>";

$ini_sendmail = ini_get('sendmail_path');
echo "<p>Sendmail Path: " . ($ini_sendmail ?: 'Nicht gesetzt') . "</p>";

?>

