<?php
// test_database.php - Datenbankverbindung testen
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

require_once 'config.php';

try {
    // Test der Datenbankverbindung
    $stmt = $pdo->prepare("SELECT 1");
    $stmt->execute();
    
    // Alle Tabellen auflisten
    $stmt = $pdo->prepare("SHOW TABLES");
    $stmt->execute();
    $allTables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    // Prüfen ob users-Tabelle existiert
    $usersTableExists = in_array('users', $allTables);
    
    // Prüfen ob autohauser-Tabelle existiert
    $autohauserTableExists = in_array('autohauser', $allTables);
    
    // Prüfen ob events-Tabelle existiert (aus appointments.php)
    $eventsTableExists = in_array('events', $allTables);
    
    // Prüfen ob appointments-Tabelle existiert
    $appointmentsTableExists = in_array('appointments', $allTables);
    
    // Tabellen-Struktur prüfen (falls users-Tabelle existiert)
    $tableStructure = null;
    if ($usersTableExists) {
        $stmt = $pdo->prepare("DESCRIBE users");
        $stmt->execute();
        $tableStructure = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    echo json_encode([
        'success' => true,
        'database_connection' => 'OK',
        'all_tables' => $allTables,
        'users_table_exists' => $usersTableExists,
        'autohauser_table_exists' => $autohauserTableExists,
        'events_table_exists' => $eventsTableExists,
        'appointments_table_exists' => $appointmentsTableExists,
        'table_structure' => $tableStructure,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage(),
        'database_connection' => 'FAILED',
        'timestamp' => date('Y-m-d H:i:s')
    ]);
}
?>
